/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdGoodsGiftRspBO;
import com.tydic.uoc.common.ability.bo.OrdInspectionItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdInspectionRspBO;
import com.tydic.uoc.common.atom.api.UocCoreInspectionDetailsQueryAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreInspectionDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreInspectionDetailsQueryRspBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsGiftMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsGiftPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdShipItemPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreInspectionDetailsQueryAtomService")
public class UocCoreInspectionDetailsQueryAtomServiceImpl
implements UocCoreInspectionDetailsQueryAtomService {
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsGiftMapper ordGoodsGiftMapper;

    @Override
    public UocCoreInspectionDetailsQueryRspBO getInspectionDetailsQuery(UocCoreInspectionDetailsQueryReqBO reqBO) {
        UocCoreInspectionDetailsQueryRspBO rspBO = new UocCoreInspectionDetailsQueryRspBO();
        this.validateParams(reqBO);
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY_NOT.equals(reqBO.getQueryLevel())) {
            OrdInspectionRspBO ordInspectionRspBO = this.buildOrdInspectionRspBO(reqBO);
            rspBO.setOrdInspectionRspBO(ordInspectionRspBO);
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            ArrayList<Long> shipVoucherIdList = new ArrayList<Long>();
            List<OrdInspectionItemRspBO> ordInspectionItemRspBOS = this.buildOrdInspectionItemRspBOList(reqBO, shipVoucherIdList);
            if (CollectionUtils.isEmpty(ordInspectionItemRspBOS)) {
                if (UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u9a8c\u6536\u660e\u7ec6Item\u4fe1\u606f\uff1a" + reqBO.getOrderId());
                    rspBO.setOrdInspectionItemRspBOList(ordInspectionItemRspBOS);
                    if (null == rspBO.getOrdInspectionRspBO()) {
                        rspBO.setOrdInspectionRspBO(new OrdInspectionRspBO());
                    }
                    rspBO.getOrdInspectionRspBO().setShipVoucherIdList(shipVoucherIdList);
                    return rspBO;
                }
            } else {
                rspBO.setOrdInspectionItemRspBOList(ordInspectionItemRspBOS);
                if (null == rspBO.getOrdInspectionRspBO()) {
                    rspBO.setOrdInspectionRspBO(new OrdInspectionRspBO());
                }
                rspBO.getOrdInspectionRspBO().setShipVoucherIdList(shipVoucherIdList);
            }
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            rspBO.setInspectionAccessoryList(this.buildAdjustAccessoryList(reqBO));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocCoreInspectionDetailsQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getInspectionVoucherId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u9a8c\u6536\u5355ID\u3010inspectionVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getInspectionVoucherId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u9a8c\u6536\u5355ID\u3010inspectionVoucherId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private OrdInspectionRspBO buildOrdInspectionRspBO(UocCoreInspectionDetailsQueryReqBO reqBO) {
        OrdInspectionRspBO ordInspectionRspBO = new OrdInspectionRspBO();
        OrdInspectionPO inspectionPO = new OrdInspectionPO();
        inspectionPO.setOrderId(reqBO.getOrderId());
        inspectionPO.setInspectionVoucherId(reqBO.getInspectionVoucherId());
        OrdInspectionPO ordInspectionPO = this.ordInspectionMapper.getModelBy(inspectionPO);
        if (null == ordInspectionPO) {
            return ordInspectionRspBO;
        }
        BeanUtils.copyProperties((Object)ordInspectionPO, (Object)ordInspectionRspBO);
        try {
            ordInspectionRspBO.setInspTotalSaleMoney(MoneyUtils.Long2BigDecimal((Long)ordInspectionPO.getInspTotalSaleFee()));
            ordInspectionRspBO.setInspTotalPurchaseMoney(MoneyUtils.Long2BigDecimal((Long)ordInspectionPO.getInspTotalPurchaseFee()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u9a8c\u6536\u5355\u3010uoc_ord_inspection\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
        }
        ordInspectionRspBO.setInspectionExtraMap(this.buildInspectionExtraInfoMap(reqBO));
        return ordInspectionRspBO;
    }

    private Map<String, String> buildInspectionExtraInfoMap(UocCoreInspectionDetailsQueryReqBO reqBO) {
        HashMap<String, String> orderExtraMap = new HashMap<String, String>(16);
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setObjId(reqBO.getInspectionVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setFieldCode("vendorOrderType");
        ordExtMapCondition.setObjType(UocConstant.OBJ_TYPE.SALE);
        OrdExtMapPO modelBy = this.ordExtMapMapper.getModelBy(ordExtMapCondition);
        if (modelBy != null) {
            ordExtMapList.add(modelBy);
        }
        if (!CollectionUtils.isNotEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private List<OrdAccessoryRspBO> buildAdjustAccessoryList(UocCoreInspectionDetailsQueryReqBO reqBO) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(reqBO.getOrderId());
        ordAccessoryPO.setObjectId(reqBO.getInspectionVoucherId());
        ordAccessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.INSPECTION);
        List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
        ArrayList<OrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<OrdAccessoryRspBO>();
        if (CollectionUtils.isEmpty((Collection)ordAccessoryPOList)) {
            return ordAccessoryRspBOList;
        }
        for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
            OrdAccessoryRspBO ordAccessoryRspBO = new OrdAccessoryRspBO();
            BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
            ordAccessoryRspBOList.add(ordAccessoryRspBO);
        }
        return ordAccessoryRspBOList;
    }

    private List<OrdInspectionItemRspBO> buildOrdInspectionItemRspBOList(UocCoreInspectionDetailsQueryReqBO reqBO, List<Long> shipVoucherIdMap) {
        List ordInspectionItemPOList;
        ArrayList<OrdInspectionItemRspBO> ordInspectionItemRspBOList = new ArrayList<OrdInspectionItemRspBO>();
        OrdInspectionItemPO inspectionItemPO = new OrdInspectionItemPO();
        inspectionItemPO.setOrderId(reqBO.getOrderId());
        inspectionItemPO.setInspectionVoucherId(reqBO.getInspectionVoucherId());
        if (CollectionUtils.isNotEmpty(reqBO.getInspectionItemIdList())) {
            inspectionItemPO.setInspectionItemIdList(reqBO.getInspectionItemIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)(ordInspectionItemPOList = this.ordInspectionItemMapper.getList(inspectionItemPO)))) {
            ArrayList<Long> shipItemIdList = new ArrayList<Long>(ordInspectionItemPOList.size());
            ArrayList<Long> ordItemIdList = new ArrayList<Long>(ordInspectionItemPOList.size());
            for (OrdInspectionItemPO ordInspectionItemPO : ordInspectionItemPOList) {
                shipItemIdList.add(ordInspectionItemPO.getShipItemId());
                ordItemIdList.add(ordInspectionItemPO.getOrdItemId());
            }
            OrdItemPO ordItemModel = new OrdItemPO();
            ordItemModel.setOrderId(reqBO.getOrderId());
            ordItemModel.setOrdItemIdList(ordItemIdList);
            List ordItemPOList = this.ordItemMapper.getList(ordItemModel);
            Map longOrdItemPOMap = null;
            if (CollectionUtils.isNotEmpty((Collection)ordItemPOList)) {
                longOrdItemPOMap = ordItemPOList.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, Function.identity(), (ordItemPO, ordItemPO1) -> ordItemPO));
            }
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setOrderId(reqBO.getOrderId());
            ordShipItemPO.setShipItemIdList(shipItemIdList);
            List shipItemPOS = this.ordShipItemMapper.getList(ordShipItemPO);
            HashMap<Long, OrdShipItemPO> shipItemPOMap = null;
            if (CollectionUtils.isNotEmpty((Collection)shipItemPOS)) {
                shipItemPOMap = new HashMap<Long, OrdShipItemPO>();
                for (OrdShipItemPO shipItemPO : shipItemPOS) {
                    shipItemPOMap.put(shipItemPO.getShipItemId(), shipItemPO);
                    shipVoucherIdMap.add(shipItemPO.getShipVoucherId());
                }
            }
            OrdGoodsPO goodsPO = new OrdGoodsPO();
            goodsPO.setOrderId(reqBO.getOrderId());
            goodsPO.setOrdItemIdList(ordItemIdList);
            List goodsPOS = this.ordGoodsMapper.getList(goodsPO);
            Map ordGoodsPOMap = null;
            if (CollectionUtils.isNotEmpty((Collection)goodsPOS)) {
                ordGoodsPOMap = goodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, Function.identity(), (ordGoodsPO, ordGoodsPO1) -> ordGoodsPO));
            }
            OrdGoodsGiftPO goodsGiftPO = new OrdGoodsGiftPO();
            goodsGiftPO.setOrderId(reqBO.getOrderId());
            goodsGiftPO.setOrdItemIdList(ordItemIdList);
            List ordGoodsGiftPOS = this.ordGoodsGiftMapper.getList(goodsGiftPO);
            Map<Long, List<OrdGoodsGiftPO>> ordGoodsGiftPOMap = null;
            if (CollectionUtils.isNotEmpty((Collection)ordGoodsGiftPOS)) {
                ordGoodsGiftPOMap = ordGoodsGiftPOS.stream().collect(Collectors.groupingBy(OrdGoodsGiftPO::getOrdItemId));
            }
            for (OrdInspectionItemPO ordInspectionItemPO : ordInspectionItemPOList) {
                List<OrdGoodsGiftPO> goodsGiftPOS;
                OrdGoodsPO ordGoodsPO2;
                OrdShipItemPO shipItemPO;
                OrdItemPO ordItemPO2;
                OrdInspectionItemRspBO ordInspectionItemRspBO = new OrdInspectionItemRspBO();
                BeanUtils.copyProperties((Object)ordInspectionItemPO, (Object)ordInspectionItemRspBO);
                if (longOrdItemPOMap != null && (ordItemPO2 = (OrdItemPO)longOrdItemPOMap.get(ordInspectionItemPO.getOrdItemId())) != null) {
                    ordInspectionItemRspBO.setSalePrice(ordItemPO2.getSalePrice());
                    ordInspectionItemRspBO.setUnitName(ordItemPO2.getUnitName());
                    ordInspectionItemRspBO.setPurchaseCount(ordItemPO2.getPurchaseCount());
                    ordInspectionItemRspBO.setPurchasePrice(ordItemPO2.getPurchasePrice());
                    ordInspectionItemRspBO.setTax(ordItemPO2.getTax());
                    ordInspectionItemRspBO.setSkuMaterialLongDesc(ordItemPO2.getExtField2());
                }
                try {
                    ordInspectionItemRspBO.setPurchasePriceMoney(MoneyUtils.Long2BigDecimal((Long)ordInspectionItemRspBO.getPurchasePrice()));
                    ordInspectionItemRspBO.setSalePriceMoney(MoneyUtils.Long2BigDecimal((Long)ordInspectionItemRspBO.getSalePrice()));
                    ordInspectionItemRspBO.setInspSaleMoney(MoneyUtils.Long2BigDecimal((Long)ordInspectionItemPO.getInspSaleFee()));
                    ordInspectionItemRspBO.setInspPurchaseMoney(MoneyUtils.Long2BigDecimal((Long)ordInspectionItemPO.getInspPurchaseFee()));
                }
                catch (Exception e) {
                    throw new UocProBusinessException("100001", "\u9a8c\u6536\u660e\u7ec6Item\u5355\u3010uoc_ord_inspection_item\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
                }
                if (shipItemPOMap != null && (shipItemPO = (OrdShipItemPO)shipItemPOMap.get(ordInspectionItemPO.getShipItemId())) != null) {
                    ordInspectionItemRspBO.setSendCount(shipItemPO.getSendCount());
                }
                if (ordGoodsPOMap != null && null != (ordGoodsPO2 = (OrdGoodsPO)ordGoodsPOMap.get(ordInspectionItemPO.getOrdItemId()))) {
                    ordInspectionItemRspBO.setSkuId(Long.valueOf(ordGoodsPO2.getSkuId()));
                    ordInspectionItemRspBO.setSkuName(ordGoodsPO2.getSkuName());
                    ordInspectionItemRspBO.setPicUrl(ordGoodsPO2.getSkuMainPicUrl());
                    ordInspectionItemRspBO.setSkuMaterialTypeId(ordGoodsPO2.getSkuMaterialTypeId());
                    ordInspectionItemRspBO.setSkuMaterialTypeName(ordGoodsPO2.getSkuMaterialTypeName());
                    ordInspectionItemRspBO.setSkuMaterialId(ordGoodsPO2.getSkuMaterialId());
                    ordInspectionItemRspBO.setSkuMaterialName(ordGoodsPO2.getSkuMaterialName());
                }
                if (ordGoodsGiftPOMap != null && CollectionUtils.isNotEmpty(goodsGiftPOS = ordGoodsGiftPOMap.get(ordInspectionItemPO.getOrdItemId()))) {
                    List ordGoodsGiftRspBOList = JSON.parseArray((String)JSON.toJSONString(goodsGiftPOS), OrdGoodsGiftRspBO.class);
                    ordInspectionItemRspBO.setOrdGoodsGiftRspBOList(ordGoodsGiftRspBOList);
                }
                ordInspectionItemRspBOList.add(ordInspectionItemRspBO);
            }
        }
        return ordInspectionItemRspBOList;
    }
}

