/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl.plan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.common.ability.bo.plan.CceOrderSyncMdmReqBO;
import com.tydic.uoc.common.ability.bo.plan.CceOrderSyncMdmRspBO;
import com.tydic.uoc.common.busi.api.plan.CcePlanSyncMdmBusiService;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CcePlanSyncMdmBusiServiceImpl
implements CcePlanSyncMdmBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Value(value="${needDate:30}")
    private Long needDate;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;

    @Override
    public CceOrderSyncMdmRspBO dealSyncMdm(CceOrderSyncMdmReqBO reqBO) {
        CceOrderSyncMdmRspBO rspBO = new CceOrderSyncMdmRspBO();
        JSONObject esb = reqBO.getESB();
        String result = esb.getString("RESULT");
        String desc = esb.getString("DESC");
        JSONObject datainfos = esb.getJSONObject("DATAINFOS");
        if (datainfos == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6ca1\u6709\u4efb\u4f55\u7684DATAINFOS");
            return rspBO;
        }
        JSONArray array = datainfos.getJSONArray("DATAINFO");
        if (array == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6ca1\u6709\u4efb\u4f55\u7684DATAINFO");
            return rspBO;
        }
        String orderId = datainfos.getString("UUID");
        if (orderId == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("DATAINFOS\u6ca1\u6709UUID");
            return rspBO;
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(Long.valueOf(orderId));
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (salePO == null) {
            rspBO.setRespCode("1");
            rspBO.setRespDesc("\u672a\u627e\u5230\u8ba1\u5212");
            return rspBO;
        }
        rspBO.setOrderId(salePO.getOrderId());
        rspBO.setSaleId(salePO.getSaleVoucherId());
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(Long.valueOf(orderId));
        List list = this.ordItemMapper.getList(ordItemPO);
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(salePO.getOrderId());
        List goodsPOS = this.ordGoodsMapper.getList(ordGoodsPO);
        Map<Long, OrdGoodsPO> goodsPOMap = goodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, i -> i));
        Map<Long, OrdItemPO> map = list.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, i -> i));
        boolean flag = true;
        for (Object object : array) {
            JSONObject jsonObject = (JSONObject)object;
            String uuid = jsonObject.getString("UUID");
            OrdItemPO itemPO = map.get(Long.valueOf(uuid));
            if (itemPO == null) continue;
            OrdGoodsPO sku = goodsPOMap.get(itemPO.getOrdItemId());
            OrdItemPO update = new OrdItemPO();
            update.setOrdItemId(itemPO.getOrdItemId());
            update.setOrderId(itemPO.getOrderId());
            String status = jsonObject.getString("SYNSTATUS");
            String remark = jsonObject.getString("SYNRESULT");
            if ("0".equals(status) || "4".equals(status)) {
                update.setLmSubOrderId(PebExtConstant.YES.toString());
            } else {
                update.setLmSubOrderId("\u7269\u6599\uff1a" + sku.getSkuMaterialId() + "\u5206\u914d\u5931\u8d25");
                if (StringUtils.isNotBlank((CharSequence)remark)) {
                    update.setLmSubOrderId(itemPO.getLmSubOrderId() + "\uff0c\u539f\u56e0\uff1a" + remark);
                }
                flag = false;
            }
            this.ordItemMapper.updateById(update);
        }
        OrdSalePO update = new OrdSalePO();
        update.setOrderId(salePO.getOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

