/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebOrderPrintPurchaseAbilityService;
import com.tydic.uoc.common.ability.api.UocApprovalprocessListQryAbilityService;
import com.tydic.uoc.common.ability.bo.OrderPrintPurchaseRepBO;
import com.tydic.uoc.common.ability.bo.OrderPrintPurchaseRspBO;
import com.tydic.uoc.common.ability.bo.UocApprovalLogBO;
import com.tydic.uoc.common.ability.bo.UocApprovalprocessListQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalprocessListQryAbilityRspBO;
import com.tydic.uoc.common.utils.PdfReportM1HeaderFooterUtil;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrdStateChgLogMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrdStateChgLogPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderPrintPurchaseAbilityService"})
public class PebOrderPrintPurchaseAbilityServiceImpl
implements PebOrderPrintPurchaseAbilityService {
    @Autowired
    private FileClient fileClient;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private UocApprovalprocessListQryAbilityService uocApprovalprocessListQryAbilityService;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdStateChgLogMapper ordStateChgLogMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(PebOrderPrintPurchaseAbilityServiceImpl.class);
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OSS = "OSS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"ExtOrder"})
    public OrderPrintPurchaseRspBO ExtOrder(@RequestBody OrderPrintPurchaseRepBO repBO) {
        this.validateParams(repBO);
        OrdSalePO ordSaleRspPO = this.getOrderSale(repBO);
        OrderPrintPurchaseRspBO orderPrintPurchaseRspBO = new OrderPrintPurchaseRspBO();
        String fileUrl = "";
        String pdfFileName = "";
        if (ordSaleRspPO == null) {
            throw new UocProBusinessException("100200", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u67e5\u8be2\u3010OrdSalePO\u3011\u4e3a\u7a7a\u6216\u67e5\u8be2\u5931\u8d25");
        }
        UocOrdZmInfoPO uocOrdZmInfoRspPO = this.getUocOrdZmInfoPO(repBO);
        if (uocOrdZmInfoRspPO == null) {
            throw new UocProBusinessException("100200", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u67e5\u8be2\u3010UocOrdZmInfoPO\u3011\u4e3a\u7a7a\u6216\u67e5\u8be2\u5931\u8d25");
        }
        OrderPO orderPO = this.getOrderPO(repBO.getOrderId());
        if (orderPO == null) {
            throw new UocProBusinessException("100200", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u67e5\u8be2\u3010orderPO\u3011\u4e3a\u7a7a\u6216\u67e5\u8be2\u5931\u8d25");
        }
        if ("2".equals(repBO.getSupplyAndPurchaseType())) {
            if ("1".equals(ordSaleRspPO.getOrderSource())) {
                fileUrl = this.extAgreementGoodsPurchaseOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
                pdfFileName = "\u81ea\u8425\u4e13\u533a\u91c7\u8d2d\u8ba2\u5355-\u91c7\u8d2d\u4fa7.pdf";
            } else if ("2".equals(ordSaleRspPO.getOrderSource())) {
                if (uocOrdZmInfoRspPO.getIsPushErp() != null && uocOrdZmInfoRspPO.getIsPushErp() == 1) {
                    fileUrl = this.extElectronicSupermarketPurchaseErpOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
                    pdfFileName = "\u7535\u5b50\u8d85\u5e02\u91c7\u8d2d\u8ba2\u5355\uff08ERP\uff09.pdf";
                } else {
                    fileUrl = this.extElectronicSupermarketPurchaseOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
                    pdfFileName = "\u7535\u5b50\u8d85\u5e02\u91c7\u8d2d\u8ba2\u5355\uff08\u975eERP\uff09.pdf";
                }
            } else if ("3".equals(ordSaleRspPO.getOrderSource())) {
                fileUrl = this.extDirectPurchaseOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
            } else if ("4".equals(ordSaleRspPO.getOrderSource())) {
                fileUrl = this.extAgreementPurchaseOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
            }
        } else if ("1".equals(ordSaleRspPO.getOrderSource())) {
            fileUrl = this.extAgreementGoodsSupplyOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
            pdfFileName = "\u81ea\u8425\u4e13\u533a\u91c7\u8d2d\u8ba2\u5355-\u4f9b\u5e94\u4fa7.pdf";
        } else if ("2".equals(ordSaleRspPO.getOrderSource())) {
            fileUrl = this.extElectronicSupermarketSupplyOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
        } else if ("3".equals(ordSaleRspPO.getOrderSource())) {
            fileUrl = this.extDirectSupplyOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
        } else if ("4".equals(ordSaleRspPO.getOrderSource())) {
            fileUrl = this.extAgreementSupplyOrder(repBO, ordSaleRspPO, uocOrdZmInfoRspPO, orderPO);
        }
        orderPrintPurchaseRspBO.setOrderPdfUrl(fileUrl);
        orderPrintPurchaseRspBO.setRespCode("0000");
        orderPrintPurchaseRspBO.setRespDesc("\u91c7\u8d2d\u8ba2\u5355\u5bfc\u51fa\u6210\u529f");
        orderPrintPurchaseRspBO.setPdfFileName(pdfFileName);
        return orderPrintPurchaseRspBO;
    }

    OrdSalePO getOrderSale(OrderPrintPurchaseRepBO repBO) {
        try {
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(repBO.getOrderId());
            return this.ordSaleMapper.getModelBy(ordSalePO);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2OrdSalePO\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    OrdLogisticsRelaPO getOrdLogisticsRela(Long contactId) {
        try {
            OrdLogisticsRelaPO ordLogisticsRelaPO = this.ordLogisticsRelaMapper.getModelById(contactId.longValue());
            return ordLogisticsRelaPO;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2OrdLogisticsRelaPO\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    OrdStateChgLogPO getOrdStateChgLog(OrderPrintPurchaseRepBO repBO) {
        try {
            OrdStateChgLogPO ordStateChgLogPO = new OrdStateChgLogPO();
            ordStateChgLogPO.setOrderId(repBO.getOrderId());
            ordStateChgLogPO.setOldState(Integer.valueOf(1101));
            return this.ordStateChgLogMapper.getModelBy(ordStateChgLogPO);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2OrdStateChgLogPO\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    UocOrdZmInfoPO getUocOrdZmInfoPO(OrderPrintPurchaseRepBO repBO) {
        try {
            UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
            uocOrdZmInfoPO.setOrderId(repBO.getOrderId());
            UocOrdZmInfoPO uocOrdZmInfoRspPO = this.uocOrdZmInfoMapper.selectOne(uocOrdZmInfoPO);
            return uocOrdZmInfoRspPO;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2UocOrdZmInfoPO\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    OrderPO getOrderPO(Long orderId) {
        try {
            OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
            return orderPO;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2OrderPO", (Throwable)e);
            return null;
        }
    }

    private OrdQueryIndexPO getOrdQueryIndexPO(OrderPrintPurchaseRepBO repBO, int objType) {
        try {
            OrdQueryIndexPO ordQueryIndexPO = new OrdQueryIndexPO();
            ordQueryIndexPO.setOrderId(repBO.getOrderId());
            ordQueryIndexPO.setObjType(Integer.valueOf(objType));
            OrdQueryIndexPO ordQueryIndexRspPO = this.ordQueryIndexMapper.getModelBy(ordQueryIndexPO);
            return ordQueryIndexRspPO;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2OrdQueryIndexPO\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private OrdStakeholderPO getOrdStakeholderPO(OrderPrintPurchaseRepBO repBO) {
        try {
            OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(repBO.getOrderId().longValue());
            return ordStakeholderPO;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2OrdStakeholderPO\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private List<OrdItemPO> getOrderItmeList(OrderPrintPurchaseRepBO repBO) {
        List orderItmeList = Lists.newArrayList();
        try {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(repBO.getOrderId());
            orderItmeList = this.ordItemMapper.getList(ordItemPO);
            return orderItmeList;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2List<OrdItemPO>\u5931\u8d25", (Throwable)e);
            return orderItmeList;
        }
    }

    private List<OrdGoodsPO> getOrderGoodsList(OrderPrintPurchaseRepBO repBO) {
        List orderGoodsList = Lists.newArrayList();
        try {
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrderId(repBO.getOrderId());
            orderGoodsList = this.ordGoodsMapper.getList(ordGoodsPO);
            return orderGoodsList;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2List<OrdGoodsPO>\u5931\u8d25", (Throwable)e);
            return orderGoodsList;
        }
    }

    private List<OrdPayConfPO> getPayConfList(OrderPrintPurchaseRepBO repBO) {
        List payConfList = Lists.newArrayList();
        try {
            OrdPayConfPO ordPayConfPO = new OrdPayConfPO();
            ordPayConfPO.setOrderId(repBO.getOrderId());
            ordPayConfPO.setUserType(Integer.valueOf(1));
            payConfList = this.ordPayConfMapper.selectByCondition(ordPayConfPO);
            return payConfList;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2List<OrdPayConfPO>\u5931\u8d25", (Throwable)e);
            return payConfList;
        }
    }

    private List<OrdAgreementPO> getOrdAgreementPOList(OrderPrintPurchaseRepBO repBO) {
        List ordAgreementPOList = Lists.newArrayList();
        try {
            OrdAgreementPO ordAgreementPO = new OrdAgreementPO();
            ordAgreementPO.setOrderId(repBO.getOrderId());
            ordAgreementPOList = this.ordAgreementMapper.selectByCondition(ordAgreementPO);
            return ordAgreementPOList;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2List<OrdAgreementPO>\u5931\u8d25", (Throwable)e);
            return ordAgreementPOList;
        }
    }

    private void doPayAccount(OrdPayConfPO ordPayConfPO, List<PdfPTable> tableList, Font contentTitleFont, Font contentFont) {
        if (ordPayConfPO.getPayType() == 0) {
            PdfPTable pdfPTable12 = new PdfPTable(62);
            tableList.add(pdfPTable12);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"\u4e8c\u3001\u4ed8\u6b3e\u65b9\u5f0f\uff1a", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"\u9884\u4ed8\u6b3e\u652f\u4ed8", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
        } else if (ordPayConfPO.getPayType() == 1) {
            PdfPTable pdfPTable12 = new PdfPTable(62);
            tableList.add(pdfPTable12);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"\u4e8c\u3001\u4ed8\u6b3e\u65b9\u5f0f\uff1a", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"\u5206\u9636\u6bb5\u652f\u4ed8", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
            PdfPTable pdfPTable13 = new PdfPTable(62);
            tableList.add(pdfPTable13);
            String sup = "";
            if (ordPayConfPO.getPrePaySup() != null) {
                String preSup = "\u9884\u4ed8\u6b3e\uff1a" + ordPayConfPO.getPrePaySup() + "%";
                sup = sup + preSup + "   ";
            }
            if (ordPayConfPO.getVerPaySup() != null) {
                String verSup = "\u5230\u8d27\u6b3e\uff1a" + ordPayConfPO.getVerPaySup() + "%";
                sup = sup + verSup + "  ";
            }
            if (ordPayConfPO.getPilPaySup() != null) {
                String pilSup = "\u9a8c\u6536\u6b3e\uff1a" + ordPayConfPO.getPilPaySup() + "%";
                sup = sup + pilSup + "  ";
            }
            if (ordPayConfPO.getQuaPaySup() != null) {
                String quaSup = "\u8d28\u4fdd\u91d1\uff1a" + ordPayConfPO.getQuaPaySup() + "%";
                sup = sup + quaSup + "  ";
            }
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)("\u652f\u4ed8\u6bd4\u4f8b\uff1a" + sup), (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
        } else if (ordPayConfPO.getPayType() == 2) {
            PdfPTable pdfPTable12 = new PdfPTable(62);
            tableList.add(pdfPTable12);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"\u4e8c\u3001\u4ed8\u6b3e\u65b9\u5f0f\uff1a", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"\u8d26\u671f\u652f\u4ed8", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
            if (ordPayConfPO.getPayRule() == 1) {
                PdfPTable pdfPTable13 = new PdfPTable(62);
                tableList.add(pdfPTable13);
                PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)"", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
                PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)"\u671f\u671b\u7ed3\u7b97\u65e5\uff1a\u6307\u5b9a\u8d26\u671f\u65e5", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
                if (ordPayConfPO.getPayAccountDay() != null) {
                    PdfPTable pdfPTable14 = new PdfPTable(62);
                    tableList.add(pdfPTable14);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)"", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)("\u9700\u8981\u5728\u6bcf\u6708" + ordPayConfPO.getPayAccountDay() + "\u65e5\u7ed3\u7b97"), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
                }
            } else if (ordPayConfPO.getPayRule() == 2) {
                PdfPTable pdfPTable13 = new PdfPTable(62);
                tableList.add(pdfPTable13);
                PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)"", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
                PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)"\u671f\u671b\u7ed3\u7b97\u65e5\uff1a\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9+\u8d26\u671f\u5929\u6570", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
                String rule = "";
                String ruleDays = "";
                if (1 == ordPayConfPO.getPayAccountDayRule()) {
                    rule = "\u9700\u8981\u5728\u8ba2\u5355\u6536\u7968";
                } else if (2 == ordPayConfPO.getPayAccountDayRule()) {
                    rule = "\u9700\u8981\u5728\u8ba2\u5355/\u9a8c\u6536\u5355\u9a8c\u6536";
                } else if (3 == ordPayConfPO.getPayAccountDayRule()) {
                    rule = "\u9700\u8981\u5728\u8ba2\u5355/\u53d1\u8d27\u5355\u5230\u8d27";
                }
                if (ordPayConfPO.getPaymentDays() != null) {
                    ruleDays = ordPayConfPO.getPaymentDays() + "\u5929\u5185\u7ed3\u7b97";
                }
                if (!StringUtils.isEmpty((String)(rule + ruleDays))) {
                    PdfPTable pdfPTable14 = new PdfPTable(62);
                    tableList.add(pdfPTable14);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)"", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)(rule + ruleDays), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
                }
            }
        } else if (ordPayConfPO.getPayType() == 3) {
            PdfPTable pdfPTable12 = new PdfPTable(62);
            tableList.add(pdfPTable12);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"\u4e8c\u3001\u4ed8\u6b3e\u65b9\u5f0f\uff1a", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)12, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable12, (Object)"\u9884\u5b58\u6b3e\u652f\u4ed8", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)50, (Integer)0);
        }
    }

    private String extElectronicSupermarketPurchaseErpOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        List approvalLogBOS;
        OrdLogisticsRelaPO ordLogisticsRelaPO;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String plaAgreementCode = null;
        String agreementName = null;
        String supRelaName = null;
        String supRelaMobile = null;
        String contactName = null;
        String contactMobile = null;
        String acceptManAddress = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
            supRelaName = ordStakeholderPO.getSupRelaName();
            supRelaMobile = ordStakeholderPO.getSupRelaMobile();
        }
        if (null != (ordLogisticsRelaPO = this.getOrdLogisticsRela(ordSaleRspPO.getContactId()))) {
            contactName = ordLogisticsRelaPO.getContactName();
            contactMobile = ordLogisticsRelaPO.getContactMobile();
            acceptManAddress = ordLogisticsRelaPO.getContactCountryName() + ordLogisticsRelaPO.getContactProvinceName() + ordLogisticsRelaPO.getContactCityName() + ordLogisticsRelaPO.getContactCountyName() + ordLogisticsRelaPO.getContactTown() + ordLogisticsRelaPO.getContactAddress();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdAgreementPO> ordAgreementPOList = this.getOrdAgreementPOList(repBO);
        if (!ordAgreementPOList.isEmpty()) {
            plaAgreementCode = ordAgreementPOList.get(0).getPlaAgreementCode();
            agreementName = ordAgreementPOList.get(0).getAgreementName();
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        String shenpLc = "";
        if ("0000".equals(uocApprovalprocessListQryAbilityRspBO.getRespCode()) && !(approvalLogBOS = uocApprovalprocessListQryAbilityRspBO.getRows()).isEmpty()) {
            for (UocApprovalLogBO approvalLogBO : approvalLogBOS) {
                shenpLc = shenpLc + approvalLogBO.getOperName() + "-";
            }
            if (shenpLc.length() > 0) {
                shenpLc = shenpLc.substring(0, shenpLc.length() - 1);
            }
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        String createOrderTime = sf.format(orderPO.getCreateTime());
        String chgTime = null;
        OrdStateChgLogPO ordStateChgLogPO = this.getOrdStateChgLog(repBO);
        if (ordStateChgLogPO != null) {
            chgTime = sf.format(ordStateChgLogPO.getChgTime());
        }
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 9.0f, 0);
        Font contentFontBold = new Font(baseFont, 9.0f, 1);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        pdfWriter.setPageEvent((PdfPageEvent)new PdfReportM1HeaderFooterUtil(new Phrase("\u5ba1\u6838\uff1a" + shenpLc, contentTableFont), new Phrase("\u4e0b\u5355\u65f6\u95f4\uff1a" + createOrderTime + "       \u5ba1\u6838\u751f\u6548\uff1a" + chgTime + "        \u6253\u5370\u65f6\u95f4\uff1a" + sf.format(new Date()), contentTableFont)));
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u7535   \u5b50   \u8d85   \u5e02   \u8ba2   \u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        tableList.add(titleTable);
        PdfPTable titleTableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)titleTableN, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(5.0f), (Integer)1, (Integer)0);
        tableList.add(titleTableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        pdfPTable1.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"\u4f9b\u5e94\u5546\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)supplierName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"\u8ba2\u5355\u7f16\u53f7\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)saleVoucherNo, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        pdfPTable2.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4f9b\u8d27\u65b9\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)supName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4e0b\u5355\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)purPlaceOrderName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        pdfPTable3.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"\u4e70\u53d7\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)buynerName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"\u4f7f\u7528\u5355\u4f4d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)uocOrdZmInfoRspPO.getUseDept(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(30);
        tableList.add(pdfPTable7);
        pdfPTable7.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u91c7\u8d2d\u7269\u8d44\u540d\u79f0\u3001\u578b\u53f7\u3001\u6570\u91cf\u3001\u91d1\u989d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)15, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\uff08\u5e01\u79cd\uff1a\u4eba\u6c11\u5e01\uff09", (Font)contentFontBold, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(23);
        pdfPTable8.setWidthPercentage(90.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5e8f\u53f7", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5355\u4f4d", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5546\u54c1\u63cf\u8ff0", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u542b\u7a0e\u5355\u4ef7", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7a0e\u7387", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u542b\u7a0e\u91d1\u989d", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        tableList.add(pdfPTable8);
        int i = 1;
        String totalPrice = "";
        Long totalCount = 0L;
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO itemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTable9 = new PdfPTable(23);
                    pdfPTable9.setWidthPercentage(90.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)i, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)1, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)goodsPO.getSkuMaterialId(), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)3, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)itemPO.getExtField2(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)5, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)itemPO.getExtField3(), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    String spms = goodsPO.getSkuExtSkuId() + "\uff1b" + goodsPO.getSkuName() + "\uff1b" + itemPO.getExtField3();
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)spms, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)5, null);
                    String purchaseCount = "";
                    if (null != itemPO.getPurchaseCount()) {
                        purchaseCount = new DecimalFormat("#,###").format(itemPO.getPurchaseCount());
                        totalCount = totalCount + (long)itemPO.getPurchaseCount().intValue();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)purchaseCount, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    String salePrice = "";
                    if (null != itemPO.getSalePrice()) {
                        salePrice = new DecimalFormat("#,###.00").format(new BigDecimal(itemPO.getSalePrice()).divide(new BigDecimal(10000), 2, 4).doubleValue());
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)salePrice, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)(itemPO.getTax() + "%"), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)1, null);
                    String totalSaleFee = "";
                    if (null != itemPO.getTotalSaleFee()) {
                        totalSaleFee = new DecimalFormat("#,###.00").format(new BigDecimal(itemPO.getTotalSaleFee()).divide(new BigDecimal(10000), 2, 4).doubleValue());
                        sumPrice = sumPrice + itemPO.getTotalSaleFee();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)totalSaleFee, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    tableList.add(pdfPTable9);
                    ++i;
                }
            }
            PdfPTable pdfPTable10 = new PdfPTable(1);
            tableList.add(pdfPTable10);
            if (sumPrice > 0L) {
                totalPrice = new DecimalFormat("#,###.00").format(new BigDecimal(sumPrice).divide(new BigDecimal(10000), 2, 4).doubleValue());
            }
            PdfPTable pdfPTableTotal = new PdfPTable(23);
            pdfPTableTotal.setWidthPercentage(90.0f);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"\u5408\u8ba1\uff1a", (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)16, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)new DecimalFormat("#,###").format(totalCount), (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)1, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)totalPrice, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            tableList.add(pdfPTableTotal);
        }
        tableList.add(pdfPTable6);
        PdfPTable pdfPTable13 = new PdfPTable(30);
        tableList.add(pdfPTable13);
        pdfPTable13.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)"\u9001\u8d27\u65f6\u95f4\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)ordSaleRspPO.getGiveTime(), (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)27, (Integer)0);
        PdfPTable pdfPTable14 = new PdfPTable(30);
        tableList.add(pdfPTable14);
        pdfPTable14.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)"\u5907\u6ce8\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)orderPO.getOrderDesc(), (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)27, (Integer)0);
        tableList.add(pdfPTable6);
        PdfPTable pdfPTable15 = new PdfPTable(30);
        tableList.add(pdfPTable15);
        pdfPTable15.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable15, (Object)"\u4e8c\u3001\u6536\u8d27\u4fe1\u606f\u53ca\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)30, (Integer)0);
        PdfPTable pdfPTable16 = new PdfPTable(41);
        tableList.add(pdfPTable16);
        pdfPTable16.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u6536\u8d27\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)contactName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)contactMobile, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u6536\u8d27\u5730\u5740\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)acceptManAddress, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)19, (Integer)0);
        PdfPTable pdfPTable17 = new PdfPTable(41);
        tableList.add(pdfPTable17);
        pdfPTable17.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"\u5e73\u53f0\u516c\u53f8\u8054\u7cfb\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)uocOrdZmInfoRspPO.getSupplierMan(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)uocOrdZmInfoRspPO.getSupplierTel(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)16, (Integer)0);
        PdfPTable pdfPTable18 = new PdfPTable(41);
        tableList.add(pdfPTable18);
        pdfPTable18.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"\u4f9b\u8d27\u65b9\u8054\u7cfb\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)supRelaName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)supRelaMobile, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)16, (Integer)0);
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u7535\u5b50\u8d85\u5e02\u91c7\u8d2d\u8ba2\u5355\uff08ERP\uff09.pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extElectronicSupermarketPurchaseOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        List approvalLogBOS;
        OrdLogisticsRelaPO ordLogisticsRelaPO;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String plaAgreementCode = null;
        String agreementName = null;
        String supRelaName = null;
        String supRelaMobile = null;
        String contactName = null;
        String contactMobile = null;
        String acceptManAddress = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
            supRelaName = ordStakeholderPO.getSupRelaName();
            supRelaMobile = ordStakeholderPO.getSupRelaMobile();
        }
        if (null != (ordLogisticsRelaPO = this.getOrdLogisticsRela(ordSaleRspPO.getContactId()))) {
            contactName = ordLogisticsRelaPO.getContactName();
            contactMobile = ordLogisticsRelaPO.getContactMobile();
            acceptManAddress = ordLogisticsRelaPO.getContactCountryName() + ordLogisticsRelaPO.getContactProvinceName() + ordLogisticsRelaPO.getContactCityName() + ordLogisticsRelaPO.getContactCountyName() + ordLogisticsRelaPO.getContactTown() + ordLogisticsRelaPO.getContactAddress();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdAgreementPO> ordAgreementPOList = this.getOrdAgreementPOList(repBO);
        if (!ordAgreementPOList.isEmpty()) {
            plaAgreementCode = ordAgreementPOList.get(0).getPlaAgreementCode();
            agreementName = ordAgreementPOList.get(0).getAgreementName();
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        String shenpLc = "";
        if ("0000".equals(uocApprovalprocessListQryAbilityRspBO.getRespCode()) && !(approvalLogBOS = uocApprovalprocessListQryAbilityRspBO.getRows()).isEmpty()) {
            for (UocApprovalLogBO approvalLogBO : approvalLogBOS) {
                shenpLc = shenpLc + approvalLogBO.getOperName() + "-";
            }
            if (shenpLc.length() > 0) {
                shenpLc = shenpLc.substring(0, shenpLc.length() - 1);
            }
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        String createOrderTime = sf.format(orderPO.getCreateTime());
        String chgTime = null;
        OrdStateChgLogPO ordStateChgLogPO = this.getOrdStateChgLog(repBO);
        if (ordStateChgLogPO != null) {
            chgTime = sf.format(ordStateChgLogPO.getChgTime());
        }
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 9.0f, 0);
        Font contentFontBold = new Font(baseFont, 9.0f, 1);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        pdfWriter.setPageEvent((PdfPageEvent)new PdfReportM1HeaderFooterUtil(new Phrase("\u5ba1\u6838\uff1a" + shenpLc, contentTableFont), new Phrase("\u4e0b\u5355\u65f6\u95f4\uff1a" + createOrderTime + "       \u5ba1\u6838\u751f\u6548\uff1a" + chgTime + "        \u6253\u5370\u65f6\u95f4\uff1a" + sf.format(new Date()), contentTableFont)));
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u7535   \u5b50   \u8d85   \u5e02   \u8ba2   \u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        tableList.add(titleTable);
        PdfPTable titleTableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)titleTableN, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(5.0f), (Integer)1, (Integer)0);
        tableList.add(titleTableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        pdfPTable1.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"\u4f9b\u5e94\u5546\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)supplierName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"\u8ba2\u5355\u7f16\u53f7\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)saleVoucherNo, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        pdfPTable2.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4f9b\u8d27\u65b9\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)supName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4e0b\u5355\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)purPlaceOrderName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        pdfPTable3.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"\u4e70\u53d7\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)buynerName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"\u4f7f\u7528\u5355\u4f4d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)uocOrdZmInfoRspPO.getUseDept(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(30);
        tableList.add(pdfPTable7);
        pdfPTable7.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u91c7\u8d2d\u7269\u8d44\u540d\u79f0\u3001\u578b\u53f7\u3001\u6570\u91cf\u3001\u91d1\u989d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)15, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\uff08\u5e01\u79cd\uff1a\u4eba\u6c11\u5e01\uff09", (Font)contentFontBold, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(18);
        pdfPTable8.setWidthPercentage(90.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5e8f\u53f7", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7535\u5546\u5546\u54c1\u7f16\u7801", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5546\u54c1\u63cf\u8ff0", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5355\u4f4d", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u542b\u7a0e\u5355\u4ef7", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7a0e\u7387", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u542b\u7a0e\u91d1\u989d", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        tableList.add(pdfPTable8);
        int i = 1;
        String totalPrice = "";
        Long totalCount = 0L;
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO itemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTable9 = new PdfPTable(18);
                    pdfPTable9.setWidthPercentage(90.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)i, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)1, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)goodsPO.getSkuExtSkuId(), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)3, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)goodsPO.getSkuName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)5, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)itemPO.getUnitName(), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    String purchaseCount = "";
                    if (null != itemPO.getPurchaseCount()) {
                        purchaseCount = new DecimalFormat("#,###").format(itemPO.getPurchaseCount());
                        totalCount = totalCount + (long)itemPO.getPurchaseCount().intValue();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)purchaseCount, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    String salePrice = "";
                    if (null != itemPO.getSalePrice()) {
                        salePrice = new DecimalFormat("#,###.00").format(new BigDecimal(itemPO.getSalePrice()).divide(new BigDecimal(10000), 2, 4).doubleValue());
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)salePrice, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)(itemPO.getTax() + "%"), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)1, null);
                    String totalSaleFee = "";
                    if (null != itemPO.getTotalSaleFee()) {
                        totalSaleFee = new DecimalFormat("#,###.00").format(new BigDecimal(itemPO.getTotalSaleFee()).divide(new BigDecimal(10000), 2, 4).doubleValue());
                        sumPrice = sumPrice + itemPO.getTotalSaleFee();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTable9, (Object)totalSaleFee, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    tableList.add(pdfPTable9);
                    ++i;
                }
            }
            PdfPTable pdfPTable10 = new PdfPTable(1);
            tableList.add(pdfPTable10);
            if (sumPrice > 0L) {
                totalPrice = new DecimalFormat("#,###.00").format(new BigDecimal(sumPrice).divide(new BigDecimal(10000), 2, 4).doubleValue());
            }
            PdfPTable pdfPTableTotal = new PdfPTable(18);
            pdfPTableTotal.setWidthPercentage(90.0f);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"\u5408\u8ba1\uff1a", (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)new DecimalFormat("#,###").format(totalCount), (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)1, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)totalPrice, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            tableList.add(pdfPTableTotal);
        }
        tableList.add(pdfPTable6);
        PdfPTable pdfPTable13 = new PdfPTable(30);
        tableList.add(pdfPTable13);
        pdfPTable13.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)"\u9001\u8d27\u65f6\u95f4\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)ordSaleRspPO.getGiveTime(), (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)27, (Integer)0);
        PdfPTable pdfPTable14 = new PdfPTable(30);
        tableList.add(pdfPTable14);
        pdfPTable14.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)"\u5907\u6ce8\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)orderPO.getOrderDesc(), (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)27, (Integer)0);
        tableList.add(pdfPTable6);
        PdfPTable pdfPTable15 = new PdfPTable(30);
        tableList.add(pdfPTable15);
        pdfPTable15.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable15, (Object)"\u4e8c\u3001\u6536\u8d27\u4fe1\u606f\u53ca\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)30, (Integer)0);
        PdfPTable pdfPTable16 = new PdfPTable(41);
        tableList.add(pdfPTable16);
        pdfPTable16.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u6536\u8d27\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)contactName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)contactMobile, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u6536\u8d27\u5730\u5740\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)acceptManAddress, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)19, (Integer)0);
        PdfPTable pdfPTable17 = new PdfPTable(41);
        tableList.add(pdfPTable17);
        pdfPTable17.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"\u5e73\u53f0\u516c\u53f8\u8054\u7cfb\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)uocOrdZmInfoRspPO.getSupplierMan(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)uocOrdZmInfoRspPO.getSupplierTel(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)16, (Integer)0);
        PdfPTable pdfPTable18 = new PdfPTable(41);
        tableList.add(pdfPTable18);
        pdfPTable18.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"\u4f9b\u8d27\u65b9\u8054\u7cfb\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)supRelaName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)supRelaMobile, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)16, (Integer)0);
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u7535\u5b50\u8d85\u5e02\u91c7\u8d2d\u8ba2\u5355\uff08\u975eERP\uff09.pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extDirectPurchaseOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        List approvalLogBOS;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 100.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String OrderSource = null;
        String payType = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdPayConfPO> payConfList = this.getPayConfList(repBO);
        if (!payConfList.isEmpty()) {
            if (0 == payConfList.get(0).getPayType()) {
                payType = "\u9884\u4ed8\u6b3e\u652f\u4ed8";
            } else if (1 == payConfList.get(0).getPayType()) {
                payType = "\u5206\u9636\u6bb5\u652f\u4ed8";
            } else if (2 == payConfList.get(0).getPayType()) {
                payType = "\u8d26\u671f\u652f\u4ed8";
            } else if (3 == payConfList.get(0).getPayType()) {
                payType = "\u9884\u5b58\u6b3e\u652f\u4ed8";
            }
        }
        if ("3".equals(ordSaleRspPO.getOrderSource())) {
            OrderSource = "\u5185\u4ea7\u4e13\u533a";
        } else if ("7".equals(ordSaleRspPO.getOrderSource())) {
            OrderSource = "\u4e61\u6751\u632f\u5174";
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 10.0f, 0);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTitleFontNormal = new Font(baseFont, 11.0f, 0);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable tableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)tableN, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        tableList.add(tableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u4e70\u53d7\u4eba\uff1a" + buynerName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u8ba2\u5355\u7f16\u53f7\uff1a" + saleVoucherNo), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u91c7\u8d2d\u5355\u4f4d\uff1a" + purCompanyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4ed8\u6b3e\u65b9\u5f0f\uff1a" + payType), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable5 = new PdfPTable(30);
        tableList.add(pdfPTable5);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u8ba2\u5355\u6765\u6e90\uff1a" + OrderSource), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(1);
        tableList.add(pdfPTable7);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u7269\u8d44\u6e05\u5355", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(56);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5546\u54c1\u540d\u79f0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u5206\u7c7b", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7a0e\u7387", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5355\u4ef7", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u8ba1\u91cf\u5355\u4f4d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u91d1\u989d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65e5\u671f", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        tableList.add(pdfPTable8);
        String totalPrice = "";
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO ordItemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(ordItemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableQd = new PdfPTable(56);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getSkuName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialId(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getExtField2(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialTypeName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)(ordItemPO.getTax() + "%"), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    String salePrice = "";
                    if (null != ordItemPO.getSalePrice()) {
                        salePrice = "\uffe5" + new BigDecimal(ordItemPO.getSalePrice()).divide(new BigDecimal(10000), 2, 4);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)salePrice, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    if (null != ordItemPO.getPurchaseCount()) {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getPurchaseCount().intValue(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    } else {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getPurchaseCount(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getUnitName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    String totalSaleFee = "";
                    if (null != ordItemPO.getTotalSaleFee()) {
                        totalSaleFee = "\uffe5" + new BigDecimal(ordItemPO.getTotalSaleFee()).divide(new BigDecimal(10000), 2, 4);
                        sumPrice = sumPrice + ordItemPO.getTotalSaleFee();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)totalSaleFee, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getArrivalTime(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    tableList.add(pdfPTableQd);
                }
            }
            PdfPTable pdfPTable10 = new PdfPTable(1);
            tableList.add(pdfPTable10);
            if (sumPrice > 0L) {
                totalPrice = String.valueOf(new BigDecimal(sumPrice).divide(new BigDecimal(10000), 2, 4));
            }
            PdfUtils.addCellToTable((PdfPTable)pdfPTable10, (Object)("\u8ba2\u5355\u91d1\u989d\uff08\u542b\u7a0e\uff09\uff1a" + totalPrice), (Font)contentTitleFontNormal, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        }
        tableList.add(tableN);
        if (!payConfList.isEmpty()) {
            OrdPayConfPO ordPayConfPO = payConfList.get(0);
            this.doPayAccount(ordPayConfPO, tableList, contentTitleFont, contentFont);
        }
        tableList.add(tableN);
        PdfPTable pdfPTable16 = new PdfPTable(1);
        tableList.add(pdfPTable16);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u4e09\u3001\u5ba1\u6279\u8bb0\u5f55", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        if ("0000".equals(uocApprovalprocessListQryAbilityRspBO.getRespCode()) && !(approvalLogBOS = uocApprovalprocessListQryAbilityRspBO.getRows()).isEmpty()) {
            for (UocApprovalLogBO approvalLogBO : approvalLogBOS) {
                PdfPTable pdfPTableLog = new PdfPTable(1);
                pdfPTableLog.setWidthPercentage(79.0f);
                tableList.add(pdfPTableLog);
                if (StringUtils.isEmpty((String)approvalLogBO.getAuditAdvice())) {
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableLog, (Object)(approvalLogBO.getDealTimeStr() + "  " + approvalLogBO.getOperName() + approvalLogBO.getAudit()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
                    continue;
                }
                PdfUtils.addCellToTable((PdfPTable)pdfPTableLog, (Object)(approvalLogBO.getDealTimeStr() + "  " + approvalLogBO.getOperName() + approvalLogBO.getAudit() + "  \u5ba1\u6838\u610f\u89c1:" + approvalLogBO.getAuditAdvice()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
            }
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String string = "\u91c7\u8d2d\u4fa7-\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355\uff08\u76f4\u91c7\uff09" + ordSaleRspPO.getSaleVoucherNo() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, string, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extAgreementPurchaseOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        List approvalLogBOS;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 100.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String plaAgreementCode = null;
        String agreementName = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdPayConfPO> payConfList = this.getPayConfList(repBO);
        List<OrdAgreementPO> ordAgreementPOList = this.getOrdAgreementPOList(repBO);
        if (!ordAgreementPOList.isEmpty()) {
            plaAgreementCode = ordAgreementPOList.get(0).getPlaAgreementCode();
            agreementName = ordAgreementPOList.get(0).getAgreementName();
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 10.0f, 0);
        Font contentTitleFontNormal = new Font(baseFont, 11.0f, 0);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable tableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)tableN, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        tableList.add(tableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u4e70\u53d7\u4eba\uff1a" + buynerName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u8ba2\u5355\u7f16\u53f7\uff1a" + saleVoucherNo), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)("\u4f9b\u5e94\u5546\uff1a" + supplierName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)("\u5408\u540c\u7f16\u53f7\uff1a" + plaAgreementCode), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u91c7\u8d2d\u5355\u4f4d\uff1a" + purCompanyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfPTable pdfPTable5 = new PdfPTable(30);
        tableList.add(pdfPTable5);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        if (!StringUtils.isEmpty((String)agreementName) && agreementName.length() > 16) {
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u5408\u540c\u540d\u79f0\uff1a" + agreementName.substring(0, 16)), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)agreementName.substring(16, agreementName.length()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        } else {
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u5408\u540c\u540d\u79f0\uff1a" + agreementName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)30, (Integer)0);
        }
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(1);
        tableList.add(pdfPTable7);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u7269\u8d44\u6e05\u5355", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(52);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u5206\u7c7b", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7a0e\u7387", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5355\u4ef7", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u8ba1\u91cf\u5355\u4f4d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u91d1\u989d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65e5\u671f", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        tableList.add(pdfPTable8);
        String totalPrice = "";
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO ordItemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(ordItemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableQd = new PdfPTable(52);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getExtField2(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)8, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialId(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialTypeName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)(ordItemPO.getTax() + "%"), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    String salePrice = "";
                    if (null != ordItemPO.getSalePrice()) {
                        salePrice = "\uffe5" + new BigDecimal(ordItemPO.getSalePrice()).divide(new BigDecimal(10000), 2, 4);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)salePrice, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    if (null != ordItemPO.getPurchaseCount()) {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getPurchaseCount().intValue(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    } else {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getPurchaseCount(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getUnitName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    String totalSaleFee = "";
                    if (null != ordItemPO.getTotalSaleFee()) {
                        totalSaleFee = "\uffe5" + new BigDecimal(ordItemPO.getTotalSaleFee()).divide(new BigDecimal(10000), 2, 4);
                        sumPrice = sumPrice + ordItemPO.getTotalSaleFee();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)totalSaleFee, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getArrivalTime(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    tableList.add(pdfPTableQd);
                }
            }
            PdfPTable pdfPTable10 = new PdfPTable(1);
            tableList.add(pdfPTable10);
            if (sumPrice > 0L) {
                totalPrice = String.valueOf(new BigDecimal(sumPrice).divide(new BigDecimal(10000), 2, 4));
            }
            PdfUtils.addCellToTable((PdfPTable)pdfPTable10, (Object)("\u8ba2\u5355\u91d1\u989d\uff08\u542b\u7a0e\uff09\uff1a" + totalPrice), (Font)contentTitleFontNormal, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        }
        tableList.add(tableN);
        if (!payConfList.isEmpty()) {
            OrdPayConfPO ordPayConfPO = payConfList.get(0);
            this.doPayAccount(ordPayConfPO, tableList, contentTitleFont, contentFont);
        }
        tableList.add(tableN);
        PdfPTable pdfPTable16 = new PdfPTable(1);
        tableList.add(pdfPTable16);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u4e09\u3001\u5ba1\u6279\u8bb0\u5f55", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        if ("0000".equals(uocApprovalprocessListQryAbilityRspBO.getRespCode()) && !(approvalLogBOS = uocApprovalprocessListQryAbilityRspBO.getRows()).isEmpty()) {
            for (UocApprovalLogBO approvalLogBO : approvalLogBOS) {
                PdfPTable pdfPTableLog = new PdfPTable(1);
                pdfPTableLog.setWidthPercentage(79.0f);
                tableList.add(pdfPTableLog);
                if (StringUtils.isEmpty((String)approvalLogBO.getAuditAdvice())) {
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableLog, (Object)(approvalLogBO.getDealTimeStr() + "  " + approvalLogBO.getOperName() + approvalLogBO.getAudit()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
                    continue;
                }
                PdfUtils.addCellToTable((PdfPTable)pdfPTableLog, (Object)(approvalLogBO.getDealTimeStr() + "  " + approvalLogBO.getOperName() + approvalLogBO.getAudit() + "  \u5ba1\u6838\u610f\u89c1:" + approvalLogBO.getAuditAdvice()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
            }
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String string = "\u91c7\u8d2d\u4fa7-\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355\uff08\u5408\u540c\uff09" + ordSaleRspPO.getSaleVoucherNo() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, string, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extAgreementGoodsPurchaseOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        List approvalLogBOS;
        OrdLogisticsRelaPO ordLogisticsRelaPO;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String plaAgreementCode = null;
        String agreementName = null;
        String supRelaName = null;
        String supRelaMobile = null;
        String contactName = null;
        String contactMobile = null;
        String acceptManAddress = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
            supRelaName = ordStakeholderPO.getSupRelaName();
            supRelaMobile = ordStakeholderPO.getSupRelaMobile();
        }
        if (null != (ordLogisticsRelaPO = this.getOrdLogisticsRela(ordSaleRspPO.getContactId()))) {
            contactName = ordLogisticsRelaPO.getContactName();
            contactMobile = ordLogisticsRelaPO.getContactMobile();
            acceptManAddress = ordLogisticsRelaPO.getContactCountryName() + ordLogisticsRelaPO.getContactProvinceName() + ordLogisticsRelaPO.getContactCityName() + ordLogisticsRelaPO.getContactCountyName() + ordLogisticsRelaPO.getContactTown() + ordLogisticsRelaPO.getContactAddress();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdAgreementPO> ordAgreementPOList = this.getOrdAgreementPOList(repBO);
        if (!ordAgreementPOList.isEmpty()) {
            plaAgreementCode = ordAgreementPOList.get(0).getPlaAgreementCode();
            agreementName = ordAgreementPOList.get(0).getAgreementName();
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        String shenpLc = "";
        if ("0000".equals(uocApprovalprocessListQryAbilityRspBO.getRespCode()) && !(approvalLogBOS = uocApprovalprocessListQryAbilityRspBO.getRows()).isEmpty()) {
            for (UocApprovalLogBO approvalLogBO : approvalLogBOS) {
                shenpLc = shenpLc + approvalLogBO.getOperName() + "-";
            }
            if (shenpLc.length() > 0) {
                shenpLc = shenpLc.substring(0, shenpLc.length() - 1);
            }
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        String createOrderTime = sf.format(orderPO.getCreateTime());
        String chgTime = null;
        OrdStateChgLogPO ordStateChgLogPO = this.getOrdStateChgLog(repBO);
        if (ordStateChgLogPO != null) {
            chgTime = sf.format(ordStateChgLogPO.getChgTime());
        }
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 9.0f, 0);
        Font contentFontBold = new Font(baseFont, 9.0f, 1);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        pdfWriter.setPageEvent((PdfPageEvent)new PdfReportM1HeaderFooterUtil(new Phrase("\u5ba1\u6838\uff1a" + shenpLc, contentTableFont), new Phrase("\u4e0b\u5355\u65f6\u95f4\uff1a" + createOrderTime + "       \u5ba1\u6838\u751f\u6548\uff1a" + chgTime + "        \u6253\u5370\u65f6\u95f4\uff1a" + sf.format(new Date()), contentTableFont)));
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u81ea   \u8425   \u4e13   \u533a   \u8ba2   \u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        tableList.add(titleTable);
        PdfPTable titleTableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)titleTableN, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(5.0f), (Integer)1, (Integer)0);
        tableList.add(titleTableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        pdfPTable1.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"\u4f9b\u5e94\u5546\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)supplierName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"\u8ba2\u5355\u7f16\u53f7\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)saleVoucherNo, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        pdfPTable2.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4f9b\u8d27\u65b9\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)supName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u96c6\u91c7\u534f\u8bae\u7f16\u53f7\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)plaAgreementCode, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        pdfPTable3.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"\u4e70\u53d7\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)buynerName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"\u96c6\u91c7\u534f\u8bae\u540d\u79f0\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)agreementName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        pdfPTable4.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"\u4f7f\u7528\u5355\u4f4d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)uocOrdZmInfoRspPO.getUseDept(), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"\u4e0b\u5355\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)purPlaceOrderName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(30);
        tableList.add(pdfPTable7);
        pdfPTable7.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u91c7\u8d2d\u7269\u8d44\u540d\u79f0\u3001\u578b\u53f7\u3001\u6570\u91cf\u3001\u91d1\u989d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)15, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\uff08\u5e01\u79cd\uff1a\u4eba\u6c11\u5e01\uff09", (Font)contentFontBold, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(24);
        pdfPTable8.setWidthPercentage(90.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5e8f\u53f7", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5355\u4f4d", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u542b\u7a0e\u5355\u4ef7", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7a0e\u7387", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u542b\u7a0e\u91d1\u989d", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65f6\u95f4", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5907\u6ce8", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pdfPTable8);
        int i = 1;
        String totalPrice = "";
        Long totalCount = 0L;
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO itemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableInfo = new PdfPTable(24);
                    pdfPTableInfo.setWidthPercentage(90.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)i, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)1, null);
                    String wzbm = goodsPO.getSkuMaterialId();
                    if (!StringUtils.isEmpty((String)goodsPO.getExt4())) {
                        wzbm = goodsPO.getExt4();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)wzbm, (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)3, null);
                    String wzms = itemPO.getExtField2();
                    if (!StringUtils.isEmpty((String)goodsPO.getExt6())) {
                        wzms = goodsPO.getExt6();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)wzms, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)5, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)itemPO.getUnitName(), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    String purchaseCount = "";
                    if (null != itemPO.getPurchaseCount()) {
                        purchaseCount = new DecimalFormat("#,###").format(itemPO.getPurchaseCount());
                        totalCount = totalCount + (long)itemPO.getPurchaseCount().intValue();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)purchaseCount, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    String salePrice = "";
                    if (null != itemPO.getSalePrice()) {
                        salePrice = new DecimalFormat("#,###.00").format(new BigDecimal(itemPO.getSalePrice()).divide(new BigDecimal(10000), 2, 4).doubleValue());
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)salePrice, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)(itemPO.getTax() + "%"), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)1, null);
                    String totalSaleFee = "";
                    if (null != itemPO.getTotalSaleFee()) {
                        totalSaleFee = new DecimalFormat("#,###.00").format(new BigDecimal(itemPO.getTotalSaleFee()).divide(new BigDecimal(10000), 2, 4).doubleValue());
                        sumPrice = sumPrice + itemPO.getTotalSaleFee();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)totalSaleFee, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)itemPO.getArrivalTime(), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)goodsPO.getSkuMaterialRemark(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)4, null);
                    tableList.add(pdfPTableInfo);
                    ++i;
                }
            }
            PdfPTable pdfPTable10 = new PdfPTable(1);
            tableList.add(pdfPTable10);
            if (sumPrice > 0L) {
                totalPrice = new DecimalFormat("#,###.00").format(new BigDecimal(sumPrice).divide(new BigDecimal(10000), 2, 4).doubleValue());
            }
            PdfPTable pdfPTableTotal = new PdfPTable(24);
            pdfPTableTotal.setWidthPercentage(90.0f);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"\u5408\u8ba1\uff1a", (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)new DecimalFormat("#,###").format(totalCount), (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)1, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)totalPrice, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)6, null);
            tableList.add(pdfPTableTotal);
        }
        tableList.add(pdfPTable6);
        PdfPTable pdfPTable13 = new PdfPTable(30);
        tableList.add(pdfPTable13);
        pdfPTable13.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)"\u9001\u8d27\u65f6\u95f4\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)ordSaleRspPO.getGiveTime(), (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)27, (Integer)0);
        PdfPTable pdfPTable14 = new PdfPTable(30);
        tableList.add(pdfPTable14);
        pdfPTable14.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)"\u5907\u6ce8\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)orderPO.getOrderDesc(), (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)27, (Integer)0);
        tableList.add(pdfPTable6);
        PdfPTable pdfPTable15 = new PdfPTable(30);
        tableList.add(pdfPTable15);
        pdfPTable15.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable15, (Object)"\u4e8c\u3001\u6536\u8d27\u4fe1\u606f\u53ca\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)30, (Integer)0);
        PdfPTable pdfPTable16 = new PdfPTable(41);
        tableList.add(pdfPTable16);
        pdfPTable16.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u6536\u8d27\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)contactName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)contactMobile, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u6536\u8d27\u5730\u5740\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)acceptManAddress, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)19, (Integer)0);
        PdfPTable pdfPTable17 = new PdfPTable(41);
        tableList.add(pdfPTable17);
        pdfPTable17.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"\u5e73\u53f0\u516c\u53f8\u8054\u7cfb\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)uocOrdZmInfoRspPO.getSupplierMan(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)uocOrdZmInfoRspPO.getSupplierTel(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)16, (Integer)0);
        PdfPTable pdfPTable18 = new PdfPTable(41);
        tableList.add(pdfPTable18);
        pdfPTable18.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"\u4f9b\u8d27\u65b9\u8054\u7cfb\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)supRelaName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)supRelaMobile, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)16, (Integer)0);
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u81ea\u8425\u4e13\u533a\u91c7\u8d2d\u8ba2\u5355-\u91c7\u8d2d\u4fa7.pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extAgreementMaterialsPurchaseOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        List approvalLogBOS;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 100.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String plaAgreementCode = null;
        String agreementName = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdPayConfPO> payConfList = this.getPayConfList(repBO);
        List<OrdAgreementPO> ordAgreementPOList = this.getOrdAgreementPOList(repBO);
        if (!ordAgreementPOList.isEmpty()) {
            plaAgreementCode = ordAgreementPOList.get(0).getPlaAgreementCode();
            agreementName = ordAgreementPOList.get(0).getAgreementName();
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 10.0f, 0);
        Font contentTitleFontNormal = new Font(baseFont, 11.0f, 0);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable tableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)tableN, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        tableList.add(tableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u4e70\u53d7\u4eba\uff1a" + buynerName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u8ba2\u5355\u7f16\u53f7\uff1a" + saleVoucherNo), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)("\u4f9b\u5e94\u5546\uff1a" + supplierName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)("\u534f\u8bae\u7f16\u53f7\uff1a" + plaAgreementCode), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u91c7\u8d2d\u5355\u4f4d\uff1a" + purCompanyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfPTable pdfPTable5 = new PdfPTable(30);
        tableList.add(pdfPTable5);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        if (!StringUtils.isEmpty((String)agreementName) && agreementName.length() > 16) {
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u534f\u8bae\u540d\u79f0\uff1a" + agreementName.substring(0, 16)), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)agreementName.substring(16, agreementName.length()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        } else {
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u534f\u8bae\u540d\u79f0\uff1a" + agreementName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)30, (Integer)0);
        }
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(1);
        tableList.add(pdfPTable7);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u7269\u8d44\u6e05\u5355", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(52);
        pdfPTable8.setWidthPercentage(85.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u5206\u7c7b", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7a0e\u7387", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5355\u4ef7", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u8ba1\u91cf\u5355\u4f4d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u91d1\u989d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65e5\u671f", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        tableList.add(pdfPTable8);
        String totalPrice = "";
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO ordItemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(ordItemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableQd = new PdfPTable(52);
                    pdfPTableQd.setWidthPercentage(85.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getExtField2(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)8, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialId(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialTypeName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)(ordItemPO.getTax() + "%"), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    String salePrice = "";
                    if (null != ordItemPO.getSalePrice()) {
                        salePrice = "\uffe5" + new BigDecimal(ordItemPO.getSalePrice()).divide(new BigDecimal(10000), 2, 4);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)salePrice, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    if (null != ordItemPO.getPurchaseCount()) {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getPurchaseCount().intValue(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    } else {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getPurchaseCount(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getUnitName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    String totalSaleFee = "";
                    if (null != ordItemPO.getTotalSaleFee()) {
                        totalSaleFee = "\uffe5" + new BigDecimal(ordItemPO.getTotalSaleFee()).divide(new BigDecimal(10000), 2, 4);
                        sumPrice = sumPrice + ordItemPO.getTotalSaleFee();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)totalSaleFee, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)ordItemPO.getArrivalTime(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    tableList.add(pdfPTableQd);
                }
            }
            PdfPTable pdfPTable10 = new PdfPTable(1);
            tableList.add(pdfPTable10);
            if (sumPrice > 0L) {
                totalPrice = String.valueOf(new BigDecimal(sumPrice).divide(new BigDecimal(10000), 2, 4));
            }
            PdfUtils.addCellToTable((PdfPTable)pdfPTable10, (Object)("\u8ba2\u5355\u91d1\u989d\uff08\u542b\u7a0e\uff09\uff1a" + totalPrice), (Font)contentTitleFontNormal, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        }
        tableList.add(tableN);
        if (!payConfList.isEmpty()) {
            OrdPayConfPO ordPayConfPO = payConfList.get(0);
            this.doPayAccount(ordPayConfPO, tableList, contentTitleFont, contentFont);
        }
        tableList.add(tableN);
        PdfPTable pdfPTable16 = new PdfPTable(1);
        tableList.add(pdfPTable16);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u4e09\u3001\u5ba1\u6279\u8bb0\u5f55", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        if ("0000".equals(uocApprovalprocessListQryAbilityRspBO.getRespCode()) && !(approvalLogBOS = uocApprovalprocessListQryAbilityRspBO.getRows()).isEmpty()) {
            for (UocApprovalLogBO approvalLogBO : approvalLogBOS) {
                PdfPTable pdfPTableLog = new PdfPTable(1);
                pdfPTableLog.setWidthPercentage(79.0f);
                tableList.add(pdfPTableLog);
                if (StringUtils.isEmpty((String)approvalLogBO.getAuditAdvice())) {
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableLog, (Object)(approvalLogBO.getDealTimeStr() + "  " + approvalLogBO.getOperName() + approvalLogBO.getAudit()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
                    continue;
                }
                PdfUtils.addCellToTable((PdfPTable)pdfPTableLog, (Object)(approvalLogBO.getDealTimeStr() + "  " + approvalLogBO.getOperName() + approvalLogBO.getAudit() + "  \u5ba1\u6838\u610f\u89c1:" + approvalLogBO.getAuditAdvice()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
            }
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String string = "\u91c7\u8d2d\u4fa7-\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355\uff08\u534f\u8bae\u7269\u6599\uff09" + ordSaleRspPO.getSaleVoucherNo() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, string, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extElectronicSupermarketSupplyOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 100.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purPlaceOrderName = null;
        String companyName = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdPayConfPO> payConfList = this.getPayConfList(repBO);
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 10.0f, 0);
        Font contentTitleFontNormal = new Font(baseFont, 11.0f, 0);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable tableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)tableN, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        tableList.add(tableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u9700\u65b9\u5355\u4f4d\uff1a" + buynerName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u8ba2\u5355\u7f16\u53f7\uff1a" + saleVoucherNo), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4e70\u53d7\u4eba\uff1a\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)("\u5916\u90e8\u7535\u5546\u8ba2\u5355\u7f16\u53f7\uff1a" + outOrderNo), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u7236\u8ba2\u5355\u53f7\uff1a" + upperOrderId), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(1);
        tableList.add(pdfPTable7);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u7269\u8d44\u6e05\u5355", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(44);
        pdfPTable8.setWidthPercentage(75.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5546\u54c1\u540d\u79f0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u5206\u7c7b", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u8ba1\u91cf\u5355\u4f4d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5355\u4f4d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65e5\u671f", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        tableList.add(pdfPTable8);
        String totalPrice = "";
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO itemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableQd = new PdfPTable(44);
                    pdfPTableQd.setWidthPercentage(75.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getSkuName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialId(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getExtField2(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialTypeName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    if (null != itemPO.getPurchaseCount()) {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getPurchaseCount().intValue(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    } else {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getPurchaseCount(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getExtField3(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getUnitName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getArrivalTime(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    tableList.add(pdfPTableQd);
                }
            }
        }
        tableList.add(tableN);
        if (!payConfList.isEmpty()) {
            OrdPayConfPO ordPayConfPO = payConfList.get(0);
            this.doPayAccount(ordPayConfPO, tableList, contentTitleFont, contentFont);
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u4f9b\u5e94\u4fa7-\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355\uff08\u7535\u5b50\u8d85\u5e02\uff09" + ordSaleRspPO.getSaleVoucherNo() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extDirectSupplyOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 100.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String OrderSource = null;
        String payType = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdPayConfPO> payConfList = this.getPayConfList(repBO);
        if (!payConfList.isEmpty()) {
            if (0 == payConfList.get(0).getPayType()) {
                payType = "\u9884\u4ed8\u6b3e\u652f\u4ed8";
            } else if (1 == payConfList.get(0).getPayType()) {
                payType = "\u5206\u9636\u6bb5\u652f\u4ed8";
            } else if (2 == payConfList.get(0).getPayType()) {
                payType = "\u8d26\u671f\u652f\u4ed8";
            } else if (3 == payConfList.get(0).getPayType()) {
                payType = "\u9884\u5b58\u6b3e\u652f\u4ed8";
            }
        }
        if ("3".equals(ordSaleRspPO.getOrderSource())) {
            OrderSource = "\u5185\u4ea7\u4e13\u533a";
        } else if ("7".equals(ordSaleRspPO.getOrderSource())) {
            OrderSource = "\u4e61\u6751\u632f\u5174";
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 10.0f, 0);
        Font contentTitleFontNormal = new Font(baseFont, 11.0f, 0);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable tableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)tableN, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        tableList.add(tableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u4e70\u53d7\u4eba\uff1a" + buynerName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u8ba2\u5355\u7f16\u53f7\uff1a" + saleVoucherNo), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4ed8\u6b3e\u65b9\u5f0f\uff1a" + payType), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable5 = new PdfPTable(30);
        tableList.add(pdfPTable5);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u8ba2\u5355\u6765\u6e90\uff1a" + OrderSource), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(1);
        tableList.add(pdfPTable7);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u7269\u8d44\u6e05\u5355", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(40);
        pdfPTable8.setWidthPercentage(70.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5546\u54c1\u540d\u79f0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u5206\u7c7b", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u8ba1\u91cf\u5355\u4f4d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65e5\u671f", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        tableList.add(pdfPTable8);
        if (!orderItmeList.isEmpty()) {
            for (OrdItemPO itemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableQd = new PdfPTable(40);
                    pdfPTableQd.setWidthPercentage(70.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getSkuName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialId(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getExtField2(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialTypeName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    if (null != itemPO.getPurchaseCount()) {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getPurchaseCount().intValue(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    } else {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getPurchaseCount(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getUnitName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getArrivalTime(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    tableList.add(pdfPTableQd);
                }
            }
        }
        tableList.add(tableN);
        if (!payConfList.isEmpty()) {
            OrdPayConfPO ordPayConfPO = payConfList.get(0);
            this.doPayAccount(ordPayConfPO, tableList, contentTitleFont, contentFont);
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u4f9b\u5e94\u4fa7-\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355\uff08\u76f4\u91c7\uff09" + ordSaleRspPO.getSaleVoucherNo() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extAgreementSupplyOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 100.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String plaAgreementCode = null;
        String agreementName = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdPayConfPO> payConfList = this.getPayConfList(repBO);
        List<OrdAgreementPO> ordAgreementPOList = this.getOrdAgreementPOList(repBO);
        if (!ordAgreementPOList.isEmpty()) {
            plaAgreementCode = ordAgreementPOList.get(0).getPlaAgreementCode();
            agreementName = ordAgreementPOList.get(0).getAgreementName();
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 10.0f, 0);
        Font contentTitleFontNormal = new Font(baseFont, 11.0f, 0);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable tableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)tableN, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        tableList.add(tableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u9700\u65b9\u5355\u4f4d\uff1a" + buynerName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u8ba2\u5355\u7f16\u53f7\uff1a" + saleVoucherNo), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4e70\u53d7\u4eba\uff1a\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)("\u5408\u540c\u7f16\u53f7\uff1a" + plaAgreementCode), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        PdfPTable pdfPTable5 = new PdfPTable(30);
        tableList.add(pdfPTable5);
        if (!StringUtils.isEmpty((String)agreementName) && agreementName.length() > 16) {
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u5408\u540c\u540d\u79f0\uff1a" + agreementName.substring(0, 16)), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)agreementName.substring(16, agreementName.length()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)16, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        } else {
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u5408\u540c\u540d\u79f0\uff1a" + agreementName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        }
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(1);
        tableList.add(pdfPTable7);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u7269\u8d44\u6e05\u5355", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(34);
        pdfPTable8.setWidthPercentage(70.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u5206\u7c7b", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u8ba1\u91cf\u5355\u4f4d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65e5\u671f", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        tableList.add(pdfPTable8);
        String totalPrice = "";
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO itemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableQd = new PdfPTable(34);
                    pdfPTableQd.setWidthPercentage(70.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getExtField2(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)8, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialId(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialTypeName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    if (null != itemPO.getPurchaseCount()) {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getPurchaseCount().intValue(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    } else {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getPurchaseCount(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getUnitName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getArrivalTime(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    tableList.add(pdfPTableQd);
                }
            }
        }
        tableList.add(tableN);
        if (!payConfList.isEmpty()) {
            OrdPayConfPO ordPayConfPO = payConfList.get(0);
            this.doPayAccount(ordPayConfPO, tableList, contentTitleFont, contentFont);
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u4f9b\u5e94\u4fa7-\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355\uff08\u5408\u540c\uff09" + ordSaleRspPO.getSaleVoucherNo() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return null;
    }

    private String extAgreementGoodsSupplyOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        List approvalLogBOS;
        OrdLogisticsRelaPO ordLogisticsRelaPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 40.0f, 60.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String plaAgreementCode = null;
        String agreementName = null;
        String supRelaName = null;
        String supRelaMobile = null;
        String contactName = null;
        String contactMobile = null;
        String acceptManAddress = null;
        OrdStakeholderPO ordStakeholderPO = this.getOrdStakeholderPO(repBO);
        if (null != ordStakeholderPO) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
            supRelaName = ordStakeholderPO.getSupRelaName();
            supRelaMobile = ordStakeholderPO.getSupRelaMobile();
        }
        if (null != (ordLogisticsRelaPO = this.getOrdLogisticsRela(ordSaleRspPO.getContactId()))) {
            contactName = ordLogisticsRelaPO.getContactName();
            contactMobile = ordLogisticsRelaPO.getContactMobile();
            acceptManAddress = ordLogisticsRelaPO.getContactCountryName() + ordLogisticsRelaPO.getContactProvinceName() + ordLogisticsRelaPO.getContactCityName() + ordLogisticsRelaPO.getContactCountyName() + ordLogisticsRelaPO.getContactTown() + ordLogisticsRelaPO.getContactAddress();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdAgreementPO> ordAgreementPOList = this.getOrdAgreementPOList(repBO);
        if (!ordAgreementPOList.isEmpty()) {
            plaAgreementCode = ordAgreementPOList.get(0).getPlaAgreementCode();
            agreementName = ordAgreementPOList.get(0).getAgreementName();
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        String shenpLc = "";
        if ("0000".equals(uocApprovalprocessListQryAbilityRspBO.getRespCode()) && !(approvalLogBOS = uocApprovalprocessListQryAbilityRspBO.getRows()).isEmpty()) {
            for (UocApprovalLogBO approvalLogBO : approvalLogBOS) {
                shenpLc = shenpLc + approvalLogBO.getOperName() + "-";
            }
            if (shenpLc.length() > 0) {
                shenpLc = shenpLc.substring(0, shenpLc.length() - 1);
            }
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd");
        String createOrderTime = sf.format(orderPO.getCreateTime());
        String chgTime = null;
        OrdStateChgLogPO ordStateChgLogPO = this.getOrdStateChgLog(repBO);
        if (ordStateChgLogPO != null) {
            chgTime = sf.format(ordStateChgLogPO.getChgTime());
        }
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 9.0f, 0);
        Font contentFontBold = new Font(baseFont, 9.0f, 1);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        pdfWriter.setPageEvent((PdfPageEvent)new PdfReportM1HeaderFooterUtil(new Phrase("\u5ba1\u6838\uff1a" + shenpLc, contentTableFont), new Phrase("\u4e0b\u5355\u65f6\u95f4\uff1a" + createOrderTime + "       \u5ba1\u6838\u751f\u6548\uff1a" + chgTime + "        \u6253\u5370\u65f6\u95f4\uff1a" + sf.format(new Date()), contentTableFont)));
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u81ea   \u8425   \u4e13   \u533a   \u8ba2   \u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        tableList.add(titleTable);
        PdfPTable titleTableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)titleTableN, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(5.0f), (Integer)1, (Integer)0);
        tableList.add(titleTableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        pdfPTable1.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"\u4f9b\u8d27\u65b9\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)supName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"\u8ba2\u5355\u7f16\u53f7\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)saleVoucherNo, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        pdfPTable2.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4e70\u53d7\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u96c6\u91c7\u534f\u8bae\u7f16\u53f7\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)plaAgreementCode, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        pdfPTable3.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"\u9700\u65b9\u5355\u4f4d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)buynerName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"\u96c6\u91c7\u534f\u8bae\u540d\u79f0\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)agreementName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        pdfPTable4.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"\u4f7f\u7528\u5355\u4f4d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)uocOrdZmInfoRspPO.getUseDept(), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)1, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"\u4e0b\u5355\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)purPlaceOrderName, (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)11, (Integer)0);
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(30);
        tableList.add(pdfPTable7);
        pdfPTable7.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u91c7\u8d2d\u7269\u8d44\u540d\u79f0\u3001\u578b\u53f7\u3001\u6570\u91cf\u3001\u91d1\u989d\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)15, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\uff08\u5e01\u79cd\uff1a\u4eba\u6c11\u5e01\uff09", (Font)contentFontBold, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(24);
        pdfPTable8.setWidthPercentage(90.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5e8f\u53f7", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5355\u4f4d", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u542b\u7a0e\u5355\u4ef7", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7a0e\u7387", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u542b\u7a0e\u91d1\u989d", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65f6\u95f4", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u5907\u6ce8", (Font)contentFontBold, (Integer)1, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pdfPTable8);
        int i = 1;
        String totalPrice = "";
        Long totalCount = 0L;
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO itemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableInfo = new PdfPTable(24);
                    pdfPTableInfo.setWidthPercentage(90.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)i, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)1, null);
                    String wzbm = goodsPO.getSkuMaterialId();
                    if (!StringUtils.isEmpty((String)goodsPO.getExt4())) {
                        wzbm = goodsPO.getExt4();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)wzbm, (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)3, null);
                    String wzms = itemPO.getExtField2();
                    if (!StringUtils.isEmpty((String)goodsPO.getExt6())) {
                        wzms = goodsPO.getExt6();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)wzms, (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)5, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)itemPO.getUnitName(), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    String purchaseCount = "";
                    if (null != itemPO.getPurchaseCount()) {
                        purchaseCount = new DecimalFormat("#,###").format(itemPO.getPurchaseCount());
                        totalCount = totalCount + (long)itemPO.getPurchaseCount().intValue();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)purchaseCount, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    String purchasePrice = "";
                    if (null != itemPO.getPurchasePrice()) {
                        purchasePrice = new DecimalFormat("#,###.00").format(new BigDecimal(itemPO.getPurchasePrice()).divide(new BigDecimal(10000), 2, 4).doubleValue());
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)purchasePrice, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)(itemPO.getTax() + "%"), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)1, null);
                    String totalPurchaseFee = "";
                    if (null != itemPO.getTotalPurchaseFee()) {
                        totalPurchaseFee = new DecimalFormat("#,###.00").format(new BigDecimal(itemPO.getTotalPurchaseFee()).divide(new BigDecimal(10000), 2, 4).doubleValue());
                        sumPrice = sumPrice + itemPO.getTotalPurchaseFee();
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)totalPurchaseFee, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)itemPO.getArrivalTime(), (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)2, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableInfo, (Object)goodsPO.getSkuMaterialRemark(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(45.0f), (Integer)4, null);
                    tableList.add(pdfPTableInfo);
                    ++i;
                }
            }
            PdfPTable pdfPTable10 = new PdfPTable(1);
            tableList.add(pdfPTable10);
            if (sumPrice > 0L) {
                totalPrice = new DecimalFormat("#,###.00").format(new BigDecimal(sumPrice).divide(new BigDecimal(10000), 2, 4).doubleValue());
            }
            PdfPTable pdfPTableTotal = new PdfPTable(24);
            pdfPTableTotal.setWidthPercentage(90.0f);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"\u5408\u8ba1\uff1a", (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)11, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)new DecimalFormat("#,###").format(totalCount), (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)1, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)1, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)totalPrice, (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pdfPTableTotal, (Object)"", (Font)contentTableFont, (Integer)2, (Integer)4, (Float)Float.valueOf(15.0f), (Integer)6, null);
            tableList.add(pdfPTableTotal);
        }
        tableList.add(pdfPTable6);
        PdfPTable pdfPTable13 = new PdfPTable(30);
        tableList.add(pdfPTable13);
        pdfPTable13.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)"\u9001\u8d27\u65f6\u95f4\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable13, (Object)ordSaleRspPO.getGiveTime(), (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)27, (Integer)0);
        PdfPTable pdfPTable14 = new PdfPTable(30);
        tableList.add(pdfPTable14);
        pdfPTable14.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)"\u5907\u6ce8\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable14, (Object)orderPO.getOrderDesc(), (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)27, (Integer)0);
        tableList.add(pdfPTable6);
        PdfPTable pdfPTable15 = new PdfPTable(30);
        tableList.add(pdfPTable15);
        pdfPTable15.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable15, (Object)"\u4e8c\u3001\u6536\u8d27\u4fe1\u606f\u53ca\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a", (Font)contentFontBold, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)30, (Integer)0);
        PdfPTable pdfPTable16 = new PdfPTable(41);
        tableList.add(pdfPTable16);
        pdfPTable16.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u6536\u8d27\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)contactName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)contactMobile, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)"\u6536\u8d27\u5730\u5740\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable16, (Object)acceptManAddress, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)19, (Integer)0);
        PdfPTable pdfPTable17 = new PdfPTable(41);
        tableList.add(pdfPTable17);
        pdfPTable17.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"\u5e73\u53f0\u516c\u53f8\u8054\u7cfb\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)uocOrdZmInfoRspPO.getSupplierMan(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)uocOrdZmInfoRspPO.getSupplierTel(), (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable17, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)16, (Integer)0);
        PdfPTable pdfPTable18 = new PdfPTable(41);
        tableList.add(pdfPTable18);
        pdfPTable18.setWidthPercentage(89.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"\u4f9b\u8d27\u65b9\u8054\u7cfb\u4eba\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)supRelaName, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"\u8054\u7cfb\u7535\u8bdd\uff1a", (Font)contentFontBold, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)supRelaMobile, (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)6, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)5, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable18, (Object)"", (Font)contentFont, (Integer)0, (Integer)4, (Float)Float.valueOf(30.0f), (Integer)16, (Integer)0);
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u81ea\u8425\u4e13\u533a\u91c7\u8d2d\u8ba2\u5355-\u4f9b\u5e94\u4fa7.pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String extAgreementMaterialsSupplyOrder(OrderPrintPurchaseRepBO repBO, OrdSalePO ordSaleRspPO, UocOrdZmInfoPO uocOrdZmInfoRspPO, OrderPO orderPO) {
        String exportUrl;
        OrdStakeholderPO ordStakeholderPO;
        BaseFont baseFont;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4, -10.0f, 0.0f, 100.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        String buynerName = uocOrdZmInfoRspPO.getBuynerName();
        String saleVoucherNo = ordSaleRspPO.getSaleVoucherNo();
        String supplierName = uocOrdZmInfoRspPO.getSupplierName();
        String outOrderNo = null;
        String supName = null;
        Long upperOrderId = orderPO.getUpperOrderId();
        String purCompanyName = uocOrdZmInfoRspPO.getPurCompanyName();
        String purPlaceOrderName = null;
        String companyName = null;
        String plaAgreementCode = null;
        String agreementName = null;
        OrdQueryIndexPO ordQueryIndexRspPO = this.getOrdQueryIndexPO(repBO, 2);
        if (null != ordQueryIndexRspPO) {
            outOrderNo = ordQueryIndexRspPO.getOutOrderNo();
        }
        if (null != (ordStakeholderPO = this.getOrdStakeholderPO(repBO))) {
            supName = ordStakeholderPO.getSupName();
            purPlaceOrderName = ordStakeholderPO.getPurPlaceOrderName();
            companyName = ordStakeholderPO.getCompanyName();
        }
        List<OrdItemPO> orderItmeList = this.getOrderItmeList(repBO);
        List<OrdGoodsPO> orderGoodsList = this.getOrderGoodsList(repBO);
        List<OrdPayConfPO> payConfList = this.getPayConfList(repBO);
        List<OrdAgreementPO> ordAgreementPOList = this.getOrdAgreementPOList(repBO);
        if (!ordAgreementPOList.isEmpty()) {
            plaAgreementCode = ordAgreementPOList.get(0).getPlaAgreementCode();
            agreementName = ordAgreementPOList.get(0).getAgreementName();
        }
        UocApprovalprocessListQryAbilityReqBO uocApprovalprocessListQryAbilityReqBO = new UocApprovalprocessListQryAbilityReqBO();
        uocApprovalprocessListQryAbilityReqBO.setOrderId(repBO.getOrderId());
        uocApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(10));
        UocApprovalprocessListQryAbilityRspBO uocApprovalprocessListQryAbilityRspBO = this.uocApprovalprocessListQryAbilityService.getUccSkuApprovalprocessListQry(uocApprovalprocessListQryAbilityReqBO);
        int COLUMNS = 30;
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 10.0f, 0);
        Font contentTitleFontNormal = new Font(baseFont, 11.0f, 0);
        Font contentTitleFont = new Font(baseFont, 11.0f, 1);
        Font contentTableFont = new Font(baseFont, 9.0f, 0);
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        PdfPTable titleTable = new PdfPTable(1);
        tableList.add(titleTable);
        PdfUtils.addCellToTable((PdfPTable)titleTable, (Object)"\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355", (Font)titleFont, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable tableN = new PdfPTable(1);
        PdfUtils.addCellToTable((PdfPTable)tableN, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        tableList.add(tableN);
        PdfPTable pdfPTable1 = new PdfPTable(30);
        tableList.add(pdfPTable1);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u9700\u65b9\u5355\u4f4d\uff1a" + buynerName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable1, (Object)("\u8ba2\u5355\u7f16\u53f7\uff1a" + saleVoucherNo), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable2 = new PdfPTable(30);
        tableList.add(pdfPTable2);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"\u4e70\u53d7\u4eba\uff1a\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable2, (Object)("\u534f\u8bae\u7f16\u53f7\uff1a" + plaAgreementCode), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        PdfPTable pdfPTable3 = new PdfPTable(30);
        tableList.add(pdfPTable3);
        PdfPTable pdfPTable4 = new PdfPTable(30);
        tableList.add(pdfPTable4);
        PdfPTable pdfPTable5 = new PdfPTable(30);
        tableList.add(pdfPTable5);
        if (!StringUtils.isEmpty((String)agreementName) && agreementName.length() > 16) {
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u534f\u8bae\u540d\u79f0\uff1a" + agreementName.substring(0, 16)), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)agreementName.substring(16, agreementName.length()), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)16, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable5, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        } else {
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u4f9b\u8d27\u65b9\uff1a" + supName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable3, (Object)("\u534f\u8bae\u540d\u79f0\uff1a" + agreementName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u5355\u4f4d\uff1a" + companyName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)"", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)2, (Integer)0);
            PdfUtils.addCellToTable((PdfPTable)pdfPTable4, (Object)("\u4e0b\u5355\u4eba\uff1a" + purPlaceOrderName), (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)14, (Integer)0);
        }
        PdfPTable pdfPTable6 = new PdfPTable(1);
        tableList.add(pdfPTable6);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable6, (Object)"\n", (Font)contentFont, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable7 = new PdfPTable(1);
        tableList.add(pdfPTable7);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable7, (Object)"\u4e00\u3001\u7269\u8d44\u6e05\u5355", (Font)contentTitleFont, (Integer)0, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)1, (Integer)0);
        PdfPTable pdfPTable8 = new PdfPTable(36);
        pdfPTable8.setWidthPercentage(70.0f);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u63cf\u8ff0", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u7f16\u7801", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u7269\u8d44\u5206\u7c7b", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u6570\u91cf", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u8ba1\u91cf\u5355\u4f4d", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pdfPTable8, (Object)"\u4ea4\u8d27\u65e5\u671f", (Font)contentTableFont, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)6, null);
        tableList.add(pdfPTable8);
        if (!orderItmeList.isEmpty()) {
            Long sumPrice = 0L;
            for (OrdItemPO itemPO : orderItmeList) {
                if (orderGoodsList.isEmpty()) continue;
                for (OrdGoodsPO goodsPO : orderGoodsList) {
                    if (!goodsPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                    PdfPTable pdfPTableQd = new PdfPTable(36);
                    pdfPTableQd.setWidthPercentage(70.0f);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getExtField2(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)8, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialId(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)goodsPO.getSkuMaterialTypeName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    if (null != itemPO.getPurchaseCount()) {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getPurchaseCount().intValue(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    } else {
                        PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getPurchaseCount(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)4, null);
                    }
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getUnitName(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    PdfUtils.addCellToTable((PdfPTable)pdfPTableQd, (Object)itemPO.getArrivalTime(), (Font)contentTableFont, (Integer)0, (Integer)4, (Float)Float.valueOf(60.0f), (Integer)6, null);
                    tableList.add(pdfPTableQd);
                }
            }
        }
        tableList.add(tableN);
        if (!payConfList.isEmpty()) {
            OrdPayConfPO ordPayConfPO = payConfList.get(0);
            this.doPayAccount(ordPayConfPO, tableList, contentTitleFont, contentFont);
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u4f9b\u5e94\u4fa7-\u4e2d\u7164\u6613\u8d2d\u91c7\u8d2d\u8ba2\u5355\uff08\u534f\u8bae\u7269\u6599\uff09" + ordSaleRspPO.getSaleVoucherNo() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private void validateParams(OrderPrintPurchaseRepBO repBO) {
        if (null == repBO) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u5165\u53c2\u3010bo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (repBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)repBO.getSupplyAndPurchaseType())) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u4f9b\u5e94\u4fa7\u91c7\u8d2d\u4fa7\u6807\u8bc6\u3010supplyAndPurchaseType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(repBO.getSupplyAndPurchaseType()) && !"2".equals(repBO.getSupplyAndPurchaseType())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u5bfc\u51faPDF\u6253\u5370\u6587\u4ef6API\u4f9b\u5e94\u4fa7\u91c7\u8d2d\u4fa7\u6807\u8bc6\u3010supplyAndPurchaseType\u3011\u7c7b\u578b\u9519\u8bef");
        }
    }

    private String convertNullToString(Object obj) {
        if (obj == null) {
            return "-";
        }
        String value = String.valueOf(obj);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
            return "-";
        }
        return value;
    }
}

