/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.bo.other.UocProStationWebBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgByUserStationAbilityService;
import com.tydic.uoc.busibase.busi.bo.QryOrgByUserStationReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgByUserStationRspBO;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import com.tydic.uoc.common.busi.api.UocEsQryInspectionListBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryInspectionListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryInspectionListRspBO;
import com.tydic.uoc.common.comb.bo.AuthorityInfoBO;
import com.tydic.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.uoc.po.ConfTabOrdStatePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService"})
public class UocInspectionDetailsListPageQueryAbilityServiceImpl
implements UocInspectionDetailsListPageQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocInspectionDetailsListPageQueryAbilityServiceImpl.class);
    @Autowired
    private UocEsQryInspectionListBusiService esQryInspectionListBusiService;
    @Autowired
    private PebIntfQryOrgByUserStationAbilityService pebIntfQryOrgByUserStationAbilityService;
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;

    @PostMapping(value={"getInspectionDetailsList"})
    public UocInspectionDetailsListPageQueryRspBO getInspectionDetailsList(@RequestBody UocInspectionDetailsListPageQueryReqBO reqBO) {
        Boolean isPermission = this.controlPermission(reqBO);
        UocEsQryInspectionListRspBO esQryInspectionListRspBO = new UocEsQryInspectionListRspBO();
        if (isPermission.booleanValue()) {
            UocEsQryInspectionListReqBO esQryInspectionListReqBO = this.buildEsQryInspectionListReqBO(reqBO);
            if (null != reqBO.getTabId()) {
                esQryInspectionListReqBO.setInspectionStateList(this.getStatueList(reqBO.getTabId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getInspectionStateList())) {
                esQryInspectionListReqBO.setInspectionStateQuery(new ArrayList<Integer>(reqBO.getInspectionStateList()));
            }
            if (null != reqBO.getInspectionState()) {
                esQryInspectionListReqBO.setInspectionStateQuery(Collections.singletonList(reqBO.getInspectionState()));
            }
            if (UocCoreConstant.TabId.FSC_DEDICATED.equals(reqBO.getTabId())) {
                ArrayList<Integer> saleState = new ArrayList<Integer>(2);
                saleState.add(UocConstant.SALE_ORDER_STATUS.RECEIVED);
                saleState.add(UocConstant.SALE_ORDER_STATUS.ZONE_ACCEPT_PART);
                saleState.add(UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED);
                saleState.add(UocConstant.SALE_ORDER_STATUS.ARRIVED);
                esQryInspectionListReqBO.setSaleState(saleState);
            }
            esQryInspectionListRspBO = this.esQryInspectionListBusiService.esQryInspectionList(esQryInspectionListReqBO);
        }
        return this.transEsQryInspectionListRspBO(esQryInspectionListRspBO, isPermission, reqBO);
    }

    private UocEsQryInspectionListReqBO buildEsQryInspectionListReqBO(UocInspectionDetailsListPageQueryReqBO reqBO) {
        UocEsQryInspectionListReqBO esQryInspectionListReqBO = (UocEsQryInspectionListReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocEsQryInspectionListReqBO.class);
        if (null == reqBO.getIsAfterSales()) {
            esQryInspectionListReqBO.setIsAfterSales(true);
        } else {
            esQryInspectionListReqBO.setIsAfterSales(reqBO.getIsAfterSales());
        }
        return esQryInspectionListReqBO;
    }

    private UocInspectionDetailsListPageQueryRspBO transEsQryInspectionListRspBO(UocEsQryInspectionListRspBO esQryInspectionListRspBO, Boolean isPermission, UocInspectionDetailsListPageQueryReqBO reqBO) {
        UocInspectionDetailsListPageQueryRspBO rspBO = new UocInspectionDetailsListPageQueryRspBO();
        if (isPermission.booleanValue()) {
            rspBO.setPageNo(esQryInspectionListRspBO.getPageNo());
            rspBO.setTotal(esQryInspectionListRspBO.getTotal());
            rspBO.setRecordsTotal(esQryInspectionListRspBO.getRecordsTotal());
            if ((null == reqBO.getIsAfterSales() || reqBO.getIsAfterSales().booleanValue()) && CollectionUtils.isNotEmpty((Collection)esQryInspectionListRspBO.getRows())) {
                for (UocInspectionDetailsListBO inspectionDetailsListBO : esQryInspectionListRspBO.getRows()) {
                    inspectionDetailsListBO.getInspectionItemInfo().removeIf(inspectionItemListBO -> inspectionItemListBO.getAvailableAfterServCount().compareTo(BigDecimal.ZERO) <= 0);
                }
            }
            rspBO.setRows(esQryInspectionListRspBO.getRows());
            rspBO.setSumFieldInfo(esQryInspectionListRspBO.getSumFieldInfo());
        } else {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList(0));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Boolean controlPermission(UocInspectionDetailsListPageQueryReqBO reqBO) {
        if (null != reqBO.getIsControlData() && reqBO.getIsControlData().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u5c97\u4f4d\u4fe1\u606f[umcStationsListWebExt]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> orderSourceList = new ArrayList<String>();
            for (UocProStationWebBO stationWebBO : reqBO.getUmcStationsListWebExt()) {
                if ("cs:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("2");
                } else if ("zq:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("1");
                }
                if (orderSourceList.size() != 2) continue;
                break;
            }
            if (orderSourceList.size() == 0) {
                return false;
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderSourceList())) {
                reqBO.getOrderSourceList().removeIf(orderSource -> !orderSourceList.contains(orderSource));
            } else if (orderSourceList.size() < 2) {
                reqBO.setOrderSourceList(orderSourceList);
            }
        }
        if (null != reqBO.getIsControlPermission() && reqBO.getIsControlPermission().booleanValue()) {
            AuthorityInfoBO authorityInfoBO = this.getOrgInfo(reqBO);
            if (StringUtils.isNotBlank((CharSequence)reqBO.getIsProfessionalOrgExt())) {
                if ("1".equals(reqBO.getIsProfessionalOrgExt()) && !authorityInfoBO.getViewAllFlag().booleanValue()) {
                    if (!CollectionUtils.isEmpty(authorityInfoBO.getOrgList()) || !CollectionUtils.isEmpty(authorityInfoBO.getOrgListThrough())) {
                        reqBO.setOrgList(authorityInfoBO.getOrgList());
                        reqBO.setOrgListThrough(authorityInfoBO.getOrgListThrough());
                        reqBO.setPurNo(null);
                    }
                    reqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
                }
            } else if (!authorityInfoBO.getViewAllFlag().booleanValue()) {
                if (!CollectionUtils.isEmpty(authorityInfoBO.getOrgIdList())) {
                    reqBO.setPurNo(null);
                    reqBO.setPurNoList(authorityInfoBO.getOrgIdList());
                }
                reqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            }
        }
        return true;
    }

    private AuthorityInfoBO getOrgInfo(UocInspectionDetailsListPageQueryReqBO reqBO) {
        QryOrgByUserStationReqBO qryOrgReqBO = new QryOrgByUserStationReqBO();
        if (null == reqBO.getMemIdExt() || 0L == reqBO.getMemIdExt()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4f1a\u5458ID[memIdExt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        qryOrgReqBO.setMemIdExt(reqBO.getMemIdExt());
        qryOrgReqBO.setStationType("ORDER_QRY_ORG_AUTH");
        QryOrgByUserStationRspBO qryOrgRspBO = this.pebIntfQryOrgByUserStationAbilityService.qryOrgTreePathByUserStation(qryOrgReqBO);
        log.debug("\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u673a\u6784\u5217\u8868\u7ed3\u679c\u4e3a:{}", (Object)JSON.toJSONString((Object)qryOrgRspBO));
        if (!"0000".equals(qryOrgRspBO.getRespCode())) {
            throw new UocProBusinessException(qryOrgRspBO.getRespCode(), qryOrgRspBO.getRespDesc());
        }
        AuthorityInfoBO authorityInfoBO = new AuthorityInfoBO();
        if (!qryOrgRspBO.getViewAllFlag().booleanValue()) {
            authorityInfoBO.setOrgList(qryOrgRspBO.getOrgList());
            authorityInfoBO.setOrgListThrough(qryOrgRspBO.getOrgListThrough());
        }
        authorityInfoBO.setViewAllFlag(qryOrgRspBO.getViewAllFlag());
        return authorityInfoBO;
    }

    private List<Integer> getStatueList(Integer tabId) {
        ConfTabOrdStatePO confTabOrdStatePO = this.confTabOrdStateMapper.getModelById((long)tabId.intValue());
        if (null != confTabOrdStatePO) {
            ArrayList<Integer> statueItemList = new ArrayList<Integer>();
            String statueStr = confTabOrdStatePO.getOrderStatusCode();
            if (!StringUtils.isEmpty((CharSequence)statueStr)) {
                String[] statue = statueStr.contains(",") ? statueStr.split(",") : new String[]{statueStr};
                for (String state : statue) {
                    statueItemList.add(Integer.valueOf(state));
                }
            }
            return statueItemList;
        }
        throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u9875\u7b7e\uff08tabId\uff09\u914d\u7f6e\u4fe1\u606f");
    }
}

