/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.PebQryOrderStatusAbilityService;
import com.tydic.uoc.common.ability.api.UocProOrderCreateResultQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrderStatusBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderStatusBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderStatusReqBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderStatusRspBO;
import com.tydic.uoc.common.ability.bo.UocProOrderCreateResultQryAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderCreateResultQryAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocProOrderCreateResultQryOrdersBo;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.SysDicDictionaryMapper;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.SysDicDictionaryPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderCreateResultQryAbilityService"})
public class UocProOrderCreateResultQryAbilityServiceImpl
implements UocProOrderCreateResultQryAbilityService {
    @Autowired
    private PebQryOrderStatusAbilityService pebQryOrderStatusAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @PostMapping(value={"qryOrderResult"})
    public UocProOrderCreateResultQryAbilityRspBo qryOrderResult(@RequestBody UocProOrderCreateResultQryAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        OrdSalePO qryListPo = new OrdSalePO();
        qryListPo.setMergeOrderId(reqBo.getMergeOrderId());
        List list = this.ordSaleMapper.getList(qryListPo);
        Map<Long, OrdSalePO> collect = list.stream().collect(Collectors.toMap(OrdSalePO::getOrderId, po -> po));
        if (ObjectUtil.isEmpty((Object)list)) {
            throw new UocProBusinessException("104002", "\u8be5mergeOrderId(" + reqBo.getMergeOrderId() + ")\u4e0b\u6ca1\u6709\u6570\u636e");
        }
        PebQryOrderStatusReqBO qryReqBo = new PebQryOrderStatusReqBO();
        ArrayList<PebQryOrderStatusBO> orderStatusList = new ArrayList<PebQryOrderStatusBO>();
        qryReqBo.setOrderStatusList(orderStatusList);
        for (OrdSalePO salePo : list) {
            PebQryOrderStatusBO tBo = new PebQryOrderStatusBO();
            tBo.setOrderId(salePo.getOrderId());
            orderStatusList.add(tBo);
        }
        PebQryOrderStatusRspBO qryRspBo = this.pebQryOrderStatusAbilityService.qryOrderStatus(qryReqBo);
        if (!"0000".equals(qryRspBo.getRespCode())) {
            throw new UocProBusinessException("104002", "\u67e5\u8be2\u5931\u8d25\uff1a" + qryRspBo.getRespDesc());
        }
        UocProOrderCreateResultQryAbilityRspBo rspBo = (UocProOrderCreateResultQryAbilityRspBo)UocProRspBoUtil.success(UocProOrderCreateResultQryAbilityRspBo.class);
        Map<String, String> dicMap = this.qryDic();
        List orderInfos = qryRspBo.getOrderInfo();
        for (PebOrderStatusBO orderInfo : orderInfos) {
            UocProOrderCreateResultQryOrdersBo rspTmpBo = new UocProOrderCreateResultQryOrdersBo();
            BeanUtils.copyProperties((Object)orderInfo, (Object)rspTmpBo);
            if ("2".equals(orderInfo.getOrderSource()) && UocCoreConstant.RESULT_CODE.SUCCESS.equals(orderInfo.getResultCode()) && UocConstant.SALE_ORDER_STATUS.PAYING.equals(orderInfo.getSaleState())) {
                rspBo.getCanPayOrders().add(rspTmpBo);
            } else {
                rspBo.getNeedApprovedOrders().add(rspTmpBo);
            }
            OrderPO orderPO = this.orderMapper.getModelById(orderInfo.getOrderId().longValue());
            rspTmpBo.setCreateTime(orderPO.getCreateTime());
            OrdPayPO qryPayPo = new OrdPayPO();
            qryPayPo.setOrderId(orderInfo.getOrderId());
            qryPayPo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            OrdPayPO modelBy = this.ordPayMapper.getModelBy(qryPayPo);
            if (modelBy != null) {
                rspTmpBo.setPayType(modelBy.getPayType());
                rspTmpBo.setPayTypeName(dicMap.get(rspTmpBo.getPayType().toString()));
            }
            rspTmpBo.setOrderSource(collect.get(orderInfo.getOrderId()).getOrderSource());
            rspTmpBo.setSaleVoucherId(collect.get(orderInfo.getOrderId()).getSaleVoucherId());
        }
        return rspBo;
    }

    private Map<String, String> qryDic() {
        SysDicDictionaryPO qryPo = new SysDicDictionaryPO();
        qryPo.setPCode("FSC_PAY_TYPE");
        List list = this.sysDicDictionaryMapper.getList(qryPo);
        return list.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getDescrip));
    }

    private void validateArg(UocProOrderCreateResultQryAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104002", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getMergeOrderId())) {
            throw new UocProBusinessException("104002", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[mergeOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

