/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebOrderItemAdjustBO;
import com.tydic.uoc.common.ability.bo.UocPebAccessoryBO;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocZoneSpecificLinkBusiToDealAtomService;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocZoneSpecificLinkBusiToDealAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocZoneSpecificLinkBusiToDealAtomRspBO;
import com.tydic.uoc.common.busi.api.UocGeneralCirculationBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdItemWtLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdSaleMtLogMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdItemWtLogPO;
import com.tydic.uoc.po.OrdSaleMtLogPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocGeneralCirculationBusiServiceImpl
implements UocGeneralCirculationBusiService {
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocZoneSpecificLinkBusiToDealAtomService uocZoneSpecificLinkBusiToDealAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private OrdItemWtLogMapper ordItemWtLogMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdSaleMtLogMapper ordSaleMtLogMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Value(value="${uoc.main.pro.org:100096,100100}")
    private String proOrg;

    @Override
    public UocGeneralCirculationRspBO dealGeneralCirculation(UocGeneralCirculationReqBO reqBO) {
        UocGeneralCirculationRspBO rspBO = new UocGeneralCirculationRspBO();
        if (reqBO.getAuthCtrl() == null) {
            reqBO.setAuthCtrl(PecConstant.AuthCtrl.NO_CTRL);
        }
        if ("ADMIN_COMFIM".equals(reqBO.getActionCode())) {
            reqBO.setObjType(2);
            this.doRunProcess(reqBO, new HashMap<String, Object>(), rspBO);
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(reqBO.getOrderId());
            orderPO.setExt1(reqBO.getLoginName());
            orderPO.setExt2(reqBO.getUserId() + "");
            orderPO.setExt3(reqBO.getName());
            this.orderMapper.updateById(orderPO);
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            String ext5 = String.valueOf(reqBO.getOrgId());
            block0: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    ext5 = pro;
                    continue block0;
                }
            }
            OrdSalePO salePO = new OrdSalePO();
            salePO.setExt5(ext5);
            salePO.setOrderId(reqBO.getOrderId());
            salePO.setSaleVoucherId(reqBO.getObjId());
            this.ordSaleMapper.updateById(salePO);
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(reqBO.getOrderId());
            zmInfoPO.setSupplierTel(reqBO.getCellphone());
            zmInfoPO.setSupplierMan(reqBO.getName());
            this.uocOrdZmInfoMapper.update(zmInfoPO);
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        this.doCheckAuthority(reqBO);
        this.doStateCheck(reqBO);
        this.saveFile(reqBO);
        if (!StringUtils.isEmpty((Object)reqBO.getRemark())) {
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(reqBO.getOrderId());
            orderPO.setExt5(reqBO.getRemark());
            this.orderMapper.updateById(orderPO);
        }
        if (CollectionUtils.isEmpty(reqBO.getOrderItemAdjustList())) {
            Map<String, Object> variables = this.doSpecificLinks(reqBO);
            this.doRunProcess(reqBO, variables, rspBO);
        } else {
            this.saveAdjustPrice(reqBO, rspBO);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void saveAdjustPrice(UocGeneralCirculationReqBO reqBO, UocGeneralCirculationRspBO rspBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherId(reqBO.getObjId());
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdSaleMtLogPO ordSaleMtLogPO = new OrdSaleMtLogPO();
        BeanUtils.copyProperties((Object)salePO, (Object)ordSaleMtLogPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        ArrayList<OrdItemWtLogPO> list = new ArrayList<OrdItemWtLogPO>(reqBO.getOrderItemAdjustList().size());
        Long saleFee = 0L;
        Long purFee = 0L;
        Long adjustSaleFee = 0L;
        Long adjustPurFee = 0L;
        block2: for (PebOrderItemAdjustBO pebOrderItemAdjustBO : reqBO.getOrderItemAdjustList()) {
            for (OrdItemPO itemPO : itemPOS) {
                if (!itemPO.getOrdItemId().equals(pebOrderItemAdjustBO.getSaleOrderItemId())) continue;
                OrdItemWtLogPO po = new OrdItemWtLogPO();
                BeanUtils.copyProperties((Object)itemPO, (Object)po);
                try {
                    po.setId(Long.valueOf(this.idUtil.nextId()));
                    po.setIsNew(UocConstant.IS_NEW.NEW);
                    po.setSalePrice(itemPO.getSalePrice());
                    po.setPurchasePrice(itemPO.getPurchasePrice());
                    po.setTotalSaleFee(Long.valueOf(new BigDecimal(itemPO.getSalePrice()).multiply(itemPO.getPurchaseCount()).longValue()));
                    po.setTotalPurchaseFee(Long.valueOf(new BigDecimal(itemPO.getPurchasePrice()).multiply(itemPO.getPurchaseCount()).longValue()));
                    po.setAdjustSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)pebOrderItemAdjustBO.getSalePriceNew()));
                    po.setMarkUpRate(Double.valueOf(pebOrderItemAdjustBO.getMarkUpRateNew().doubleValue()));
                    po.setAdjustPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)pebOrderItemAdjustBO.getPurchasingPriceNew()));
                    po.setAdjustTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)pebOrderItemAdjustBO.getSalePriceNew().multiply(itemPO.getPurchaseCount())));
                    po.setAdjustTotalPurchaseFee(MoneyUtils.BigDecimal2Long((BigDecimal)pebOrderItemAdjustBO.getPurchasingPriceNew().multiply(itemPO.getPurchaseCount())));
                    po.setOldAdjustRate(itemPO.getMarkUpRate());
                    po.setNewAdjustRate(Double.valueOf(pebOrderItemAdjustBO.getMarkUpRateNew().doubleValue()));
                    po.setAdjustTime(new Date());
                    saleFee = saleFee + po.getTotalSaleFee();
                    purFee = purFee + po.getTotalPurchaseFee();
                    adjustSaleFee = adjustSaleFee + po.getAdjustTotalSaleFee();
                    adjustPurFee = adjustPurFee + po.getAdjustTotalPurchaseFee();
                }
                catch (Exception e) {
                    throw new UocProBusinessException("102029", "\u8ba2\u5355\u660e\u7ec6\u8c03\u4ef7\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                }
                list.add(po);
                continue block2;
            }
        }
        Map<Long, PebOrderItemAdjustBO> map = reqBO.getOrderItemAdjustList().stream().collect(Collectors.toMap(PebOrderItemAdjustBO::getSaleOrderItemId, i -> i));
        for (OrdItemPO itemPO : itemPOS) {
            if (map.get(itemPO.getOrdItemId()) != null) continue;
            saleFee = saleFee + itemPO.getTotalSaleFee();
            purFee = purFee + itemPO.getTotalPurchaseFee();
            adjustSaleFee = adjustSaleFee + itemPO.getTotalSaleFee();
            adjustPurFee = adjustPurFee + itemPO.getTotalPurchaseFee();
        }
        ordSaleMtLogPO.setAdjustOper(reqBO.getUserId().toString());
        ordSaleMtLogPO.setAdjustOperName(reqBO.getUsername());
        ordSaleMtLogPO.setAdjustTime(new Date());
        ordSaleMtLogPO.setSaleFee(saleFee);
        ordSaleMtLogPO.setPurchaseFee(purFee);
        ordSaleMtLogPO.setAdjustSaleFee(adjustSaleFee);
        ordSaleMtLogPO.setAdjustPurchaseFee(adjustPurFee);
        ordSaleMtLogPO.setIsNew(UocConstant.IS_NEW.NEW);
        ordSaleMtLogPO.setId(Long.valueOf(this.idUtil.nextId()));
        ordSaleMtLogPO.setPlaAgreementCode(reqBO.getRemark());
        this.ordSaleMtLogMapper.insert(ordSaleMtLogPO);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            this.ordItemWtLogMapper.insertBatch(list);
        }
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        ordExtMapPO.setObjId(reqBO.getOrderId());
        ordExtMapPO.setOrderId(reqBO.getOrderId());
        ordExtMapPO.setFieldCode("adjust_price_time");
        OrdExtMapPO extMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
        String time = DateUtils.dateToStrLong((Date)new Date());
        if (extMapPO == null) {
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(time);
            ordExtMapPO.setFieldName("\u8c03\u4ef7\u65f6\u95f4");
            this.ordExtMapMapper.insert(ordExtMapPO);
        } else {
            ordExtMapPO.setId(extMapPO.getId());
            ordExtMapPO.setFieldValue(time);
            this.ordExtMapMapper.updateById(ordExtMapPO);
        }
        OrdExtMapPO orRemarkMapPO = new OrdExtMapPO();
        orRemarkMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        orRemarkMapPO.setObjId(reqBO.getOrderId());
        orRemarkMapPO.setOrderId(reqBO.getOrderId());
        orRemarkMapPO.setFieldCode("adjust_price_remark");
        OrdExtMapPO extMapRemarkPO = this.ordExtMapMapper.getModelBy(orRemarkMapPO);
        if (extMapRemarkPO == null) {
            orRemarkMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            orRemarkMapPO.setFieldValue(reqBO.getRemark());
            orRemarkMapPO.setFieldName("\u8c03\u4ef7\u5907\u6ce8");
            this.ordExtMapMapper.insert(orRemarkMapPO);
        } else {
            orRemarkMapPO.setId(extMapRemarkPO.getId());
            orRemarkMapPO.setFieldName("\u8c03\u4ef7\u5907\u6ce8");
            orRemarkMapPO.setFieldValue(reqBO.getRemark());
            this.ordExtMapMapper.updateById(orRemarkMapPO);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("cancelFlag", 4);
        this.doRunProcess(reqBO, variables, rspBO);
    }

    private void saveFile(UocGeneralCirculationReqBO reqBO) {
        List<UocPebAccessoryBO> pebAccessoryReqBOList = reqBO.getAccessoryList();
        if (!CollectionUtils.isEmpty(pebAccessoryReqBOList)) {
            for (UocPebAccessoryBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setObjectType(reqBO.getObjType());
                uocCoreCreateAccessoryReqBO.setObjectId(reqBO.getObjId());
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("100001", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
    }

    private void doCheckAuthority(UocGeneralCirculationReqBO reqBO) {
        if (!PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO permissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)permissionsCheckingAtomReqBO));
            PebOperationPermissionsCheckingAtomRspBO permissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(permissionsCheckingAtomReqBO);
            if (!"0000".equals(permissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6743\u9650\u6821\u9a8c\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + permissionsCheckingAtomRspBO.getRespDesc());
            }
        }
    }

    private void doStateCheck(UocGeneralCirculationReqBO reqBO) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getObjId());
        uocCoreStateCheckAtomReqBO.setObjType(reqBO.getObjType());
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
    }

    private Map<String, Object> doSpecificLinks(UocGeneralCirculationReqBO reqBO) {
        UocZoneSpecificLinkBusiToDealAtomReqBO specificLinkReq = new UocZoneSpecificLinkBusiToDealAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)specificLinkReq));
        UocZoneSpecificLinkBusiToDealAtomRspBO specificLinkRsp = this.uocZoneSpecificLinkBusiToDealAtomService.dealSpecificLinkBusi(specificLinkReq);
        if (!"0000".equals(specificLinkRsp.getRespCode())) {
            throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u7279\u5b9a\u73af\u8282\u4e1a\u52a1\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + specificLinkRsp.getRespDesc());
        }
        return specificLinkRsp.getVariables();
    }

    private void doRunProcess(UocGeneralCirculationReqBO reqBO, Map<String, Object> map, UocGeneralCirculationRspBO rspBO) {
        rspBO.setAuto(this.run(reqBO.getOrderId(), reqBO.getObjId(), reqBO.getUserId() + "", map, reqBO.getObjType()));
    }

    private boolean run(Long orderId, Long objId, String userId, Map<String, Object> map, Integer objType) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setVariables(map);
        processRunReqBO.setOperId(userId);
        processRunReqBO.setSysCode("eb_el_sale_order_master_order_status");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(orderId);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102034", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        return uocProcessRunRspBO.getAuto();
    }
}

