/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.UocQrySupplierQuotaConfigAbilityService;
import com.tydic.uoc.common.ability.bo.UocQrySupplierQuotaConfigAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocQrySupplierQuotaConfigAbilityReqSkuBo;
import com.tydic.uoc.common.ability.bo.UocQrySupplierQuotaConfigAbilityRspBo;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.po.ConfSupplierPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocQrySupplierQuotaConfigAbilityService"})
public class UocQrySupplierQuotaConfigAbilityServiceImpl
implements UocQrySupplierQuotaConfigAbilityService {
    @Autowired
    private ConfSupplierMapper confSupplierMapper;

    @PostMapping(value={"checkSupQuotaLimit"})
    public UocQrySupplierQuotaConfigAbilityRspBo checkSupQuotaLimit(@RequestBody UocQrySupplierQuotaConfigAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        Set supplierSet = reqBo.getItemList().stream().map(UocQrySupplierQuotaConfigAbilityReqSkuBo::getGoodsSupplierId).collect(Collectors.toSet());
        ConfSupplierPO qrySupConfPo = new ConfSupplierPO();
        qrySupConfPo.setSupplierNos(new ArrayList(supplierSet));
        List confSupplierMapperList = this.confSupplierMapper.getList(qrySupConfPo);
        Map<Long, ConfSupplierPO> supConfigMap = confSupplierMapperList.stream().collect(Collectors.toMap(ConfSupplierPO::getSupNo, obj -> obj));
        Map<Long, List<UocQrySupplierQuotaConfigAbilityReqSkuBo>> supMap = reqBo.getItemList().stream().collect(Collectors.groupingBy(UocQrySupplierQuotaConfigAbilityReqSkuBo::getGoodsSupplierId));
        for (Map.Entry<Long, List<UocQrySupplierQuotaConfigAbilityReqSkuBo>> tMap : supMap.entrySet()) {
            Long key = tMap.getKey();
            List<UocQrySupplierQuotaConfigAbilityReqSkuBo> value = tMap.getValue();
            ConfSupplierPO confSupplierPO = supConfigMap.get(key);
            if (confSupplierPO == null) continue;
            BigDecimal totalPrice = new BigDecimal(0);
            for (UocQrySupplierQuotaConfigAbilityReqSkuBo skuBo : value) {
                if (confSupplierPO.getOrderLimit() == null) continue;
                totalPrice = skuBo.getPurchaseCount().multiply(skuBo.getSkuSalePrice()).add(totalPrice);
            }
            try {
                Long aLong = UocMoneyUtil.BigDecimal2Long((BigDecimal)totalPrice);
                if (confSupplierPO.getOrderLimit() <= aLong) continue;
                return (UocQrySupplierQuotaConfigAbilityRspBo)UocProRspBoUtil.failed((String)(confSupplierPO.getSupName() + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3[" + UocMoneyUtil.Long2BigDecimal((Long)confSupplierPO.getOrderLimit()).toString() + "]\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002"), UocQrySupplierQuotaConfigAbilityRspBo.class);
            }
            catch (Exception e) {
                throw new UocProBusinessException("104001", "BigDecimal2Long\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
        return (UocQrySupplierQuotaConfigAbilityRspBo)UocProRspBoUtil.success(UocQrySupplierQuotaConfigAbilityRspBo.class);
    }

    private void validateArgs(UocQrySupplierQuotaConfigAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemList = reqBo.getItemList();
        if (ObjectUtil.isEmpty((Object)itemList)) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocQrySupplierQuotaConfigAbilityReqSkuBo tBo : itemList) {
            if (ObjectUtil.isEmpty((Object)tBo)) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getGoodsSupplierId())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getPurchaseCount())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tBo.getSkuId())) {
                throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)tBo.getSkuSalePrice())) continue;
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5c5e\u6027itemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[skuSalePrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

