/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.CheckBusiCodeByStationCodeAbilityService;
import com.tydic.uoc.busibase.busi.bo.CheckBusiCodeByStationCodeReqBO;
import com.tydic.uoc.busibase.busi.bo.CheckBusiCodeByStationCodeRspBO;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebOperationPermissionsCheckingAtomServiceImpl
implements PebOperationPermissionsCheckingAtomService {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private CheckBusiCodeByStationCodeAbilityService checkBusiCodeByStationCodeAbilityService;

    @Override
    public PebOperationPermissionsCheckingAtomRspBO dealPebOperationPermissionsChecking(PebOperationPermissionsCheckingAtomReqBO reqBO) {
        this.checkParameter(reqBO);
        this.validAuthority(reqBO);
        PebOperationPermissionsCheckingAtomRspBO rspBO = new PebOperationPermissionsCheckingAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u901a\u8fc7");
        return rspBO;
    }

    private void validAuthority(PebOperationPermissionsCheckingAtomReqBO reqBO) {
        if (PecConstant.AuthCtrl.SELF.equals(reqBO.getAuthCtrl())) {
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(reqBO.getOrderId());
            orderPO.setCreateOperId(reqBO.getMemId() + "");
            orderPO = this.orderMapper.getModelBy(orderPO);
            if (orderPO == null) {
                throw new UocProBusinessException("100001", "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u64cd\u4f5c\u4eba\u4e0e\u8ba2\u5355\u521b\u5efa\u4eba\u4e0d\u5339\u914d");
            }
        } else if (PecConstant.AuthCtrl.STATION.equals(reqBO.getAuthCtrl())) {
            CheckBusiCodeByStationCodeReqBO checkBusiCodeByStationCodeReqBO = new CheckBusiCodeByStationCodeReqBO();
            checkBusiCodeByStationCodeReqBO.setStationCode(reqBO.getStationId());
            checkBusiCodeByStationCodeReqBO.setBusiCode(reqBO.getActionCode());
            CheckBusiCodeByStationCodeRspBO checkBusiCodeByStationCodeRspBO = this.checkBusiCodeByStationCodeAbilityService.checkBusiCodeByStationCode(checkBusiCodeByStationCodeReqBO);
            if (!"0000".equals(checkBusiCodeByStationCodeRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", checkBusiCodeByStationCodeRspBO.getRespDesc());
            }
        } else if (PecConstant.AuthCtrl.DELIVERY.equals(reqBO.getAuthCtrl())) {
            OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
            ordStakeholderPO.setOrderId(reqBO.getOrderId());
            ordStakeholderPO.setProDeliveryId(reqBO.getMemId() + "");
            ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
            if (ordStakeholderPO == null) {
                throw new UocProBusinessException("100001", "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u64cd\u4f5c\u4eba\u4e0e\u8ba2\u5355\u914d\u9001\u5458\u4e0d\u5339\u914d");
            }
        }
    }

    private void checkParameter(PebOperationPermissionsCheckingAtomReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAuthCtrl() == null) {
            throw new UocProBusinessException("100002", "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010\u6743\u9650\u63a7\u5236\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (PecConstant.AuthCtrl.SELF.equals(reqBO.getAuthCtrl()) || PecConstant.AuthCtrl.DELIVERY.equals(reqBO.getAuthCtrl())) {
            if (StringUtils.isEmpty((Object)reqBO.getMemId())) {
                throw new UocProBusinessException("100002", "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010\u64cd\u4f5c\u4eba\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getOrderId() == null) {
                throw new UocProBusinessException("100002", "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010\u8ba2\u5355\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else {
            if (PecConstant.AuthCtrl.STATION.equals(reqBO.getAuthCtrl()) && StringUtils.isEmpty((Object)reqBO.getActionCode())) {
                throw new UocProBusinessException("100002", "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010\u52a8\u4f5c\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            throw new UocProBusinessException("100002", "\u64cd\u4f5c\u6743\u9650\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010\u6743\u9650\u63a7\u5236\u3011\u4f20\u503c\u6709\u8bef\uff01");
        }
    }
}

