/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.ThirdApiCommonConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfSmsAbilityService;
import com.tydic.uoc.busibase.busi.api.PebTheOrderRemindAbilityService;
import com.tydic.uoc.busibase.busi.bo.HaiLiangBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfSmsReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfSmsRspBO;
import com.tydic.uoc.busibase.busi.bo.PebTheOrderRemindReqBO;
import com.tydic.uoc.busibase.busi.bo.PebTheOrderRemindRspBO;
import com.tydic.uoc.busibase.busi.bo.RongLianYTXBO;
import com.tydic.uoc.common.atom.api.PebTheOrderRemindAtomService;
import com.tydic.uoc.common.atom.bo.PebTheOrderRemindAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebTheOrderRemindAtomRspBO;
import com.tydic.uoc.dao.OrdRemindLogMapper;
import com.tydic.uoc.po.OrdRemindLogPO;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="pebTheOrderRemindAtomService")
public class PebTheOrderRemindAtomServiceImpl
implements PebTheOrderRemindAtomService {
    @Autowired
    PebTheOrderRemindAbilityService pebTheOrderRemindAbilityService;
    @Autowired
    private PebIntfSmsAbilityService pebIntfSmsAbilityService;
    @Autowired
    OrdRemindLogMapper ordRemindLogMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Value(value="${IS_ENABLE_SMS:false}")
    private Boolean isEnableSMS;
    @Value(value="${sms.type:1}")
    private String smsType;

    @Override
    public PebTheOrderRemindAtomRspBO dealPebTheOrderRemind(PebTheOrderRemindAtomReqBO reqBO) {
        this.validateParams(reqBO);
        PebTheOrderRemindAtomRspBO rspBO = new PebTheOrderRemindAtomRspBO();
        Integer sendType = reqBO.getSendType();
        return this.sendRemind(reqBO);
    }

    private void validateParams(PebTheOrderRemindAtomReqBO reqBO) {
        Integer sendType = reqBO.getSendType();
        String templateId = reqBO.getTemplateId();
        Map<String, Object> templateParam = reqBO.getTemplateParam();
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Boolean insertRemindLog(PebTheOrderRemindAtomReqBO reqBO, boolean isSendSuccess, PebTheOrderRemindAtomRspBO rspBO) {
        boolean isRecordSuccess = true;
        OrdRemindLogPO ordRemindLogPO = new OrdRemindLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)ordRemindLogPO);
        ordRemindLogPO.setCreateTime(new Date());
        ordRemindLogPO.setMsgParam(JSON.toJSONString(reqBO.getTemplateParam()));
        ordRemindLogPO.setTemplateId(reqBO.getTemplateId());
        ordRemindLogPO.setMemId(String.valueOf(reqBO.getUserId()));
        ordRemindLogPO.setId(Long.valueOf(this.sequence.nextId()));
        if (reqBO.getSendType().equals(ThirdApiCommonConstant.ORDER_SEND_EMIL)) {
            ordRemindLogPO.setReceiveRole(reqBO.getEmail());
        }
        if (reqBO.getSendType().equals(ThirdApiCommonConstant.ORDER_SEND_MOBILE)) {
            ordRemindLogPO.setReceiveRole(reqBO.getMobile());
        }
        if (reqBO.getSendType().equals(ThirdApiCommonConstant.ORDER_SEND_MESSAGE)) {
            ordRemindLogPO.setReceiveRole(reqBO.getReceiveId().toString());
        }
        if (isSendSuccess) {
            ordRemindLogPO.setStatus("1");
            try {
                this.ordRemindLogMapper.insert(ordRemindLogPO);
            }
            catch (Exception e) {
                rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f,\u63d2\u5165\u65e5\u5fd7\u5931\u8d25");
                rspBO.setRespCode("101019");
                isRecordSuccess = false;
            }
        } else {
            ordRemindLogPO.setStatus("0");
            try {
                this.ordRemindLogMapper.insert(ordRemindLogPO);
            }
            catch (Exception e) {
                rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u5931\u8d25,\u63d2\u5165\u65e5\u5fd7\u5931\u8d25");
                rspBO.setRespCode("101019");
                isRecordSuccess = false;
            }
        }
        return isRecordSuccess;
    }

    private PebTheOrderRemindAtomRspBO sendSMS(PebTheOrderRemindAtomReqBO reqBO) {
        PebTheOrderRemindAtomRspBO rspBO = new PebTheOrderRemindAtomRspBO();
        PebIntfSmsReqBO pebIntfSmsReqBO = new PebIntfSmsReqBO();
        pebIntfSmsReqBO.setMobile(reqBO.getMobile());
        pebIntfSmsReqBO.setContent(reqBO.getContent());
        PebIntfSmsRspBO pebIntfSmsRspBO = this.pebIntfSmsAbilityService.sendMsg(pebIntfSmsReqBO);
        if (pebIntfSmsRspBO.getRespCode().equals("0000")) {
            Boolean isRecordSuccess = this.insertRemindLog(reqBO, true, rspBO);
            if (!isRecordSuccess.booleanValue()) {
                return rspBO;
            }
            rspBO.setRespDesc(pebIntfSmsRspBO.getRespDesc());
            rspBO.setRespCode(pebIntfSmsRspBO.getRespCode());
        } else {
            Boolean isRecordSuccess = this.insertRemindLog(reqBO, false, rspBO);
            if (!isRecordSuccess.booleanValue()) {
                return rspBO;
            }
            rspBO.setRespDesc(pebIntfSmsRspBO.getRespDesc());
            rspBO.setRespCode(pebIntfSmsRspBO.getRespCode());
        }
        return rspBO;
    }

    private PebTheOrderRemindAtomRspBO sendRemind(PebTheOrderRemindAtomReqBO reqBO) {
        Boolean isRecordSuccess;
        PebTheOrderRemindAtomRspBO rspBO = new PebTheOrderRemindAtomRspBO();
        PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)pebTheOrderRemindReqBO);
        if ("1".equals(this.smsType) && reqBO.getSendType().equals(ThirdApiCommonConstant.ORDER_SEND_MOBILE)) {
            RongLianYTXBO lianYTXBO = new RongLianYTXBO();
            if (reqBO.getTemplateParam() != null) {
                String[] data = new String[reqBO.getTemplateParam().size()];
                int i = 0;
                for (String key : reqBO.getTemplateParam().keySet()) {
                    data[i] = String.valueOf(reqBO.getTemplateParam().get(key));
                    ++i;
                }
                lianYTXBO.setDatas(data);
            }
            lianYTXBO.setMobiles(reqBO.getMobile());
            lianYTXBO.setTemplateId(reqBO.getTemplateId());
            pebTheOrderRemindReqBO.setRongLianYTXBO(lianYTXBO);
        } else if ("2".equals(this.smsType) && reqBO.getSendType().equals(ThirdApiCommonConstant.ORDER_SEND_MOBILE)) {
            HaiLiangBO haiLiangBO = new HaiLiangBO();
            haiLiangBO.setMobile(reqBO.getMobile());
            haiLiangBO.setContent(reqBO.getContent());
            pebTheOrderRemindReqBO.setHaiLiangBO(haiLiangBO);
        }
        pebTheOrderRemindReqBO.setSubject(reqBO.getSubject());
        pebTheOrderRemindReqBO.setTitel(reqBO.getSubject());
        pebTheOrderRemindReqBO.setText(reqBO.getContent());
        pebTheOrderRemindReqBO.setEmail(reqBO.getEmail());
        PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindAbilityService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
        if (pebTheOrderRemindRspBO.getRespCode().equals("0000")) {
            isRecordSuccess = this.insertRemindLog(reqBO, true, rspBO);
            if (!isRecordSuccess.booleanValue()) {
                return rspBO;
            }
            rspBO.setRespDesc(pebTheOrderRemindRspBO.getRespDesc());
            rspBO.setRespCode(pebTheOrderRemindRspBO.getRespCode());
        } else {
            isRecordSuccess = this.insertRemindLog(reqBO, false, rspBO);
            if (!isRecordSuccess.booleanValue()) {
                return rspBO;
            }
            rspBO.setRespDesc(pebTheOrderRemindRspBO.getRespDesc());
            rspBO.setRespCode(pebTheOrderRemindRspBO.getRespCode());
        }
        return rspBO;
    }
}

