/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.UocCoreExtFieldInAtomService;
import com.tydic.uoc.common.atom.api.UocCoreInspectionAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.CommonCenterFieldValueBO;
import com.tydic.uoc.common.atom.bo.CruFieldBO;
import com.tydic.uoc.common.atom.bo.ExtFieldBO;
import com.tydic.uoc.common.atom.bo.InspectionInfoBO;
import com.tydic.uoc.common.atom.bo.UocCoreExtFieldInReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreExtFieldInRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreInspectionReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreInspectionRspBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipInspectionMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipInspectionPO;
import com.tydic.uoc.po.OrdShipItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreInspectionAtomService")
public class UocCoreInspectionAtomServiceImpl
implements UocCoreInspectionAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreInspectionAtomServiceImpl.class);
    private static final Integer CHECK_FLAG = 1;
    private OrdSaleMapper ordSaleMapper;
    private OrdItemMapper ordItemMapper;
    private OrdShipItemMapper ordShipItemMapper;
    private OrdShipInspectionMapper ordShipInspectionMapper;
    private OrdInspectionMapper ordInspectionMapper;
    private OrdInspectionItemMapper ordInspectionItemMapper;
    private UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService;
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Autowired
    public UocCoreInspectionAtomServiceImpl(OrdSaleMapper ordSaleMapper, OrdItemMapper ordItemMapper, OrdShipItemMapper ordShipItemMapper, OrdShipInspectionMapper ordShipInspectionMapper, OrdInspectionMapper ordInspectionMapper, OrdInspectionItemMapper ordInspectionItemMapper, UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService, UocStartProcessAtomService uocStartProcessAtomService) {
        this.ordSaleMapper = ordSaleMapper;
        this.ordItemMapper = ordItemMapper;
        this.ordShipItemMapper = ordShipItemMapper;
        this.ordShipInspectionMapper = ordShipInspectionMapper;
        this.ordInspectionMapper = ordInspectionMapper;
        this.ordInspectionItemMapper = ordInspectionItemMapper;
        this.uocCoreExtFieldInAtomService = uocCoreExtFieldInAtomService;
        this.uocStartProcessAtomService = uocStartProcessAtomService;
    }

    @Override
    public UocCoreInspectionRspBO dealCoreInspection(UocCoreInspectionReqBO atomReqBO) {
        log.info("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1-\u5165\u53c2\uff1a" + atomReqBO.toString());
        UocCoreInspectionRspBO rsp = new UocCoreInspectionRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        this.validateParam(atomReqBO);
        rsp = this.updateShipAndOrdItemInspectionNum(atomReqBO, rsp);
        if (!"0000".equals(rsp.getRespCode())) {
            return rsp;
        }
        if (!"0000".equals((rsp = this.createInspectionCode(atomReqBO, rsp)).getRespCode())) {
            return rsp;
        }
        if (!"0000".equals((rsp = this.createShipAndInspectionReal(atomReqBO, rsp)).getRespCode())) {
            return rsp;
        }
        if (!"0000".equals((rsp = this.createInspectionExtInfo(atomReqBO, rsp)).getRespCode())) {
            return rsp;
        }
        log.info("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1-\u51fa\u53c2\uff1a" + rsp.toString());
        return rsp;
    }

    private void validateParam(UocCoreInspectionReqBO atomReqBO) {
        if (atomReqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getInspectionInfoList() != null && !atomReqBO.getInspectionInfoList().isEmpty()) {
            for (InspectionInfoBO inspectionInfoBO : atomReqBO.getInspectionInfoList()) {
                if (inspectionInfoBO.getShipItemId() == null) {
                    throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010getInspectionInfoList.ShipItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (inspectionInfoBO.getOrdItemId() == null) {
                    throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010getInspectionInfoList.OrdItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (inspectionInfoBO.getShipVoucherId() == null) {
                    throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010getInspectionInfoList.ShipVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (inspectionInfoBO.getInspectionCount() != null) continue;
                throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010getInspectionInfoList.InspectionCount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (atomReqBO.getCruFieldList() != null && atomReqBO.getCruFieldList().size() > 0) {
            for (CruFieldBO cruFieldBO : atomReqBO.getCruFieldList()) {
                if (StringUtils.isBlank((CharSequence)cruFieldBO.getFieldCode())) {
                    throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010CruFieldList.FieldCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isBlank((CharSequence)cruFieldBO.getFieldValue())) continue;
                throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010CruFieldList.FieldValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (atomReqBO.getExtFieldList() != null && atomReqBO.getExtFieldList().size() > 0) {
            for (ExtFieldBO extFieldBO : atomReqBO.getExtFieldList()) {
                if (StringUtils.isBlank((CharSequence)extFieldBO.getFieldCode())) {
                    throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ExtFieldList.FieldCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isBlank((CharSequence)extFieldBO.getFieldValue())) continue;
                throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ExtFieldList.FieldValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private UocCoreInspectionRspBO updateShipAndOrdItemInspectionNum(UocCoreInspectionReqBO atomReqBO, UocCoreInspectionRspBO rspBO) {
        for (InspectionInfoBO bo : atomReqBO.getInspectionInfoList()) {
            if (!CHECK_FLAG.equals(atomReqBO.getCheckFlag())) {
                this.validateCounts(atomReqBO.getOrderId(), bo.getShipItemId());
            }
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setShipItemId(bo.getShipItemId());
            ordShipItemPO.setOrderId(atomReqBO.getOrderId());
            ordShipItemPO.setAcceptanceCount(bo.getInspectionCount());
            try {
                int updateShipItemInspectionNumResult = this.ordShipItemMapper.updateInspectionCounts(ordShipItemPO);
                if (updateShipItemInspectionNumResult < 1) {
                    rspBO.setRespCode("101034");
                    rspBO.setRespDesc("\u53d1\u8d27\u660e\u7ec6\u8868\u9a8c\u6536\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff01");
                    return rspBO;
                }
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u53d1\u8d27\u660e\u7ec6\u8868\u9a8c\u6536\u6570\u91cf\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                throw new UocProBusinessException("101034", "\u66f4\u65b0\u53d1\u8d27\u660e\u7ec6\u8868\u9a8c\u6536\u6570\u91cf\u6570\u636e\u5e93\u5f02\u5e38");
            }
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrdItemId(bo.getOrdItemId());
            ordItemPO.setOrderId(atomReqBO.getOrderId());
            ordItemPO.setAcceptanceCount(bo.getInspectionCount());
            try {
                int updateOrdItemInspectionNumResult = this.ordItemMapper.updateInspectionCounts(ordItemPO);
                if (updateOrdItemInspectionNumResult >= 1) continue;
                rspBO.setRespCode("101034");
                rspBO.setRespDesc("\u9500\u552e\u660e\u7ec6\u8868\u9a8c\u6536\u6536\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff01");
                return rspBO;
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u9500\u552e\u660e\u7ec6\u8868\u9a8c\u6536\u6570\u91cf\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                throw new UocProBusinessException("101034", "\u66f4\u65b0\u9500\u552e\u660e\u7ec6\u8868\u9a8c\u6536\u6570\u91cf\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
        return rspBO;
    }

    private void validateCounts(Long orderId, Long shipItemId) {
        try {
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setShipItemId(shipItemId);
            ordShipItemPO.setOrderId(orderId);
            OrdShipItemPO ordShipItem = this.ordShipItemMapper.getModelBy(ordShipItemPO);
            if (ordShipItem.getRefuseCount() == null) {
                ordShipItem.setRefuseCount(BigDecimal.ZERO);
            }
            if (ordShipItem.getAcceptanceCount() == null) {
                ordShipItem.setAcceptanceCount(BigDecimal.ZERO);
            }
            BigDecimal inspectionCount = ordShipItem.getSendCount().subtract(ordShipItem.getRefuseCount());
            if (ordShipItem.getAcceptanceCount().compareTo(inspectionCount) > 0) {
                throw new UocProBusinessException("101034", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u53d1\u8d27\u660e\u7ec6\u3010\u9a8c\u6536\u6570\u91cf>\u53d1\u8d27\u6570\u91cf-\u62d2\u6536\u6570\u91cf\u3011\uff01");
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("101034", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u6570\u91cf\u6821\u9a8c\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private UocCoreInspectionRspBO createInspectionCode(UocCoreInspectionReqBO atomReqBO, UocCoreInspectionRspBO rsp) {
        OrdSalePO ordSalePO = this.qryOrdSale(atomReqBO);
        OrdInspectionPO ordInspectionModel = new OrdInspectionPO();
        ordInspectionModel.setOrderId(atomReqBO.getOrderId());
        try {
            List ordInspectionPOList = this.ordInspectionMapper.getList(ordInspectionModel);
            if (String.valueOf(UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT).equals(ordSalePO.getOrderSource())) {
                if (ordInspectionPOList == null || ordInspectionPOList.isEmpty()) {
                    String inspectionCode = this.createInspectionCode(ordSalePO.getSaleVoucherNo(), ordSalePO.getOrderId(), ordSalePO.getOrderSource());
                    rsp = this.createInspection(inspectionCode, ordSalePO, atomReqBO, rsp);
                } else {
                    OrdInspectionPO inspectionPO = (OrdInspectionPO)ordInspectionPOList.get(0);
                    rsp = this.createInspectionItem(atomReqBO, inspectionPO, rsp);
                    rsp.setInspectionVoucherId(inspectionPO.getInspectionVoucherId());
                    rsp.setInspectionVoucherCode(inspectionPO.getInspectionVoucherCode());
                }
            } else if (String.valueOf(PecConstant.ORDER_SOURCE.ELEC_AREA).equals(ordSalePO.getOrderSource())) {
                String inspectionCode = this.createInspectionCode(ordSalePO.getSaleVoucherNo(), ordSalePO.getOrderId(), ordSalePO.getOrderSource());
                rsp = this.createInspection(inspectionCode, ordSalePO, atomReqBO, rsp);
            } else {
                String inspectionCode = this.createInspectionCode(ordSalePO.getSaleVoucherNo(), ordSalePO.getOrderId(), ordSalePO.getOrderSource());
                rsp = this.createInspection(inspectionCode, ordSalePO, atomReqBO, rsp);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u662f\u5426\u5df2\u5b58\u5728\u9a8c\u6536\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("101034", "\u67e5\u8be2\u662f\u5426\u5df2\u5b58\u5728\u9a8c\u6536\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
        return rsp;
    }

    private OrdSalePO qryOrdSale(UocCoreInspectionReqBO atomReqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(atomReqBO.getOrderId());
        try {
            OrdSalePO ordSale = this.ordSaleMapper.getModelBy(ordSalePO);
            if (ordSale == null) {
                throw new UocProBusinessException("101034", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355ID[" + atomReqBO.getOrderId() + "]\u7684\u9500\u552e\u5355\u4fe1\u606f");
            }
            return ordSale;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("101034", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    private String createInspectionCode(String saleVoucherNo, Long orderId, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey("ORDER_INSPECTION_NO");
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("101034", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.createInspectionCode(saleVoucherNo, orderId);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String createInspectionCode(String saleVoucherNo, Long orderId) {
        String ysd = "-YSD-";
        int random = new RandomDataGenerator().nextInt(100, 1000);
        String timeCuo = DateUtils.DateToStryyyyMMdd((Date)new Date());
        String inspectionCode = saleVoucherNo + ysd + timeCuo + random;
        OrdInspectionPO ordInspectionModel = new OrdInspectionPO();
        ordInspectionModel.setInspectionVoucherCode(inspectionCode);
        ordInspectionModel.setOrderId(orderId);
        OrdInspectionPO ordInspectionPO = this.ordInspectionMapper.getModelBy(ordInspectionModel);
        if (ordInspectionPO == null) {
            return inspectionCode;
        }
        inspectionCode = this.createInspectionCode(saleVoucherNo, orderId);
        return inspectionCode;
    }

    private UocCoreInspectionRspBO createInspection(String inspectionCode, OrdSalePO ordSalePO, UocCoreInspectionReqBO atomReqBO, UocCoreInspectionRspBO rsp) {
        OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
        ordInspectionPO.setInspectionVoucherCode(inspectionCode);
        ordInspectionPO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        ordInspectionPO.setOrderId(atomReqBO.getOrderId());
        ordInspectionPO.setInspectionState(UocConstant.ACCEPT_ORDER_STATUS.ARRIVED);
        ordInspectionPO.setExt1(atomReqBO.getExt1());
        if (atomReqBO.getInspectionFee() != null) {
            ordInspectionPO.setInspTotalPurchaseFee(atomReqBO.getInspectionFee());
        }
        if (atomReqBO.getInspectionSaleFee() != null) {
            ordInspectionPO.setInspTotalSaleFee(atomReqBO.getInspectionSaleFee());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getInspectionOperId())) {
            ordInspectionPO.setInspectionOperId(atomReqBO.getInspectionOperId());
        }
        if (null != atomReqBO.getInspectionTime()) {
            ordInspectionPO.setInspectionTime(atomReqBO.getInspectionTime());
        } else {
            ordInspectionPO.setInspectionTime(new Date());
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getCrateOperId())) {
            ordInspectionPO.setCreateOperId(Long.valueOf(atomReqBO.getCrateOperId()));
        } else if (!StringUtils.isBlank((CharSequence)atomReqBO.getInspectionOperId())) {
            ordInspectionPO.setCreateOperId(Long.valueOf(atomReqBO.getInspectionOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)atomReqBO.getInspectionOper())) {
            ordInspectionPO.setInspectionOper(atomReqBO.getInspectionOper());
        }
        if (StringUtils.isNotBlank((CharSequence)atomReqBO.getInspectionOperPhone())) {
            ordInspectionPO.setInspectionOperPhone(atomReqBO.getInspectionOperPhone());
        }
        if (null != atomReqBO.getCreateTime()) {
            ordInspectionPO.setCreateTime(atomReqBO.getCreateTime());
        } else {
            ordInspectionPO.setCreateTime(new Date());
        }
        ordInspectionPO.setRemark(atomReqBO.getInspectionRemark());
        ordInspectionPO.setInspectionVoucherId(Long.valueOf(this.sequence.nextId()));
        UocProcessStartRspBO uocProcessStartRspBO = this.startProcess(ordInspectionPO.getInspectionVoucherId(), ordInspectionPO.getOrderId(), atomReqBO.getProcDefKey());
        ordInspectionPO.setInspectionState(UocCoreInspectionAtomServiceImpl.string2Integer(uocProcessStartRspBO.getStepId()));
        try {
            int isInsert = this.ordInspectionMapper.insert(ordInspectionPO);
            if (isInsert < 1) {
                rsp.setRespCode("101034");
                rsp.setRespDesc("\u9a8c\u6536\u5355\u63d2\u5165\u5931\u8d25\uff01");
                return rsp;
            }
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u9a8c\u6536\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("101034", "\u63d2\u5165\u9a8c\u6536\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
        rsp = this.createInspectionItem(atomReqBO, ordInspectionPO, rsp);
        rsp.setInspectionVoucherId(ordInspectionPO.getInspectionVoucherId());
        rsp.setInspectionVoucherCode(inspectionCode);
        return rsp;
    }

    private UocCoreInspectionRspBO createInspectionItem(UocCoreInspectionReqBO atomReqBO, OrdInspectionPO ordInspectionPO, UocCoreInspectionRspBO rsp) {
        for (InspectionInfoBO inspectionInfoBO : atomReqBO.getInspectionInfoList()) {
            OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
            OrdItemPO ordItemPO = this.qryOrderItem(inspectionInfoBO, atomReqBO);
            if (ordItemPO == null) {
                rsp.setRespCode("101034");
                rsp.setRespDesc("\u9a8c\u6536\u660e\u7ec6\u63d2\u5165\u5931\u8d25\uff01");
                break;
            }
            ordInspectionItemPO.setInspSaleFee(Long.valueOf(new BigDecimal(ordItemPO.getSalePrice()).multiply(inspectionInfoBO.getInspectionCount()).longValue()));
            ordInspectionItemPO.setInspPurchaseFee(Long.valueOf(new BigDecimal(ordItemPO.getPurchasePrice()).multiply(inspectionInfoBO.getInspectionCount()).longValue()));
            ordInspectionItemPO.setShipItemId(inspectionInfoBO.getShipItemId());
            ordInspectionItemPO.setOrdItemId(inspectionInfoBO.getOrdItemId());
            ordInspectionItemPO.setInspectionVoucherId(ordInspectionPO.getInspectionVoucherId());
            ordInspectionItemPO.setOrderId(atomReqBO.getOrderId());
            ordInspectionItemPO.setCheckStatus(UocConstant.ACCEPT_ORDER_STATUS.ARRIVED);
            ordInspectionItemPO.setUnitName(inspectionInfoBO.getUnitName());
            ordInspectionItemPO.setInspectionCount(inspectionInfoBO.getInspectionCount());
            ordInspectionItemPO.setInspectionItemId(Long.valueOf(this.sequence.nextId()));
            try {
                int isInsert2 = this.ordInspectionItemMapper.insert(ordInspectionItemPO);
                if (isInsert2 >= 1) continue;
                rsp.setRespCode("101034");
                rsp.setRespDesc("\u9a8c\u6536\u660e\u7ec6\u63d2\u5165\u5931\u8d25\uff01");
                break;
            }
            catch (Exception e) {
                log.error("\u63d2\u5165\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                throw new UocProBusinessException("101034", "\u63d2\u5165\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
        OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
        ordInspectionItemPO.setInspectionVoucherId(ordInspectionPO.getInspectionVoucherId());
        ordInspectionItemPO.setOrderId(ordInspectionPO.getOrderId());
        List list = this.ordInspectionItemMapper.getList(ordInspectionItemPO);
        Long saleFee = 0L;
        Long purFee = 0L;
        for (OrdInspectionItemPO itemPO : list) {
            if (itemPO.getInspSaleFee() != null) {
                saleFee = saleFee + itemPO.getInspSaleFee();
            }
            if (itemPO.getInspPurchaseFee() == null) continue;
            purFee = purFee + itemPO.getInspPurchaseFee();
        }
        OrdInspectionPO inspectionPO = new OrdInspectionPO();
        inspectionPO.setInspTotalSaleFee(saleFee);
        inspectionPO.setInspTotalPurchaseFee(purFee);
        inspectionPO.setInspectionVoucherId(ordInspectionPO.getInspectionVoucherId());
        inspectionPO.setOrderId(ordInspectionPO.getOrderId());
        this.ordInspectionMapper.updateById(inspectionPO);
        return rsp;
    }

    private OrdItemPO qryOrderItem(InspectionInfoBO inspectionInfoBO, UocCoreInspectionReqBO atomReqBO) {
        OrdItemPO ordItemModel = new OrdItemPO();
        ordItemModel.setOrdItemId(inspectionInfoBO.getOrdItemId());
        ordItemModel.setOrderId(atomReqBO.getOrderId());
        try {
            return this.ordItemMapper.getModelBy(ordItemModel);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("101034", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    private UocCoreInspectionRspBO createShipAndInspectionReal(UocCoreInspectionReqBO atomReqBO, UocCoreInspectionRspBO rsp) {
        HashSet<Long> shipVoucherId = new HashSet<Long>();
        for (InspectionInfoBO inspectionInfoBO : atomReqBO.getInspectionInfoList()) {
            shipVoucherId.add(inspectionInfoBO.getShipVoucherId());
        }
        if (shipVoucherId.size() > 0) {
            for (Long id : shipVoucherId) {
                OrdShipInspectionPO ordShipInspectionPO = new OrdShipInspectionPO();
                ordShipInspectionPO.setShipVoucherId(id);
                ordShipInspectionPO.setOrderId(atomReqBO.getOrderId());
                ordShipInspectionPO.setInspectionVoucherId(rsp.getInspectionVoucherId());
                ordShipInspectionPO.setCreateTime(new Date());
                ordShipInspectionPO.setId(Long.valueOf(this.sequence.nextId()));
                try {
                    int isInsert = this.ordShipInspectionMapper.insert(ordShipInspectionPO);
                    if (isInsert >= 1) continue;
                    rsp.setRespCode("101034");
                    rsp.setRespDesc("\u9a8c\u6536\u5355\u548c\u53d1\u8d27\u5355\u5173\u7cfb\u8868\u63d2\u5165\u5931\u8d25\uff01");
                    break;
                }
                catch (Exception e) {
                    log.error("\u9a8c\u6536\u5355\u548c\u53d1\u8d27\u5355\u5173\u7cfb\u8868\u63d2\u5165\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                    throw new UocProBusinessException("101034", "\u9a8c\u6536\u5355\u548c\u53d1\u8d27\u5355\u5173\u7cfb\u8868\u63d2\u5165\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
                }
            }
        }
        return rsp;
    }

    private UocCoreInspectionRspBO createInspectionExtInfo(UocCoreInspectionReqBO atomReqBO, UocCoreInspectionRspBO rsp) {
        if (atomReqBO.getExtFieldList() != null || atomReqBO.getCruFieldList() != null) {
            UocCoreExtFieldInRspBO atomRsp;
            CommonCenterFieldValueBO fieldValueBO;
            UocCoreExtFieldInReqBO reqBO = new UocCoreExtFieldInReqBO();
            reqBO.setOrderId(atomReqBO.getOrderId());
            reqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
            if (atomReqBO.getCruFieldList() != null && atomReqBO.getCruFieldList().size() > 0) {
                ArrayList<CommonCenterFieldValueBO> cruFieldList = new ArrayList<CommonCenterFieldValueBO>();
                for (CruFieldBO bo : atomReqBO.getCruFieldList()) {
                    fieldValueBO = new CommonCenterFieldValueBO();
                    BeanUtils.copyProperties((Object)bo, (Object)fieldValueBO);
                    cruFieldList.add(fieldValueBO);
                }
                reqBO.setCruFieldList(cruFieldList);
                if (log.isDebugEnabled()) {
                    log.debug("\u9a8c\u6536\u5355\u4e3b\u8981\u6269\u5c55\u5c5e\u6027\uff1a" + reqBO.toString());
                }
            }
            if (atomReqBO.getExtFieldList() != null && atomReqBO.getExtFieldList().size() > 0) {
                ArrayList<CommonCenterFieldValueBO> extFieldList = new ArrayList<CommonCenterFieldValueBO>();
                for (ExtFieldBO extFieldBO : atomReqBO.getExtFieldList()) {
                    fieldValueBO = new CommonCenterFieldValueBO();
                    BeanUtils.copyProperties((Object)extFieldBO, (Object)fieldValueBO);
                    extFieldList.add(fieldValueBO);
                }
                reqBO.setExtFieldList(extFieldList);
                if (log.isDebugEnabled()) {
                    log.debug("\u9a8c\u6536\u5355\u4e3b\u8981\u548c\u6b21\u8981\u6269\u5c55\u5c5e\u6027\uff1a" + reqBO.toString());
                }
            }
            if (!"0000".equals((atomRsp = this.uocCoreExtFieldInAtomService.dealCoreExtFieldIn(reqBO)).getRespCode())) {
                rsp.setRespCode(atomRsp.getRespCode());
                rsp.setRespDesc(atomRsp.getRespDesc());
                return rsp;
            }
        }
        return rsp;
    }

    private UocProcessStartRspBO startProcess(Long objId, Long orderId, String procDefKey) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        if (StringUtils.isNotBlank((CharSequence)procDefKey)) {
            processStartReqBO.setProcDefKey(procDefKey);
        } else {
            processStartReqBO.setProcDefId("acceptance_status:1:308719980665315328");
            processStartReqBO.setProcDefKey("acceptance_status");
        }
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
        processStartReqBO.setOrderId(orderId);
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        processStartReqBO.setVariables(map);
        UocProcessStartRspBO processStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(processStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101034", "\u901a\u8fc7\u5165\u53c2\uff1a" + processStartReqBO.toString() + "\u542f\u52a8\u72b6\u6001\u673a\u5931\u8d25\u539f\u56e0\uff1a" + processStartRspBO.getRespDesc());
        }
        return processStartRspBO;
    }

    private static Integer string2Integer(String val) {
        if (val == null) {
            return null;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("101034", "\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38[string2Integer]");
        }
    }
}

