/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.UocCoreChgVoucherStateAtomService;
import com.tydic.uoc.common.atom.api.UocProShouldPayOrDeductDealAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomRspBo;
import com.tydic.uoc.common.atom.bo.VoucherStateBO;
import com.tydic.uoc.common.busi.api.PebGcAgrOrderBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebGcAgrOrderBusiServiceImpl
implements PebGcAgrOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebGcAgrOrderBusiServiceImpl.class);
    @Autowired
    private UocCoreChgVoucherStateAtomService uocCoreChgVoucherStateAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocProShouldPayOrDeductDealAtomService uocProShouldPayOrDeductDealAtomService;

    @Override
    public UocGeneralCirculationRspBO dealAgrOrd(UocGeneralCirculationReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (PebExtConstant.OrderType.GC.equals(orderPO.getOrderType()) || !salePO.getTotalIntegralFee().equals(salePO.getSaleFee())) {
            this.updateStatus(salePO, orderPO, UocConstant.SALE_ORDER_STATUS.PAYING);
            UocProShouldPayOrDeductDealAtomReqBo uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
            uocProShouldPayOrDeductDealAtomReqBo.setOrderId(reqBO.getOrderId());
            uocProShouldPayOrDeductDealAtomReqBo.setObjId(reqBO.getObjId());
            uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            uocProShouldPayOrDeductDealAtomReqBo.setObjDate(orderPO.getCreateTime());
            uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT_NOW);
            uocProShouldPayOrDeductDealAtomReqBo.setRunStatus(false);
            uocProShouldPayOrDeductDealAtomReqBo.setOrderType(orderPO.getOrderType());
            UocProShouldPayOrDeductDealAtomRspBo shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
            if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
                throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
            }
        } else {
            this.updateStatus(salePO, orderPO, UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER);
        }
        UocGeneralCirculationRspBO rspBO = new UocGeneralCirculationRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UocGeneralCirculationRspBO dealPayStatus(UocGeneralCirculationReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        UocGeneralCirculationRspBO rspBO = new UocGeneralCirculationRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.CANCEL) || salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.PAYING)) {
            return rspBO;
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
        this.orderMapper.updateById(orderPO);
        try {
            OrdPayPO ordPayPO = new OrdPayPO();
            ordPayPO.setOrderId(reqBO.getOrderId());
            ordPayPO.setOrderId(reqBO.getOrderId());
            ordPayPO = this.ordPayMapper.getModelBy(ordPayPO);
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
            ordPayPO.setPayTime(new Date());
            this.ordPayMapper.updateById(ordPayPO);
        }
        catch (Exception e) {
            log.error(reqBO.getOrderId() + ":\u4fee\u6539\u652f\u4ed8\u72b6\u6001\u5931\u8d25" + e);
        }
        return null;
    }

    private void updateStatus(OrdSalePO saleRspBO, OrderPO orderPO, Integer status) {
        UocCoreChgVoucherStateReqBO voucherStateReqBO = new UocCoreChgVoucherStateReqBO();
        voucherStateReqBO.setDealDesc("\u5458\u5de5\u8d85\u5e02");
        voucherStateReqBO.setOperId(orderPO.getCreateOperId());
        voucherStateReqBO.setOrderId(orderPO.getOrderId());
        ArrayList<VoucherStateBO> voucherStateBOS = new ArrayList<VoucherStateBO>();
        VoucherStateBO voucherStateBO = new VoucherStateBO();
        voucherStateBO.setAfterState(status);
        voucherStateBO.setObjId(saleRspBO.getSaleVoucherId());
        voucherStateBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        voucherStateBOS.add(voucherStateBO);
        voucherStateReqBO.setVoucherStateList(voucherStateBOS);
        UocCoreChgVoucherStateRspBO rspBO = this.uocCoreChgVoucherStateAtomService.dealCoreChgVoucherState(voucherStateReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("102078", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u66f4\u65b0\u72b6\u6001\u5931\u8d25," + rspBO.getRespDesc());
        }
    }
}

