/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebInOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebInOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdRhItemBO;
import com.tydic.uoc.common.ability.bo.UocOrdSaleRspBO;
import com.tydic.uoc.common.busi.api.PebInOrderBusiService;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocOrdRhInfoMapper;
import com.tydic.uoc.dao.UocOrdRhItemMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.UocOrdRhInfoPO;
import com.tydic.uoc.po.UocOrdRhItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebInOrderBusiServiceImpl
implements PebInOrderBusiService {
    @Autowired
    private UocOrdRhInfoMapper uocOrdRhInfoMapper;
    @Autowired
    private UocOrdRhItemMapper uocOrdRhItemMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Value(value="${SUPPLIER_JD_ID:100055}")
    private Long supplierIdJD;

    @Override
    public PebInOrderRspBO dealInOrder(PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdRhItemBO line = reqBO.getLine();
        UocOrdRhItemPO itemPO = new UocOrdRhItemPO();
        itemPO.setTransactionId(line.getTransactionId());
        itemPO = this.uocOrdRhItemMapper.selectOne(itemPO);
        if (itemPO != null) {
            rspBO.setRespDesc("\u5165\u5e93\u5355\u4ee5\u5165\u5e93");
            return rspBO;
        }
        UocOrdRhInfoPO po = new UocOrdRhInfoPO();
        po.setExt1(line.getTransactionType());
        po.setReceiptNum(line.getReceiptNum());
        po.setExt2(line.getPoNum());
        po = this.uocOrdRhInfoMapper.selectOne(po);
        Long zId = null;
        if (po != null) {
            UocOrdRhInfoPO update = new UocOrdRhInfoPO();
            update.setId(po.getId());
            update.setAccStatus(Integer.valueOf(2));
            update.setLastUpdateDate(new Date());
            this.uocOrdRhInfoMapper.update(update);
            zId = update.getId();
        } else {
            UocOrdRhInfoPO insert = new UocOrdRhInfoPO();
            insert.setExt1(line.getTransactionType());
            insert.setReceiptNum(line.getReceiptNum());
            insert.setExt2(line.getPoNum());
            insert.setId(Long.valueOf(this.idUtil.nextId()));
            insert.setLastUpdateDate(new Date());
            insert.setAccStatus(Integer.valueOf(2));
            insert.setCreatedBy(line.getCreatedBy());
            insert.setCreationDate(line.getCreationDate());
            insert.setFullName(line.getFullName());
            insert.setOrderId(reqBO.getOrderId());
            insert.setUserName(line.getUserName());
            insert.setExt3(reqBO.getSource());
            this.uocOrdRhInfoMapper.insert(insert);
            zId = insert.getId();
        }
        itemPO = new UocOrdRhItemPO();
        BeanUtils.copyProperties((Object)line, (Object)itemPO);
        itemPO.setExt2(String.valueOf(zId));
        itemPO.setId(Long.valueOf(this.idUtil.nextId()));
        itemPO.setInTime(new Date());
        itemPO.setAccStatus(Integer.valueOf(0));
        this.uocOrdRhItemMapper.insert(itemPO);
        ArrayList<UocOrdSaleRspBO> saleRspBOS = new ArrayList<UocOrdSaleRspBO>();
        if (!UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER.equals(reqBO.getStatus())) {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrdItemId(itemPO.getOrdItemId());
            ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
            this.update(ordItemPO, line.getTransactionType(), line.getQuantity());
            UocOrdSaleRspBO saleRspBO = new UocOrdSaleRspBO();
            saleRspBO.setOrderId(ordItemPO.getOrderId());
            saleRspBO.setSaleVoucherId(ordItemPO.getSaleVoucherId());
            saleRspBOS.add(saleRspBO);
        } else {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setLmOrderId(itemPO.getOrdItemId().toString());
            List list = this.ordItemMapper.getList(ordItemPO);
            if ("DELIVER".equals(line.getTransactionType())) {
                BigDecimal quantity = line.getQuantity();
                for (OrdItemPO get : list) {
                    if (quantity.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal count = null;
                        BigDecimal last = get.getPurchaseCount().subtract(get.getRefuseCount()).subtract(get.getReturnCount());
                        BigDecimal wrh = last.subtract(count = StringUtils.isBlank((CharSequence)get.getExtField5()) ? BigDecimal.ZERO : new BigDecimal(get.getExtField5()));
                        if (wrh.compareTo(BigDecimal.ZERO) <= 0) continue;
                        if (quantity.compareTo(wrh) > 0) {
                            count = wrh;
                            quantity = quantity.subtract(wrh);
                        } else {
                            count = quantity;
                            quantity = BigDecimal.ZERO;
                        }
                        this.saveItem(get, count, last);
                        UocOrdSaleRspBO saleRspBO = new UocOrdSaleRspBO();
                        saleRspBO.setOrderId(get.getOrderId());
                        saleRspBO.setSaleVoucherId(get.getSaleVoucherId());
                        saleRspBOS.add(saleRspBO);
                        continue;
                    }
                    break;
                }
            } else {
                BigDecimal quantity = line.getQuantity();
                for (OrdItemPO get : list) {
                    if (quantity.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal count = null;
                        count = StringUtils.isBlank((CharSequence)get.getExtField5()) ? BigDecimal.ZERO : new BigDecimal(get.getExtField5());
                        if (count.compareTo(BigDecimal.ZERO) <= 0) continue;
                        BigDecimal last = get.getPurchaseCount().subtract(get.getRefuseCount()).subtract(get.getReturnCount());
                        if (count.compareTo(quantity) >= 0) {
                            count = count.subtract(quantity);
                            quantity = BigDecimal.ZERO;
                        } else {
                            count = BigDecimal.ZERO;
                            quantity = quantity.subtract(count);
                        }
                        this.saveItem(get, count, last);
                        UocOrdSaleRspBO saleRspBO = new UocOrdSaleRspBO();
                        saleRspBO.setOrderId(get.getOrderId());
                        saleRspBO.setSaleVoucherId(get.getSaleVoucherId());
                        saleRspBOS.add(saleRspBO);
                        continue;
                    }
                    break;
                }
            }
        }
        rspBO.setSaleRspBOS(saleRspBOS);
        return rspBO;
    }

    private void saveItem(OrdItemPO ordItemPO, BigDecimal count, BigDecimal last) {
        OrdItemPO update = new OrdItemPO();
        if (last.compareTo(count) > 0) {
            update.setExtField4("2");
        } else {
            update.setExtField4("1");
        }
        if (count.compareTo(BigDecimal.ZERO) == 0) {
            update.setExtField4("0");
        }
        update.setOrdItemId(ordItemPO.getOrdItemId());
        update.setExtField5(count.toString());
        update.setOrderId(ordItemPO.getOrderId());
        this.ordItemMapper.updateById(update);
    }

    private void update(OrdItemPO ordItemPO, String type, BigDecimal quantity) {
        BigDecimal count = null;
        BigDecimal last = ordItemPO.getPurchaseCount().subtract(ordItemPO.getRefuseCount()).subtract(ordItemPO.getReturnCount());
        count = StringUtils.isBlank((CharSequence)ordItemPO.getExtField5()) ? BigDecimal.ZERO : new BigDecimal(ordItemPO.getExtField5());
        count = "DELIVER".equals(type) ? count.add(quantity) : count.subtract(quantity);
        this.saveItem(ordItemPO, count, last);
    }
}

