/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfConfirmOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.ConfirmOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.ConfirmOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelRspBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.UocPayOrderReFundBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.api.UocPebPreOrderSubmitBsuiService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.dao.OrdCancelMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdCancelPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocPebPreOrderSubmitBsuiServiceImpl
implements UocPebPreOrderSubmitBsuiService {
    private static Logger logger = LoggerFactory.getLogger(UocPebPreOrderSubmitBsuiServiceImpl.class);
    @Autowired
    private PebIntfConfirmOrderAbilityService pebIntfConfirmOrderAbilityService;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Value(value="${isActivationTemp}")
    private boolean isActivationTemp;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocPayOrderReFundBusiService uocPayOrderReFundBusiService;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Value(value="${SUPPLIER_JD_ID}")
    private String jdId;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private String jdIdFl;

    @Override
    public UocPebPreOrderSubmitRspBO submit(UocPebPreOrderSubmitReqBO reqBO) {
        UocPebPreOrderSubmitRspBO rspBO = new UocPebPreOrderSubmitRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ConfirmOrderReqBO confirmOrderReqBO = this.buildConfirmOrderParmByOrderId(reqBO);
        try {
            OrdExtMapPO mapPO = new OrdExtMapPO();
            mapPO.setOrderId(reqBO.getOrderId());
            mapPO.setFieldCode("jdOrgId");
            mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            mapPO = this.ordExtMapMapper.getModelBy(mapPO);
            if (mapPO != null) {
                confirmOrderReqBO.setOrgId(mapPO.getFieldValue());
            }
            ConfirmOrderRspBO confirmOrderRspBO = this.getConfirmOrder(confirmOrderReqBO);
            this.saveLog(reqBO.getOrderId(), reqBO.getSaleVoucherId(), JSON.toJSONString((Object)confirmOrderReqBO), JSON.toJSONString((Object)confirmOrderRspBO), confirmOrderRspBO.getRespCode(), confirmOrderRspBO.getRespCode());
            logger.debug("\u9884\u5b9a\u5355\u63d0\u4ea4" + JSON.toJSONString((Object)confirmOrderRspBO));
            if (!("0000".equals(confirmOrderRspBO.getRespCode()) && confirmOrderRspBO.getResult().booleanValue() || confirmOrderRspBO.getRespDesc().contains("\u91cd\u590d"))) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(confirmOrderRspBO.getRespDesc());
                return rspBO;
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("102082", "\u9884\u8ba2\u5355\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
        }
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        this.checkJD(reqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102082", "\u9884\u8ba2\u5355\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1\u5904\u7406\u6d41\u7a0b\u5931\u8d25");
        }
        return rspBO;
    }

    private void checkJD(UocPebPreOrderSubmitReqBO reqBO) {
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderId(reqBO.getOrderId());
        ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
        if (null == ordStakeholderPO) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u4e09\u65b9\u4fe1\u606f");
        }
        if (this.jdId.equals(ordStakeholderPO.getSupNo()) || this.jdIdFl.equals(ordStakeholderPO.getSupNo())) {
            OrdSalePO saleRspBO = new OrdSalePO();
            saleRspBO.setOrderId(reqBO.getOrderId());
            saleRspBO = this.ordSaleMapper.getModelBy(saleRspBO);
            if (!UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(saleRspBO.getSaleState())) {
                return;
            }
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setObjId(saleRspBO.getSaleVoucherId());
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(saleRspBO.getOrderId());
            processRunReqBO.setOperId(String.valueOf(reqBO.getUserId()));
            UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
                throw new UocProBusinessException("102049", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
            }
        }
    }

    private void saveLog(Long orderId, Long saleId, String in, String out, String code, String errCode) {
        if (StringUtils.isBlank((CharSequence)in)) {
            in = "in";
        }
        if (StringUtils.isBlank((CharSequence)out)) {
            out = "out";
        }
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setCallCount(1);
        logBO.setCallState("1");
        logBO.setCallTime(new Date());
        logBO.setCreateLoginId("1");
        logBO.setErrCode(errCode);
        logBO.setErrDetail("1");
        logBO.setFlowFlag(1);
        logBO.setInContent(in);
        logBO.setInterCode("\u7535\u5546\u786e\u8ba4");
        logBO.setInterSn("1");
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setOrderId(orderId);
        logBO.setObjId(saleId);
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ConfirmOrderRspBO getConfirmOrder(ConfirmOrderReqBO confirmOrderReqBO) {
        ConfirmOrderRspBO confirmOrderRspBO;
        if (this.isActivationTemp) {
            confirmOrderRspBO = new ConfirmOrderRspBO();
            confirmOrderRspBO.setResult(Boolean.valueOf(true));
            confirmOrderRspBO.setRespCode("0000");
            confirmOrderRspBO.setRespDesc("\u6210\u529f");
        } else {
            confirmOrderRspBO = this.pebIntfConfirmOrderAbilityService.confirmOrder(confirmOrderReqBO);
        }
        return confirmOrderRspBO;
    }

    private void cancel(UocPebPreOrderSubmitReqBO reqBO, String desc) {
        UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
        cancelReqBO.setOrderId(reqBO.getOrderId());
        cancelReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        cancelReqBO.setCancelOperId(String.valueOf(reqBO.getUserId()));
        cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("approvalResult", "0");
        cancelReqBO.setCancelDesc("\u7535\u5546\u9884\u8ba2\u5355\u786e\u8ba4\u5931\u8d25\uff1a" + desc);
        cancelReqBO.setCancelReason("\u7535\u5546\u9884\u8ba2\u5355\u786e\u8ba4\u5931\u8d25\uff1a" + desc);
        cancelReqBO.setVariables(map);
        UocPebOrderCancelRspBO rspBO = this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("102082", "\u8ba2\u5355\u53d6\u6d88\u5931\u8d25" + rspBO.getRespDesc());
        }
        this.save(cancelReqBO);
    }

    private void save(UocPebOrderCancelReqBO reqBO) {
        try {
            OrdCancelPO cancelPO = new OrdCancelPO();
            cancelPO.setCancelNo(this.biuldNo("", "QXSQ"));
            cancelPO.setCancelReason(reqBO.getCancelDesc());
            cancelPO.setOrderId(reqBO.getOrderId());
            cancelPO.setSaleVoucherId(reqBO.getSaleVoucherId());
            cancelPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            cancelPO.setCreateOperName(reqBO.getUsername());
            cancelPO.setCreateTime(new Date());
            cancelPO.setOrderStatus(UocConstant.SALE_ORDER_STATUS.CREATE);
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_SUCCESS);
            this.ordCancelMapper.insert(cancelPO);
        }
        catch (Exception ignored) {
            logger.error("\u67e5\u8be2\u53d6\u6d88\u539f\u56e0\u5931\u8d25!!");
        }
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdCancelPO cancelPO = new OrdCancelPO();
        cancelPO.setCancelNo(no);
        int count = this.ordCancelMapper.getCheckBy(cancelPO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }

    private ConfirmOrderReqBO buildConfirmOrderParmByOrderId(UocPebPreOrderSubmitReqBO reqBO) {
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(reqBO.getOrderId());
        try {
            stakeholderPO = this.ordStakeholderMapper.getModelBy(stakeholderPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102082", "\u67e5\u8be2\u4e09\u65b9\u8868\u5931\u8d25");
        }
        ConfirmOrderReqBO confirmOrderReqBO = new ConfirmOrderReqBO();
        confirmOrderReqBO.setSupplierId(Long.valueOf(stakeholderPO.getSupNo()));
        OrdQueryIndexPO ordQueryIndexModel = new OrdQueryIndexPO();
        ordQueryIndexModel.setOrderId(reqBO.getOrderId());
        OrdQueryIndexPO result = null;
        try {
            result = this.ordQueryIndexMapper.getModelBy(ordQueryIndexModel);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102082", "\u67e5\u8be2\u5185\u5916\u90e8\u8ba2\u5355\u5173\u8054\u8868\u5931\u8d25");
        }
        if (result == null) {
            throw new UocProBusinessException("100001", "\u6ca1\u6709\u67e5\u8be2\u5230\u5185\u5916\u90e8\u8ba2\u5355\u5173\u8054\u4fe1\u606f");
        }
        confirmOrderReqBO.setOrderId(result.getOutOrderNo());
        return confirmOrderReqBO;
    }
}

