/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.busi.api.UocProOrderZqPaymentCallbackBusiService;
import com.tydic.uoc.common.busi.bo.UocProOrderZqPaymentCallbackBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocProOrderZqPaymentCallbackBusiRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocProOrderZqPaymentCallbackBusiServiceImpl
implements UocProOrderZqPaymentCallbackBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;

    @Override
    public UocProOrderZqPaymentCallbackBusiRspBO dealZqPaymentCallBack(UocProOrderZqPaymentCallbackBusiReqBO reqBO) {
        OrdPayPO ordPayPO;
        OrdSalePO salePo = new OrdSalePO();
        salePo.setSaleVoucherNo(reqBO.getOrderCode());
        salePo = this.ordSaleMapper.getModelBy(salePo);
        if (salePo == null) {
            throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        OrdItemPO ordItemPo = new OrdItemPO();
        ordItemPo.setOrderId(salePo.getOrderId());
        BigDecimal totalShouldPayAmt = this.ordItemMapper.sumShouldPayAmount(salePo.getOrderId());
        if (reqBO.getPayFlag().booleanValue()) {
            if (reqBO.getTotalPaidAmt().compareTo(totalShouldPayAmt) >= 0) {
                ordPayPO = new OrdPayPO();
                ordPayPO.setOrderId(salePo.getOrderId());
                ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
                this.ordPayMapper.updateById(ordPayPO);
            }
        } else {
            ordPayPO = new OrdPayPO();
            ordPayPO.setOrderId(salePo.getOrderId());
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.FAILURE);
            this.ordPayMapper.updateById(ordPayPO);
        }
        UocProOrderZqPaymentCallbackBusiRspBO busiRspBO = new UocProOrderZqPaymentCallbackBusiRspBO();
        busiRspBO.setSaleVoucherId(salePo.getSaleVoucherId());
        busiRspBO.setOrderId(salePo.getOrderId());
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }
}

