/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.uoc.base.bo.UocOrdItemFlBO;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleCouponRspBO;
import com.tydic.uoc.common.ability.bo.SaleOrdItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdSaleCouponRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdSaleMtLogRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsQueryRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreSalesSingleDetailsQueryAtomService;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreSalesSingleDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreSalesSingleDetailsQueryRspBO;
import com.tydic.uoc.common.busi.api.UocSalesSingleDetailsQueryBusiService;
import com.tydic.uoc.dao.UocOrdItemFlMapper;
import com.tydic.uoc.po.UocOrdItemFlPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocSalesSingleDetailsQueryBusiService")
public class UocSalesSingleDetailsQueryBusiServiceImpl
implements UocSalesSingleDetailsQueryBusiService {
    @Autowired
    private UocCoreSalesSingleDetailsQueryAtomService uocCoreSalesSingleDetailsQueryAtomService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    private static final String ELC_OUT_SALEORDERNO = "ElcOutSaleOrderNo";
    private static final String SPLIT_MARK = "splitMark";
    private static final String SPLIT_REASON = "splitReason";
    @Autowired
    private UocOrdItemFlMapper uocOrdItemFlMapper;

    @Override
    public UocSalesSingleDetailsQueryRspBO getSalesSingleDetailsQuery(UocSalesSingleDetailsQueryReqBO reqBO) {
        UocSalesSingleDetailsQueryRspBO rspBO = new UocSalesSingleDetailsQueryRspBO();
        this.validateParams(reqBO);
        UocCoreSalesSingleDetailsQueryReqBO atomReqBO = new UocCoreSalesSingleDetailsQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomReqBO);
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        atomReqBO.setItemIdList(reqBO.getItemIdList());
        UocCoreSalesSingleDetailsQueryRspBO atomRspBO = this.uocCoreSalesSingleDetailsQueryAtomService.getSalesSingleDetailsQuery(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            rspBO.setRespCode(atomRspBO.getRespCode());
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            return rspBO;
        }
        rspBO = this.buildAtomRspBO(atomRspBO);
        if (null != rspBO.getOrdSaleRspBO()) {
            this.transOrdSale(rspBO.getOrdSaleRspBO());
        }
        UocOrdItemFlPO flPO = new UocOrdItemFlPO();
        flPO.setOrderId(reqBO.getOrderId());
        List list = this.uocOrdItemFlMapper.selectByCondition(flPO);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List itemFlList = JSONArray.parseArray((String)JSON.toJSONString((Object)list), UocOrdItemFlBO.class);
            rspBO.setItemFlList(itemFlList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocSalesSingleDetailsQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private UocSalesSingleDetailsQueryRspBO buildAtomRspBO(UocCoreSalesSingleDetailsQueryRspBO atomRspBO) {
        UocOrdItemRspBO uocOrdItemRspBO;
        UocSalesSingleDetailsQueryRspBO rspBO = new UocSalesSingleDetailsQueryRspBO();
        List<Integer> saleStateList = Arrays.asList(1100, 2127, 2109, 2128, 2110, 2111, 2112, 2132, 2131, 2113);
        if (null != atomRspBO.getOrdSaleRspBO()) {
            UocOrdSaleRspBO ordSaleRspBO = new UocOrdSaleRspBO();
            BeanUtils.copyProperties((Object)atomRspBO.getOrdSaleRspBO(), (Object)ordSaleRspBO);
            ordSaleRspBO.setStepId(atomRspBO.getOrdSaleRspBO().getTbOrderId());
            if (ordSaleRspBO.getSaleExtraMap().get(ELC_OUT_SALEORDERNO) != null) {
                ordSaleRspBO.setElcOutSaleOrderNo((String)ordSaleRspBO.getSaleExtraMap().get(ELC_OUT_SALEORDERNO));
            }
            if (ordSaleRspBO.getSaleExtraMap().get(SPLIT_MARK) != null) {
                ordSaleRspBO.setSplitMark((String)ordSaleRspBO.getSaleExtraMap().get(SPLIT_MARK));
            }
            if (ordSaleRspBO.getSaleExtraMap().get(SPLIT_REASON) != null) {
                ordSaleRspBO.setSplitReason((String)ordSaleRspBO.getSaleExtraMap().get(SPLIT_REASON));
            }
            if (null != ordSaleRspBO.getSaleExtraMap().get("vendorOrderType")) {
                ordSaleRspBO.setVendorOrderType((String)ordSaleRspBO.getSaleExtraMap().get("vendorOrderType"));
            }
            if (StringUtils.isBlank((CharSequence)ordSaleRspBO.getBusiMode())) {
                ordSaleRspBO.setBusiMode("0");
            }
            rspBO.setOrdSaleRspBO(ordSaleRspBO);
        }
        if (null != atomRspBO.getOrdSaleMtLogRspBO()) {
            UocOrdSaleMtLogRspBO ordSaleMtLogRspBO = new UocOrdSaleMtLogRspBO();
            BeanUtils.copyProperties((Object)atomRspBO.getOrdSaleMtLogRspBO(), (Object)ordSaleMtLogRspBO);
            rspBO.setOrdSaleMtLogRspBO(ordSaleMtLogRspBO);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getSaleAccessoryList())) {
            ArrayList<UocOrdAccessoryRspBO> saleAccessoryRspBOList = new ArrayList<UocOrdAccessoryRspBO>();
            for (OrdAccessoryRspBO ordAccessoryRspBO : atomRspBO.getSaleAccessoryList()) {
                UocOrdAccessoryRspBO uocOrdAccessoryRspBO = new UocOrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)ordAccessoryRspBO, (Object)uocOrdAccessoryRspBO);
                saleAccessoryRspBOList.add(uocOrdAccessoryRspBO);
            }
            rspBO.setSaleAccessoryList(saleAccessoryRspBOList);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getOrdItemRspBOList())) {
            ArrayList<UocOrdItemRspBO> ordItemRspBOList = new ArrayList<UocOrdItemRspBO>();
            for (SaleOrdItemRspBO ordItemRspBO : atomRspBO.getOrdItemRspBOList()) {
                uocOrdItemRspBO = new UocOrdItemRspBO();
                BeanUtils.copyProperties((Object)ordItemRspBO, (Object)uocOrdItemRspBO);
                uocOrdItemRspBO.setPicUrl(uocOrdItemRspBO.getOrdGoodsRspBO().getSkuMainPicUrl());
                uocOrdItemRspBO.setOrdPromotionRspBOList(ordItemRspBO.getOrdPromotionRspBOList());
                uocOrdItemRspBO.setOrdSkuImeiRspBOList(ordItemRspBO.getOrdSkuImeiRspBOList());
                if (atomRspBO.getOrdSaleRspBO() != null && atomRspBO.getOrdSaleRspBO().getSaleState() != null && saleStateList.contains(atomRspBO.getOrdSaleRspBO().getSaleState())) {
                    uocOrdItemRspBO.setArrivalTime("\u81ea\u8ba2\u5355\u751f\u6548\u8d77" + ordItemRspBO.getArrivalTime() + "\u65e5\u5185\u4ea4\u8d27");
                }
                this.transOrdItem(uocOrdItemRspBO);
                ordItemRspBOList.add(uocOrdItemRspBO);
            }
            rspBO.setOrdItemRspBOList(ordItemRspBOList);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getItemInfo())) {
            ArrayList<UocOrdItemRspBO> itemInfo = new ArrayList<UocOrdItemRspBO>();
            for (SaleOrdItemRspBO ordItemRspBO : atomRspBO.getItemInfo()) {
                uocOrdItemRspBO = new UocOrdItemRspBO();
                BeanUtils.copyProperties((Object)ordItemRspBO, (Object)uocOrdItemRspBO);
                uocOrdItemRspBO.setPicUrl(uocOrdItemRspBO.getOrdGoodsRspBO().getSkuMainPicUrl());
                uocOrdItemRspBO.setOrdPromotionRspBOList(ordItemRspBO.getOrdPromotionRspBOList());
                uocOrdItemRspBO.setOrdSkuImeiRspBOList(ordItemRspBO.getOrdSkuImeiRspBOList());
                this.transOrdItem(uocOrdItemRspBO);
                itemInfo.add(uocOrdItemRspBO);
            }
            rspBO.setItemInfo(itemInfo);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getOrdSaleCouponRspBOList())) {
            ArrayList<UocOrdSaleCouponRspBO> ordSaleCouponRspBOList = new ArrayList<UocOrdSaleCouponRspBO>();
            for (OrdSaleCouponRspBO ordSaleCouponRspBO : atomRspBO.getOrdSaleCouponRspBOList()) {
                UocOrdSaleCouponRspBO uocOrdSaleCouponRspBO = new UocOrdSaleCouponRspBO();
                BeanUtils.copyProperties((Object)ordSaleCouponRspBO, (Object)uocOrdSaleCouponRspBO);
                ordSaleCouponRspBOList.add(uocOrdSaleCouponRspBO);
            }
            rspBO.setOrdSaleCouponRspBOList(ordSaleCouponRspBOList);
        }
        return rspBO;
    }

    private void transOrdSale(UocOrdSaleRspBO ordSaleRspBO) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(ordSaleRspBO.getOrderLevel() + "");
        dictReqBO.setPcode("ORDER_LEVEL");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordSaleRspBO.setOrderLevelStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordSaleRspBO.getOrderSource());
        dictReqBO.setPcode("ORDER_SOURCE");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordSaleRspBO.setOrderSourceStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordSaleRspBO.getOrderMethod() + "");
        dictReqBO.setPcode("ORDER_METHOD");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordSaleRspBO.setOrderMethodStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordSaleRspBO.getPurchaseType() + "");
        dictReqBO.setPcode("PURCHASE_TYPE");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordSaleRspBO.setPurchaseTypeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordSaleRspBO.getSaleState() + "");
        dictReqBO.setPcode("SALE_ORDER_STATUS_ADMIN");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordSaleRspBO.setSaleStateAdminStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        if (null != ordSaleRspBO.getOrderType() && 6 == ordSaleRspBO.getOrderType()) {
            dictReqBO.setCode(ordSaleRspBO.getSaleState() + "");
            dictReqBO.setPcode("SALE_ORDER_STATUS_QUERY_RY");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordSaleRspBO.setSaleStateStr(dictRspBO.getDicDictionarys().getDescrip());
            }
        } else {
            dictReqBO.setCode(ordSaleRspBO.getSaleState() + "");
            dictReqBO.setPcode("SALE_ORDER_STATUS");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordSaleRspBO.setSaleStateStr(dictRspBO.getDicDictionarys().getDescrip());
            }
            if (!UocCoreConstant.ModelSettle.TRADING.equals(ordSaleRspBO.getModelSettle()) || UocConstant.SALE_ORDER_STATUS.REJECT_PENDING.equals(ordSaleRspBO.getSaleState())) {
                // empty if block
            }
        }
        dictReqBO.setCode(ordSaleRspBO.getSaleState() + "");
        dictReqBO.setPcode("SALE_ORDER_STATUS_DESC");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordSaleRspBO.setSaleStateDesc(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordSaleRspBO.getSaleState() + "");
        dictReqBO.setPcode("PURCHASE_ORDER_STATUS");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordSaleRspBO.setPurchaseStateStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordSaleRspBO.getGiveTime() + "");
        dictReqBO.setPcode("GIVE_TIME_TYPE");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordSaleRspBO.setGiveTimeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        if (null != ordSaleRspBO.getVendorOrderType()) {
            dictReqBO.setCode(ordSaleRspBO.getVendorOrderType());
            dictReqBO.setPcode("VENDOR_ORDER_TYPE");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordSaleRspBO.setVendorOrderTypeStr(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
        if (null != ordSaleRspBO.getChnlId()) {
            dictReqBO.setCode(ordSaleRspBO.getChnlId());
            dictReqBO.setPcode("DEAL_WAY");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordSaleRspBO.setChnlIdStr(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
        if (null != ordSaleRspBO.getChnlType()) {
            dictReqBO.setCode(ordSaleRspBO.getChnlType());
            dictReqBO.setPcode("DELIVERY_WAY");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordSaleRspBO.setChnlTypeStr(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
    }

    private void transOrdItem(UocOrdItemRspBO ordItemRspBO) {
        String property;
        if (StringUtils.isNotBlank((CharSequence)ordItemRspBO.getShipStatus())) {
            SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
            dictReqBO.setCode(ordItemRspBO.getShipStatus());
            dictReqBO.setPcode("SHIP_ORDER_STATUS");
            SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                ordItemRspBO.setShipStatusStr(dictRspBO.getDicDictionarys().getDescrip());
            }
        }
        if (null != (property = OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID")) && null != ordItemRspBO.getSupNo()) {
            if (ordItemRspBO.getSupNo().equals(property)) {
                ordItemRspBO.setIsJDGoods(PecConstant.IsJd.JD);
            } else {
                ordItemRspBO.setIsJDGoods(PecConstant.IsJd.NOT);
            }
        }
    }
}

