/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl.plan;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfCommodityListsAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryAgreementDetailsAbilityService;
import com.tydic.uoc.busibase.busi.bo.CommodityAndSkusDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.CommodityImageBO;
import com.tydic.uoc.busibase.busi.bo.CommodityInfoListsReqBO;
import com.tydic.uoc.busibase.busi.bo.CommodityInfoListsRspBO;
import com.tydic.uoc.busibase.busi.bo.QryAgreementDetailsReqBO;
import com.tydic.uoc.busibase.busi.bo.QryAgreementDetailsRspBO;
import com.tydic.uoc.busibase.busi.bo.QryCommodityDetailListReqBO;
import com.tydic.uoc.busibase.busi.bo.QrySkusDetailListReqBO;
import com.tydic.uoc.busibase.busi.bo.SkuDetailListInfoBO;
import com.tydic.uoc.busibase.busi.bo.SkuInfoImageBO;
import com.tydic.uoc.common.ability.bo.plan.UocUpdatePlanItemReqBO;
import com.tydic.uoc.common.ability.bo.plan.UocUpdatePlanItemRspBO;
import com.tydic.uoc.common.busi.api.plan.UocUpdatePlanItemBusiService;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdPlanItemDao;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdPlanItemPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocUpdatePlanItemBusiServiceImpl
implements UocUpdatePlanItemBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocUpdatePlanItemBusiServiceImpl.class);
    @Autowired
    private OrdPlanItemDao ordPlanItemPO;
    @Autowired
    private PebIntfCommodityListsAbilityService pebIntfCommodityListsAbilityService;
    @Autowired
    private PebIntfQryAgreementDetailsAbilityService pebIntfQryAgreementDetailsAbilityService;
    private static final Byte AGR_YES = 4;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;

    @Override
    public UocUpdatePlanItemRspBO dealUpdatePlanItem(UocUpdatePlanItemReqBO reqBO) {
        OrdPlanItemPO itemPO = new OrdPlanItemPO();
        itemPO.setPlanItemId(reqBO.getPlanItemId());
        itemPO.setOrderId(reqBO.getOrderId());
        if (UocConstant.PlanItemFlag.PP.equals(reqBO.getFlag())) {
            ArrayList<QrySkusDetailListReqBO> detailListReqBOS = new ArrayList<QrySkusDetailListReqBO>();
            ArrayList<QryCommodityDetailListReqBO> commodityDetailListReqBOS = new ArrayList<QryCommodityDetailListReqBO>();
            QrySkusDetailListReqBO qrySkusDetailListReqBO = new QrySkusDetailListReqBO();
            qrySkusDetailListReqBO.setSupplierShopId(reqBO.getSupplierShopId());
            Long[] skuId = new Long[]{reqBO.getSkuId()};
            Long[] spuId = new Long[]{reqBO.getSpuId()};
            qrySkusDetailListReqBO.setSkuId(skuId);
            detailListReqBOS.add(qrySkusDetailListReqBO);
            QryCommodityDetailListReqBO listReqBO = new QryCommodityDetailListReqBO();
            listReqBO.setCommodityId(spuId);
            listReqBO.setSupplierShopId(reqBO.getSupplierShopId());
            commodityDetailListReqBOS.add(listReqBO);
            CommodityInfoListsReqBO uccCommodityInfoListsReqBO = new CommodityInfoListsReqBO();
            uccCommodityInfoListsReqBO.setSkusDetailListReqBOS(detailListReqBOS);
            uccCommodityInfoListsReqBO.setCommodityDetailListReqBOS(commodityDetailListReqBOS);
            uccCommodityInfoListsReqBO.setRootOrgIdIn(reqBO.getRootOrgIdIn());
            uccCommodityInfoListsReqBO.setParentOrgIdIn(reqBO.getParentOrgIdIn());
            uccCommodityInfoListsReqBO.setOrgIdIn(reqBO.getOrgIdIn());
            log.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uccCommodityInfoListsReqBO));
            CommodityInfoListsRspBO commodityInfoListsRspBO = this.pebIntfCommodityListsAbilityService.queryCommodityListsInfo(uccCommodityInfoListsReqBO);
            if (CollectionUtils.isEmpty((Collection)commodityInfoListsRspBO.getUccCommodityAndSkusDetailRspBOS())) {
                throw new UocProBusinessException("104048", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u548c\u4ef7\u683c\u7ec4\u5408\u670d\u52a1  \u8c03\u7528\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u670d\u52a1  \u65e0\u8fd4\u56de\u7ed3\u679c");
            }
            SkuDetailListInfoBO detail = (SkuDetailListInfoBO)((CommodityAndSkusDetailRspBO)commodityInfoListsRspBO.getUccCommodityAndSkusDetailRspBOS().get(0)).getUccSkusDetailBO().getUccSkuDetailListInfoBOList().get(0);
            log.error("\u5546\u54c1\u4fe1\u606f\uff1a" + detail.toString());
            itemPO.setPassCount(reqBO.getPurchaseCount());
            itemPO.setSkuId(detail.getSkuId());
            itemPO.setSkuName(detail.getSkuName());
            itemPO.setModel(detail.getModel());
            itemPO.setSpec(detail.getSpec());
            itemPO.setSupplierShopId(detail.getSupplierShopId());
            itemPO.setSpuId(reqBO.getSpuId());
            itemPO.setSkuExtSkuId(detail.getExtSkuId());
            itemPO.setSupplierShopName(detail.getShopName());
            itemPO.setSkuSupplierId(detail.getSupplierShopId());
            itemPO.setSkuSupplierName(detail.getShopName());
            itemPO.setSkuMainPicUrl(this.setSkuMainPicUrl(detail, (CommodityAndSkusDetailRspBO)commodityInfoListsRspBO.getUccCommodityAndSkusDetailRspBOS().get(0)));
            itemPO.setSkuDetail(detail.getSkuPcDetailChar());
            itemPO.setSkuStatus(detail.getSkuStatus());
            itemPO.setSkuBrandName(detail.getBrandName());
            itemPO.setSkuLocation(detail.getSkuSource());
            itemPO.setSkuMarketPrice(Long.valueOf(ElUtils.Long2bigDecimal(detail.getSkuInfoPrice().getMarketPrice()).longValue()));
            itemPO.setSkuAgreementPrice(Long.valueOf(ElUtils.Long2bigDecimal(detail.getSkuInfoPrice().getAgreementPrice()).longValue()));
            if (detail.getSkuInfoPrice().getMemberPrice1() != null) {
                itemPO.setSkuMemberPrice(Long.valueOf(ElUtils.Long2bigDecimal(detail.getSkuInfoPrice().getMemberPrice1()).longValue()));
            }
            itemPO.setSkuSalePrice(Long.valueOf(ElUtils.Long2bigDecimal(detail.getSkuInfoPrice().getSalePrice()).longValue()));
            itemPO.setPurchaseCount(reqBO.getPurchaseCount());
            itemPO.setVendorOrderType(reqBO.getVendorOrderType());
            if (reqBO.getTax() == null) {
                itemPO.setTax(Long.valueOf(13L));
            } else {
                itemPO.setTax(reqBO.getTax());
            }
            try {
                BigDecimal djs = new BigDecimal(itemPO.getSkuSalePrice()).divide(new BigDecimal(10000));
                BigDecimal taxA = new BigDecimal(String.valueOf(1.0f + (float)itemPO.getTax().longValue() / 100.0f));
                BigDecimal tax = new BigDecimal((float)itemPO.getTax().longValue() / 100.0f).setScale(2, 4);
                BigDecimal bud = djs.multiply(tax).divide(taxA, 8, RoundingMode.HALF_UP);
                itemPO.setTaxPrice(MoneyUtils.BigDecimal2Long((BigDecimal)bud));
            }
            catch (Exception e) {
                log.error("\u7a0e\u4ef7\u9519\u8bef");
            }
            if (detail.getAgreementId() != null) {
                this.qryAgr(detail.getAgreementId(), reqBO.getSkuId(), reqBO.getPlanItemId());
            }
            this.ordPlanItemPO.updateById(itemPO);
        } else if (UocConstant.PlanItemFlag.RETURN.equals(reqBO.getFlag())) {
            itemPO.setReturnSku(reqBO.getFlag());
            this.ordPlanItemPO.updateById(itemPO);
        }
        UocUpdatePlanItemRspBO rspBO = new UocUpdatePlanItemRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UocUpdatePlanItemRspBO dealUpdateGoods(UocUpdatePlanItemReqBO reqBO) {
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setGoodsItemIdList(reqBO.getGoodsItems());
        ordGoodsPO.setExt5(PebExtConstant.YES.toString());
        this.ordGoodsMapper.updateMdm(ordGoodsPO);
        UocUpdatePlanItemRspBO rspBO = new UocUpdatePlanItemRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void qryAgr(Long agreementId, Long skuId, Long planItemId) {
        OrdAgreementPO po = new OrdAgreementPO();
        po.setOrderId(planItemId);
        po.setUnitAccountId(planItemId);
        List list = this.ordAgreementMapper.selectByCondition(po);
        QryAgreementDetailsReqBO agreementDetailsReqBO = new QryAgreementDetailsReqBO();
        agreementDetailsReqBO.setAgreementId(agreementId);
        QryAgreementDetailsRspBO qryAgreementDetailsRspBO = this.pebIntfQryAgreementDetailsAbilityService.qryAgreementDetails(agreementDetailsReqBO);
        if (!"0000".equals(qryAgreementDetailsRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", skuId + "\u7684\u534f\u8bae\u67e5\u8be2\u51fa\u9519" + qryAgreementDetailsRspBO.getRespDesc());
        }
        if (qryAgreementDetailsRspBO.getAgrAgreementBO() == null) {
            throw new UocProBusinessException("100001", skuId + "\u7684\u534f\u8bae\u4e0d\u5b58\u5728");
        }
        OrdAgreementPO agreementPO = (OrdAgreementPO)JSON.parseObject((String)JSON.toJSONString((Object)qryAgreementDetailsRspBO.getAgrAgreementBO()), OrdAgreementPO.class);
        if (!AGR_YES.equals(qryAgreementDetailsRspBO.getAgrAgreementBO().getAgreementStatus())) {
            throw new UocProBusinessException("100001", skuId + "\u7684\u534f\u8bae\uff1a\u672a\u542f\u7528");
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.ordAgreementMapper.delete(po);
        }
        agreementPO.setUnitAccountId(planItemId);
        agreementPO.setOrderId(planItemId);
        agreementPO.setId(Long.valueOf(this.idUtil.nextId()));
        this.ordAgreementMapper.insert(agreementPO);
    }

    private String setSkuMainPicUrl(SkuDetailListInfoBO skuInfomationBo, CommodityAndSkusDetailRspBO uccCommodityAndSkusDetailRspBO) {
        List commdImageInfo;
        List list = skuInfomationBo.getSkuImags();
        String url = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (SkuInfoImageBO imageBo : list) {
                if (imageBo.getCommodityPicType() == null || !imageBo.getCommodityPicType().equals(PecConstant.COMMODITYPIC_TYPE.MAIN)) continue;
                url = imageBo.getSkuPicUrl();
                break;
            }
        }
        if (StringUtils.isBlank(url) && !CollectionUtils.isEmpty((Collection)(commdImageInfo = uccCommodityAndSkusDetailRspBO.getCommdImageInfo()))) {
            for (CommodityImageBO imageBo : commdImageInfo) {
                if (imageBo.getCommodityPicType() == null || !imageBo.getCommodityPicType().equals(PecConstant.COMMODITYPIC_TYPE.MAIN)) continue;
                url = imageBo.getCommodityPicUrl();
                break;
            }
        }
        return url;
    }
}

