/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebPushErpReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderDelieveredRejectReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderDelieveredRejectRspBO;
import com.tydic.uoc.common.busi.api.PebPushErpBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderDelieveredRejectBusiService;
import com.tydic.uoc.common.busi.bo.UocReverseReqBO;
import com.tydic.uoc.common.busi.bo.UocSendMessageReqBO;
import com.tydic.uoc.common.comb.api.UocPebOrderDelieveredRejectCombService;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdShipPO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebOrderDelieveredRejectCombService")
public class UocPebOrderDelieveredRejectCombServiceImpl
implements UocPebOrderDelieveredRejectCombService {
    @Autowired
    private UocPebOrderDelieveredRejectBusiService uocPebOrderDelieveredRejectBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_ORDER_CANCEL_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CANCEL_TAG}")
    private String tag;
    @Resource(name="uocPebOrderCancelMsgProvider")
    private ProxyMessageProducer uocPebOrderCancelMsgProvider;
    @Value(value="${uoc.reverse:false}")
    private Boolean reverse;
    @Value(value="${UOC_NOTIFY_ORDER_TOPIC}")
    private String notifyTopic;
    @Value(value="${UOC_NOTIFY_ORDER_TAG}")
    private String notifyTag;
    @Resource(name="notifyOrderMsgProvider")
    private ProxyMessageProducer notifyOrderMsgProvider;
    @Autowired
    private PebPushErpBusiService pebPushErpBusiService;

    @Override
    public UocPebOrderDelieveredRejectRspBO executePebOrderDelieveredReject(UocPebOrderDelieveredRejectReqBO reqBO) {
        UocPebOrderDelieveredRejectRspBO rspBO = this.uocPebOrderDelieveredRejectBusiService.executePebOrderDelieveredReject(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("103004", "\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + rspBO.getRespDesc());
        }
        if (1 == reqBO.getStatus() || 3 == reqBO.getStatus()) {
            UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
            uocSendMessageReqBO.setNotifyBusiness(UocConstant.NOTIFY_BUSINESS.ORDER_ARRIVAL_REGISTER);
            uocSendMessageReqBO.setOrderType(UocConstant.NOTIFY_ORDER_TYPE.ORDER_STORE);
            uocSendMessageReqBO.setNotifyType(UocConstant.NOTIFY_TYPE.ORDER_NOTIFY);
            uocSendMessageReqBO.setOrderId(reqBO.getOrderId());
            uocSendMessageReqBO.setPushTime(DateUtils.dateToStr((Date)new Date()));
            this.notifyOrderMsgProvider.send(new ProxyMessage(this.notifyTopic, this.notifyTag, JSONObject.toJSONString((Object)((Object)uocSendMessageReqBO))));
        }
        if (PecConstant.EXT_ORDER_STATE.REFUSED.equals(reqBO.getStatus())) {
            if (this.reverse != null && this.reverse.booleanValue()) {
                UocReverseReqBO reverseReqBO = new UocReverseReqBO();
                reverseReqBO.setOrderId(reqBO.getOrderId());
                reverseReqBO.setObjId(rspBO.getShipVoucherId());
                reverseReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                this.uocPebOrderCancelMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)reverseReqBO)));
            }
        } else {
            PebPushErpReqBO erpReqBO = new PebPushErpReqBO();
            erpReqBO.setOrderId(reqBO.getOrderId());
            this.pebPushErpBusiService.dealPushErp(erpReqBO);
        }
        UocPebOrdIdxSyncReqBO saleOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(rspBO.getOrderId(), rspBO.getSaleVoucherId(), UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)saleOrdIdxSyncReqBO)));
        if ("0000".equals(rspBO.getRespCode())) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(reqBO.getOrderId());
            List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
            for (OrdShipPO shipPO : ordShipPOList) {
                UocPebOrdIdxSyncReqBO shipOrdIdxSyncReqBO = this.bulidOrdIdxSyncReqBOParam(shipPO.getOrderId(), shipPO.getShipVoucherId(), UocConstant.OBJ_TYPE.SHIP);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)shipOrdIdxSyncReqBO)));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u7ec4\u5408\u670d\u52a1\u6210\u529f\uff01");
        return rspBO;
    }

    private UocPebOrdIdxSyncReqBO bulidOrdIdxSyncReqBOParam(Long orderId, Long objId, Integer objType) {
        UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        ordIdxSyncReqBO.setOrderId(orderId);
        ordIdxSyncReqBO.setObjId(objId);
        ordIdxSyncReqBO.setObjType(objType);
        return ordIdxSyncReqBO;
    }
}

