/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.authority.busi.bo.StationWebBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebOrderApprovalAbilityService;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalRspBO;
import com.tydic.uoc.common.busi.api.PebOrderApprovalBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderApprovalAbilityService"})
public class PebOrderApprovalAbilityServiceImpl
implements PebOrderApprovalAbilityService {
    @Autowired
    private PebOrderApprovalBusiService pebOrderApprovalBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Resource(name="dealZoneDealAutomaticTaskMsgProvider")
    private ProxyMessageProducer dealZoneDealAutomaticTaskMsgProvider;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TOPIC}")
    private String taskTopic;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TAG}")
    private String taskTag;
    @Value(value="${PUSH_ERP_ORDER_TOPIC:PUSH_ERP_ORDER_TOPIC}")
    private String pushErpTopic;
    @Value(value="${PUSH_ERP_ORDER_TOPIC:*}")
    private String pushErpTag;
    @Resource(name="pushErpOrderOrderProvider")
    private ProxyMessageProducer pushErpOrderOrderProvider;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @PostMapping(value={"dealPebOrderApproval"})
    public PebOrderApprovalRspBO dealPebOrderApproval(@RequestBody PebOrderApprovalReqBO reqBO) {
        this.validateParams(reqBO);
        if (!StringUtils.isBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        ArrayList<Long> taskList = new ArrayList<Long>();
        List umcStationsListWebExt = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getUmcStationsListWebExt()), StationWebBO.class);
        for (StationWebBO webBO : umcStationsListWebExt) {
            taskList.add(webBO.getStationId());
        }
        PebOrderApprovalRspBO rspBO = new PebOrderApprovalRspBO();
        for (PebDealOrderBO orderBO : reqBO.getOrderApprovalList()) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setTaskList(taskList);
            salePO.setOrderId(orderBO.getOrderId());
            int count = this.ordSaleMapper.getAuditCount(salePO);
            if (count == 0) {
                this.idxSync(orderBO);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u60a8\u6ca1\u6709\u8be5\u8ba2\u5355\u7684\u5ba1\u6279\u6743\u9650");
                return rspBO;
            }
            ArrayList<PebDealOrderBO> orderApprovalList = new ArrayList<PebDealOrderBO>();
            PebOrderApprovalReqBO busi = new PebOrderApprovalReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)busi);
            orderApprovalList.add(orderBO);
            busi.setOrderApprovalList(orderApprovalList);
            PebOrderApprovalRspBO approvalRspBO = this.pebOrderApprovalBusiService.dealPebOrderApproval(busi);
            if (!"0000".equals(approvalRspBO.getRespCode())) {
                return approvalRspBO;
            }
            for (PebDealOrderBO pebDealOrderBO : approvalRspBO.getOrderApprovalList()) {
                if (!pebDealOrderBO.getAuto().booleanValue()) continue;
                UocGeneralCirculationReqBO circulationReqBO = new UocGeneralCirculationReqBO();
                circulationReqBO.setActionCode("ACTPEB019");
                circulationReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
                circulationReqBO.setOrderId(pebDealOrderBO.getOrderId());
                circulationReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                this.dealZoneDealAutomaticTaskMsgProvider.send(new ProxyMessage(this.taskTopic, this.taskTag, JSONObject.toJSONString((Object)((Object)circulationReqBO))));
            }
        }
        for (PebDealOrderBO pebDealOrderBO : reqBO.getOrderApprovalList()) {
            this.idxSync(pebDealOrderBO);
            if (pebDealOrderBO.getPushOrderId() == null) continue;
            this.pushErpOrderOrderProvider.send(new ProxyMessage(this.pushErpTopic, this.pushErpTag, JSONObject.toJSONString((Object)pebDealOrderBO)));
        }
        return rspBO;
    }

    private void idxSync(PebDealOrderBO reqBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void validateParams(PebOrderApprovalReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5ba1\u6279API\u5165\u53c2\u3010bo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getActionCode() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5ba1\u6279\u52a8\u4f5c\u7f16\u7801\u3010actionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBO.getActionCode().equals("ACTPEB007") && !reqBO.getActionCode().equals("ACTPEB008")) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5ba1\u6279\u52a8\u4f5c\u7f16\u7801\u3010actionCode\u3011\u7c7b\u578b\u9519\u8bef");
        }
        if (reqBO.getAuditResult() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.PASS) && !reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.NO_PASS)) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u7c7b\u578b\u9519\u8bef");
        }
        if (reqBO.getOrderApprovalList() == null || reqBO.getOrderApprovalList().size() == 0) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5ba1\u6279\u5ba1\u6279\u8ba2\u5355\u5bf9\u8c61\u3010orderApprovalList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperId() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5ba1\u6279\u5ba1\u6279\u7528\u6237id\u3010operId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperName() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5ba1\u6279\u7528\u6237\u540d\u79f0\u3010operName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

