/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebUpdateOrderBusiService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService"})
public class PebUpdateOrderAbilityServiceImpl
implements PebUpdateOrderAbilityService {
    @Autowired
    private PebUpdateOrderBusiService pebUpdateOrderBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    @PostMapping(value={"updateOrder"})
    public PebUpdateOrderRspBO updateOrder(@RequestBody PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateOrder(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    @PostMapping(value={"updateHt"})
    public PebUpdateOrderRspBO updateHt(@RequestBody PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateHt(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    @PostMapping(value={"updateFscStatus"})
    public PebUpdateOrderRspBO updateFscStatus(@RequestBody PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateFscStatus(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    private void sync(PebUpdateOrderReqBO reqBO) {
        UocPebOrdIdxSyncReqBO idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        idxSyncReqBO.setOrderId(reqBO.getOrderId());
        idxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
    }
}

