/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.UocProAfterServiceTypeQryAbilityService;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceTypeQryAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceTypeQryAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceTypeRspDataBo;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProAfterServiceTypeQryAbilityService"})
public class UocProAfterServiceTypeQryAbilityServiceImpl
implements UocProAfterServiceTypeQryAbilityService {
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    private String returnDesc = "\u652f\u63017\u5929\u65e0\u7406\u7531\u9000\u8d27\uff0c\u5df2\u8d85\u8fc7\u89c4\u5b9a\u7684\u9000\u8d27\u65f6\u95f4";
    private String fAndCDesc = "\u5df2\u8d85\u8fc7\u6362\u8d27/\u7ef4\u4fee\u65f6\u9650";

    @PostMapping(value={"qryAfterServiceType"})
    public UocProAfterServiceTypeQryAbilityRspBo qryAfterServiceType(@RequestBody UocProAfterServiceTypeQryAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        UocProAfterServiceTypeQryAbilityRspBo rspBo = (UocProAfterServiceTypeQryAbilityRspBo)UocProRspBoUtil.success(UocProAfterServiceTypeQryAbilityRspBo.class);
        OrdShipPO shipPO = this.ordShipMapper.getModelById(reqBo.getShipVoucherId().longValue());
        Date receiverTime = shipPO.getReceiverTime();
        UocProAfterServiceTypeRspDataBo salesReturn = new UocProAfterServiceTypeRspDataBo();
        salesReturn.setCanApply(Boolean.valueOf(true));
        salesReturn.setServerType(UocConstant.AfterService.AFS_RETURN);
        salesReturn.setServerDesc("");
        salesReturn.setServerName("\u9000\u8d27");
        UocProAfterServiceTypeRspDataBo exchange = new UocProAfterServiceTypeRspDataBo();
        exchange.setCanApply(Boolean.valueOf(true));
        exchange.setServerType(UocConstant.AfterService.AFS_EXCHANGE);
        exchange.setServerDesc("");
        exchange.setServerName("\u6362\u8d27");
        UocProAfterServiceTypeRspDataBo fix = new UocProAfterServiceTypeRspDataBo();
        fix.setCanApply(Boolean.valueOf(true));
        fix.setServerType(UocConstant.AfterService.AFS_MAINTAIN);
        fix.setServerDesc("");
        fix.setServerName("\u7ef4\u4fee");
        List serverTypes = rspBo.getServerTypes();
        serverTypes.add(exchange);
        serverTypes.add(fix);
        serverTypes.add(salesReturn);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBo.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        if (orderPO != null && orderPO.getOrderType() != 2 && "2205".equals(shipPO.getShipStatus())) {
            serverTypes.remove(salesReturn);
        }
        if (receiverTime != null) {
            Calendar receiverDate = Calendar.getInstance();
            receiverDate.setTime(receiverTime);
            OrdGoodsPO qryGoodsPo = new OrdGoodsPO();
            qryGoodsPo.setOrdItemIdList(new ArrayList(reqBo.getOrdItems()));
            List goodsList = this.ordGoodsMapper.getList(qryGoodsPo);
            if (CollectionUtils.isEmpty((Collection)goodsList)) {
                throw new UocProBusinessException("104017", "\u672a\u6839\u636e\u5165\u53c2[ordItems]\u67e5\u8be2\u5230\u8ba2\u5355\u7269\u6599\uff01");
            }
            Map<Long, OrdGoodsPO> ordGoodMap = goodsList.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, po -> po));
            for (Long itemId : reqBo.getOrdItems()) {
                Calendar nowDate;
                OrdGoodsPO goodTmpPo = ordGoodMap.get(itemId);
                if (goodTmpPo == null) continue;
                Integer rejectAllowDate = goodTmpPo.getRejectAllowDate();
                Integer exchangeAllowDate = goodTmpPo.getExchangeAllowDate();
                Integer maintainAllowDate = goodTmpPo.getMaintainAllowDate();
                if (rejectAllowDate != null && rejectAllowDate > 0) {
                    nowDate = Calendar.getInstance();
                    nowDate.setTime(new Date());
                    nowDate.add(5, -rejectAllowDate.intValue());
                    if (nowDate.after(receiverDate) && salesReturn.getCanApply().booleanValue()) {
                        salesReturn.setCanApply(Boolean.valueOf(false));
                        salesReturn.setServerDesc(goodTmpPo.getSkuName() + ":" + this.returnDesc);
                    }
                } else {
                    serverTypes.remove(salesReturn);
                }
                if (exchangeAllowDate != null && exchangeAllowDate > 0) {
                    nowDate = Calendar.getInstance();
                    nowDate.setTime(new Date());
                    nowDate.add(5, -exchangeAllowDate.intValue());
                    if (nowDate.after(receiverDate) && exchange.getCanApply().booleanValue()) {
                        exchange.setCanApply(Boolean.valueOf(false));
                        exchange.setServerDesc(goodTmpPo.getSkuName() + ":" + this.fAndCDesc);
                    }
                } else {
                    serverTypes.remove(exchange);
                }
                if (maintainAllowDate != null && maintainAllowDate > 0) {
                    nowDate = Calendar.getInstance();
                    nowDate.setTime(new Date());
                    nowDate.add(5, -maintainAllowDate.intValue());
                    if (!nowDate.after(receiverDate) || !fix.getCanApply().booleanValue()) continue;
                    fix.setCanApply(Boolean.valueOf(false));
                    fix.setServerDesc(goodTmpPo.getSkuName() + ":" + this.fAndCDesc);
                    continue;
                }
                serverTypes.remove(fix);
            }
        }
        return rspBo;
    }

    private void addDefaultBo(UocProAfterServiceTypeQryAbilityReqBo reqBo, UocProAfterServiceTypeQryAbilityRspBo rspBo) {
    }

    private void validateArgs(UocProAfterServiceTypeQryAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104017", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104017", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleVoucherId())) {
            throw new UocProBusinessException("104017", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrdItems())) {
            throw new UocProBusinessException("104017", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[ordItems]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipVoucherId())) {
            throw new UocProBusinessException("104017", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[shipVoucherId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

