/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfZmCreatePurchaseOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.DisData;
import com.tydic.uoc.busibase.busi.bo.HeaderDataBO;
import com.tydic.uoc.busibase.busi.bo.LineInfoBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfZmCreatePurchaseOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfZmCreatePurchaseOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebPushErpReqBO;
import com.tydic.uoc.common.ability.bo.PebPushErpRspBO;
import com.tydic.uoc.common.atom.api.plan.GetSchemeCodeByPlanIdService;
import com.tydic.uoc.common.atom.bo.plan.PlanSchemeBO;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.PebPushErpBusiService;
import com.tydic.uoc.common.busi.api.plan.PushMdmBusiService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.common.busi.bo.plan.PushMdmReqBO;
import com.tydic.uoc.common.busi.bo.plan.PushMdmRspBO;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPlanItemDao;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrgSubCodeMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.PlanDiversionInfo;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrgSubCodePO;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebPushErpBusiServiceImpl
implements PebPushErpBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebIntfZmCreatePurchaseOrderAbilityService pebIntfZmCreatePurchaseOrderAbilityService;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Value(value="${needDate:30}")
    private Long needDate;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Value(value="${ATTRIBUTE_CATEGORY:\u4e00\u4f53\u5316\u8ba2\u5355}")
    private String ATTRIBUTE_CATEGORY;
    @Autowired
    private UocOrgSubCodeMapper uocOrgSubCodeMapper;
    @Autowired
    private OrdPlanItemDao ordPlanItemDao;
    @Value(value="${mdm.fenpei:0}")
    private String fenpei;
    @Autowired
    private PushMdmBusiService pushMdmBusiService;
    @Autowired
    private GetSchemeCodeByPlanIdService getSchemeCodeByPlanIdService;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;

    @Override
    public PebPushErpRspBO dealPushErp(PebPushErpReqBO reqBO) {
        PebPushErpRspBO rspBO = new PebPushErpRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(ordItemPO);
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(reqBO.getOrderId());
        List goodsPOS = this.ordGoodsMapper.getList(ordGoodsPO);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (!PebExtConstant.YES.equals(zmInfoPO.getIsPushErp())) {
            rspBO.setRespCode("102001");
            rspBO.setRespDesc("\u8be5\u8ba2\u5355\u4e0d\u9700\u8981\u63a8\u9001erp");
            return rspBO;
        }
        if (PebExtConstant.YES.equals(zmInfoPO.getErpStatus())) {
            rspBO.setSaleId(ordSalePO.getSaleVoucherId());
            return rspBO;
        }
        PebIntfZmCreatePurchaseOrderReqBO purchaseOrderReqBO = new PebIntfZmCreatePurchaseOrderReqBO();
        purchaseOrderReqBO.setPBATCH_ID(reqBO.getOrderId().toString());
        ArrayList<HeaderDataBO> headerDataBOS = new ArrayList<HeaderDataBO>();
        HeaderDataBO headerDataBO = new HeaderDataBO();
        headerDataBO.setHEADER_UUID(reqBO.getOrderId().toString());
        headerDataBO.setORG_ID(zmInfoPO.getBuynerErpNo());
        headerDataBO.setVENDOR_CODE(zmInfoPO.getSupplierErpNo());
        headerDataBO.setVENDOR_NAME(zmInfoPO.getSupplierName());
        headerDataBO.setATTRIBUTE_CATEGORY(this.ATTRIBUTE_CATEGORY);
        if (zmInfoPO.getVendorSiteId() != null) {
            headerDataBO.setB2BSITE_ID(zmInfoPO.getVendorSiteId().toString());
        }
        if (zmInfoPO.getAgentId() != null) {
            headerDataBO.setAGENT_ID(zmInfoPO.getAgentId().toString());
        }
        headerDataBO.setCURRENCY_CODE("CNY");
        headerDataBO.setUSER_NAME(zmInfoPO.getErpUserName());
        headerDataBO.setDOC_TYPE("STANDARD");
        headerDataBO.setDOC_NUM(ordSalePO.getSaleVoucherNo());
        headerDataBO.setAUTO_APPROVE("Y");
        headerDataBO.setSHIP_TO_LOC_ID(zmInfoPO.getAcquirerId());
        headerDataBO.setBILL_TO_LOC_ID(zmInfoPO.getConsigneeId());
        headerDataBO.setATTRIBUTE1(zmInfoPO.getTaxrate().toString());
        headerDataBO.setATTRIBUTE2(zmInfoPO.getSourcesOfFundsId());
        headerDataBO.setATTRIBUTE3(zmInfoPO.getUseDeptId());
        headerDataBO.setATTRIBUTE4(zmInfoPO.getDemandTrackingNo());
        headerDataBO.setATTRIBUTE5(zmInfoPO.getEnDeliveryDate());
        headerDataBO.setATTRIBUTE6(zmInfoPO.getEnglishPaymentTerms());
        headerDataBO.setATTRIBUTE7(zmInfoPO.getEnVersionPriceTerm());
        headerDataBO.setATTRIBUTE8(zmInfoPO.getEnVersionShipment());
        headerDataBO.setATTRIBUTE9(zmInfoPO.getEnPortDestination());
        if (PebExtConstant.YES.equals(zmInfoPO.getIsWaiWei())) {
            headerDataBO.setATTRIBUTE10("Y");
        } else {
            headerDataBO.setATTRIBUTE10("N");
        }
        headerDataBO.setATTRIBUTE11(zmInfoPO.getWaiWeiId());
        if (PebExtConstant.YES.equals(zmInfoPO.getIsFixedAsset())) {
            headerDataBO.setATTRIBUTE12("Y");
        } else {
            headerDataBO.setATTRIBUTE12("N");
        }
        if (PebExtConstant.YES.equals(zmInfoPO.getIsJsXy())) {
            headerDataBO.setATTRIBUTE13("Y");
        } else {
            headerDataBO.setATTRIBUTE13("N");
        }
        headerDataBO.setATTRIBUTE14(zmInfoPO.getDaTunRemark());
        headerDataBO.setATTRIBUTE15(zmInfoPO.getPurType());
        ArrayList<LineInfoBO> lineInfoBOS = new ArrayList<LineInfoBO>();
        headerDataBO.setLINE_DATA(lineInfoBOS);
        Map<Long, OrdGoodsPO> map = goodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, i -> i));
        ArrayList<Long> ids = new ArrayList<Long>();
        StringBuilder msg = new StringBuilder();
        for (OrdItemPO itemPO : list) {
            if (PebExtConstant.YES.toString().equals(this.fenpei) && PebExtConstant.YES.toString().equals(itemPO.getLmSubOrderId())) {
                if (StringUtils.isBlank((CharSequence)itemPO.getLmSubOrderId())) {
                    throw new UocProBusinessException("102001", "\u7269\u6599\u5206\u914d\u7ec4\u7ec7\u7ed3\u679c\u672a\u8fd4\u56de\uff0c\u8bf7\u7a0d\u540e");
                }
                if (!PebExtConstant.YES.toString().equals(itemPO.getLmSubOrderId())) {
                    msg.append(itemPO.getLmSubOrderId());
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)itemPO.getOrganizationId())) continue;
            ids.add(Long.valueOf(itemPO.getOrganizationId()));
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            PushMdmReqBO mdmReqBO = new PushMdmReqBO();
            mdmReqBO.setOrderId(reqBO.getOrderId());
            PushMdmRspBO mdmRspBO = this.pushMdmBusiService.dealPush(mdmReqBO);
            if (!"0000".equals(mdmRspBO.getRespCode())) {
                throw new UocProBusinessException("102001", "\u7269\u6599\u5206\u914d\u7ec4\u7ec7\u5931\u8d25\uff0c" + mdmRspBO.getRespDesc());
            }
            throw new UocProBusinessException("102001", "\u7269\u6599\u5206\u914d\u7ec4\u7ec7\u5931\u8d25\uff0c\u5df2\u91cd\u65b0\u63a8\u9001\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u6216\u8005\u7b49\u5f85\uff0c\u539f\u62a5\u9519\u4e3a\uff1a" + msg);
        }
        List subCodePOS = new ArrayList();
        if (ids.size() > 0) {
            UocOrgSubCodePO codePO = new UocOrgSubCodePO();
            codePO.setBfOrgIdList(ids);
            subCodePOS = this.uocOrgSubCodeMapper.selectByCondition(codePO);
        }
        int i2 = 0;
        ArrayList<String> planIds = new ArrayList<String>();
        ArrayList<PlanSchemeBO> data = new ArrayList<PlanSchemeBO>();
        for (OrdItemPO itemPO : list) {
            ++i2;
            OrdGoodsPO goodsPO = map.get(itemPO.getOrdItemId());
            LineInfoBO infoBO = new LineInfoBO();
            if (itemPO.getPlanId() != null) {
                PlanDiversionInfo diversionInfo = this.planDiversionMapper.selectOneByPlanId(itemPO.getPlanId());
                planIds.add(itemPO.getPlanId() + "");
                PlanSchemeBO schemeBO = new PlanSchemeBO();
                schemeBO.setPlanId(diversionInfo.getPlanId() + "");
                schemeBO.setLINE_ID(diversionInfo.getLineId());
                schemeBO.setHEADER_ID(diversionInfo.getHeaderId());
                schemeBO.setSOURCE_CODE(diversionInfo.getSourceCode());
                data.add(schemeBO);
            }
            infoBO.setLINE_ATTRIBUTE14(PebPushErpBusiServiceImpl.str(itemPO.getSkuName()));
            infoBO.setLINE_ATTRIBUTE10("Y");
            infoBO.setLINE_ATTRIBUTE8(stakeholderPO.getSupName());
            if (StringUtils.isNotBlank((CharSequence)goodsPO.getExt4())) {
                infoBO.setITEM_NO(goodsPO.getExt4());
                infoBO.setITEM_DESC(goodsPO.getExt6());
            } else {
                infoBO.setITEM_NO(goodsPO.getSkuMaterialId());
                infoBO.setITEM_DESC(itemPO.getExtField2());
            }
            infoBO.setUNIT_OF_MEASURE(itemPO.getUnitName());
            try {
                infoBO.setNEED_BY_DATE(DateUtils.dateToStr((Date)DateUtils.strToDateLong((String)ordSalePO.getGiveTime())));
            }
            catch (Exception e) {
                infoBO.setNEED_BY_DATE(DateUtils.dateToStr((Date)DateUtils.strToDate((String)ordSalePO.getGiveTime())));
            }
            if (StringUtils.isBlank((CharSequence)infoBO.getNEED_BY_DATE())) {
                try {
                    infoBO.setNEED_BY_DATE(DateUtils.dateToStr((Date)DateUtils.strToDate((String)itemPO.getArrivalTime())));
                }
                catch (Exception e) {
                    infoBO.setNEED_BY_DATE(DateUtils.dateToStr((Date)DateUtils.strToDate((String)itemPO.getArrivalTime())));
                }
            }
            infoBO.setQUANTITY(itemPO.getPurchaseCount().toString());
            OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
            if (PebExtConstant.YES.toString().equals(orderPO.getExt4())) {
                try {
                    infoBO.setUNIT_PRICE(MoneyUtils.Long2BigDecimal((Long)itemPO.getSalePrice()) + "");
                }
                catch (Exception schemeBO) {}
            } else {
                try {
                    BigDecimal price = itemPO.getTax() == null ? new BigDecimal(0.16) : new BigDecimal((float)itemPO.getTax().longValue() / 100.0f);
                    BigDecimal djs = new BigDecimal(itemPO.getSalePrice()).divide(new BigDecimal(10000));
                    BigDecimal taxA = price.add(BigDecimal.ONE);
                    BigDecimal bud = djs.multiply(price).divide(taxA, 6, RoundingMode.HALF_UP);
                    infoBO.setUNIT_PRICE(djs.subtract(bud) + "");
                }
                catch (Exception price) {
                    // empty catch block
                }
            }
            if (itemPO.getPlanItemId() != null) {
                infoBO.setSHIPMENT_ATR15(itemPO.getPlanItemId().toString());
            }
            infoBO.setUSER_NAME(zmInfoPO.getErpUserName());
            infoBO.setLINE_NUM(String.valueOf(i2));
            infoBO.setORGANIZATION_ID(itemPO.getOrganizationId());
            infoBO.setLINE_ATTRIBUTE4(itemPO.getOrdItemId().toString());
            infoBO.setLINE_ATTRIBUTE5(itemPO.getTax().toString());
            infoBO.setLINE_ATTRIBUTE7("N");
            ArrayList<DisData> disDatas = new ArrayList<DisData>();
            DisData disData = new DisData();
            disData.setQUANTITY_ORDERED(itemPO.getPurchaseCount().toString());
            disData.setDIS_NUM("1");
            disData.setUPDATESTATUS("0");
            if (itemPO.getPlanId() != null) {
                Long yes = 1L;
                if (yes.equals(itemPO.getPreFee())) {
                    disData.setSCH_LINE_ID(itemPO.getPlanItemId().toString());
                    disData.setUPDATESTATUS("1");
                } else {
                    disData.setUPDATESTATUS("0");
                    disData.setSCH_LINE_ID(itemPO.getPlanItemId().toString());
                }
            }
            disData.setUSER_NAME(zmInfoPO.getErpUserName());
            if (StringUtils.isNotBlank((CharSequence)zmInfoPO.getConsigneeId())) {
                disData.setDELIVER_TO_LOC_ID(zmInfoPO.getConsigneeId());
            }
            if (CollectionUtils.isNotEmpty(subCodePOS)) {
                for (UocOrgSubCodePO codePO : subCodePOS) {
                    if (!codePO.getBfOrgId().toString().equals(itemPO.getOrganizationId())) continue;
                    disData.setORGANIZATION_ID(codePO.getAfsOrgId().toString());
                    disData.setDESTINATION_SUBINVENTORY(codePO.getSubCode());
                    if (!StringUtils.isNotBlank((CharSequence)codePO.getDeliveryId())) break;
                    disData.setDELIVER_TO_LOC_ID(codePO.getDeliveryId());
                    break;
                }
            }
            if (StringUtils.isBlank((CharSequence)disData.getORGANIZATION_ID())) {
                disData.setORGANIZATION_ID(itemPO.getOrganizationId());
            }
            infoBO.setORGANIZATION_ID(disData.getORGANIZATION_ID());
            if (StringUtils.isBlank((CharSequence)disData.getDESTINATION_SUBINVENTORY())) {
                disData.setDESTINATION_SUBINVENTORY("");
            }
            disDatas.add(disData);
            infoBO.setDIS_DATA(disDatas);
            lineInfoBOS.add(infoBO);
        }
        headerDataBOS.add(headerDataBO);
        purchaseOrderReqBO.setHEADER_DATA(headerDataBOS);
        PebIntfZmCreatePurchaseOrderRspBO purchaseOrderRspBO = this.pebIntfZmCreatePurchaseOrderAbilityService.puchaserOrder(purchaseOrderReqBO);
        rspBO.setRespCode(purchaseOrderRspBO.getRespCode());
        rspBO.setRespDesc(purchaseOrderRspBO.getRespDesc());
        this.saveLog(reqBO.getOrderId(), purchaseOrderRspBO.getReturnString(), JSON.toJSONString((Object)purchaseOrderReqBO), "pushErp", purchaseOrderRspBO.getRespCode());
        rspBO.setSaleId(ordSalePO.getSaleVoucherId());
        if ("0000".equals(purchaseOrderRspBO.getRespCode())) {
            UocOrdZmInfoPO update = new UocOrdZmInfoPO();
            update.setOrderId(reqBO.getOrderId());
            update.setErpStatus(Integer.valueOf(1));
            this.uocOrdZmInfoMapper.update(update);
        }
        return rspBO;
    }

    public static String str(String s) {
        if (PebPushErpBusiServiceImpl.getWordCountCode(s, "UTF-8") > 150) {
            s = s.substring(0, s.length() - 1);
        }
        if (PebPushErpBusiServiceImpl.getWordCountCode(s, "UTF-8") > 150) {
            s = PebPushErpBusiServiceImpl.str(s);
        }
        return s;
    }

    public static int getWordCountCode(String str, String code) {
        try {
            return str.getBytes(code).length;
        }
        catch (UnsupportedEncodingException e) {
            return 149;
        }
    }

    private void saveLog(Long orderId, String out, String in, String interCode, String code) {
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setErrDetail("1");
        logBO.setFlowFlag(1);
        logBO.setInContent(in);
        logBO.setInterCode(interCode);
        logBO.setInterSn("1");
        logBO.setCallCount(1);
        logBO.setCallState("1");
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(code);
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

