/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.UocPebPriceCalculationAtomService;
import com.tydic.uoc.common.atom.bo.OrderBO;
import com.tydic.uoc.common.atom.bo.OrderItemBO;
import com.tydic.uoc.common.atom.bo.UocPebPriceCalculationReqBO;
import com.tydic.uoc.common.atom.bo.UocPebPriceCalculationRespBO;
import com.tydic.uoc.common.atom.bo.YanbaoBO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UocPebPriceCalculationAtomServiceImpl
implements UocPebPriceCalculationAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocPebPriceCalculationAtomServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();

    @Override
    public UocPebPriceCalculationRespBO dealUocPebPriceCalculation(UocPebPriceCalculationReqBO uocPebPriceCalculationReqBO) {
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u8ba2\u5355\u603b\u4ef7\u8ba1\u7b97\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2:" + uocPebPriceCalculationReqBO.toString());
        }
        this.validateParams(uocPebPriceCalculationReqBO);
        List<OrderBO> orders = uocPebPriceCalculationReqBO.getOrders();
        BigDecimal totalPrice = BigDecimal.ZERO;
        HashMap<Long, Object> map = new HashMap<Long, Object>(5);
        for (OrderBO order : orders) {
            List<OrderItemBO> orderItems = order.getOrderItems();
            BigDecimal skuAndYanbaosPrice = BigDecimal.ZERO;
            for (OrderItemBO orderItem : orderItems) {
                List<YanbaoBO> yanbaos = orderItem.getYanbaos();
                BigDecimal yanbaosPrice = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(yanbaos)) {
                    for (YanbaoBO yanbao : yanbaos) {
                        Integer bindSkuCount = yanbao.getBindSkuCount();
                        BigDecimal price = yanbao.getPrice();
                        yanbaosPrice = yanbaosPrice.add(price.multiply(new BigDecimal(bindSkuCount)));
                    }
                }
                BigDecimal purchaseCount = orderItem.getPurchaseCount();
                BigDecimal skuSalePrice = orderItem.getSkuSalePrice();
                skuAndYanbaosPrice = skuAndYanbaosPrice.add(skuSalePrice.multiply(purchaseCount)).add(yanbaosPrice);
            }
            BigDecimal orderPrice = BigDecimal.ZERO;
            BigDecimal orderFreight = order.getTatleTransportationFee();
            orderPrice = orderFreight != null ? skuAndYanbaosPrice.add(orderFreight) : skuAndYanbaosPrice;
            map.put(order.getGoodsSupplierId(), orderPrice);
            totalPrice = totalPrice.add(orderPrice);
        }
        if (uocPebPriceCalculationReqBO.getTotalAmount().compareTo(totalPrice) != 0) {
            throw new UocProBusinessException("101058", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u8ba1\u7b97\u7684\u8ba2\u5355\u4ef7\u683c\u4e0e\u4f20\u5165\u603b\u4ef7\u4e0d\u4e00\u81f4");
        }
        UocPebPriceCalculationRespBO uocPebPriceCalculationRespBO = new UocPebPriceCalculationRespBO();
        uocPebPriceCalculationRespBO.setMap(map);
        uocPebPriceCalculationRespBO.setTotalPrice(totalPrice);
        uocPebPriceCalculationRespBO.setRespCode("0000");
        uocPebPriceCalculationRespBO.setRespDesc("\u6821\u9a8c\u6210\u529f");
        return uocPebPriceCalculationRespBO;
    }

    private void validateParams(UocPebPriceCalculationReqBO uocPebPriceCalculationReqBO) {
        if (uocPebPriceCalculationReqBO.getTotalAmount() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u603b\u91d1\u989d\u3010totalAmount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<OrderBO> orders = uocPebPriceCalculationReqBO.getOrders();
        if (CollectionUtils.isEmpty(orders)) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u8ba2\u5355\u96c6\u5408\u5165\u53c2\u3010orders\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (OrderBO order : orders) {
            if (order.getGoodsSupplierId() == null) {
                throw new UocProBusinessException("100002", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u8ba2\u5355\u4e0b\u4f9b\u5e94\u5546\u7f16\u53f7\u3010supplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<OrderItemBO> orderItems = order.getOrderItems();
            if (CollectionUtils.isEmpty(orderItems)) {
                throw new UocProBusinessException("100002", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u8ba2\u5355\u4e0b\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u3010orderItems\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (OrderItemBO orderItem : orderItems) {
                if (orderItem.getPurchaseCount() == null) {
                    throw new UocProBusinessException("100002", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u8ba2\u5355\u4e0b\u8ba2\u5355\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u3010purchaseCount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (orderItem.getSkuSalePrice() == null) {
                    throw new UocProBusinessException("100002", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u8ba2\u5355\u4e0b\u8ba2\u5355\u660e\u7ec6\u5546\u54c1\u4ef7\u683c\u3010skuMemberPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List<YanbaoBO> yanbaos = orderItem.getYanbaos();
                if (!CollectionUtils.isNotEmpty(yanbaos)) continue;
                for (YanbaoBO yanbao : yanbaos) {
                    if (yanbao.getBindSkuCount() == null) {
                        throw new UocProBusinessException("100002", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u8ba2\u5355\u4e0b\u8ba2\u5355\u660e\u7ec6\u5ef6\u4fdd\u4fe1\u606f\u7ed1\u5b9a\u5546\u54c1\u6570\u91cf\u3010bindSkuCount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (yanbao.getPrice() != null) continue;
                    throw new UocProBusinessException("100002", "\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1  \u8ba2\u5355\u4e0b\u8ba2\u5355\u660e\u7ec6\u5ef6\u4fdd\u4fe1\u606f\u4ef7\u683c\u3010price\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }
}

