/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreBusiOperRecordAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateConfigRemindAtomService;
import com.tydic.uoc.common.atom.api.UocProShouldPayOrDeductDealAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreBusiOperRecordReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreBusiOperRecordRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateConfigRemindAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.PebOrderApprovalBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancellationBusiService;
import com.tydic.uoc.common.busi.bo.UocPebOrderCancellationReqBO;
import com.tydic.uoc.common.busi.bo.UocPebOrderCancellationRspBO;
import com.tydic.uoc.common.busi.impl.PebOrderToRemindBusiServiceImpl;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdItemWtLogMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdSaleMtLogMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PecOrdSaleMapper;
import com.tydic.uoc.dao.UocOrdHistoryMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdItemWtLogPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSaleMtLogPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdHistoryPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="pebOrderApprovalBusiService")
public class PebOrderApprovalBusiServiceImpl
implements PebOrderApprovalBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebOrderToRemindBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private PecOrdSaleMapper pecOrdSaleMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemWtLogMapper ordItemWtLogMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdSaleMtLogMapper ordSaleMtLogMapper;
    @Autowired
    private UocCoreStateConfigRemindAtomService uocCoreStateConfigRemindAtomService;
    @Autowired
    private UocPebOrderCancellationBusiService uocPebOrderCancellationBusiService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Value(value="${uoc.reverse:false}")
    private Boolean reverse;
    @Value(value="${UOC_ORDER_CANCEL_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CANCEL_TAG}")
    private String tag;
    @Resource(name="uocPebOrderCancelMsgProvider")
    private ProxyMessageProducer uocPebOrderCancelMsgProvider;
    @Autowired
    private UocProShouldPayOrDeductDealAtomService uocProShouldPayOrDeductDealAtomService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private UocOrdHistoryMapper uocOrdHistoryMapper;

    @Override
    public PebOrderApprovalRspBO dealPebOrderApproval(PebOrderApprovalReqBO reqBO) {
        PebOrderApprovalRspBO rspBO = new PebOrderApprovalRspBO();
        List orderApprovalList = reqBO.getOrderApprovalList();
        for (PebDealOrderBO pebDealOrderBO : orderApprovalList) {
            UocCoreStateCheckAtomRspBO uocCoreStateCheckAtomRspBO;
            UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
            uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
            uocCoreStateCheckAtomReqBO.setOrderId(pebDealOrderBO.getOrderId());
            uocCoreStateCheckAtomReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
            uocCoreStateCheckAtomReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            if (this.IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u5165\u53c2:" + uocCoreStateCheckAtomReqBO.toString());
            }
            if (!(uocCoreStateCheckAtomRspBO = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO)).getRespCode().equals("0000")) {
                throw new UocProBusinessException("100001", "\u8ba2\u5355id:" + pebDealOrderBO.getOrderId() + "\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(pebDealOrderBO.getOrderId());
            ordSalePO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            pebDealOrderBO.setOrderSource(ordSalePO.getOrderSource());
            pebDealOrderBO.setSaleFee(ordSalePO.getSaleFee());
            if (!StringUtils.isBlank((CharSequence)pebDealOrderBO.getStepId())) continue;
            pebDealOrderBO.setStepId(ordSalePO.getTbOrderId());
        }
        this.audit(reqBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }

    private void audit(PebOrderApprovalReqBO reqBO, PebOrderApprovalRspBO rspBO) {
        Integer objType = null;
        List orderApprovalList = reqBO.getOrderApprovalList();
        if (reqBO.getActionCode().equals("ACTPEB007")) {
            objType = UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007;
        }
        if (reqBO.getActionCode().equals("ACTPEB008")) {
            objType = UocConstant.APPROVAL_OBJ_TYPE.ACTPEB008;
        }
        Map<String, List<PebDealOrderBO>> map = orderApprovalList.stream().collect(Collectors.groupingBy(PebDealOrderBO::getStepId));
        for (String key : map.keySet()) {
            UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO;
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            uacNoTaskAuditOrderAuditReqBO.setStepId(key);
            uacNoTaskAuditOrderAuditReqBO.setAuditResult(reqBO.getAuditResult());
            uacNoTaskAuditOrderAuditReqBO.setOperId(reqBO.getOperId());
            uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOrgName());
            uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getOperName());
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApprovalRemark());
            uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOperDept());
            uacNoTaskAuditOrderAuditReqBO.setObjType(objType);
            ArrayList<Long> objIds = new ArrayList<Long>();
            for (PebDealOrderBO id : map.get(key)) {
                objIds.add(id.getSaleVoucherId());
            }
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
            HashMap<String, Object> ows = new HashMap<String, Object>();
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(map.get(key).get(0).getOrderId());
            zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
            if (zmInfoPO != null) {
                ows.put("jhwzlb", ElUtils.getMaterialCategory(zmInfoPO.getMaterialCategory()));
                try {
                    ows.put("ysje", MoneyUtils.Long2BigDecimal((Long)map.get(key).get(0).getSaleFee()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                uacNoTaskAuditOrderAuditReqBO.setVariables(ows);
            }
            if (!(uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO)).getRespCode().equals("0000")) {
                throw new UocProBusinessException("102044", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
            }
            this.dealSuccess(map.get(key), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish(), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId(), reqBO, rspBO);
        }
    }

    private void dealSuccess(List<PebDealOrderBO> list, boolean finish, String stepId, PebOrderApprovalReqBO reqBO, PebOrderApprovalRspBO rspBO) {
        ArrayList<PebDealOrderBO> result = new ArrayList<PebDealOrderBO>();
        for (PebDealOrderBO pebDealOrderBO : list) {
            if (finish) {
                if (!reqBO.getActionCode().equals("ACTPEB008")) {
                    this.reasonForBackFillCancellation(pebDealOrderBO, reqBO);
                }
                if (!UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult()) || reqBO.getActionCode().equals("ACTPEB008")) {
                    boolean auto = this.run(pebDealOrderBO, reqBO.getAuditResult(), reqBO);
                    pebDealOrderBO.setAuto(Boolean.valueOf(auto));
                } else {
                    pebDealOrderBO.setAuto(Boolean.valueOf(false));
                }
                result.add(pebDealOrderBO);
            } else {
                OrdSalePO salePo = new OrdSalePO();
                salePo.setOrderId(pebDealOrderBO.getOrderId());
                salePo.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
                salePo.setTbOrderId(stepId);
                this.ordSaleMapper.updateById(salePo);
            }
            rspBO.setOrderApprovalList(result);
            if (!"ACTPEB008".equals(reqBO.getActionCode())) continue;
            if ("0".equals(reqBO.getAuditResult().toString())) {
                this.saveAdjustInfo(pebDealOrderBO);
                this.sendMsg(pebDealOrderBO);
                continue;
            }
            OrdSaleMtLogPO ordSaleMtLogPo = new OrdSaleMtLogPO();
            ordSaleMtLogPo.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
            ordSaleMtLogPo.setOrderId(pebDealOrderBO.getOrderId());
            this.ordSaleMtLogMapper.deleteBy(ordSaleMtLogPo);
            OrdItemWtLogPO logPo = new OrdItemWtLogPO();
            logPo.setOrderId(pebDealOrderBO.getOrderId());
            this.ordItemWtLogMapper.deleteBy(logPo);
        }
    }

    private void saveLog(PebOrderApprovalReqBO reqBO, PebDealOrderBO pebDealOrderBO) {
        UocCoreBusiOperRecordReqBO uocCoreBusiOperRecordReqBO = new UocCoreBusiOperRecordReqBO();
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(reqBO.getActionCode());
        dictReqBO.setPcode("ACTION_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (dictRspBO != null && dictRspBO.getDicDictionarys() != null) {
            String describe = dictRspBO.getDicDictionarys().getDescrip();
            uocCoreBusiOperRecordReqBO.setDealName(describe);
            uocCoreBusiOperRecordReqBO.setDealTypeName(describe);
            uocCoreBusiOperRecordReqBO.setDealDesc(describe);
            uocCoreBusiOperRecordReqBO.setTaskId(describe);
            uocCoreBusiOperRecordReqBO.setTaskName(describe);
            uocCoreBusiOperRecordReqBO.setDealReason(describe);
        }
        uocCoreBusiOperRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.TASK_OPER_RECORD);
        uocCoreBusiOperRecordReqBO.setOrderId(pebDealOrderBO.getOrderId());
        uocCoreBusiOperRecordReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreBusiOperRecordReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
        uocCoreBusiOperRecordReqBO.setCreateTime(new Date());
        uocCoreBusiOperRecordReqBO.setDealOperId(String.valueOf(reqBO.getUserId()));
        uocCoreBusiOperRecordReqBO.setDealOperName(reqBO.getUsername());
        uocCoreBusiOperRecordReqBO.setDealDeptId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealDeptName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealPostId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealPostName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealCode(reqBO.getActionCode());
        UocCoreBusiOperRecordRspBO busiOperRecord = this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(uocCoreBusiOperRecordReqBO);
        if (!"0000".equals(busiOperRecord.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + busiOperRecord.getRespDesc());
        }
    }

    private void sendMsg(PebDealOrderBO pebDealOrderBO) {
        UocCoreStateConfigRemindAtomReqBO reqBO = new UocCoreStateConfigRemindAtomReqBO();
        reqBO.setOrderId(pebDealOrderBO.getOrderId());
        this.uocCoreStateConfigRemindAtomService.dealStateConfigRemind(reqBO);
    }

    private void saveAdjustInfo(PebDealOrderBO pebDealOrderBO) {
        OrdSaleMtLogPO ordSaleMtLogPO = new OrdSaleMtLogPO();
        ordSaleMtLogPO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
        ordSaleMtLogPO.setOrderId(pebDealOrderBO.getOrderId());
        ordSaleMtLogPO = this.ordSaleMtLogMapper.getModelBy(ordSaleMtLogPO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
        salePO.setOrderId(pebDealOrderBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdSalePO updateSale = new OrdSalePO();
        updateSale.setOrderId(salePO.getOrderId());
        updateSale.setSaleVoucherId(salePO.getSaleVoucherId());
        updateSale.setSaleFee(ordSaleMtLogPO.getAdjustSaleFee());
        updateSale.setPurchaseFee(ordSaleMtLogPO.getAdjustPurchaseFee());
        this.ordSaleMapper.updateById(updateSale);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(pebDealOrderBO.getOrderId());
        ordPayPO.setTotalFee(ordSaleMtLogPO.getAdjustSaleFee());
        ordPayPO.setPayFee(ordSaleMtLogPO.getAdjustSaleFee());
        this.ordPayMapper.updateById(ordPayPO);
        this.updateItem(pebDealOrderBO);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(salePO.getOrderId());
        orderPO.setTotalSaleFee(ordSaleMtLogPO.getAdjustSaleFee());
        orderPO.setTotalPurchaseFee(ordSaleMtLogPO.getAdjustPurchaseFee());
        this.orderMapper.updateById(orderPO);
    }

    private void updateItem(PebDealOrderBO pebDealOrderBO) {
        OrdItemWtLogPO ordItemWtLogPO = new OrdItemWtLogPO();
        ordItemWtLogPO.setOrderId(pebDealOrderBO.getOrderId());
        List wtLogMapperList = this.ordItemWtLogMapper.getList(ordItemWtLogPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(pebDealOrderBO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        Map<Long, OrdItemPO> map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, itemPO -> itemPO));
        for (OrdItemWtLogPO wtLogPO : wtLogMapperList) {
            OrdItemPO itemPO2 = map.get(wtLogPO.getOrdItemId());
            if (itemPO2 == null) continue;
            OrdItemPO updateItem = new OrdItemPO();
            updateItem.setOrderId(itemPO2.getOrderId());
            updateItem.setOrdItemId(itemPO2.getOrdItemId());
            updateItem.setSalePrice(wtLogPO.getAdjustSalePrice());
            updateItem.setPurchasePrice(wtLogPO.getAdjustPurchasePrice());
            updateItem.setTotalSaleFee(wtLogPO.getAdjustTotalSaleFee());
            updateItem.setTotalPurchaseFee(wtLogPO.getAdjustTotalPurchaseFee());
            updateItem.setMarkUpRate(itemPO2.getMarkUpRate());
            this.ordItemMapper.updateById(updateItem);
            OrdPayItemPO payItemPO = new OrdPayItemPO();
            payItemPO.setTotalFee(wtLogPO.getAdjustTotalSaleFee());
            payItemPO.setOrderId(pebDealOrderBO.getOrderId());
            payItemPO.setSalePrice(wtLogPO.getAdjustSalePrice());
            payItemPO.setPurchasePrice(wtLogPO.getAdjustPurchasePrice());
            payItemPO.setOrdItemId(itemPO2.getOrdItemId());
            this.ordPayItemMapper.updateById(payItemPO);
        }
    }

    private void saveLog(PebDealOrderBO pebDealOrderBO, PebOrderApprovalReqBO reqBO) {
        UocCoreBusiOperRecordRspBO recordRspBO;
        UocCoreBusiOperRecordReqBO uocCoreBusiOperRecordReqBO = new UocCoreBusiOperRecordReqBO();
        uocCoreBusiOperRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        uocCoreBusiOperRecordReqBO.setOrderId(pebDealOrderBO.getOrderId());
        uocCoreBusiOperRecordReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
        uocCoreBusiOperRecordReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOperId())) {
            uocCoreBusiOperRecordReqBO.setDealOperId(reqBO.getOperId());
        } else {
            uocCoreBusiOperRecordReqBO.setDealOperId(String.valueOf(reqBO.getUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOperName())) {
            uocCoreBusiOperRecordReqBO.setDealOperName(reqBO.getOperName());
        } else {
            uocCoreBusiOperRecordReqBO.setDealOperName(reqBO.getUsername());
        }
        uocCoreBusiOperRecordReqBO.setCreateTime(new Date());
        uocCoreBusiOperRecordReqBO.setDealDeptId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealPostId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealDeptName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealPostName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealDesc(reqBO.getApprovalRemark());
        uocCoreBusiOperRecordReqBO.setDealCode(reqBO.getActionCode());
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(uocCoreBusiOperRecordReqBO.getDealCode());
        dictReqBO.setPcode("ACTION_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (dictRspBO != null && dictRspBO.getDicDictionarys() != null) {
            String describe = dictRspBO.getDicDictionarys().getDescrip();
            uocCoreBusiOperRecordReqBO.setDealName(describe);
            uocCoreBusiOperRecordReqBO.setDealTypeName(describe);
            uocCoreBusiOperRecordReqBO.setDealDesc(describe);
            uocCoreBusiOperRecordReqBO.setTaskId(describe);
            uocCoreBusiOperRecordReqBO.setTaskName(describe);
            if (StringUtils.isBlank((CharSequence)reqBO.getApprovalRemark())) {
                uocCoreBusiOperRecordReqBO.setDealDesc(describe);
            }
        }
        if (!(recordRspBO = this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(uocCoreBusiOperRecordReqBO)).getRespCode().equals("0000")) {
            throw new UocProBusinessException("102044", "\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private Boolean run(PebDealOrderBO pebDealOrderBO, Integer flag, PebOrderApprovalReqBO reqBO) {
        HashMap<String, Object> variables = new HashMap<String, Object>(1);
        if (reqBO.getActionCode().equals("ACTPEB007")) {
            UocOrdHistoryPO historyPO = new UocOrdHistoryPO();
            historyPO.setAuditTime(new Date());
            historyPO.setOrderId(pebDealOrderBO.getOrderId());
            this.uocOrdHistoryMapper.update(historyPO);
            OrdPayConfPO confPO = new OrdPayConfPO();
            confPO.setOrderId(pebDealOrderBO.getOrderId());
            confPO.setUserType(Integer.valueOf(1));
            List list = this.ordPayConfMapper.selectByCondition(confPO);
            variables.put("payFlag", "1");
            confPO = (OrdPayConfPO)list.get(0);
            if ("2".equals(confPO.getPayType().toString())) {
                variables.put("payFlag", "2");
                UocProShouldPayOrDeductDealAtomReqBo uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
                uocProShouldPayOrDeductDealAtomReqBo.setOrderId(pebDealOrderBO.getOrderId());
                uocProShouldPayOrDeductDealAtomReqBo.setObjId(pebDealOrderBO.getSaleVoucherId());
                uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                uocProShouldPayOrDeductDealAtomReqBo.setIsToBePaid(true);
                uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT);
                UocProShouldPayOrDeductDealAtomRspBo shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
                if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
                    throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
                }
            } else {
                UocProShouldPayOrDeductDealAtomReqBo uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
                uocProShouldPayOrDeductDealAtomReqBo.setOrderId(pebDealOrderBO.getOrderId());
                uocProShouldPayOrDeductDealAtomReqBo.setObjId(pebDealOrderBO.getSaleVoucherId());
                uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT_NOW);
                uocProShouldPayOrDeductDealAtomReqBo.setObjDate(this.orderMapper.getModelById(pebDealOrderBO.getOrderId().longValue()).getCreateTime());
                UocProShouldPayOrDeductDealAtomRspBo shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
                if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
                    throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
                }
            }
            pebDealOrderBO.setPushOrderId(pebDealOrderBO.getOrderId());
        } else if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
            if (reqBO.getActionCode().equals("ACTPEB008")) {
                variables.put("auditFlag", "2");
            } else {
                variables.put("auditFlag", flag);
            }
        } else {
            variables.put("auditFlag", flag);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(pebDealOrderBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (UocConstant.SALE_ORDER_STATUS.PAYING.equals(salePO.getSaleState())) {
            return false;
        }
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            return false;
        }
        UocProcessRunReqBO uocProcessStartReqBO = new UocProcessRunReqBO();
        uocProcessStartReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
        uocProcessStartReqBO.setOrderId(pebDealOrderBO.getOrderId());
        uocProcessStartReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        uocProcessStartReqBO.setOperId(reqBO.getOperId());
        uocProcessStartReqBO.setOperName(reqBO.getOperName());
        uocProcessStartReqBO.setVariables(variables);
        UocProcessRunRspBO uocProcessStartRspBO = this.uocRunProcessAtomService.start(uocProcessStartReqBO);
        if (!uocProcessStartRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException("100001", uocProcessStartRspBO.getRespDesc());
        }
        return uocProcessStartRspBO.getAuto();
    }

    private void reasonForBackFillCancellation(PebDealOrderBO pebDealOrderBO, PebOrderApprovalReqBO reqBO) {
        if (UocCoreConstant.AUDIT_RESULT.NOT_PASS.equals(reqBO.getAuditResult())) {
            if (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(pebDealOrderBO.getOrderSource())) {
                UocProcessRunReqBO uocProcessStartReqBO = new UocProcessRunReqBO();
                uocProcessStartReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
                uocProcessStartReqBO.setOrderId(pebDealOrderBO.getOrderId());
                uocProcessStartReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                uocProcessStartReqBO.setOperId(reqBO.getOperId());
                uocProcessStartReqBO.setOperName(reqBO.getOperName());
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("payFlag", "4");
                uocProcessStartReqBO.setVariables(variables);
                UocProcessRunRspBO uocProcessStartRspBO = this.uocRunProcessAtomService.start(uocProcessStartReqBO);
                if (!uocProcessStartRspBO.getRespCode().equals("0000")) {
                    throw new UocProBusinessException("100001", uocProcessStartRspBO.getRespDesc());
                }
            } else {
                UocPebOrderCancellationReqBO cancellationReqBO = new UocPebOrderCancellationReqBO();
                cancellationReqBO.setUserId(reqBO.getUserId());
                cancellationReqBO.setUsername(reqBO.getUsername());
                cancellationReqBO.setDealName(reqBO.getOperName());
                cancellationReqBO.setDealCode(reqBO.getActionCode());
                cancellationReqBO.setCancelDesc("\u8ba2\u5355\u5ba1\u6279\u9a73\u56de");
                cancellationReqBO.setCancelReson("\u8ba2\u5355\u5ba1\u6279\u9a73\u56de");
                cancellationReqBO.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
                cancellationReqBO.setOrderId(pebDealOrderBO.getOrderId());
                if (reqBO.getUserId() != null) {
                    cancellationReqBO.setCancelOperId(reqBO.getUserId().toString());
                } else {
                    cancellationReqBO.setCancelOperId(reqBO.getOperId());
                }
                cancellationReqBO.setIsVal(false);
                UocPebOrderCancellationRspBO rspBO = this.uocPebOrderCancellationBusiService.dealPebOrderCancellation(cancellationReqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    throw new UocProBusinessException("102044", rspBO.getRespDesc());
                }
            }
            OrdSalePO ordSalePo = new OrdSalePO();
            ordSalePo.setOrderId(pebDealOrderBO.getOrderId());
            ordSalePo.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
            ordSalePo.setExt3("\u5ba1\u6279\u62d2\u7edd");
            this.ordSaleMapper.updateById(ordSalePo);
        } else {
            OrdSalePO ordSalePo = new OrdSalePO();
            ordSalePo.setOrderId(pebDealOrderBO.getOrderId());
            ordSalePo.setSaleVoucherId(pebDealOrderBO.getSaleVoucherId());
            ordSalePo.setExt3("\u5ba1\u6279\u901a\u8fc7");
            this.ordSaleMapper.updateById(ordSalePo);
        }
    }
}

