/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.DicDictionaryBO;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.PebAccessoryReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebProcessOrderCountBO;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreBusiOperRecordAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.api.UocCoreOrderShipAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderDetailAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderItemListAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.ShipCruxFieldBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOryOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderDetailRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderItemListRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipItemReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.PebOrderDeliveryBusiService;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebOrderDeliveryBusiServiceImpl
implements PebOrderDeliveryBusiService {
    private static final Integer PURCHASE_TYPE_MATERIAL = 1;
    private static final Integer ORDER_METHOD_UNIT_PRICE = 1;
    private static final Integer ORDER_METHOD_TOTAL_PRICE = 2;
    private static final Integer ORDER_METHOD_FRAME = 3;
    private static final String DIC_QRY_KEY = "unit_order_ship_limit";
    private static final String DIC_QRY_PCODE = "UNIT_ORDER_SHIP_LIMIT";
    @Autowired
    private UocCoreQryOrderDetailAtomService uocCoreQryOrerDetailAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocCoreQryOrderItemListAtomService uocCoreQryOrderItemListAtomService;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreOrderShipAtomService uocCoreOrderShipAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public PebOrderDeliveryAbilityRspBO dealPebOrderDelivery(PebOrderDeliveryAbilityReqBO reqBO) {
        DateTime beginDate;
        List pebProcessOrderCountBOList;
        this.validateArg(reqBO);
        if (StringUtils.isBlank((CharSequence)reqBO.getActionCode())) {
            reqBO.setActionCode("ACTPEB005");
        }
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = new PebOrderDeliveryAbilityRspBO();
        UocCoreOryOrderReqBO uocCoreOryOrderReqBO = new UocCoreOryOrderReqBO();
        uocCoreOryOrderReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOryOrderReqBO.setOrderId(reqBO.getOrderId());
        UocCoreQryOrderDetailRspBO uocCoreQryOrderDetailRspBO = this.uocCoreQryOrerDetailAtomService.qryCoreQryOrderDetail(uocCoreOryOrderReqBO);
        if (!"0000".equals(uocCoreQryOrderDetailRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreQryOrderDetailRspBO.getRespDesc());
        }
        if (uocCoreQryOrderDetailRspBO.getOrderRspBO() == null || uocCoreQryOrderDetailRspBO.getOrdSaleRspBO() == null) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:\u6ca1\u6709\u67e5\u8be2\u5230\u76f8\u5173\u5355\u636e!");
        }
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        uocCoreStateCheckAtomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getSaleVoucherId());
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
        OrdSaleRspBO ordSaleRspBO = uocCoreQryOrderDetailRspBO.getOrdSaleRspBO();
        UocCoreOryOrderReqBO uocCoreOryOrderItemReqBO = new UocCoreOryOrderReqBO();
        uocCoreOryOrderItemReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOryOrderItemReqBO.setPageNo(1);
        uocCoreOryOrderItemReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOryOrderItemReqBO.setPageSize(200);
        UocCoreQryOrderItemListRspBO uocCoreQryOrderItemListRspBO = this.uocCoreQryOrderItemListAtomService.qryCoreQryOrderItemList(uocCoreOryOrderItemReqBO);
        if (!"0000".equals(uocCoreQryOrderItemListRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreQryOrderItemListRspBO.getRespDesc());
        }
        List rows = uocCoreQryOrderItemListRspBO.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            throw new UocProBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:\u6ca1\u6709\u67e5\u8be2\u5230\u660e\u7ec6\u4fe1\u606f!");
        }
        DicDictionaryBO codeByVal = this.dicDictionaryService.getCodeByVal(DIC_QRY_KEY, DIC_QRY_PCODE);
        int multiple = 1;
        if (codeByVal != null) {
            multiple = Integer.parseInt(codeByVal.getDescrip());
        }
        if (!CollectionUtils.isEmpty((Collection)(pebProcessOrderCountBOList = reqBO.getPebProcessOrderCountBOList()))) {
            for (PebProcessOrderCountBO pebProcessOrderCountBO : pebProcessOrderCountBOList) {
                for (OrdItemRspBO ordItemRspBO : rows) {
                    BigDecimal newSendCount;
                    if (!ordItemRspBO.getOrdItemId().equals(pebProcessOrderCountBO.getOrdItemId())) continue;
                    pebProcessOrderCountBO.setUnitName(ordItemRspBO.getUnitName());
                    BigDecimal purchaseCount = ordItemRspBO.getPurchaseCount();
                    BigDecimal sendCount = ordItemRspBO.getSendCount();
                    if (sendCount == null) {
                        sendCount = new BigDecimal(0);
                    }
                    if ((newSendCount = sendCount.add(pebProcessOrderCountBO.getProcessCount())).compareTo(purchaseCount) > 0) {
                        BigDecimal modVal = newSendCount.remainder(purchaseCount).setScale(0, 4);
                        if (newSendCount.multiply(new BigDecimal(multiple)).compareTo(purchaseCount) > 0) {
                            throw new UocProBusinessException("100001", "\u53d1\u8d27\u91cf\u4e0d\u80fd\u5927\u4e8e\u672a\u53d1\u8d27\u91cf");
                        }
                    }
                    ordItemRspBO.setSendCount(newSendCount);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getActionCode()) && !PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO pebOperationPermissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            pebOperationPermissionsCheckingAtomReqBO.setActionCode(reqBO.getActionCode());
            pebOperationPermissionsCheckingAtomReqBO.setAuthCtrl(reqBO.getAuthCtrl());
            pebOperationPermissionsCheckingAtomReqBO.setOrderId(reqBO.getOrderId());
            pebOperationPermissionsCheckingAtomReqBO.setStationId(reqBO.getStationId());
            pebOperationPermissionsCheckingAtomReqBO.setMemId(reqBO.getMemId());
            pebOperationPermissionsCheckingAtomReqBO.setMemId(reqBO.getMemIdIn());
            PebOperationPermissionsCheckingAtomRspBO pebOperationPermissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(pebOperationPermissionsCheckingAtomReqBO);
            if (!"0000".equals(pebOperationPermissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u6743\u9650\u6821\u9a8c\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + pebOperationPermissionsCheckingAtomRspBO.getRespDesc());
            }
        }
        UocCoreOrderShipReqBO uocCoreOrderShipReqBO = new UocCoreOrderShipReqBO();
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setShipStatus("1201");
        uocCoreOrderShipReqBO.setIsStartProcess(true);
        uocCoreOrderShipReqBO.setPackageId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setExtOrderId(reqBO.getExtOrderId());
        uocCoreOrderShipReqBO.setShipName(reqBO.getProcessName());
        uocCoreOrderShipReqBO.setShipPhone(reqBO.getProcessPhone());
        uocCoreOrderShipReqBO.setSubmit(reqBO.getSubmit());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDeliveryTime())) {
            beginDate = DateTime.parse((String)reqBO.getDeliveryTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setShipTime(beginDate.toDate());
        } else {
            uocCoreOrderShipReqBO.setShipTime(new Date());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEstimatedArrivalTime())) {
            beginDate = DateTime.parse((String)reqBO.getEstimatedArrivalTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setEstimateArrivalTime(beginDate.toDate());
        }
        uocCoreOrderShipReqBO.setShipId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipCompanyId(reqBO.getTransportMode());
        uocCoreOrderShipReqBO.setShipCompanyName(reqBO.getLogisticsExecutionUnit());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShipOrderNo())) {
            uocCoreOrderShipReqBO.setShipVoucherCode(reqBO.getShipOrderNo());
        } else {
            uocCoreOrderShipReqBO.setShipVoucherCode(this.buildNo(uocCoreQryOrderDetailRspBO.getOrdPurchaseRspBO().getPurchaseVoucherNo(), "FHD", "ORDER_SHIP_NO", uocCoreQryOrderDetailRspBO.getOrdSaleRspBO().getOrderSource()));
        }
        if (reqBO.getProcessDate() == null) {
            reqBO.setProcessDate(DateUtils.dateToStrLong((Date)new Date()));
        }
        ArrayList<ShipCruxFieldBO> shipCruxFieldBOList = new ArrayList<ShipCruxFieldBO>();
        ShipCruxFieldBO shipCruxFieldBO = new ShipCruxFieldBO();
        shipCruxFieldBO.setFieldCode("processDate");
        shipCruxFieldBO.setFieldName("\u65bd\u5de5\u3001\u670d\u52a1\u5904\u7406\u65f6\u95f4");
        shipCruxFieldBO.setFieldValue(reqBO.getProcessDate());
        shipCruxFieldBOList.add(shipCruxFieldBO);
        uocCoreOrderShipReqBO.setCruxFieldList(shipCruxFieldBOList);
        if (!CollectionUtils.isEmpty((Collection)pebProcessOrderCountBOList)) {
            ArrayList<UocCoreShipItemReqBO> uocCoreShipItemReqBOList = new ArrayList<UocCoreShipItemReqBO>();
            for (Object pebProcessOrderCountBO : pebProcessOrderCountBOList) {
                if (pebProcessOrderCountBO.getProcessCount().compareTo(BigDecimal.ZERO) == 0) continue;
                UocCoreShipItemReqBO uocCoreShipItemReqBO = new UocCoreShipItemReqBO();
                uocCoreShipItemReqBO.setOrdItemId(pebProcessOrderCountBO.getOrdItemId());
                uocCoreShipItemReqBO.setSendCount(pebProcessOrderCountBO.getProcessCount());
                uocCoreShipItemReqBO.setOrderId(reqBO.getOrderId());
                uocCoreShipItemReqBO.setUnitName(pebProcessOrderCountBO.getUnitName());
                uocCoreShipItemReqBOList.add(uocCoreShipItemReqBO);
            }
            if (CollectionUtils.isEmpty(uocCoreShipItemReqBOList)) {
                throw new UocProBusinessException("102033", "\u4e0d\u80fd\u6240\u6709\u5546\u54c1\u53d1\u8d27\u6570\u91cf\u90fd\u4e3a0");
            }
            uocCoreOrderShipReqBO.setShipItemList(uocCoreShipItemReqBOList);
        }
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setIsStartProcess(true);
        uocCoreOrderShipReqBO.setProcKey("peb_el_ship_order_order_status");
        UocCoreOrderShipRspBO uocCoreOrderShipRspBO = this.uocCoreOrderShipAtomService.dealCoreOrderShip(uocCoreOrderShipReqBO);
        if (!"0000".equals(uocCoreOrderShipRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u751f\u6210\u53d1\u8d27,\u53d1\u8d27\u660e\u7ec6\u4fe1\u606f\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreOrderShipRspBO.getRespDesc());
        }
        pebOrderDeliveryAbilityRspBO.setShipVoucherId(uocCoreOrderShipRspBO.getShipVoucherId());
        boolean isAll = true;
        for (OrdItemRspBO ordItemRspBO : rows) {
            if (ordItemRspBO.getSendCount().compareTo(ordItemRspBO.getPurchaseCount()) >= 0) continue;
            isAll = false;
        }
        OrdSalePO ordSalePo = new OrdSalePO();
        ordSalePo.setOrderId(reqBO.getOrderId());
        ordSalePo = this.ordSaleMapper.getModelBy(ordSalePo);
        Boolean auto = false;
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(ordSalePo.getSaleState())) {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setObjId(reqBO.getSaleVoucherId());
            processRunReqBO.setOrderId(reqBO.getOrderId());
            processRunReqBO.setOperId(reqBO.getMemIdIn() + "");
            processRunReqBO.setOperId(reqBO.getMemId() + "");
            processRunReqBO.setOperName(reqBO.getUsername());
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("cancelFlag", 0);
            processRunReqBO.setVariables(param);
            UocProcessRunRspBO start = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(start.getRespCode())) {
                throw new UocProBusinessException("100001", "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + start.getRespDesc());
            }
            auto = start.getAuto();
        }
        this.saveFile(uocCoreOrderShipRspBO.getShipVoucherId(), reqBO);
        pebOrderDeliveryAbilityRspBO.setIsSuccess(Boolean.valueOf(true));
        pebOrderDeliveryAbilityRspBO.setRespCode("0000");
        pebOrderDeliveryAbilityRspBO.setRespDesc("\u6210\u529f");
        pebOrderDeliveryAbilityRspBO.setAuto(auto);
        return pebOrderDeliveryAbilityRspBO;
    }

    private void saveFile(Long shipId, PebOrderDeliveryAbilityReqBO reqBO) {
        List pebAccessoryReqBOList = reqBO.getPebAccessoryReqBOList();
        if (!CollectionUtils.isEmpty((Collection)pebAccessoryReqBOList)) {
            for (PebAccessoryReqBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setObjectType(UocConstant.OBJ_TYPE.SHIP);
                uocCoreCreateAccessoryReqBO.setObjectId(shipId);
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("100001", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
    }

    @Override
    public PebOrderDeliveryAbilityRspBO dealUpdateDelivery(PebOrderDeliveryAbilityReqBO reqBO) {
        DateTime beginDate;
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = new PebOrderDeliveryAbilityRspBO();
        pebOrderDeliveryAbilityRspBO.setIsSuccess(Boolean.valueOf(true));
        pebOrderDeliveryAbilityRspBO.setRespCode("0000");
        pebOrderDeliveryAbilityRspBO.setRespDesc("\u6210\u529f");
        pebOrderDeliveryAbilityRspBO.setShipVoucherId(reqBO.getShipVoucherId());
        if (PebExtConstant.YES.toString().equals(reqBO.getIsDelete())) {
            OrdShipPO shipPO = new OrdShipPO();
            return pebOrderDeliveryAbilityRspBO;
        }
        OrdShipPO uocCoreOrderShipReqBO = new OrdShipPO();
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setPackageId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setExtOrderId(reqBO.getExtOrderId());
        uocCoreOrderShipReqBO.setShipName(reqBO.getProcessName());
        uocCoreOrderShipReqBO.setShipPhone(reqBO.getProcessPhone());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDeliveryTime())) {
            beginDate = DateTime.parse((String)reqBO.getDeliveryTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setShipTime(beginDate.toDate());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEstimatedArrivalTime())) {
            beginDate = DateTime.parse((String)reqBO.getEstimatedArrivalTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            uocCoreOrderShipReqBO.setEstimateArrivalTime(beginDate.toDate());
        }
        uocCoreOrderShipReqBO.setShipId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipCompanyId(reqBO.getTransportMode());
        uocCoreOrderShipReqBO.setShipCompanyName(reqBO.getLogisticsExecutionUnit());
        uocCoreOrderShipReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        this.ordShipMapper.updateById(uocCoreOrderShipReqBO);
        if (reqBO.getProcessDate() == null) {
            reqBO.setProcessDate(DateUtils.dateToStrLong((Date)new Date()));
        }
        if (PebExtConstant.YES.toString().equals(reqBO.getSubmit())) {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
            processRunReqBO.setObjId(reqBO.getShipVoucherId());
            processRunReqBO.setOrderId(reqBO.getOrderId());
            processRunReqBO.setOperId(reqBO.getMemIdIn() + "");
            processRunReqBO.setOperId(reqBO.getMemId() + "");
            processRunReqBO.setOperName(reqBO.getUsername());
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("submit", 1);
            processRunReqBO.setVariables(param);
            UocProcessRunRspBO start = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(start.getRespCode())) {
                throw new UocProBusinessException("100001", "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + start.getRespDesc());
            }
        }
        OrdShipItemPO itemPO = new OrdShipItemPO();
        itemPO.setShipVoucherId(reqBO.getShipVoucherId());
        List list = this.ordShipItemMapper.getList(itemPO);
        Map<Long, OrdShipItemPO> map = list.stream().collect(Collectors.toMap(OrdShipItemPO::getShipItemId, i -> i));
        for (PebProcessOrderCountBO countBO : reqBO.getPebProcessOrderCountBOList()) {
            OrdShipItemPO shipItemPO = map.get(countBO.getShipItemId());
            BigDecimal num = countBO.getProcessCount().subtract(shipItemPO.getSendCount());
            if (countBO.getProcessCount().compareTo(BigDecimal.ZERO) == 0) {
                this.ordShipItemMapper.deleteById(shipItemPO.getShipItemId().longValue());
            } else {
                OrdShipItemPO update = new OrdShipItemPO();
                update.setShipItemId(shipItemPO.getShipItemId());
                update.setSendCount(num);
                update.setOrderId(reqBO.getOrderId());
                this.ordShipItemMapper.updateCounts(update);
            }
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setSendCount(num);
            ordItemPO.setOrdItemId(shipItemPO.getOrdItemId());
            ordItemPO.setOrderId(reqBO.getOrderId());
            this.ordItemMapper.updateCounts(ordItemPO);
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List ordItemPOS = this.ordItemMapper.getList(ordItemPO);
        for (OrdItemPO po : ordItemPOS) {
            if (po.getPurchaseCount().compareTo(po.getSendCount()) >= 0) continue;
            throw new UocProBusinessException("104025", po.getSkuName() + "\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u91c7\u8d2d\u6570\u91cf\uff0c\u8bf7\u8c03\u6574\u518d\u63d0\u4ea4");
        }
        this.saveFile(reqBO.getShipVoucherId(), reqBO);
        return pebOrderDeliveryAbilityRspBO;
    }

    private void validateArg(PebOrderDeliveryAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSaleVoucherId())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPebProcessOrderCountBOList())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PebProcessOrderCountBO proBo : reqBO.getPebProcessOrderCountBOList()) {
            if (ObjectUtil.isEmpty((Object)proBo)) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)proBo.getOrdItemId())) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)proBo.getProcessCount())) {
                throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[processCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (proBo.getProcessCount().compareTo(BigDecimal.ZERO) > 0) continue;
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e2d\u5bf9\u8c61\u5c5e\u6027[processCount]\u5fc5\u987b\u5927\u4e8e0");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessName())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessPhone())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processPhone]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProcessNum())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDeliveryTime())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[deliveryTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getEstimatedArrivalTime())) {
            throw new UocProBusinessException("102033", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[estimatedArrivalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildNo(String saleVoucherNo, String start, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102033", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.buildNo(saleVoucherNo, start);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String buildNo(String saleVoucherNo, String start) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        return saleVoucherNo + "-" + start + "-" + date + time.substring(time.length() - 3);
    }

    @Override
    public PebOrderDeliveryAbilityRspBO dealPurDelivery(PebOrderDeliveryAbilityReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        Map<Long, OrdItemPO> map = list.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, i -> i));
        OrdShipPO uocCoreOrderShipReqBO = new OrdShipPO();
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setShipStatus("2203");
        uocCoreOrderShipReqBO.setShipTime(new Date());
        uocCoreOrderShipReqBO.setShipId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipVoucherCode(this.buildNo(salePO.getSaleVoucherNo(), "FHD", "ORDER_SHIP_NO", salePO.getOrderSource()));
        if (reqBO.getProcessDate() == null) {
            reqBO.setProcessDate(DateUtils.dateToStrLong((Date)new Date()));
        }
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setShipTime(new Date());
        uocCoreOrderShipReqBO.setArriveTime(new Date());
        uocCoreOrderShipReqBO.setShipVoucherId(Long.valueOf(this.idUtil.nextId()));
        uocCoreOrderShipReqBO.setReceiverContact(reqBO.getReceiverContact());
        uocCoreOrderShipReqBO.setReceiverRemark(reqBO.getRemark());
        uocCoreOrderShipReqBO.setReceiverTime(new Date());
        uocCoreOrderShipReqBO.setReceiverUser(reqBO.getConsignee());
        uocCoreOrderShipReqBO.setReceiverNo(reqBO.getUsername());
        uocCoreOrderShipReqBO.setArriveTime(new Date());
        this.startProcess(uocCoreOrderShipReqBO.getOrderId(), uocCoreOrderShipReqBO.getShipVoucherId(), "peb_el_ship_order_order_status", "3");
        this.ordShipMapper.insert(uocCoreOrderShipReqBO);
        ArrayList<OrdShipItemPO> insert = new ArrayList<OrdShipItemPO>();
        for (PebProcessOrderCountBO countBO : reqBO.getPebProcessOrderCountBOList()) {
            OrdItemPO po = map.get(countBO.getOrdItemId());
            if (countBO.getProcessCount().compareTo(po.getPurchaseCount().subtract(po.getSendCount())) > 0) {
                throw new UocProBusinessException("102033", po.getSkuName() + "\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u4ee5\u53d1\u8d27\u6570\u91cf");
            }
            OrdShipItemPO shipItemPO = new OrdShipItemPO();
            shipItemPO.setShipVoucherId(uocCoreOrderShipReqBO.getShipVoucherId());
            shipItemPO.setOrdItemId(po.getOrdItemId());
            shipItemPO.setSendCount(countBO.getProcessCount());
            shipItemPO.setArriveCount(countBO.getProcessCount());
            shipItemPO.setOrderId(reqBO.getOrderId());
            shipItemPO.setUnitName(po.getUnitName());
            shipItemPO.setShipItemId(Long.valueOf(this.idUtil.nextId()));
            shipItemPO.setReturnCount(BigDecimal.ZERO);
            shipItemPO.setRefuseCount(BigDecimal.ZERO);
            insert.add(shipItemPO);
            OrdItemPO update = new OrdItemPO();
            update.setOrderId(reqBO.getOrderId());
            update.setOrdItemId(po.getOrdItemId());
            update.setSendCount(countBO.getProcessCount());
            update.setArriveCount(countBO.getProcessCount());
            this.ordItemMapper.updateCounts(update);
        }
        this.ordShipItemMapper.insertBatch(insert);
        reqBO.setActionCode("ACTPEB0027");
        this.saveFile(uocCoreOrderShipReqBO.getShipVoucherId(), reqBO);
        PebOrderDeliveryAbilityRspBO pebOrderDeliveryAbilityRspBO = new PebOrderDeliveryAbilityRspBO();
        pebOrderDeliveryAbilityRspBO.setIsSuccess(Boolean.valueOf(true));
        pebOrderDeliveryAbilityRspBO.setRespCode("0000");
        pebOrderDeliveryAbilityRspBO.setShipVoucherId(uocCoreOrderShipReqBO.getShipVoucherId());
        pebOrderDeliveryAbilityRspBO.setRespDesc("\u6210\u529f");
        return pebOrderDeliveryAbilityRspBO;
    }

    private void startProcess(Long objId, Long orderId, String procKey, String submit) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setProcDefKey(procKey);
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
        processStartReqBO.setOrderId(orderId);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("submit", submit);
        processStartReqBO.setVariables(map);
        UocProcessStartRspBO processStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(processStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101059", "\u901a\u8fc7\u5165\u53c2\uff1a" + processStartReqBO.toString() + "\u542f\u52a8\u72b6\u6001\u673a\u5931\u8d25\u539f\u56e0\uff1a" + processStartRspBO.getRespDesc());
        }
    }
}

