/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.contract.ability.ContractPlanOrderAbilityService;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityReqBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityRspBo;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.plan.InterFaceContractUpdateOrderItemAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemAtomReqBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemAtomRspBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemBO;
import com.tydic.uoc.common.busi.api.PebUpdateOrderBusiService;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrdZmItemMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrdZmItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebUpdateOrderBusiServiceImpl
implements PebUpdateOrderBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private UocOrdGoodsTempMapper uocOrdGoodsTempMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private UocOrdZmItemMapper uocOrdZmItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private InterFaceContractUpdateOrderItemAtomService interFaceContractUpdateOrderItemAtomService;
    @Autowired
    private ContractPlanOrderAbilityService contractPlanOrderAbilityService;

    @Override
    public PebUpdateOrderRspBO updateOrder(PebUpdateOrderReqBO reqBO) {
        if (reqBO.getZmInfoBO() != null) {
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            BeanUtils.copyProperties((Object)reqBO.getZmInfoBO(), (Object)zmInfoPO);
            this.uocOrdZmInfoMapper.update(zmInfoPO);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdSalePO update = new OrdSalePO();
        update.setSaleVoucherId(salePO.getSaleVoucherId());
        update.setOrderId(reqBO.getOrderId());
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setUpdateOperId(reqBO.getUserId().toString());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExt4())) {
            orderPO.setExt4(reqBO.getExt4());
        }
        orderPO.setOrderName(reqBO.getOrderName());
        if (reqBO.getAddressInfo() != null) {
            this.updateAddr(reqBO.getAddressInfo(), salePO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getGiveTime())) {
            update.setGiveTime(reqBO.getGiveTime());
        }
        Long orderId = reqBO.getOrderId();
        this.updateExt("purUserNo", "\u91c7\u8d2d\u5458\u7f16\u7801", reqBO.getPurUserNo(), orderId);
        this.updateExt("purUserName", "\u91c7\u8d2d\u5458\u540d\u79f0", reqBO.getPurUserName(), orderId);
        this.updateExt("erpAgrNo", "\u91c7\u8d2d\u534f\u8bae\u7f16\u7801", reqBO.getErpAgrNo(), orderId);
        this.updateExt("erpAgrName", "\u91c7\u8d2d\u534f\u8bae\u540d\u79f0", reqBO.getErpAgrName(), orderId);
        this.updateExt("erpAgrId", "\u91c7\u8d2d\u534f\u8baeid", reqBO.getErpAgrId(), orderId);
        this.updateExt("adjustType", "\u8c03\u4ef7\u65b9\u5f0f", reqBO.getAdjustType(), orderId);
        this.saveItem(update, orderPO, reqBO);
        this.saveAccessory(reqBO, orderId);
        if (PebExtConstant.YES.toString().equals(reqBO.getSubmit())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("submit", "1");
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(salePO.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(salePO.getOrderId());
            processRunReqBO.setOperId("1");
            processRunReqBO.setVariables(map);
            UocProcessRunRspBO rspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new UocProBusinessException("8888", rspBO.getRespDesc());
            }
            this.audit(salePO);
        }
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void audit(OrdSalePO saleRspBO) {
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO;
        Long orderId = saleRspBO.getOrderId();
        OrdStakeholderPO stakeholderPo = this.ordStakeholderMapper.getModelById(orderId.longValue());
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(stakeholderPo.getPurPlaceOrderId());
        noTaskAuditCreateReqBO.setCreateOperName(stakeholderPo.getPurPlaceOrderName());
        noTaskAuditCreateReqBO.setCreateOperDept(stakeholderPo.getPurName());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setCreateOperId(stakeholderPo.getPurPlaceOrderId());
        infoReqBO.setUsername(stakeholderPo.getPurPlaceOrderName());
        infoReqBO.setRemark("\u521b\u5efa\u4f9b\u5e94\u5546\u63a5\u5355\u5ba1\u6279");
        infoReqBO.setOrderId(orderId);
        infoReqBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
        Long saleId = saleRspBO.getSaleVoucherId();
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
        approvalObjBO.setObjId(String.valueOf(saleId));
        ArrayList<ApprovalObjBO> objBoS = new ArrayList<ApprovalObjBO>(1);
        objBoS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBoS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBoS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBoS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBoS);
        noTaskAuditCreateReqBO.setOrgId(stakeholderPo.getPurOrgId());
        noTaskAuditCreateReqBO.setOrgTreeId(stakeholderPo.getPurOrgPath());
        noTaskAuditCreateReqBO.setMenuId("M001103");
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(saleRspBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(saleRspBO.getOrderId());
        salePO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(salePO);
        if (zmInfoPO != null) {
            if (StringUtils.isNotBlank((CharSequence)zmInfoPO.getExt1())) {
                noTaskAuditCreateReqBO.setProcDefKey(zmInfoPO.getExt1());
            }
            HashMap<String, Object> ows = new HashMap<String, Object>();
            ows.put("jhwzlb", ElUtils.getMaterialCategory(zmInfoPO.getMaterialCategory()));
            try {
                ows.put("ysje", MoneyUtils.Long2BigDecimal((Long)ordSalePO.getSaleFee()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            noTaskAuditCreateReqBO.setVariables(ows);
        }
        if (!"0000".equals((uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO)).getRespCode())) {
            throw new UocProBusinessException("8888", "\u521b\u5efa\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new UocProBusinessException("8888", "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ba1\u6279\u6d41\u7a0b");
        }
        OrdSalePO ordSalePo = new OrdSalePO();
        ordSalePo.setOrderId(orderId);
        ordSalePo.setSaleVoucherId(saleId);
        ordSalePo.setTbOrderId(uacNoTaskAuditCreateRspBO.getStepId());
        ordSalePo.setExt3("\u5ba1\u6279\u4e2d");
        this.ordSaleMapper.updateById(ordSalePo);
    }

    private void saveItem(OrdSalePO salePO, OrderPO orderPO, PebUpdateOrderReqBO reqBO) {
        UocOrdGoodsTempPO tempPO = new UocOrdGoodsTempPO();
        tempPO.setOrderId(salePO.getOrderId());
        List list = this.uocOrdGoodsTempMapper.selectByCondition(tempPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(salePO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        Map<Long, OrdItemPO> map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getTempId, i -> i));
        Long saleFee = 0L;
        OrdExtMapPO createType = new OrdExtMapPO();
        createType.setOrderId(salePO.getOrderId());
        createType.setFieldCode("createType");
        createType = this.ordExtMapMapper.getModelBy(createType);
        boolean pushFz = false;
        boolean pushHt = true;
        if (createType != null) {
            if ("4".equals(createType.getFieldValue()) || "3".equals(createType.getFieldValue())) {
                pushFz = true;
                pushHt = false;
            }
            if ("2".equals(createType.getFieldValue())) {
                pushHt = false;
            }
        }
        ArrayList<InterFaceContractUpdateOrderItemBO> operOrderItem = new ArrayList<InterFaceContractUpdateOrderItemBO>();
        ArrayList<ContractPlanOrderAbilityBo> planOrderReqBo = new ArrayList<ContractPlanOrderAbilityBo>();
        for (UocOrdGoodsTempPO goodsTempPO : list) {
            OrdPayItemPO payItemPO = new OrdPayItemPO();
            OrdItemPO itemPO = new OrdItemPO();
            OrdItemPO qry = map.get(goodsTempPO.getTempId());
            if (pushFz) {
                InterFaceContractUpdateOrderItemBO updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                updateOrderItemBO.setGoodTypeId(goodsTempPO.getOutObjItemId());
                updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                BigDecimal count = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                if (count.compareTo(BigDecimal.ZERO) > 0) {
                    updateOrderItemBO.setOperateType(0);
                    updateOrderItemBO.setOrderNum(count);
                    operOrderItem.add(updateOrderItemBO);
                } else if (count.compareTo(BigDecimal.ZERO) < 0) {
                    updateOrderItemBO.setOperateType(1);
                    updateOrderItemBO.setOrderNum(count.negate());
                    operOrderItem.add(updateOrderItemBO);
                }
            }
            if (pushHt) {
                BigDecimal count = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                abilityBo.setItemId(goodsTempPO.getHtItemId());
                abilityBo.setNum(count.negate());
                if (count.compareTo(BigDecimal.ZERO) > 0) {
                    planOrderReqBo.add(abilityBo);
                } else if (count.compareTo(BigDecimal.ZERO) < 0) {
                    planOrderReqBo.add(abilityBo);
                }
            }
            itemPO.setOrdItemId(qry.getOrdItemId());
            itemPO.setOrderId(salePO.getOrderId());
            itemPO.setTempId(goodsTempPO.getTempId());
            itemPO.setTempId(goodsTempPO.getTempId());
            itemPO.setPurchaseCount(goodsTempPO.getPurchaseCount());
            try {
                itemPO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getSalePrice()));
                itemPO.setPurchasePrice(itemPO.getSalePrice());
                itemPO.setTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getTotalSalePrice()));
                saleFee = saleFee + itemPO.getTotalSaleFee();
                itemPO.setTotalPurchaseFee(itemPO.getTotalSaleFee());
                itemPO.setNakedPrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getTotalNakePrice()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            itemPO.setOrganizationId(goodsTempPO.getOrganizationId());
            itemPO.setOrganizationName(goodsTempPO.getOrganizationName());
            itemPO.setArrivalTime(goodsTempPO.getArrivalTime());
            this.ordItemMapper.updateById(itemPO);
            payItemPO.setPayCount(itemPO.getPurchaseCount());
            payItemPO.setPayFee(itemPO.getSalePrice());
            payItemPO.setTotalFee(itemPO.getTotalSaleFee());
            payItemPO.setOrderId(itemPO.getOrderId());
            payItemPO.setOrdItemId(itemPO.getOrdItemId());
            this.ordPayItemMapper.updateById(payItemPO);
            UocOrdZmItemPO zmItemPO = new UocOrdZmItemPO();
            BeanUtils.copyProperties((Object)goodsTempPO, (Object)zmItemPO);
            zmItemPO.setOrdItemId(itemPO.getOrdItemId());
            this.uocOrdZmItemMapper.update(zmItemPO);
            OrdGoodsPO goodsPO = new OrdGoodsPO();
            goodsPO.setSkuMaterialRemark(goodsTempPO.getSkuMaterialRemark());
            goodsPO.setOrdItemId(itemPO.getOrdItemId());
            this.ordGoodsMapper.updateByItem(goodsPO);
            goodsTempPO.setPurchaseCount(itemPO.getPurchaseCount().subtract(qry.getPurchaseCount()));
        }
        salePO.setSaleFee(saleFee);
        salePO.setPurchaseFee(saleFee);
        this.ordSaleMapper.updateById(salePO);
        orderPO.setTotalSaleFee(saleFee);
        orderPO.setTotalPurchaseFee(saleFee);
        this.orderMapper.updateById(orderPO);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(salePO.getOrderId());
        ordPayPO.setPayFee(saleFee);
        this.ordPayMapper.updateById(ordPayPO);
        if (operOrderItem.size() > 0) {
            InterFaceContractUpdateOrderItemAtomReqBO interFaceContractUpdateOrderItemAtomReqBO = new InterFaceContractUpdateOrderItemAtomReqBO();
            interFaceContractUpdateOrderItemAtomReqBO.setToken(reqBO.getToken());
            interFaceContractUpdateOrderItemAtomReqBO.setOrderItem(operOrderItem);
            InterFaceContractUpdateOrderItemAtomRspBO interFaceContractUpdateOrderItemAtomRspBO = this.interFaceContractUpdateOrderItemAtomService.updateSchemeOrderItemStatus(interFaceContractUpdateOrderItemAtomReqBO);
            if (!"0000".equals(interFaceContractUpdateOrderItemAtomRspBO.getRespCode())) {
                throw new UocProBusinessException(interFaceContractUpdateOrderItemAtomRspBO.getRespCode(), "\u4fee\u6539\u65b9\u6848\u660e\u7ec6\u62a5\u9519\uff1a" + interFaceContractUpdateOrderItemAtomRspBO.getRespDesc());
            }
        }
        if (planOrderReqBo.size() > 0) {
            ContractPlanOrderAbilityReqBo reqBo = new ContractPlanOrderAbilityReqBo();
            reqBo.setPlanOrderReqBo(planOrderReqBo);
            ContractPlanOrderAbilityRspBo abilityRspBo = this.contractPlanOrderAbilityService.dealContractOrder(reqBo);
            if (!"0000".equals(abilityRspBo.getRespCode())) {
                throw new UocProBusinessException(abilityRspBo.getRespCode(), "\u5408\u540c\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a" + abilityRspBo.getRespDesc());
            }
        }
    }

    private void saveAccessory(PebUpdateOrderReqBO reqBO, Long orderId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("CREATE_ORDER");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void updateExt(String key, String name, String val, Long orderId) {
        if (val.equals("")) {
            val = " ";
        }
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setFieldValue(val);
        extMapPO.setFieldCode(key);
        extMapPO.setFieldName(name);
        extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        extMapPO.setObjId(orderId);
        extMapPO.setOrderId(orderId);
        this.ordExtMapMapper.updateById(extMapPO);
    }

    private void updateAddr(PebExtAddressInfoIntfceReqBO addressInfoIntfceBO, OrdSalePO salePO) {
        OrdLogisticsRelaPO relaPO = new OrdLogisticsRelaPO();
        relaPO.setOrderId(salePO.getOrderId());
        relaPO.setContactId(salePO.getContactId());
        relaPO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        relaPO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        relaPO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        relaPO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        relaPO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        relaPO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        relaPO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        relaPO.setContactName(addressInfoIntfceBO.getReceiverName());
        relaPO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        relaPO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        relaPO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        relaPO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        relaPO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        relaPO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        relaPO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        relaPO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        this.ordLogisticsRelaMapper.updateById(relaPO);
    }

    @Override
    public PebUpdateOrderRspBO updateHt(PebUpdateOrderReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO.setExt1(reqBO.getType());
        this.ordSaleMapper.updateById(salePO);
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebUpdateOrderRspBO updateFscStatus(PebUpdateOrderReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        reqBO.setSaleVoucherId(salePO.getSaleVoucherId());
        OrderPO orderPO = new OrderPO();
        orderPO.setExt9(reqBO.getFscStatus());
        orderPO.setExt10(reqBO.getFscStatus());
        orderPO.setOrderId(reqBO.getOrderId());
        this.orderMapper.updateById(orderPO);
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

