/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfReturnPlanService;
import com.tydic.uoc.busibase.busi.bo.PebIntfReturnPlanData;
import com.tydic.uoc.busibase.busi.bo.PebIntfReturnPlanReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfReturnPlanRspBO;
import com.tydic.uoc.common.ability.bo.UocProOrderDeleteAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderDeleteAbilityRspBo;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.UocProOrderDeleteBusiService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrdStateChgLogMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrdStateChgLogPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.PlanDiversionInfo;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocProOrderDeleteBusiServiceImpl
implements UocProOrderDeleteBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdStateChgLogMapper ordStateChgLogMapper;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private PebIntfReturnPlanService pebIntfReturnPlanService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;

    @Override
    public UocProOrderDeleteAbilityRspBo deleteOrder(UocProOrderDeleteAbilityReqBo reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO.setSaleState(UocConstant.SALE_ORDER_STATUS.ORDER_DELETE);
        this.ordSaleMapper.updateById(ordSalePO);
        OrdStateChgLogPO ordStateChgLogPO = new OrdStateChgLogPO();
        ordStateChgLogPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
        ordStateChgLogPO.setOrderId(reqBO.getOrderId());
        ordStateChgLogPO.setOldState(reqBO.getSaleState());
        ordStateChgLogPO.setNewState(UocConstant.SALE_ORDER_STATUS.ORDER_DELETE);
        ordStateChgLogPO.setStateType("A01");
        ordStateChgLogPO.setChgTime(new Date());
        ordStateChgLogPO.setOperId(String.valueOf(reqBO.getUserId()));
        ordStateChgLogPO.setChgDesc(reqBO.getUsername() + "\u64cd\u4f5c\u8ba2\u5355\u5220\u9664");
        this.ordStateChgLogMapper.insert(ordStateChgLogPO);
        UocProOrderDeleteAbilityRspBo rspBO = new UocProOrderDeleteAbilityRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        if (!"1".equals(ordStakeholderPO.getExtField3())) {
            return rspBO;
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(ordItemPO);
        ArrayList<Long> planIds = new ArrayList<Long>();
        for (OrdItemPO itemPO : list) {
            planIds.add(itemPO.getPlanId());
        }
        reqBO.setSaleVoucherId(((OrdItemPO)list.get(0)).getSaleVoucherId());
        rspBO.setPlanId(planIds);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        List infos = this.planDiversionMapper.selectListByPlanId(planIds);
        if (PebExtConstant.YES.equals(zmInfoPO.getErpStatus())) {
            PebIntfReturnPlanReqBO pebIntfReturnPlanReqBO = new PebIntfReturnPlanReqBO();
            ArrayList<PebIntfReturnPlanData> hearder = new ArrayList<PebIntfReturnPlanData>();
            for (PlanDiversionInfo info : infos) {
                PebIntfReturnPlanData data = new PebIntfReturnPlanData();
                data.setP_HEADER_ID(info.getHeaderId());
                data.setP_SOURCE_CODE(info.getSourceCode());
                data.setP_LINE_ID(info.getLineId());
                data.setP_USER_NAME(zmInfoPO.getErpUserName());
                hearder.add(data);
            }
            pebIntfReturnPlanReqBO.setPBATCH_ID(String.valueOf(System.currentTimeMillis()));
            pebIntfReturnPlanReqBO.setHEADER_DATA(hearder);
            PebIntfReturnPlanRspBO pebIntfReturnPlanRspBO = this.pebIntfReturnPlanService.send(pebIntfReturnPlanReqBO);
            this.saveLog(reqBO.getOrderId(), pebIntfReturnPlanRspBO);
            if (!"0000".equals(pebIntfReturnPlanRspBO.getRespCode())) {
                rspBO.setRespCode(pebIntfReturnPlanRspBO.getRespCode());
                rspBO.setRespDesc(pebIntfReturnPlanRspBO.getRespDesc());
                return rspBO;
            }
        }
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(reqBO.getOrderId());
        stakeholderPO.setExtField3("2");
        this.ordStakeholderMapper.updateById(stakeholderPO);
        this.updatePlan(orderPO, list);
        return rspBO;
    }

    private void updatePlan(OrderPO orderPO, List<OrdItemPO> list) {
        for (OrdItemPO skuInfo : list) {
            PlanDiversionInfo info = new PlanDiversionInfo();
            info.setPlanId(skuInfo.getPlanId());
            if (PebExtConstant.OrderType.CX_AGR.equals(orderPO.getOrderType())) {
                info.setPlanStatus("101");
                info.setAgreementQty(skuInfo.getPurchaseCount().negate());
            } else if (PebExtConstant.OrderType.CX_AGR_GOODS.equals(orderPO.getOrderType())) {
                info.setCommodityQty(skuInfo.getPurchaseCount().negate());
                info.setPlanStatus("102");
            } else {
                info.setPlanStatus("102");
                info.setCommodityQty(skuInfo.getPurchaseCount().negate());
            }
            info.setOrderQty(skuInfo.getPurchaseCount().negate());
            this.planDiversionMapper.updateCount(info);
        }
    }

    private void saveLog(Long orderId, PebIntfReturnPlanRspBO rsp) {
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setErrDetail("1");
        logBO.setFlowFlag(1);
        logBO.setInContent(rsp.getInString());
        logBO.setInterCode("returnPlan");
        logBO.setInterSn("1");
        logBO.setCallCount(1);
        logBO.setCallState("1");
        logBO.setOutContent(rsp.getReturnString());
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(rsp.getRespCode());
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

