/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfDelMsgPushAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfGetMsgPushAbilityService;
import com.tydic.uoc.busibase.busi.bo.BusiDelMsgReqBO;
import com.tydic.uoc.busibase.busi.bo.BusiDelMsgRspBO;
import com.tydic.uoc.busibase.busi.bo.BusiGetMsgReqBO;
import com.tydic.uoc.busibase.busi.bo.BusiGetMsgRspBO;
import com.tydic.uoc.common.ability.api.UocPebQryOutPushMsgAbilityService;
import com.tydic.uoc.common.ability.bo.ResultBO;
import com.tydic.uoc.common.ability.bo.UocPebQryOutPushMsgReqBO;
import com.tydic.uoc.common.ability.bo.UocPebQryOutPushMsgRspBO;
import com.tydic.uoc.common.busi.api.UocPebQryOutPushMsgBusiService;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.po.ConfSupplierPO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocPebQryOutPushMsgAbilityService"})
public class UocPebQryOutPushMsgAbilityServiceImpl
implements UocPebQryOutPushMsgAbilityService {
    private UocPebQryOutPushMsgBusiService uocPebQryOutPushMsgBusiService;
    @Autowired
    private PebIntfGetMsgPushAbilityService pebIntfGetMsgPushAbilityService;
    private static final Logger LOG = LoggerFactory.getLogger(UocPebQryOutPushMsgAbilityServiceImpl.class);
    @Autowired
    private PebIntfDelMsgPushAbilityService pebIntfDelMsgPushAbilityService;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Value(value="${isOpenDelPushMsg}")
    private boolean isOpenDelPushMsg;

    @Autowired
    public UocPebQryOutPushMsgAbilityServiceImpl(UocPebQryOutPushMsgBusiService uocPebQryOutPushMsgBusiService) {
        this.uocPebQryOutPushMsgBusiService = uocPebQryOutPushMsgBusiService;
    }

    @PostMapping(value={"createAndQryOutPushMsg"})
    public UocPebQryOutPushMsgRspBO createAndQryOutPushMsg(@RequestBody UocPebQryOutPushMsgReqBO uocPebQryOutPushMsgReqBO) {
        String[] dealTypes;
        this.validataParams(uocPebQryOutPushMsgReqBO);
        ConfSupplierPO confSupplierPO = this.qryConfSupplier(uocPebQryOutPushMsgReqBO);
        Long supNo = uocPebQryOutPushMsgReqBO.getGoodsSupplierId();
        for (String dealType : dealTypes = confSupplierPO.getDealType().split(",")) {
            BusiGetMsgRspBO qryMsgRsp;
            Boolean isAnalysis = this.defineAnalysisType(dealType);
            if (!isAnalysis.booleanValue()) {
                dealType = dealType.substring(0, dealType.length() - 1);
            }
            if (null != (qryMsgRsp = this.qryPushMsg(supNo, dealType, isAnalysis)) && null != qryMsgRsp.getResult() && !qryMsgRsp.getResult().isEmpty()) {
                List resultVOlist = qryMsgRsp.getResult();
                UocPebQryOutPushMsgReqBO reqBO = new UocPebQryOutPushMsgReqBO();
                reqBO.setGoodsSupplierId(uocPebQryOutPushMsgReqBO.getGoodsSupplierId());
                reqBO.setResultVOlist(resultVOlist);
                reqBO.setIsAnalysis(isAnalysis);
                reqBO.setType(dealType);
                UocPebQryOutPushMsgRspBO rspBO = this.uocPebQryOutPushMsgBusiService.createAndQryOutPushMsg(reqBO);
                if (!"0000".equals(rspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)rspBO.getList())) continue;
                for (String msgId : rspBO.getList()) {
                    this.deletePushMsg(msgId, uocPebQryOutPushMsgReqBO.getGoodsSupplierId());
                }
                continue;
            }
            LOG.debug("\u672a\u67e5\u8be2\u5230\u6d88\u606f\u7c7b\u578b\u4e3a[dealType=" + dealType + "]\u7684\u5916\u90e8\u7535\u5546\u63a8\u9001\u6d88\u606f");
        }
        UocPebQryOutPushMsgRspBO rspBO = new UocPebQryOutPushMsgRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63a8\u9001\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private ConfSupplierPO qryConfSupplier(UocPebQryOutPushMsgReqBO reqBO) {
        try {
            ConfSupplierPO confSupplierPO = this.confSupplierMapper.getModelById(reqBO.getGoodsSupplierId().longValue());
            if (confSupplierPO == null) {
                throw new UocProBusinessException("104027", "\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u5f53\u524d\u4f9b\u5e94\u5546[" + reqBO.getGoodsSupplierId() + "]\u914d\u7f6e\u4fe1\u606f!");
            }
            if (StringUtils.isEmpty((CharSequence)confSupplierPO.getDealType())) {
                throw new UocProBusinessException("104027", "\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u5f53\u524d\u4f9b\u5e94\u5546[" + reqBO.getGoodsSupplierId() + "]\u672a\u914d\u7f6e\u5904\u7406\u7c7b\u578b!");
            }
            return confSupplierPO;
        }
        catch (Exception e) {
            LOG.error("\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u4f9b\u5e94\u5546\u914d\u7f6e\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38!", (Throwable)e);
            throw new UocProBusinessException("104027", "\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u4f9b\u5e94\u5546\u914d\u7f6e\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38!");
        }
    }

    private BusiGetMsgRspBO qryPushMsg(Long supNo, String dealType, Boolean isAnalysis) {
        BusiGetMsgReqBO busiGetMsgReq = new BusiGetMsgReqBO();
        busiGetMsgReq.setSupplierId(supNo);
        busiGetMsgReq.setType(Integer.valueOf(dealType));
        busiGetMsgReq.setIsAnalysis(isAnalysis);
        BusiGetMsgRspBO qryMsgRsp = this.pebIntfGetMsgPushAbilityService.getMsg(busiGetMsgReq);
        if (qryMsgRsp == null || !qryMsgRsp.isSuccess()) {
            LOG.error("\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u5931\u8d25");
            return null;
        }
        List resultVOlist = qryMsgRsp.getResult();
        if (null == resultVOlist) {
            LOG.error("\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u5916\u90e8\u670d\u52a1\u672a\u8fd4\u56de\u5904\u7406\u6d88\u606f");
            return null;
        }
        for (ResultBO resultVO : resultVOlist) {
            LOG.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2resultVO\uff1a" + resultVO.toString());
            if (null == resultVO.getResult()) continue;
            LOG.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2Result: " + resultVO.getResult().toString());
        }
        return qryMsgRsp;
    }

    private Boolean defineAnalysisType(String dealType) {
        boolean isAnalysis = true;
        String endWithUpper = "F";
        String endWithLower = "f";
        if (dealType.endsWith(endWithUpper) || dealType.endsWith(endWithLower)) {
            isAnalysis = false;
        }
        return isAnalysis;
    }

    private void deletePushMsg(String msgId, Long supplierId) {
        if (this.isOpenDelPushMsg) {
            BusiDelMsgReqBO busiDelMsgReq = new BusiDelMsgReqBO();
            busiDelMsgReq.setId(msgId);
            busiDelMsgReq.setSupplierId(supplierId);
            BusiDelMsgRspBO usiDelMsgRsp = this.pebIntfDelMsgPushAbilityService.delMsgPush(busiDelMsgReq);
            if (!"0000".equals(usiDelMsgRsp.getRespCode())) {
                LOG.error("\u63a8\u9001\u6d88\u606f\u5165\u5e93\u65f6\u672a\u6210\u529f\u5220\u9664\u6570\u636e\u5e93\u4e2d\u672a\u5b58\u5728\u7684\u5916\u90e8\u8ba2\u5355\u7684\u63a8\u9001\u6d88\u606f!" + usiDelMsgRsp.getRespDesc());
            }
        }
    }

    private void validataParams(UocPebQryOutPushMsgReqBO uocPebQryOutPushMsgReqBO) {
        if (uocPebQryOutPushMsgReqBO.getGoodsSupplierId() == null || uocPebQryOutPushMsgReqBO.getGoodsSupplierId() == 0L) {
            throw new UocProBusinessException("100002", "\u4f9b\u5e94\u5546\u7f16\u53f7[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

