/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.UocProAfterServiceCompleteConfirmAbilityService;
import com.tydic.uoc.common.ability.bo.PebAfterSalesServiceApprovalReqBO;
import com.tydic.uoc.common.ability.bo.PebAfterSalesServiceApprovalRspBO;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceCompleteConfirmAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProAfterServiceCompleteConfirmAbilityRspBo;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.busi.api.EsMsgLogBusiService;
import com.tydic.uoc.common.busi.api.PebAfterSalesServiceApprovalBusiService;
import com.tydic.uoc.common.busi.api.UocProAfterServiceCompleteConfirmBusiService;
import com.tydic.uoc.common.busi.bo.EsMsgLogReqBO;
import com.tydic.uoc.common.busi.bo.EsMsgLogRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdAsObjMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdAsObjPO;
import com.tydic.uoc.po.OrdSalePO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProAfterServiceCompleteConfirmAbilityService"})
public class UocProAfterServiceCompleteConfirmAbilityServiceImpl
implements UocProAfterServiceCompleteConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocProAfterServiceCompleteConfirmAbilityServiceImpl.class);
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAsObjMapper ordAsObjMapper;
    @Autowired
    private UocProAfterServiceCompleteConfirmBusiService uocProAfterServiceCompleteConfirmBusiService;
    @Autowired
    PebAfterSalesServiceApprovalBusiService pebAfterSalesServiceApprovalBusiService;
    @Autowired
    private EsMsgLogBusiService esMsgLogBusiService;

    @PostMapping(value={"completeAfterService"})
    public UocProAfterServiceCompleteConfirmAbilityRspBo completeAfterService(@RequestBody UocProAfterServiceCompleteConfirmAbilityReqBo reqBo) {
        this.checkState(reqBo);
        UocProAfterServiceCompleteConfirmAbilityRspBo rspBo = this.uocProAfterServiceCompleteConfirmBusiService.dealCompleteAfterService(reqBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            throw new UocProBusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
        }
        this.dealEsSync(reqBo);
        return rspBo;
    }

    private void checkState(UocProAfterServiceCompleteConfirmAbilityReqBo reqBo) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setActionCode("ACTPEB015");
        uocCoreStateCheckAtomReqBO.setOrderId(reqBo.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjId(reqBo.getAfterServId());
        uocCoreStateCheckAtomReqBO.setObjType(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE);
        log.debug("\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u5165\u53c2:" + uocCoreStateCheckAtomReqBO.toString());
        UocCoreStateCheckAtomRspBO uocCoreStateCheckAtomRspBO = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!uocCoreStateCheckAtomRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException("100001", "\u552e\u540e\u5355id:" + uocCoreStateCheckAtomRspBO.getRespDesc() + "\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
    }

    @PostMapping(value={"supCompleteAfterService"})
    public UocProAfterServiceCompleteConfirmAbilityRspBo supCompleteAfterService(@RequestBody UocProAfterServiceCompleteConfirmAbilityReqBo reqBo) {
        PebAfterSalesServiceApprovalReqBO approvalReqBO = new PebAfterSalesServiceApprovalReqBO();
        approvalReqBO.setOrderId(reqBo.getOrderId());
        approvalReqBO.setAfterServId(reqBo.getAfterServId());
        approvalReqBO.setAfsActionCode(UocConstant.AFS_ACTION_CODE.AGREE);
        approvalReqBO.setActionCode("ACTPEB015");
        PebAfterSalesServiceApprovalRspBO approvalRspBO = this.pebAfterSalesServiceApprovalBusiService.dealPebAfterSalesServiceApproval(approvalReqBO);
        if (!"0000".equals(approvalRspBO.getRespCode())) {
            throw new UocProBusinessException(approvalRspBO.getRespCode(), approvalRspBO.getRespDesc());
        }
        this.dealEsSync(reqBo);
        return (UocProAfterServiceCompleteConfirmAbilityRspBo)UocProRspBoUtil.success(UocProAfterServiceCompleteConfirmAbilityRspBo.class);
    }

    private void dealEsSync(UocProAfterServiceCompleteConfirmAbilityReqBo reqBo) {
        OrdAsObjPO qryShip = new OrdAsObjPO();
        qryShip.setAfterServId(reqBo.getAfterServId());
        OrdAsObjPO shipPo = this.ordAsObjMapper.getModelBy(qryShip);
        UocOrdIdxSyncReqBO uocOrdAsIdxSyncShip = new UocOrdIdxSyncReqBO();
        uocOrdAsIdxSyncShip.setObjId(shipPo.getShipVoucherId());
        uocOrdAsIdxSyncShip.setObjType(UocConstant.OBJ_TYPE.SHIP);
        uocOrdAsIdxSyncShip.setOrderId(reqBo.getOrderId());
        try {
            EsMsgLogReqBO logReqBO = new EsMsgLogReqBO();
            logReqBO.setObjId(uocOrdAsIdxSyncShip.getObjId());
            logReqBO.setObjType(uocOrdAsIdxSyncShip.getObjType());
            logReqBO.setOrderId(uocOrdAsIdxSyncShip.getOrderId());
            EsMsgLogRspBO rspBO = this.esMsgLogBusiService.dealSave(logReqBO);
            uocOrdAsIdxSyncShip.setEsLogId(rspBO.getId());
        }
        catch (Exception logReqBO) {
            // empty catch block
        }
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdAsIdxSyncShip)));
        UocOrdIdxSyncReqBO uocOrdAsIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdAsIdxSyncReqBO.setObjId(reqBo.getAfterServId());
        uocOrdAsIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        uocOrdAsIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        try {
            EsMsgLogReqBO logReqBO = new EsMsgLogReqBO();
            logReqBO.setObjId(uocOrdAsIdxSyncShip.getObjId());
            logReqBO.setObjType(uocOrdAsIdxSyncShip.getObjType());
            logReqBO.setOrderId(uocOrdAsIdxSyncShip.getOrderId());
            EsMsgLogRspBO rspBO = this.esMsgLogBusiService.dealSave(logReqBO);
            uocOrdAsIdxSyncShip.setEsLogId(rspBO.getId());
        }
        catch (Exception logReqBO) {
            // empty catch block
        }
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdAsIdxSyncReqBO)));
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBo.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        uocOrdSaleIdxSyncReqBO.setObjId(ordSalePO.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        try {
            EsMsgLogReqBO logReqBO = new EsMsgLogReqBO();
            logReqBO.setObjId(uocOrdAsIdxSyncShip.getObjId());
            logReqBO.setObjType(uocOrdAsIdxSyncShip.getObjType());
            logReqBO.setOrderId(uocOrdAsIdxSyncShip.getOrderId());
            EsMsgLogRspBO rspBO = this.esMsgLogBusiService.dealSave(logReqBO);
            uocOrdAsIdxSyncShip.setEsLogId(rspBO.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

