/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.OrdInspectionRspBO;
import com.tydic.uoc.common.ability.bo.PebDistributionReqBO;
import com.tydic.uoc.common.ability.bo.PebDistributionRspBO;
import com.tydic.uoc.common.ability.bo.UocDistributionBO;
import com.tydic.uoc.common.busi.api.PebDistributionBusiService;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocDistributionMapper;
import com.tydic.uoc.dao.UocOrderRelMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocDistributionPO;
import com.tydic.uoc.po.UocOrderRelPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebDistributionBusiServiceImpl
implements PebDistributionBusiService {
    @Autowired
    private UocDistributionMapper uocDistributionMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @Override
    public PebDistributionRspBO dealDistribution(PebDistributionReqBO reqBO) {
        ArrayList<UocDistributionPO> list = new ArrayList<UocDistributionPO>();
        ArrayList<OrdInspectionRspBO> ids = new ArrayList<OrdInspectionRspBO>();
        for (UocDistributionBO distributionBO : reqBO.getUocDistributionList()) {
            UocDistributionPO po = new UocDistributionPO();
            BeanUtils.copyProperties((Object)distributionBO, (Object)po);
            po.setId(Long.valueOf(this.idUtil.nextId()));
            po.setCreateOperCode(reqBO.getUsername());
            po.setCreateOperId(reqBO.getUserId() + "");
            po.setCreateOperName(reqBO.getName());
            po.setCreateOrgCode(reqBO.getOrgCodeIn());
            po.setCreateOrgName(reqBO.getOrgName());
            po.setCreateOrgId(reqBO.getOrgId() + "");
            po.setCreateTime(new Date());
            list.add(po);
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(distributionBO.getOrderId());
            orderPO.setExt1(distributionBO.getNewOperCode());
            orderPO.setExt2(distributionBO.getNewOperId());
            orderPO.setExt3(distributionBO.getNewOperName());
            orderPO.setExt6(distributionBO.getNewOrgId());
            orderPO.setExt7(distributionBO.getNewOrgCode());
            orderPO.setExt8(distributionBO.getNewOrgName());
            this.orderMapper.updateById(orderPO);
            UocOrderRelPO relPO = new UocOrderRelPO();
            relPO.setOrderId(distributionBO.getOrderId());
            relPO.setRelStatus(Integer.valueOf(1));
            int count = this.uocOrderRelMapper.getCheckByOrderId(distributionBO.getOrderId().longValue());
            if (count > 0) {
                OrdSalePO salePO = new OrdSalePO();
                salePO.setOrderId(distributionBO.getOrderId());
                salePO = this.ordSaleMapper.getModelBy(salePO);
                throw new UocProBusinessException("8888", salePO.getSaleVoucherNo() + "\u5df2\u7ecf\u63d0\u4ea4\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u5206\u914d");
            }
            OrdInspectionPO inspectionPO = new OrdInspectionPO();
            inspectionPO.setOrderId(distributionBO.getOrderId());
            List inspectionPOS = this.ordInspectionMapper.getList(inspectionPO);
            for (OrdInspectionPO sp : inspectionPOS) {
                OrdInspectionRspBO bo = new OrdInspectionRspBO();
                bo.setOrderId(distributionBO.getOrderId());
                bo.setInspectionVoucherId(sp.getInspectionVoucherId());
                ids.add(bo);
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.uocDistributionMapper.insertBatch(list);
        }
        PebDistributionRspBO rspBO = new PebDistributionRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setInspectionRspBOS(ids);
        return rspBO;
    }

    @Override
    public PebDistributionRspBO qryDistribution(PebDistributionReqBO reqBO) {
        UocDistributionPO uocDistributionPO = new UocDistributionPO();
        uocDistributionPO.setOrderId(reqBO.getOrderId());
        List list = this.uocDistributionMapper.getList(uocDistributionPO);
        PebDistributionRspBO rspBO = new PebDistributionRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)list)) {
            return rspBO;
        }
        List uocDistributionList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)list), UocDistributionBO.class);
        rspBO.setUocDistributionList(uocDistributionList);
        return rspBO;
    }
}

