/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.uoc.base.bo.UocOrdGoodsTempBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebOrderItemTepmReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderItemTepmRspBO;
import com.tydic.uoc.common.busi.api.PebOrderItemTempBusiService;
import com.tydic.uoc.common.utils.BatchImportUtils;
import com.tydic.uoc.dao.UocOrdGoodsTempMapper;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PebOrderItemTempBusiServiceImpl
implements PebOrderItemTempBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebOrderItemTempBusiServiceImpl.class);
    @Autowired
    private UocOrdGoodsTempMapper uocOrdGoodsTempMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UccThematerialsearchAbilityService uccThematerialsearchAbilityService;

    @Override
    public PebOrderItemTepmRspBO dealCreate(PebOrderItemTepmReqBO reqBO) {
        this.getMaterial(reqBO.getTempList(), true);
        ArrayList<UocOrdGoodsTempPO> insertList = new ArrayList<UocOrdGoodsTempPO>();
        for (UocOrdGoodsTempBO tempBO : reqBO.getTempList()) {
            UocOrdGoodsTempPO po;
            if (tempBO.getTempId() == null) {
                po = new UocOrdGoodsTempPO();
                BeanUtils.copyProperties((Object)tempBO, (Object)po);
                po.setTempId(Long.valueOf(this.idUtil.nextId()));
                po.setCreateTime(new Date());
                po.setUpdateTime(new Date());
                po.setCreateOperId(String.valueOf(reqBO.getUserId()));
                po.setUpdateOperId(String.valueOf(reqBO.getUserId()));
                if (po.getTax() == null) {
                    po.setTax(Long.valueOf(0L));
                }
                insertList.add(po);
                continue;
            }
            po = new UocOrdGoodsTempPO();
            po.setTempId(tempBO.getTempId());
            if (PebExtConstant.YES.toString().equals(tempBO.getExt10())) {
                this.uocOrdGoodsTempMapper.delete(po);
                continue;
            }
            po.setPurchaseCount(tempBO.getPurchaseCount());
            po.setSalePrice(tempBO.getSalePrice());
            po.setTotalSalePrice(tempBO.getTotalSalePrice());
            po.setNakePrice(tempBO.getNakePrice());
            po.setTotalNakePrice(tempBO.getTotalNakePrice());
            po.setOrganizationId(tempBO.getOrganizationId());
            po.setOrganizationName(tempBO.getOrganizationName());
            po.setArrivalTime(tempBO.getArrivalTime());
            po.setBjType(tempBO.getBjType());
            po.setDbPrice(tempBO.getDbPrice());
            po.setZljsyq(tempBO.getZljsyq());
            po.setZxbz(tempBO.getZxbz());
            po.setPpcd(tempBO.getPpcd());
            po.setDccj(tempBO.getDccj());
            po.setSkuMaterialRemark(tempBO.getSkuMaterialRemark());
            this.uocOrdGoodsTempMapper.update(po);
        }
        if (insertList.size() > 0) {
            this.uocOrdGoodsTempMapper.insertBatch(insertList);
        }
        PebOrderItemTepmRspBO rspBO = new PebOrderItemTepmRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebOrderItemTepmRspBO getList(PebOrderItemTepmReqBO reqBO) {
        PebOrderItemTepmRspBO rspBO = new PebOrderItemTepmRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdGoodsTempPO tempPO = new UocOrdGoodsTempPO();
        tempPO.setOrderId(reqBO.getOrderId());
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        List list = this.uocOrdGoodsTempMapper.selectListPage(tempPO, page);
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setTotal(0);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        List rows = JSONArray.parseArray((String)JSON.toJSONString((Object)list), UocOrdGoodsTempBO.class);
        rspBO.setRows(rows);
        tempPO = this.uocOrdGoodsTempMapper.getTotal(tempPO);
        rspBO.setTaxPrice(tempPO.getTaxPrice());
        rspBO.setPurchaseCount(tempPO.getPurchaseCount());
        rspBO.setTotalNakePrice(tempPO.getTotalNakePrice());
        rspBO.setTotalSalePrice(tempPO.getTotalSalePrice());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(reqBO.getPageNo());
        return rspBO;
    }

    @Override
    @Transactional
    public PebOrderItemTepmRspBO dealImport(PebOrderItemTepmReqBO reqBO) {
        List<Map<String, Object>> importDataMap;
        PebOrderItemTepmRspBO rspBO = new PebOrderItemTepmRspBO();
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u660e\u7ec6id");
        title.add("\u7269\u8d44\u7f16\u7801");
        title.add("\u8ba1\u91cf\u5355\u4f4d");
        title.add("\u6570\u91cf");
        if (PebExtConstant.YES.equals(reqBO.getIsTax())) {
            title.add("\u542b\u7a0e\u5355\u4ef7");
            title.add("\u542b\u7a0e\u91d1\u989d");
        } else {
            title.add("\u4e0d\u542b\u7a0e\u5355\u4ef7");
            title.add("\u4e0d\u542b\u7a0e\u91d1\u989d");
        }
        title.add("\u7a0e\u7387");
        title.add("\u7533\u62a5\u5355\u4f4d\u7f16\u7801");
        title.add("\u7533\u62a5\u5355\u4f4d");
        title.add("\u4ea4\u8d27\u65e5\u671f");
        title.add("\u6bd4\u4ef7\u7c7b\u522b");
        title.add("\u5bf9\u6bd4\u5355\u4ef7");
        title.add("\u89c4\u683c");
        title.add("\u578b\u53f7");
        title.add("\u90e8\u4ef6\u53f7");
        title.add("\u8d28\u91cf\u6280\u672f\u8981\u6c42");
        title.add("\u5177\u4f53\u7528\u9014");
        title.add("\u6267\u884c\u6807\u51c6");
        title.add("\u4ea7\u5730\u54c1\u724c");
        title.add("\u5230/\u51fa\u5382\u4ef7");
        title.add("\u5907\u6ce8");
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<UocOrdGoodsTempBO> batchImportUtils = new BatchImportUtils<UocOrdGoodsTempBO>(title, data, UocOrdGoodsTempBO.class);
            batchImportUtils.batchImport(reqBO.getUrl(), 0, 1, -1);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:{}", (Object)e.toString());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(importDataMap)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            return rspBO;
        }
        List list = JSONArray.parseArray((String)JSON.toJSONString(importDataMap), UocOrdGoodsTempBO.class);
        ArrayList<UocOrdGoodsTempPO> insertList = new ArrayList<UocOrdGoodsTempPO>();
        UocOrdGoodsTempPO tempPO = new UocOrdGoodsTempPO();
        tempPO.setOrderId(reqBO.getOrderId());
        List qry = this.uocOrdGoodsTempMapper.selectByCondition(tempPO);
        Map<Object, Object> map = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)qry)) {
            map = qry.stream().collect(Collectors.toMap(UocOrdGoodsTempPO::getTempId, i -> i));
        }
        this.getMaterial(list, true);
        for (UocOrdGoodsTempBO tempBO : list) {
            BigDecimal tn;
            BigDecimal ts;
            BigDecimal tax;
            UocOrdGoodsTempPO po;
            if (StringUtils.isNotBlank((CharSequence)tempBO.getOrganizationId()) && tempBO.getOrganizationId().contains(".0")) {
                tempBO.setOrganizationId(tempBO.getOrganizationId().substring(0, tempBO.getOrganizationId().indexOf(".")));
            }
            if (StringUtils.isNotBlank((CharSequence)tempBO.getTaxStr())) {
                if (tempBO.getTaxStr().contains(".0")) {
                    tempBO.setTaxStr(tempBO.getTaxStr().substring(0, tempBO.getTaxStr().indexOf(".")));
                }
                tempBO.setTax(Long.valueOf(tempBO.getTaxStr()));
            }
            if (tempBO.getTempId() != null) {
                BigDecimal tn2;
                po = new UocOrdGoodsTempPO();
                po.setTempId(tempBO.getTempId());
                po.setPurchaseCount(tempBO.getPurchaseCount());
                po.setSalePrice(tempBO.getSalePrice());
                po.setTotalSalePrice(tempBO.getTotalSalePrice());
                po.setOrganizationId(tempBO.getOrganizationId());
                po.setNakePrice(tempBO.getNakePrice());
                po.setTotalNakePrice(tempBO.getTotalNakePrice());
                po.setOrganizationName(tempBO.getOrganizationName());
                po.setArrivalTime(tempBO.getArrivalTime());
                po.setBjType(tempBO.getBjType());
                po.setDbPrice(tempBO.getDbPrice());
                po.setZljsyq(tempBO.getZljsyq());
                po.setZxbz(tempBO.getZxbz());
                po.setPpcd(tempBO.getPpcd());
                po.setDccj(tempBO.getDccj());
                po.setTax(tempBO.getTax());
                po.setSkuMaterialRemark(tempBO.getSkuMaterialRemark());
                tax = null;
                UocOrdGoodsTempPO goodsTempPO = (UocOrdGoodsTempPO)map.get(tempBO.getTempId());
                if (tempBO.getTax() == null) {
                    if (goodsTempPO.getTax() == null) {
                        goodsTempPO.setTax(Long.valueOf(0L));
                    }
                    tax = new BigDecimal(goodsTempPO.getTax() + "").divide(new BigDecimal("100"), 2);
                } else {
                    tax = new BigDecimal(tempBO.getTax() + "").divide(new BigDecimal("100"), 2);
                }
                if (tempBO.getSalePrice() != null) {
                    BigDecimal nk = tempBO.getSalePrice().divide(BigDecimal.ONE.add(tax), 4, 4);
                    ts = tempBO.getSalePrice().multiply(po.getPurchaseCount());
                    tn2 = nk.multiply(po.getPurchaseCount());
                    po.setNakePrice(nk);
                    po.setTotalSalePrice(ts);
                    po.setTotalNakePrice(tn2);
                } else {
                    BigDecimal sale = tempBO.getNakePrice().multiply(BigDecimal.ONE.add(tax));
                    ts = sale.multiply(po.getPurchaseCount());
                    tn2 = tempBO.getNakePrice().multiply(po.getPurchaseCount());
                    po.setSalePrice(sale);
                    po.setTotalSalePrice(ts);
                    po.setTotalNakePrice(tn2);
                }
                this.uocOrdGoodsTempMapper.update(po);
                continue;
            }
            po = new UocOrdGoodsTempPO();
            BeanUtils.copyProperties((Object)tempBO, (Object)po);
            po.setCreateTime(new Date());
            po.setUpdateTime(new Date());
            po.setTempId(Long.valueOf(this.idUtil.nextId()));
            po.setOrderId(reqBO.getOrderId());
            if (reqBO.getSkuSupplierId() == null) {
                throw new UocProBusinessException("100030", "\u5f53\u524d\u8ba2\u5355\u4e0d\u652f\u6301\u65b0\u589e\u660e\u7ec6\uff0c\u53ea\u80fd\u5bfc\u5165\u66f4\u65b0");
            }
            po.setSkuSupplierId(reqBO.getSkuSupplierId());
            po.setSkuSupplierName(reqBO.getSkuSupplierName());
            po.setSupplierShopId(reqBO.getSupplierShopId());
            po.setSupplier(reqBO.getSupplier());
            po.setCreateOperId(String.valueOf(reqBO.getUserId()));
            po.setUpdateOperId(String.valueOf(reqBO.getUserId()));
            tax = new BigDecimal(tempBO.getTax() + "").divide(new BigDecimal("100"), 2);
            if (tempBO.getSalePrice() != null) {
                BigDecimal nk = tempBO.getSalePrice().divide(BigDecimal.ONE.add(tax), 4, 4);
                tn = nk.multiply(po.getPurchaseCount());
                ts = tempBO.getSalePrice().multiply(po.getPurchaseCount());
                po.setNakePrice(nk);
                po.setTaxPrice(ts.subtract(tn));
                po.setTotalSalePrice(ts);
                po.setTotalNakePrice(tn);
            } else {
                BigDecimal sale = tempBO.getNakePrice().multiply(BigDecimal.ONE.add(tax));
                tn = tempBO.getNakePrice().multiply(po.getPurchaseCount());
                ts = sale.multiply(po.getPurchaseCount());
                po.setSalePrice(sale);
                po.setTotalSalePrice(ts);
                po.setTotalNakePrice(tn);
                po.setTaxPrice(ts.subtract(tn));
            }
            insertList.add(po);
        }
        if (insertList.size() > 0) {
            this.uocOrdGoodsTempMapper.insertBatch(insertList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void getMaterial(List<UocOrdGoodsTempBO> tempList, boolean qry) {
        HashSet<String> code = new HashSet<String>();
        ArrayList<String> materialCodes = new ArrayList<String>();
        for (UocOrdGoodsTempBO skuInfo : tempList) {
            materialCodes.add(skuInfo.getSkuMaterialId());
            code.add(skuInfo.getSkuMaterialId());
            if (!StringUtils.isNotBlank((CharSequence)skuInfo.getSkuMaterialId()) || !skuInfo.getSkuMaterialId().endsWith("000000")) continue;
            throw new UocProBusinessException("100030", "\u901a\u7528\u7269\u6599\u4e0d\u80fd\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7269\u6599");
        }
        UccThematerialsearchAbilityReqBO uccThematerialsearchAbilityReqBO = new UccThematerialsearchAbilityReqBO();
        uccThematerialsearchAbilityReqBO.setMaterialCodes(materialCodes);
        log.debug("\u67e5\u8be2\u7269\u6599\u7f16\u7801:" + JSON.toJSONString((Object)uccThematerialsearchAbilityReqBO));
        UccThematerialsearchAbilityRspBO rspBO = this.uccThematerialsearchAbilityService.dealUccThematerialsearch(uccThematerialsearchAbilityReqBO);
        log.debug("\u67e5\u8be2\u7269\u6599\u7f16\u7801:");
        if (rspBO.getRespCode().equals("0000") && CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            throw new UocProBusinessException("100030", ((Object)code).toString() + "\u7f3a\u5c11\u7269\u8d44\u4fe1\u606f\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458");
        }
        ArrayList<String> mCode = new ArrayList<String>();
        List eMdmMaterialBOS = JSONArray.parseArray((String)JSON.toJSONString((Object)rspBO.getRows()), UccEMdmMaterialBO.class);
        for (UccEMdmMaterialBO uccEMdmMaterialBO : eMdmMaterialBOS) {
            mCode.add(uccEMdmMaterialBO.getMaterialCode());
        }
        String desc = null;
        for (String m : code) {
            if (mCode.contains(m)) continue;
            desc = m + ",";
        }
        if (StringUtils.isNotBlank(desc)) {
            throw new UocProBusinessException("100030", "\u3010" + desc + "\u3011\u7f3a\u5c11\u7269\u8d44\u4fe1\u606f\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458");
        }
        for (UccEMdmMaterialBO uccEMdmMaterialBO : eMdmMaterialBOS) {
            for (UocOrdGoodsTempBO skuInfo : tempList) {
                if (!uccEMdmMaterialBO.getMaterialCode().equals(skuInfo.getSkuMaterialId())) continue;
                if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialBO.getSpec())) {
                    skuInfo.setSpec(uccEMdmMaterialBO.getSpec());
                }
                if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialBO.getModel())) {
                    skuInfo.setModel(uccEMdmMaterialBO.getModel());
                }
                skuInfo.setCateCode(uccEMdmMaterialBO.getCatalogCode());
                skuInfo.setCateName(uccEMdmMaterialBO.getCatalogName());
                if (!StringUtils.isBlank((CharSequence)skuInfo.getSkuMaterialName())) continue;
                if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialBO.getLongDesc())) {
                    skuInfo.setSkuMaterialName(uccEMdmMaterialBO.getLongDesc());
                    continue;
                }
                skuInfo.setSkuMaterialName(uccEMdmMaterialBO.getMaterialName());
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("220401000000".endsWith("000000"));
    }
}

