/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.busi.api.UocEsCountStateNumBusiService;
import com.tydic.uoc.common.busi.bo.UocEsCountStateNumReqBO;
import com.tydic.uoc.common.busi.bo.UocEsCountStateNumRspBO;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="esCountStateNumBusiService")
public class UocEsCountStateNumBusiServiceImpl
implements UocEsCountStateNumBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsCountStateNumBusiServiceImpl.class);
    private UocEsConfig uocEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsCountStateNumBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsCountStateNumRspBO countState(UocEsCountStateNumReqBO uocEsCountStateNumReqBO) {
        UocEsCountStateNumRspBO rspBO = new UocEsCountStateNumRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.countStateNum(uocEsCountStateNumReqBO);
        String endPoint = "/" + this.uocEsConfig.getOrderIndexName() + "/" + this.uocEsConfig.getOrderIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        try {
            LOGGER.debug("ES\u7edf\u8ba1\u7ed3\u679csql---->" + qryString);
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("ES\u7edf\u8ba1\u7ed3\u679cresult---->" + result);
            rspBO = this.resovelRetrunData(result, rspBO);
        }
        catch (IOException e) {
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("102026");
            rspBO.setRespDesc("ES\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\u7edf\u8ba1\u6570\u91cf\u5f02\u5e38!");
        }
        return rspBO;
    }

    private UocEsCountStateNumRspBO resovelRetrunData(String result, UocEsCountStateNumRspBO rspBO) {
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7edf\u8ba1\u6210\u529f!");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        rspBO.setCount(total);
        return rspBO;
    }
}

