/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl.plan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.ability.bo.plan.PebExtEnquiryOfProductDetailsListOfCoalZonePlanBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtEsQryProductDetailsListReqBO;
import com.tydic.uoc.common.ability.bo.plan.PebExtEsQryProductDetailsListRspBO;
import com.tydic.uoc.common.busi.api.plan.PebExtEsQryErpProductDetailsListBusiService;
import com.tydic.uoc.common.utils.PebExtBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pebExtEsQryErpProductDetailsListBusiService")
public class PebExtEsQryErpProductDetailsListBusiServiceImpl
implements PebExtEsQryErpProductDetailsListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebExtEsQryErpProductDetailsListBusiServiceImpl.class);
    private UocEsConfig esConfig;
    private UocElasticsearchUtil elasticsearchUtil;
    private PebExtBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public PebExtEsQryErpProductDetailsListBusiServiceImpl(UocEsConfig esConfig, UocElasticsearchUtil elasticsearchUtil) {
        this.esConfig = esConfig;
        this.elasticsearchUtil = elasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new PebExtBuildEsQrySqlConditionUtil();
    }

    @Override
    public PebExtEsQryProductDetailsListRspBO esQryErpProductDetailsList(PebExtEsQryProductDetailsListReqBO reqBO) {
        PebExtEsQryProductDetailsListRspBO rspBO = new PebExtEsQryProductDetailsListRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryErpProductDetailsEsSql(reqBO);
        System.out.println("ES\u67e5\u8be2\u8ba1\u5212\u5f85\u91c7\u5546\u54c1\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.esConfig.getProductIndexName() + "/" + this.esConfig.getProductIndexType() + "/_search";
        System.out.println("\u7d22\u5f15--->" + endPoint);
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        String result = null;
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            System.out.println("ES\u67e5\u8be2\u8ba1\u5212\u5f85\u91c7\u5546\u54c1result---->" + result);
            this.resovelRetrunData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.elasticsearchUtil.createIndex(this.esConfig.getProductIndexName());
                if (!index) {
                    LOGGER.error("\u81ea\u52a8\u8ba1\u5212\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u8ba1\u5212\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    LOGGER.error("ioException", (Throwable)e);
                    rspBO.setRespCode("100100");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u8ba1\u5212\u5f85\u91c7\u5546\u54c1\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBO;
                }
            }
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("102052");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u8ba1\u5212\u5f85\u91c7\u5546\u54c1\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
            return rspBO;
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            this.resolveReturnCounts(result, rspBO);
        }
        return rspBO;
    }

    private void resolveReturnCounts(String result, PebExtEsQryProductDetailsListRspBO rspBO) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject allInterestsObj = (JSONObject)aggregationsObj.get((Object)"all_interests");
        JSONArray bucketsArray = allInterestsObj.getJSONArray("buckets");
        HashMap<String, Integer> tabCountsMap = new HashMap<String, Integer>();
        for (int i = 0; i < bucketsArray.size(); ++i) {
            JSONObject bucketsObj = bucketsArray.getJSONObject(i);
            tabCountsMap.put(bucketsObj.getString("key"), bucketsObj.getInteger("doc_count"));
        }
        rspBO.setTabCountsMap(tabCountsMap);
    }

    private void resovelRetrunData(String result, PebExtEsQryProductDetailsListRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total.intValue());
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba1\u5212\u5f85\u91c7\u5546\u54c1\u4fe1\u606f!");
            return;
        }
        ArrayList<PebExtEnquiryOfProductDetailsListOfCoalZonePlanBO> rows = new ArrayList<PebExtEnquiryOfProductDetailsListOfCoalZonePlanBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            PebExtEnquiryOfProductDetailsListOfCoalZonePlanBO enquiryOfProductDetailsListOfCoalZonePlanBO = (PebExtEnquiryOfProductDetailsListOfCoalZonePlanBO)JSON.toJavaObject((JSON)objJson, PebExtEnquiryOfProductDetailsListOfCoalZonePlanBO.class);
            rows.add(enquiryOfProductDetailsListOfCoalZonePlanBO);
        }
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total.intValue());
        rspBO.setPageNo(pageNo.intValue());
        rspBO.setRespDesc("\u67e5\u8be2\u8ba1\u5212\u5f85\u91c7\u5546\u54c1\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
    }
}

