/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.UocPebAfterSaleRequestReqBO;
import com.tydic.uoc.common.ability.bo.UocPebAfterSaleRequestRspBO;
import com.tydic.uoc.common.ability.bo.UocPebEstoreSubmitAfterSaleApplyItemBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocPebAfterSaleRequestBusiService;
import com.tydic.uoc.common.comb.api.UocPebAfterSaleRequestCombService;
import com.tydic.uoc.dao.OrdAbnormalMapper;
import com.tydic.uoc.dao.OrdAsPurIdxMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdAsPurIdxPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebAfterSaleRequestCombService")
public class UocPebAfterSaleRequestCombServiceImpl
implements UocPebAfterSaleRequestCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebAfterSaleRequestCombServiceImpl.class);
    @Autowired
    private UocPebAfterSaleRequestBusiService uocPebAfterSaleRequestBusiService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdAsPurIdxMapper ordAsPurIdxMapper;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;
    @Value(value="${SUPPLIER_JD_ID}")
    private String supplierJdId;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private String jdIdFl;
    @Value(value="${SUPPLIER_SUNING_FL:202200512}")
    private String snIdFl;

    @Override
    public UocPebAfterSaleRequestRspBO dealUocPebApplyGoodsReturn(UocPebAfterSaleRequestReqBO reqBO) {
        UocPebAfterSaleRequestRspBO uocPebAfterSaleRequestRspBO;
        this.validateParam(reqBO);
        OrdStakeholderPO ordStakeholderPO = this.qryOrdStakeholderPO(reqBO.getOrderId());
        reqBO.setSupNo(ordStakeholderPO.getSupNo());
        if (this.ordAbnormalMapper.getNotRejectedCount(reqBO.getOrderId(), Integer.valueOf(1)) > 0) {
            throw new UocProBusinessException("103009", "\u8be5\u8ba2\u5355\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u5f02\u5e38\u53d8\u66f4,\u65e0\u6cd5\u8fdb\u884c\u552e\u540e");
        }
        if (this.supplierJdId.equals(ordStakeholderPO.getSupNo()) || this.jdIdFl.equals(ordStakeholderPO.getSupNo())) {
            if (reqBO.getReturnItemList().size() > 1) {
                throw new UocProBusinessException("103009", "\u4eac\u4e1c\u8ba2\u5355\u4e0d\u652f\u6301\u6279\u91cf\u552e\u540e\uff0c\u8bf7\u9009\u62e9\u5355\u6761\u660e\u7ec6\u8fdb\u884c\u552e\u540e");
            }
            int returnSkuNum = ((UocPebEstoreSubmitAfterSaleApplyItemBO)reqBO.getReturnItemList().get(0)).getSkuNum().intValue();
            OrdAsPurIdxPO ordAsPurIdxPO = new OrdAsPurIdxPO();
            ordAsPurIdxPO.setObjJson(String.valueOf(((UocPebEstoreSubmitAfterSaleApplyItemBO)reqBO.getReturnItemList().get(0)).getShipItemId()));
            ordAsPurIdxPO.setOrderId(reqBO.getOrderId());
            ordAsPurIdxPO.setDealResult(PecConstant.OUT_MSG_RUN_RESULT.WAIT_RUN);
            List ordAsPurIdxPOList = this.ordAsPurIdxMapper.getList(ordAsPurIdxPO);
            int newJdOrderIdSize = 0;
            if (CollectionUtils.isNotEmpty((Collection)ordAsPurIdxPOList)) {
                newJdOrderIdSize = ordAsPurIdxPOList.size();
            }
            if (0 == newJdOrderIdSize) {
                uocPebAfterSaleRequestRspBO = this.uocPebAfterSaleRequestBusiService.dealUocPebApplyGoodsReturn(reqBO);
            } else if (newJdOrderIdSize > returnSkuNum || newJdOrderIdSize == returnSkuNum) {
                uocPebAfterSaleRequestRspBO = this.newJdOrderIdAfsApply(reqBO, ordAsPurIdxPOList, returnSkuNum);
            } else {
                UocPebAfterSaleRequestRspBO jdAfterSaleRequestRspBO = this.newJdOrderIdAfsApply(reqBO, ordAsPurIdxPOList, newJdOrderIdSize);
                reqBO.setIsUseNewJdOrderApply(Boolean.valueOf(false));
                reqBO.setNewJdOrderId(null);
                reqBO.setOldAfterServiceId(null);
                reqBO.setOldAfterServiceNo(null);
                reqBO.setOldObjId(null);
                ((UocPebEstoreSubmitAfterSaleApplyItemBO)reqBO.getReturnItemList().get(0)).setSkuNum(new BigDecimal(returnSkuNum - newJdOrderIdSize));
                uocPebAfterSaleRequestRspBO = this.uocPebAfterSaleRequestBusiService.dealUocPebApplyGoodsReturn(reqBO);
                if (!"0000".equals(uocPebAfterSaleRequestRspBO.getRespCode())) {
                    uocPebAfterSaleRequestRspBO = jdAfterSaleRequestRspBO;
                    uocPebAfterSaleRequestRspBO.setRespCode(jdAfterSaleRequestRspBO.getRespCode());
                    uocPebAfterSaleRequestRspBO.setRespDesc(jdAfterSaleRequestRspBO.getRespDesc());
                    uocPebAfterSaleRequestRspBO.setShipVoucherId(jdAfterSaleRequestRspBO.getShipVoucherId());
                    uocPebAfterSaleRequestRspBO.setSaleVoucherId(jdAfterSaleRequestRspBO.getSaleVoucherId());
                    uocPebAfterSaleRequestRspBO.setAfterServIdList(jdAfterSaleRequestRspBO.getAfterServIdList());
                    uocPebAfterSaleRequestRspBO.setAfterServId(null);
                } else {
                    List afterSevIdList = uocPebAfterSaleRequestRspBO.getAfterServIdList();
                    afterSevIdList.addAll(jdAfterSaleRequestRspBO.getAfterServIdList());
                    uocPebAfterSaleRequestRspBO.setAfterServIdList(afterSevIdList);
                }
            }
        } else {
            uocPebAfterSaleRequestRspBO = this.uocPebAfterSaleRequestBusiService.dealUocPebApplyGoodsReturn(reqBO);
        }
        if (!"0000".equals(uocPebAfterSaleRequestRspBO.getRespCode())) {
            throw new UocProBusinessException("103009", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25,\u539f\u56e0\uff1a" + uocPebAfterSaleRequestRspBO.getRespDesc());
        }
        this.syncSaleList(uocPebAfterSaleRequestRspBO, reqBO);
        if (uocPebAfterSaleRequestRspBO.getAfterServId() != null && uocPebAfterSaleRequestRspBO.getAfterServId() != 0L) {
            this.syncServList(reqBO.getOrderId(), uocPebAfterSaleRequestRspBO.getAfterServId());
        } else if (CollectionUtils.isNotEmpty((Collection)uocPebAfterSaleRequestRspBO.getAfterServIdList())) {
            for (Long afterServId : uocPebAfterSaleRequestRspBO.getAfterServIdList()) {
                this.syncServList(reqBO.getOrderId(), afterServId);
            }
        }
        this.syncShipList(uocPebAfterSaleRequestRspBO, reqBO);
        return uocPebAfterSaleRequestRspBO;
    }

    private OrdStakeholderPO qryOrdStakeholderPO(Long orderId) {
        try {
            OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
            if (ordStakeholderPO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("\u6267\u884c\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u7b2c\u4e09\u65b9\u4fe1\u606f\u6570\u636e");
                }
                throw new UocProBusinessException("0000", "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u7b2c\u4e09\u65b9\u4fe1\u606f\u6570\u636e");
            }
            return ordStakeholderPO;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u5931\u8d25:\u67e5\u8be2\u7b2c\u4e09\u65b9\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            }
            throw new UocProBusinessException("0000", "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u5931\u8d25:\u67e5\u8be2\u7b2c\u4e09\u65b9\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    private UocPebAfterSaleRequestRspBO newJdOrderIdAfsApply(UocPebAfterSaleRequestReqBO reqBO, List<OrdAsPurIdxPO> ordAsPurIdxPOList, int returnSkuNum) {
        UocPebAfterSaleRequestRspBO rspBO = new UocPebAfterSaleRequestRspBO();
        int successCount = 0;
        boolean firstFail = false;
        String firstFailDesc = "";
        Long saleVoucherId = null;
        Long shipVoucherId = null;
        ArrayList afterSevIdList = new ArrayList();
        for (int i = 0; i < returnSkuNum; ++i) {
            OrdAsPurIdxPO asPurIdxPO = ordAsPurIdxPOList.get(i);
            if (firstFail) {
                throw new UocProBusinessException("103009", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25,\u539f\u56e0\uff1a" + firstFailDesc);
            }
            reqBO.setNewJdOrderId(asPurIdxPO.getSaleVoucherNo());
            reqBO.setIsUseNewJdOrderApply(Boolean.valueOf(true));
            reqBO.setOldAfterServiceNo(asPurIdxPO.getAfterServiceNo());
            reqBO.setOldAfterServiceId(asPurIdxPO.getAfsServiceId());
            reqBO.setOldObjId(asPurIdxPO.getObjId());
            UocPebAfterSaleRequestRspBO uocPebAfterSaleRequestRspBO = this.uocPebAfterSaleRequestBusiService.dealUocPebApplyGoodsReturn(reqBO);
            if (!"0000".equals(uocPebAfterSaleRequestRspBO.getRespCode())) {
                if (false != successCount) continue;
                firstFail = true;
                firstFailDesc = uocPebAfterSaleRequestRspBO.getResultDesc();
                if (1 != returnSkuNum) continue;
                throw new UocProBusinessException("103009", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25,\u539f\u56e0\uff1a" + firstFailDesc);
            }
            if (null == saleVoucherId) {
                saleVoucherId = uocPebAfterSaleRequestRspBO.getSaleVoucherId();
            }
            if (null == shipVoucherId) {
                shipVoucherId = uocPebAfterSaleRequestRspBO.getShipVoucherId();
            }
            afterSevIdList.addAll(uocPebAfterSaleRequestRspBO.getAfterServIdList());
            ++successCount;
        }
        rspBO.setRespCode("0000");
        rspBO.setResultDesc("\u90e8\u5206\u65b0\u4eac\u4e1c\u8ba2\u5355\u552e\u540e\u7533\u8bf7\u5931\u8d25!\u5931\u8d25\u90e8\u5206\u53ef\u91cd\u65b0\u8fdb\u884c\u552e\u540e\u7533\u8bf7");
        rspBO.setSaleVoucherId(saleVoucherId);
        rspBO.setShipVoucherId(shipVoucherId);
        rspBO.setAfterServIdList(afterSevIdList);
        return rspBO;
    }

    private void syncServList(Long orderId, Long afterServId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(orderId);
        pebOrdIdxSyncReqBO.setObjId(afterServId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.AFTER_SERVICE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }

    private void syncSaleList(UocPebAfterSaleRequestRspBO rspBO, UocPebAfterSaleRequestReqBO reqBO) {
        UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocPebOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        uocPebOrdIdxSyncReqBO.setObjId(rspBO.getSaleVoucherId());
        uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
    }

    private void syncShipList(UocPebAfterSaleRequestRspBO rspBO, UocPebAfterSaleRequestReqBO reqBO) {
        UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocPebOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        uocPebOrdIdxSyncReqBO.setObjId(rspBO.getShipVoucherId());
        uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
    }

    private void validateParam(UocPebAfterSaleRequestReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getReturnItemList())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010returnItemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocPebEstoreSubmitAfterSaleApplyItemBO submitAfterSaleApplyItemBO : reqBO.getReturnItemList()) {
            if (submitAfterSaleApplyItemBO.getShipItemId() == null) {
                throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010ShipItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (submitAfterSaleApplyItemBO.getSkuId() == null) {
                throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010SkuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)submitAfterSaleApplyItemBO.getSkuName())) continue;
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010SkuName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getServiceType())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010ServiceType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPickwareType() == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010PickwareType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPickwareProvinceId())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010PickwareProvinceId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPickwareProvinceName())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010PickwareProvinceName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPickwareCityId())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010PickwareCityId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPickwareCityName())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010PickwareCityName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPickwareCountyId())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010PickwareCountyId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPickwareCountyName())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010PickwareCountyName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPickwareAddress())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010PickwareAddress\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCustName())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010CustName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCustMobileNumber())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010CustMobileNumber\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRetrunwareProvinceId())) {
            reqBO.setRetrunwareProvinceId(reqBO.getRetrunwareProvinceId());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRetrunwareProvinceName())) {
            reqBO.setRetrunwareProvinceName(reqBO.getPickwareProvinceName());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRetrunwareCityId())) {
            reqBO.setRetrunwareCityId(reqBO.getRetrunwareCityId());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRetrunwareCityName())) {
            reqBO.setRetrunwareCityName(reqBO.getPickwareCityName());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRetrunwareCountyName())) {
            reqBO.setRetrunwareCountyId(reqBO.getRetrunwareCountyName());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRetrunwareCountyName())) {
            reqBO.setRetrunwareCountyName(reqBO.getPickwareCountyName());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRetrunwareTown())) {
            reqBO.setRetrunwareTown(reqBO.getPickwareTown());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRetrunwareAddress())) {
            reqBO.setRetrunwareAddress(reqBO.getPickwareAddress());
        }
    }
}

