/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrderInfoAbilityService;
import com.tydic.uoc.busibase.busi.bo.ChildSaleOrderBO;
import com.tydic.uoc.busibase.busi.bo.QryOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderIdByOutOrderNoAtomService;
import com.tydic.uoc.common.atom.bo.OrdQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderIdByOutOrderNoReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderIdByOutOrderNoRspBO;
import com.tydic.uoc.common.busi.api.PebUpdateSaleStatusBusiService;
import com.tydic.uoc.common.busi.api.UocPebCreateOrdByOrdSplitBusiService;
import com.tydic.uoc.common.busi.bo.UocPebCreateOrdByOrdSplitBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPebCreateOrdByOrdSplitBusiRspBO;
import com.tydic.uoc.common.comb.api.UocPebExtOrderSplitCombService;
import com.tydic.uoc.common.comb.api.UocPebOrdIdxSyncCombService;
import com.tydic.uoc.common.comb.bo.UocPebExtOrderSplitReqBO;
import com.tydic.uoc.common.comb.bo.UocPebExtOrderSplitRspBO;
import com.tydic.uoc.config.OutServiceTemDataService;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebExtOrderSplitCombService")
public class UocPebExtOrderSplitCombServiceImpl
implements UocPebExtOrderSplitCombService {
    private static final Logger log = LoggerFactory.getLogger(UocPebExtOrderSplitCombServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = log.isDebugEnabled();
    private UocCoreQryOrderIdByOutOrderNoAtomService uocCoreQryOrderIdByOutOrderNoAtomService;
    private PebIntfQryOrderInfoAbilityService pebIntfQryOrderInfoAbilityService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    private OrdSaleMapper ordSaleMapper;
    private OutServiceTemDataService outServiceTemDataService;
    private UocPebCreateOrdByOrdSplitBusiService uocPebCreateOrdByOrdSplitCombService;
    @Resource(name="dealCreateInOutOrdReaProvider")
    private ProxyMessageProducer dealCreateInOutOrdReaProvider;
    @Value(value="${isActivationTemp}")
    private boolean isActivationTemp;
    private static final Integer SEARCH_SALE_ORDER_ID_BY_OUT_ORDER_ID = 0;
    private static final Integer SEARCH_ORDER_ID_BY_OUT_ORDER_ID = 1;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private PebUpdateSaleStatusBusiService pebUpdateSaleStatusBusiService;
    @Autowired
    private OrderMapper orderMapper;

    @Autowired
    public UocPebExtOrderSplitCombServiceImpl(PebIntfQryOrderInfoAbilityService pebIntfQryOrderInfoAbilityService, UocCoreQryOrderIdByOutOrderNoAtomService uocCoreQryOrderIdByOutOrderNoAtomService, OrdSaleMapper ordSaleMapper, OutServiceTemDataService outServiceTemDataService, UocPebCreateOrdByOrdSplitBusiService uocPebCreateOrdByOrdSplitCombService, UocPebOrdIdxSyncCombService uocPebOrdIdxSyncCombService) {
        this.pebIntfQryOrderInfoAbilityService = pebIntfQryOrderInfoAbilityService;
        this.uocCoreQryOrderIdByOutOrderNoAtomService = uocCoreQryOrderIdByOutOrderNoAtomService;
        this.ordSaleMapper = ordSaleMapper;
        this.outServiceTemDataService = outServiceTemDataService;
        this.uocPebCreateOrdByOrdSplitCombService = uocPebCreateOrdByOrdSplitCombService;
    }

    @Override
    public UocPebExtOrderSplitRspBO executeExtOrderSplitShip(UocPebExtOrderSplitReqBO uocPebExtOrderSplitReqBO) {
        this.validationParams(uocPebExtOrderSplitReqBO);
        UocPebExtOrderSplitRspBO rspBO = new UocPebExtOrderSplitRspBO();
        UocCoreQryOrderIdByOutOrderNoRspBO orderQueryIndexRspBO = this.getOrderQueryIndex(uocPebExtOrderSplitReqBO.getExtOrderId(), SEARCH_SALE_ORDER_ID_BY_OUT_ORDER_ID);
        if (orderQueryIndexRspBO == null || !"0000".equals(orderQueryIndexRspBO.getRespCode())) {
            throw new UocProBusinessException("103015", "\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5185\u5916\u8ba2\u5355\u5173\u8054\u5173\u7cfb");
        }
        OrdSalePO ordSalePO = this.qryOrdSale(orderQueryIndexRspBO);
        OrdQueryIndexPO indexPO = new OrdQueryIndexPO();
        indexPO.setOrderId(ordSalePO.getOrderId());
        indexPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        List indexPOS = this.ordQueryIndexMapper.getListByPid(indexPO);
        QryOrderRspBO orderRsp = this.getExtOrderInfo(uocPebExtOrderSplitReqBO, orderQueryIndexRspBO.getOrderId());
        List childSaleOrderList = orderRsp.getChildSaleOrderList();
        ArrayList<String> outId = new ArrayList<String>();
        for (Object orderBO : childSaleOrderList) {
            outId.add(orderBO.getOrderId());
        }
        ArrayList<String> outNo = new ArrayList<String>();
        for (OrdQueryIndexPO idx : indexPOS) {
            outNo.add(idx.getOutOrderNo());
            if (outId.contains(idx.getOutOrderNo())) continue;
            PebDealOrderBO bo = new PebDealOrderBO();
            bo.setOrderId(idx.getOrderId());
            bo.setSaleVoucherId(idx.getObjId());
            try {
                this.pebUpdateSaleStatusBusiService.dealUpdate(bo);
                this.syncPebIndex(bo.getOrderId(), bo.getSaleVoucherId());
            }
            catch (Exception ignored) {
                log.error("\u4e8c\u6b21\u62c6\u5355\u7684\u8ba2\u5355\u5904\u7406\u5931\u8d25:" + JSON.toJSONString((Object)idx));
            }
        }
        int count = 0;
        for (ChildSaleOrderBO childSaleOrderRspBO : childSaleOrderList) {
            ++count;
            if (outNo.contains(childSaleOrderRspBO.getOrderId())) continue;
            UocPebCreateOrdByOrdSplitBusiReqBO createOrdByOrdSplitBusiReqBO = new UocPebCreateOrdByOrdSplitBusiReqBO();
            createOrdByOrdSplitBusiReqBO.setOrderId(ordSalePO.getOrderId());
            createOrdByOrdSplitBusiReqBO.setSaleId(ordSalePO.getSaleVoucherId());
            createOrdByOrdSplitBusiReqBO.setChildSaleOrderRspBO(childSaleOrderRspBO);
            createOrdByOrdSplitBusiReqBO.setCount(count);
            UocPebCreateOrdByOrdSplitBusiRspBO uocPebCreateOrdByOrdSplitBusiRspBO = this.uocPebCreateOrdByOrdSplitCombService.createOrder(createOrdByOrdSplitBusiReqBO);
            if (null == uocPebCreateOrdByOrdSplitBusiRspBO || !"0000".equals(uocPebCreateOrdByOrdSplitBusiRspBO.getRespCode())) continue;
            this.syncPebIndex(uocPebCreateOrdByOrdSplitBusiRspBO.getOrderId(), uocPebCreateOrdByOrdSplitBusiRspBO.getSaleVoucherId());
            PebDealOrderBO bo = new PebDealOrderBO();
            bo.setOrderId(uocPebCreateOrdByOrdSplitBusiRspBO.getOrderId());
            bo.setPorderId(uocPebExtOrderSplitReqBO.getOrderId());
            this.pebUpdateSaleStatusBusiService.updatePayConfig(bo);
        }
        this.syncPebIndex(ordSalePO.getOrderId(), ordSalePO.getSaleVoucherId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u62c6\u5206\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u670d\u52a1\u6267\u884c\u6210\u529f");
        return rspBO;
    }

    private void syncPebIndex(Long orderId, Long saleId) {
        UocPebOrdIdxSyncReqBO idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        idxSyncReqBO.setOrderId(orderId);
        idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        idxSyncReqBO.setObjId(saleId);
        idxSyncReqBO.setProIdxFlag(Integer.valueOf(1));
        idxSyncReqBO.setPurIdxFlag(Integer.valueOf(1));
        idxSyncReqBO.setSupIdxFlag(Integer.valueOf(1));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
    }

    private void validationParams(UocPebExtOrderSplitReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u5165\u53c2\u5bf9\u8c61[UocPebExtOrderSplitReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getExtOrderId())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u5916\u90e8\u8ba2\u5355\u53f7[extOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null || reqBO.getSupplierId() == 0L) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u4f9b\u5e94\u5546\u7f16\u53f7[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocCoreQryOrderIdByOutOrderNoRspBO getOrderQueryIndex(String extOrderId, Integer searchType) {
        UocCoreQryOrderIdByOutOrderNoReqBO uocCoreQryOrderIdByOutOrderNoReqBO = new UocCoreQryOrderIdByOutOrderNoReqBO();
        uocCoreQryOrderIdByOutOrderNoReqBO.setOutOrderNo(extOrderId);
        uocCoreQryOrderIdByOutOrderNoReqBO.setOrderSystem(String.valueOf(PecConstant.OBJECT_TYPE_ORDER_SALE));
        return this.uocCoreQryOrderIdByOutOrderNoAtomService.qryOrderIdByOutOrderNo(uocCoreQryOrderIdByOutOrderNoReqBO);
    }

    private void getExtOrder(List<ChildSaleOrderBO> childSaleOrderList, Long supNo, List<ChildSaleOrderBO> list) {
        ArrayList<ChildSaleOrderBO> child = new ArrayList<ChildSaleOrderBO>();
        for (ChildSaleOrderBO orderBO : childSaleOrderList) {
            QryOrderReqBO qryOrderReqBO = new QryOrderReqBO();
            qryOrderReqBO.setOrderId(orderBO.getOrderId());
            qryOrderReqBO.setSupplierId(supNo);
            QryOrderRspBO orderRsp = this.pebIntfQryOrderInfoAbilityService.selectOrderInfo(qryOrderReqBO);
            if (!"0000".equals(orderRsp.getRespCode())) {
                throw new UocProBusinessException("103015", "\u8ba2\u5355\u62c6\u5355\u4e1a\u52a1\u5931\u8d25\uff1a" + orderRsp.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)orderRsp.getChildSaleOrderList())) {
                list.add(orderBO);
                continue;
            }
            child.addAll(orderRsp.getChildSaleOrderList());
        }
        if (CollectionUtils.isNotEmpty(child)) {
            this.getExtOrder(child, supNo, list);
        }
    }

    private QryOrderRspBO getExtOrderInfo(UocPebExtOrderSplitReqBO reqBO, Long orderId) {
        QryOrderRspBO orderRsp;
        QryOrderReqBO qryOrderReqBO = new QryOrderReqBO();
        qryOrderReqBO.setOrderId(reqBO.getExtOrderId());
        qryOrderReqBO.setSupplierId(reqBO.getSupplierId());
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(reqBO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            qryOrderReqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((orderRsp = !this.isActivationTemp ? this.pebIntfQryOrderInfoAbilityService.selectOrderInfo(qryOrderReqBO) : this.outServiceTemDataService.qryTempleteDataByServiceType(1, orderId, reqBO.getExtOrderId()).getOrderRsp()).getRespCode())) {
            throw new UocProBusinessException("103015", "\u8ba2\u5355\u62c6\u5355\u4e1a\u52a1\u5931\u8d25\uff1a" + orderRsp.getRespDesc());
        }
        if (orderRsp.getParentSaleOrderRspBO() == null) {
            throw new UocProBusinessException("103015", "\u8ba2\u5355\u62c6\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u6ca1\u6709\u5916\u90e8\u7236\u5355\u8bb0\u5f55!");
        }
        if (CollectionUtils.isEmpty((Collection)orderRsp.getChildSaleOrderList())) {
            throw new UocProBusinessException("103015", "\u8ba2\u5355\u62c6\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u6ca1\u6709\u5916\u90e8\u5b50\u5355\u8bb0\u5f55!");
        }
        return orderRsp;
    }

    private OrdSalePO qryOrdSale(UocCoreQryOrderIdByOutOrderNoRspBO reqBO) {
        try {
            OrdSalePO ordSaleModel = new OrdSalePO();
            ordSaleModel.setOrderId(reqBO.getOrderId());
            ordSaleModel.setSaleVoucherId(reqBO.getObjId());
            OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(ordSaleModel);
            if (ordSalePO == null) {
                throw new UocProBusinessException("103015", "\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f!");
            }
            return ordSalePO;
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u8ba2\u5355\u6570\u636e\u5e93\u5f02\u5e38!", (Throwable)e);
            throw new UocProBusinessException("103015", "\u8ba2\u5355\u62c6\u6210\u53d1\u8d27\u5355\u4e1a\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u6570\u636e\u5e93\u5f02\u5e38!");
        }
    }

    private void sendCreateInOutOrderRelationMQMsg(Long orderId, Long saleVoucherId, String outOrderNo) {
        OrdQueryReqBO ordQueryReqBO = new OrdQueryReqBO();
        ordQueryReqBO.setOrderId(orderId);
        ordQueryReqBO.setObjId(saleVoucherId);
        ordQueryReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        ordQueryReqBO.setOutOrderNo(outOrderNo);
        ordQueryReqBO.setOrderSystem(String.valueOf(PecConstant.OBJECT_TYPE_ORDER_SALE));
        this.dealCreateInOutOrdReaProvider.send(new ProxyMessage(OrderPropertiesUtil.getProperty((String)"UOC_CREATE_IN_ORDER_RELATION_TOPIC"), OrderPropertiesUtil.getProperty((String)"UOC_CREATE_IN_ORDER_RELATION_TAG"), JSON.toJSONString((Object)((Object)ordQueryReqBO))));
        if (this.IS_DEBUG_ENABLED) {
            log.debug("\u5916\u90e8\u8ba2\u5355\u62c6\u6210\u5b50\u8ba2\u5355\u4e1a\u52a1\u4e2d\u6d88\u606f\u961f\u5217\u53d1\u9001\u6210\u529f!!!!!!!!!");
        }
    }
}

