/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebDistributionAbilityService;
import com.tydic.uoc.common.ability.bo.OrdInspectionRspBO;
import com.tydic.uoc.common.ability.bo.PebDistributionReqBO;
import com.tydic.uoc.common.ability.bo.PebDistributionRspBO;
import com.tydic.uoc.common.ability.bo.UocDistributionBO;
import com.tydic.uoc.common.busi.api.PebDistributionBusiService;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebDistributionAbilityService"})
public class PebDistributionAbilityServiceImpl
implements PebDistributionAbilityService {
    @Autowired
    private PebDistributionBusiService pebDistributionBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @PostMapping(value={"dealDistribution"})
    public PebDistributionRspBO dealDistribution(@RequestBody PebDistributionReqBO reqBO) {
        PebDistributionRspBO rspBO = this.pebDistributionBusiService.dealDistribution(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            PebExtOrdIdxSyncReqBO syncReqBO;
            for (UocDistributionBO bo : reqBO.getUocDistributionList()) {
                syncReqBO = new PebExtOrdIdxSyncReqBO();
                syncReqBO.setObjId(bo.getSaleVoucherId());
                syncReqBO.setOrderId(bo.getOrderId());
                syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)syncReqBO))));
            }
            if (!CollectionUtils.isEmpty((Collection)rspBO.getInspectionRspBOS())) {
                for (OrdInspectionRspBO inspectionRspBO : rspBO.getInspectionRspBOS()) {
                    syncReqBO = new PebExtOrdIdxSyncReqBO();
                    syncReqBO.setObjId(inspectionRspBO.getInspectionVoucherId());
                    syncReqBO.setOrderId(inspectionRspBO.getOrderId());
                    syncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
                    this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)syncReqBO))));
                }
            }
        }
        return rspBO;
    }

    @PostMapping(value={"qryDistribution"})
    public PebDistributionRspBO qryDistribution(@RequestBody PebDistributionReqBO reqBO) {
        return this.pebDistributionBusiService.qryDistribution(reqBO);
    }

    @PostMapping(value={"qryOrderCount"})
    public PebDistributionRspBO qryOrderCount(@RequestBody PebDistributionReqBO reqBO) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        Date date = DateUtils.strToDate((String)(year + "-01-01"));
        OrdSalePO salePO = new OrdSalePO();
        salePO.setCreateTime(date);
        int count = this.ordSaleMapper.getOrderCount(salePO);
        PebDistributionRspBO rspBO = new PebDistributionRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setCount(Integer.valueOf(count));
        return rspBO;
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        int dow = cal.get(7);
        int dom = cal.get(5);
        int doy = cal.get(6);
        Date date = DateUtils.strToDate((String)(year + "-01-01"));
        System.out.println(date);
    }
}

