/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtAgreementCancelAbilityService;
import com.tydic.uoc.common.ability.api.UocPebOrderCancellationAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtAgreementCancelAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementCancelAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancellationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancellationAbilityRspBO;
import com.tydic.uoc.common.busi.api.PebExtCancelBusiService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtAgreementCancelAbilityService"})
public class PebExtAgreementCancelAbilityServiceImpl
implements PebExtAgreementCancelAbilityService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocPebOrderCancellationAbilityService uocPebOrderCancellationAbilityService;
    @Autowired
    private PebExtCancelBusiService pebExtCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;

    @PostMapping(value={"agreementCancel"})
    public PebExtAgreementCancelAbilityRspBO agreementCancel(@RequestBody PebExtAgreementCancelAbilityReqBO reqBO) {
        if (!StringUtils.isEmpty((Object)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        PebExtAgreementCancelAbilityRspBO rspBO = new PebExtAgreementCancelAbilityRspBO();
        this.validateParam(reqBO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null == ordSalePO) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u9500\u552e\u5355\u4fe1\u606f");
        }
        if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(ordSalePO.getSaleState()) && !PebExtConstant.YES.equals(reqBO.getIsSupAudit())) {
            PebExtCancelReqBO pebExtCancelReqBO = (PebExtCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebExtCancelReqBO.class);
            pebExtCancelReqBO.setCancelReason(reqBO.getCancelReson());
            PebExtCancelRspBO pebExtCancelRspBO = this.pebExtCancelBusiService.dealOrderCancelled(pebExtCancelReqBO);
            if (!"0000".equals(pebExtCancelRspBO.getRespCode())) {
                throw new UocProBusinessException(pebExtCancelRspBO.getRespCode(), pebExtCancelRspBO.getRespDesc());
            }
            UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
            uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
            if (!StringUtils.isEmpty((Object)pebExtCancelRspBO.getReqJsonStr())) {
                this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, pebExtCancelRspBO.getReqJsonStr()));
            }
        } else {
            UocPebOrderCancellationAbilityRspBO cancellationAbilityRspBO = this.uocPebOrderCancellationAbilityService.dealPebOrderCancellation((UocPebOrderCancellationAbilityReqBO)reqBO);
            if (!"0000".equals(cancellationAbilityRspBO.getRespCode())) {
                throw new UocProBusinessException(cancellationAbilityRspBO.getRespCode(), cancellationAbilityRspBO.getRespDesc());
            }
            rspBO.setRespCode(cancellationAbilityRspBO.getRespCode());
            rspBO.setRespDesc(cancellationAbilityRspBO.getRespDesc());
        }
        return rspBO;
    }

    private void validateParam(PebExtAgreementCancelAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null || 0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u8ba2\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSaleVoucherId() == null || 0L == reqBO.getSaleVoucherId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u9500\u552e\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCancelReson())) {
            throw new UocProBusinessException("100001", "\u3010\u53d6\u6d88\u539f\u56e0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

