/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.annotation.OrderFlowLog;
import com.tydic.uoc.common.ability.annotation.OrderLogRecord;
import com.tydic.uoc.common.ability.api.PebExtAgreementCancelAbilityService;
import com.tydic.uoc.common.ability.api.PebExtCancelAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtAgreementCancelAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementCancelAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.busi.api.PebExtCancelBusiService;
import com.tydic.uoc.common.comb.api.UocPebOrderCancelCombService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtCancelAbilityService"})
public class PebExtCancelAbilityServiceImpl
implements PebExtCancelAbilityService {
    @Autowired
    private PebExtCancelBusiService pebExtCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocPebOrderCancelCombService uocPebOrderCancelCombService;
    @Autowired
    private PebExtAgreementCancelAbilityService pebExtAgreementCancelAbilityService;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;

    @OrderLogRecord(description="\u53d6\u6d88")
    @OrderFlowLog(operationLink="\u53d6\u6d88\u8ba2\u5355", description="\u53d6\u6d88\u8ba2\u5355")
    @PostMapping(value={"dealOrderCancelled"})
    public PebExtCancelRspBO dealOrderCancelled(@RequestBody PebExtCancelReqBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        this.val(reqBO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(salePO.getOrderSource())) {
            PebExtAgreementCancelAbilityReqBO abilityReqBO = (PebExtAgreementCancelAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebExtAgreementCancelAbilityReqBO.class);
            abilityReqBO.setCancelReson(reqBO.getCancelReason());
            PebExtAgreementCancelAbilityRspBO abilityRspBO = this.pebExtAgreementCancelAbilityService.agreementCancel(abilityReqBO);
            PebExtCancelRspBO rspBO = new PebExtCancelRspBO();
            BeanUtils.copyProperties((Object)abilityRspBO, (Object)rspBO);
            return rspBO;
        }
        PebExtCancelRspBO rspBO = this.pebExtCancelBusiService.dealOrderCancelled(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
                this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
            }
            if (!rspBO.getPush().booleanValue()) {
                UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)cancelReqBO);
                cancelReqBO.setCancelDesc(reqBO.getCancelReason());
                cancelReqBO.setCancelDesc(reqBO.getCancelReason());
                cancelReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
                this.uocPebOrderCancelCombService.dealOrderCancel(cancelReqBO);
            }
            if (null == reqBO.getIsSync() || reqBO.getIsSync().booleanValue()) {
                UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
                syncReqBO.setObjId(reqBO.getSaleVoucherId());
                syncReqBO.setOrderId(reqBO.getOrderId());
                syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
            }
        }
        return rspBO;
    }

    private void val(PebExtCancelReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

