/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityRspBO;
import com.tydic.uoc.common.busi.api.PebExtOrderSettleTypeUpdateBusiService;
import com.tydic.uoc.common.busi.bo.PebExtOrderSettleTypeUpdateBusiReqBO;
import com.tydic.uoc.common.busi.bo.PebExtOrderSettleTypeUpdateBusiRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdSalePO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService"})
public class PebExtOrderSettleTypeUpdateAbilityServiceImpl
implements PebExtOrderSettleTypeUpdateAbilityService {
    @Autowired
    private PebExtOrderSettleTypeUpdateBusiService pebExtOrderSettleTypeUpdateBusiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    @PostMapping(value={"dealOrderSettleType"})
    public PebExtOrderSettleTypeUpdateAbilityRspBO dealOrderSettleType(@RequestBody PebExtOrderSettleTypeUpdateAbilityReqBO reqBO) {
        String reqString = JSONObject.toJSONString((Object)reqBO);
        PebExtOrderSettleTypeUpdateBusiReqBO busiReqBO = (PebExtOrderSettleTypeUpdateBusiReqBO)((Object)JSONObject.parseObject((String)reqString, PebExtOrderSettleTypeUpdateBusiReqBO.class));
        PebExtOrderSettleTypeUpdateBusiRspBO busiRspBO = this.pebExtOrderSettleTypeUpdateBusiService.dealOrderSettleType(busiReqBO);
        if (!CollectionUtils.isEmpty(busiRspBO.getOrderIdList())) {
            this.sendMq(busiRspBO.getOrderIdList());
        }
        return (PebExtOrderSettleTypeUpdateAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), PebExtOrderSettleTypeUpdateAbilityRspBO.class);
    }

    private void sendMq(List<Long> orderIdList) {
        OrdSalePO salePo = new OrdSalePO();
        salePo.setOrderIdList(orderIdList);
        List list = this.ordSaleMapper.getList(salePo);
        for (OrdSalePO salePO : list) {
            UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdSaleIdxSyncReqBO.setObjId(salePO.getSaleVoucherId());
            uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            uocOrdSaleIdxSyncReqBO.setOrderId(salePO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
        }
        OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
        ordInspectionPO.setOrderIdList(orderIdList);
        List inspectionList = this.ordInspectionMapper.getList(ordInspectionPO);
        for (OrdInspectionPO inspectionPO : inspectionList) {
            UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdSaleIdxSyncReqBO.setObjId(inspectionPO.getInspectionVoucherId());
            uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
            uocOrdSaleIdxSyncReqBO.setOrderId(inspectionPO.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
        }
    }
}

