/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import com.tydic.uoc.common.ability.api.UocGeneralCirculationAbilityService;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocGeneralCirculationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocOrdItemUpdateBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebUpdateOrderBusiService;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService"})
public class PebUpdateOrderAbilityServiceImpl
implements PebUpdateOrderAbilityService {
    @Autowired
    private PebUpdateOrderBusiService pebUpdateOrderBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocGeneralCirculationAbilityService uocGeneralCirculationAbilityService;

    @PostMapping(value={"updateOrder"})
    public PebUpdateOrderRspBO updateOrder(@RequestBody PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateOrder(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    @PostMapping(value={"updateOrderArrivalTime"})
    public PebUpdateOrderRspBO updateOrderArrivalTime(@RequestBody PebUpdateOrderReqBO reqBO) {
        this.validateParam(reqBO);
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateOrderArrivalTime(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    private void validateParam(PebUpdateOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTempOrderId() == null && reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[tempOrderId]\u548c[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderItemArrivalTime())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderItemArrivalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsUpdateAllArrivalTime() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[isUpdateAllArrivalTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsUpdateAllArrivalTime() != 1 && reqBO.getIsUpdateAllArrivalTime() != 2) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[isUpdateAllArrivalTime]\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    @PostMapping(value={"updateOrderByRecover"})
    public PebUpdateOrderRspBO updateOrderByRecover(@RequestBody PebUpdateOrderReqBO reqBO) {
        this.validate(reqBO);
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateOrderByRecover(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            UocGeneralCirculationAbilityReqBO abilityReqBO = new UocGeneralCirculationAbilityReqBO();
            this.sync(reqBO);
        }
        return rspBO;
    }

    private void validate(PebUpdateOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrdItemUpdateList())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[ordItemUpdateList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocOrdItemUpdateBO uocOrdItemUpdateBO : reqBO.getOrdItemUpdateList()) {
            if (uocOrdItemUpdateBO.getOrdItemId() == null) {
                throw new UocProBusinessException("8888", "\u5165\u53c2[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (uocOrdItemUpdateBO.getPurchaseCount() != null) continue;
            throw new UocProBusinessException("8888", "\u5165\u53c2[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @PostMapping(value={"updateHt"})
    public PebUpdateOrderRspBO updateHt(@RequestBody PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateHt(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    @PostMapping(value={"updateFscStatus"})
    public PebUpdateOrderRspBO updateFscStatus(@RequestBody PebUpdateOrderReqBO reqBO) {
        PebUpdateOrderRspBO rspBO = this.pebUpdateOrderBusiService.updateFscStatus(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.sync(reqBO);
        }
        return rspBO;
    }

    private void sync(PebUpdateOrderReqBO reqBO) {
        UocPebOrdIdxSyncReqBO idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        idxSyncReqBO.setOrderId(reqBO.getOrderId());
        idxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)idxSyncReqBO)));
    }
}

