/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.api.UocOrderInspectionDetailQryAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderInspectionDetailReqBO;
import com.tydic.uoc.common.ability.bo.UocOrderInspectionDetailRsqBO;
import com.tydic.uoc.common.ability.bo.UocOrderInspectionItemDetailRspBO;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocOrderInspectionDetailQryAbilityService"})
public class UocOrderInspectionDetailQryAbilityServiceImpl
implements UocOrderInspectionDetailQryAbilityService {
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdSaleMapper OrdSaleMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper OrdGoodsMapper;

    @PostMapping(value={"qryInspectionDetail"})
    public UocOrderInspectionDetailRsqBO qryInspectionDetail(@RequestBody UocOrderInspectionDetailReqBO reqBO) {
        UocOrderInspectionDetailRsqBO rspBO = new UocOrderInspectionDetailRsqBO();
        this.validateParams(reqBO);
        OrdInspectionPO ordInspectionPO = this.ordInspectionMapper.getModelById(reqBO.getInspectionVoucherId().longValue());
        if (ordInspectionPO == null) {
            throw new UocProBusinessException("100001", "\u9a8c\u6536\u5355id\u9519\u8bef\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        OrdSalePO ordSalePO = this.OrdSaleMapper.getModelById(ordInspectionPO.getSaleVoucherId().longValue());
        OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
        ordInspectionItemPO.setOrderId(reqBO.getOrderId());
        ordInspectionItemPO.setInspectionVoucherId(reqBO.getInspectionVoucherId());
        List ordInspectionItemPOS = this.ordInspectionItemMapper.getList(ordInspectionItemPO);
        ArrayList<UocOrderInspectionItemDetailRspBO> inspectionItemList = new ArrayList<UocOrderInspectionItemDetailRspBO>();
        HashSet<Long> orderItems = new HashSet<Long>();
        if (!CollectionUtils.isEmpty((Collection)ordInspectionItemPOS)) {
            for (OrdInspectionItemPO inspectionItemPO : ordInspectionItemPOS) {
                UocOrderInspectionItemDetailRspBO uocOrderInspectionItemDetailRspBO = new UocOrderInspectionItemDetailRspBO();
                BeanUtils.copyProperties((Object)inspectionItemPO, (Object)uocOrderInspectionItemDetailRspBO);
                inspectionItemList.add(uocOrderInspectionItemDetailRspBO);
                if (inspectionItemPO.getOrdItemId() == null) continue;
                orderItems.add(inspectionItemPO.getOrdItemId());
            }
        }
        if (!CollectionUtils.isEmpty(orderItems) && !CollectionUtils.isEmpty(inspectionItemList)) {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrdItemIdList(new ArrayList(orderItems));
            ordItemPO.setOrderId(reqBO.getOrderId());
            List ordItemPOS = this.ordItemMapper.getList(ordItemPO);
            Map<Object, Object> itemMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)ordItemPOS)) {
                itemMap = ordItemPOS.stream().collect(Collectors.toMap(e -> e.getOrdItemId(), e -> e, (k, v) -> k));
            }
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrderId(reqBO.getOrderId());
            ordGoodsPO.setOrdItemIdList(new ArrayList(orderItems));
            List ordGoodsPOS = this.OrdGoodsMapper.getList(ordGoodsPO);
            Map<Object, Object> goodsMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)ordGoodsPOS)) {
                goodsMap = ordGoodsPOS.stream().collect(Collectors.toMap(e -> e.getOrdItemId(), e -> e, (k, v) -> k));
            }
            for (UocOrderInspectionItemDetailRspBO uocOrderInspectionItemDetailRspBO : inspectionItemList) {
                OrdItemPO queryItem = (OrdItemPO)itemMap.get(uocOrderInspectionItemDetailRspBO.getOrdItemId());
                OrdGoodsPO queryGoods = (OrdGoodsPO)goodsMap.get(uocOrderInspectionItemDetailRspBO.getOrdItemId());
                if (queryItem != null) {
                    uocOrderInspectionItemDetailRspBO.setSkuMaterialLongDesc(queryItem.getExtField2());
                    uocOrderInspectionItemDetailRspBO.setPlanItemNo(queryItem.getPlanItemNo());
                    uocOrderInspectionItemDetailRspBO.setSalePrice(queryItem.getSalePrice());
                    uocOrderInspectionItemDetailRspBO.setPurchasePrice(queryItem.getPurchasePrice());
                    BigDecimal inspectionCountTotal = this.ifNull(uocOrderInspectionItemDetailRspBO.getAlreadyReturnCount()).add(this.ifNull(uocOrderInspectionItemDetailRspBO.getInspectionCount()));
                    uocOrderInspectionItemDetailRspBO.setInspectionCountTotal(inspectionCountTotal);
                    uocOrderInspectionItemDetailRspBO.setSurplusInspectionCount(this.ifNull(uocOrderInspectionItemDetailRspBO.getInspectionCount()));
                    try {
                        uocOrderInspectionItemDetailRspBO.setSalePriceMoney(MoneyUtil.b8B((BigDecimal)queryItem.getSaleDecimalPrice()));
                        uocOrderInspectionItemDetailRspBO.setPurchasePriceMoney(MoneyUtil.b8B((BigDecimal)queryItem.getPurchaseDecimalPrice()));
                        uocOrderInspectionItemDetailRspBO.setTotalSaleFee(Long.valueOf(new BigDecimal(queryItem.getSalePrice()).multiply(inspectionCountTotal).longValue()));
                        uocOrderInspectionItemDetailRspBO.setPurchasePrice(Long.valueOf(new BigDecimal(queryItem.getPurchasePrice()).multiply(inspectionCountTotal).longValue()));
                        uocOrderInspectionItemDetailRspBO.setTotalSaleFeeMoney(MoneyUtil.b8B((BigDecimal)uocOrderInspectionItemDetailRspBO.getTotalSaleFeeMoney()));
                        uocOrderInspectionItemDetailRspBO.setTotalPurchaseFeeMoney(MoneyUtil.b8B((BigDecimal)uocOrderInspectionItemDetailRspBO.getTotalPurchaseFeeMoney()));
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (queryGoods == null) continue;
                uocOrderInspectionItemDetailRspBO.setPicUrl(queryGoods.getSkuMainPicUrl());
                uocOrderInspectionItemDetailRspBO.setSkuMaterialId(queryGoods.getSkuMaterialId());
                uocOrderInspectionItemDetailRspBO.setSkuCode(queryGoods.getSkuCode());
                uocOrderInspectionItemDetailRspBO.setSkuName(queryGoods.getSkuName());
                uocOrderInspectionItemDetailRspBO.setSkuExtSkuId(queryGoods.getSkuExtSkuId());
                uocOrderInspectionItemDetailRspBO.setSkuUpcCode(queryGoods.getSkuUpcCode());
                uocOrderInspectionItemDetailRspBO.setPlanMaterialCode(queryGoods.getExt4());
                uocOrderInspectionItemDetailRspBO.setPlanMaterialDesc(queryGoods.getExt6());
                uocOrderInspectionItemDetailRspBO.setSkuId(Long.valueOf(Long.parseLong(queryGoods.getSkuId())));
            }
        }
        if (ordSalePO != null) {
            rspBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        }
        rspBO.setSaleVoucherNo(ordSalePO.getSaleVoucherNo());
        rspBO.setInspectionVoucherId(ordInspectionPO.getInspectionVoucherId());
        rspBO.setInspectionVoucherCode(ordInspectionPO.getInspectionVoucherCode());
        rspBO.setInspectionItemList(inspectionItemList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    BigDecimal ifNull(BigDecimal num) {
        if (num == null) {
            return BigDecimal.ZERO;
        }
        return num;
    }

    private void validateParams(UocOrderInspectionDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u9a8c\u6536\u5355\u8be6\u60c5\u67e5\u8be2API\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInspectionVoucherId() == null) {
            throw new UocProBusinessException("100001", "\u9a8c\u6536\u5355\u8be6\u60c5\u67e5\u8be2API\u5165\u53c2\u3010inspectionVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "\u9a8c\u6536\u5355\u8be6\u60c5\u67e5\u8be2API\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

