/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocPayConfChangeAbilityService;
import com.tydic.uoc.common.ability.bo.UocPayConfChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPayConfChangeAbilityRspBO;
import com.tydic.uoc.common.busi.api.UocPayConfChangeBusiService;
import com.tydic.uoc.common.busi.bo.UocPayConfChangeBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocPayConfChangeBusiRspBo;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrderRelMapper;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrderRelPO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocPayConfChangeAbilityService"})
public class UocPayConfChangeAbilityServiceImpl
implements UocPayConfChangeAbilityService {
    @Autowired
    private UocPayConfChangeBusiService uocPayConfChangeBusiService;
    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    @PostMapping(value={"payConfChange"})
    public UocPayConfChangeAbilityRspBO payConfChange(@RequestBody UocPayConfChangeAbilityReqBO reqBO) {
        this.validateParams(reqBO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherNo(reqBO.getOrderCode());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (ordSalePO == null) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        UocOrderRelPO uocOrderRelPO = new UocOrderRelPO();
        uocOrderRelPO.setOrderId(reqBO.getOrderId());
        uocOrderRelPO.setRelType(Integer.valueOf(0));
        uocOrderRelPO.setRelStatus(Integer.valueOf(1));
        List list = this.uocOrderRelMapper.getList(uocOrderRelPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u5df2\u5f00\u7968\uff0c\u4e0d\u80fd\u8fdb\u884c\u53d8\u66f4");
        }
        UocPayConfChangeBusiReqBo busiReqBo = (UocPayConfChangeBusiReqBo)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), UocPayConfChangeBusiReqBo.class));
        UocPayConfChangeBusiRspBo busiRspBo = this.uocPayConfChangeBusiService.payConfChange(busiReqBo);
        UocPayConfChangeAbilityRspBO rspBO = (UocPayConfChangeAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBo)), UocPayConfChangeAbilityRspBO.class);
        reqBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        this.dealEsOrderList(reqBO);
        OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
        ordInspectionPO.setOrderId(reqBO.getOrderId());
        List ordInspectionPOS = this.ordInspectionMapper.getList(ordInspectionPO);
        if (!CollectionUtils.isEmpty((Collection)ordInspectionPOS)) {
            for (OrdInspectionPO po : ordInspectionPOS) {
                this.dealEsInspectionList(reqBO.getOrderId(), po.getInspectionVoucherId());
            }
        }
        return rspBO;
    }

    private void validateParams(UocPayConfChangeAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOrderCode())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderAmount() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355\u91d1\u989d\u3010orderAmount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderState() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355\u72b6\u6001\u3010orderState\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UocConstant.SALE_ORDER_STATUS.CANCEL.equals(reqBO.getOrderState()) || UocConstant.SALE_ORDER_STATUS.DELETED.equals(reqBO.getOrderState()) || UocConstant.SALE_ORDER_STATUS.CANCEL_ORDER_REQUEST.equals(reqBO.getOrderState()) || UocConstant.SALE_ORDER_STATUS.REJECTED_ORDER.equals(reqBO.getOrderState()) || UocConstant.SALE_ORDER_STATUS.ORDER_FAILED.equals(reqBO.getOrderState()) || UocConstant.SALE_ORDER_STATUS.ORDER_DELETE.equals(reqBO.getOrderState())) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4");
        }
        if (reqBO.getChangeType() == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u7c7b\u578b\u3010changeType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UocCoreConstant.PayConfChangeType.TO_ADVANCE.equals(reqBO.getChangeType()) && UocCoreConstant.PayConfChangeType.TO_CREDIT.equals(reqBO.getChangeType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7c7b\u578b[changeType]\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u53ea\u5141\u8bb81\uff08\u8d26\u671f\u53d8\u9884\u5b58\uff09\u6216\u80052\uff08\u9884\u5b58\u53d8\u8d26\u671f\uff09!");
        }
        if (reqBO.getOrderType() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getOrderType() != 0) {
            throw new FscBusinessException("191000", "\u53ea\u6709\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u624d\u80fd\u53d8\u66f4\u4ed8\u6b3e\u65b9\u5f0f");
        }
    }

    private void dealEsOrderList(UocPayConfChangeAbilityReqBO rspBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(rspBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjId(rspBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void dealEsInspectionList(Long orderId, Long inspectionVoucherId) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(orderId);
        uocOrdIdxSyncReqBO.setObjId(inspectionVoucherId);
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }
}

