/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocProOrderDeleteAbilityService;
import com.tydic.uoc.common.ability.bo.PlanDiversionSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocProOrderDeleteAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderDeleteAbilityRspBo;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.busi.api.UocProOrderDeleteBusiService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderDeleteAbilityService"})
public class UocProOrderDeleteAbilityServiceImpl
implements UocProOrderDeleteAbilityService {
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocProOrderDeleteBusiService uocProOrderDeleteBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="planDiversionSyncMsgProvider")
    private ProxyMessageProducer planDiversionSyncMsgProvider;
    @Value(value="${PLAN_DIVERSION_SYNC_TOPIC:PLAN_DIVERSION_SYNC_TOPIC}")
    private String planDiversionSyncTopic;
    @Value(value="${PLAN_DIVERSION_SYNC_TAG:*}")
    private String planTag;

    @PostMapping(value={"deleteOrder"})
    public UocProOrderDeleteAbilityRspBo deleteOrder(@RequestBody UocProOrderDeleteAbilityReqBo reqBo) {
        UocProOrderDeleteAbilityRspBo rspBo;
        this.validateArgs(reqBo);
        this.stateCheck(reqBo);
        if (null == reqBo.getUserId() || 0L == reqBo.getUserId()) {
            reqBo.setUserId(reqBo.getUserIdIn());
        }
        if (!"0000".equals((rspBo = this.uocProOrderDeleteBusiService.deleteOrder(reqBo)).getRespCode())) {
            throw new UocProBusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
        }
        this.syncSale(reqBo);
        if (rspBo.getPlanId() != null) {
            PlanDiversionSyncReqBO syncReqBO = new PlanDiversionSyncReqBO();
            syncReqBO.setPlanIds(rspBo.getPlanId());
            this.planDiversionSyncMsgProvider.send(new ProxyMessage(this.planDiversionSyncTopic, this.planTag, JSON.toJSONString((Object)syncReqBO)));
        }
        return rspBo;
    }

    private void validateArgs(UocProOrderDeleteAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104039", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId() || 0L == reqBo.getOrderId()) {
            throw new UocProBusinessException("104039", "\u5165\u53c2\u5bf9\u8c61[orderId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleVoucherId() || 0L == reqBo.getSaleVoucherId()) {
            throw new UocProBusinessException("104039", "\u5165\u53c2\u5bf9\u8c61[saleVoucherId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void stateCheck(UocProOrderDeleteAbilityReqBo reqBo) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setActionCode("ORDER_DELETE");
        uocCoreStateCheckAtomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setObjId(reqBo.getSaleVoucherId());
        uocCoreStateCheckAtomReqBO.setOrderId(reqBo.getOrderId());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8be5\u8ba2\u5355\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664\u64cd\u4f5c");
        }
        reqBo.setSaleState(Integer.valueOf(uocCoreStateCheck.getObjState()));
    }

    private void syncSale(UocProOrderDeleteAbilityReqBo reqBo) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(reqBo.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

