/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.PebInOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebInOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdRhItemBO;
import com.tydic.uoc.common.ability.bo.UocOrdSaleRspBO;
import com.tydic.uoc.common.atom.api.UocProShouldPayOrDeductDealAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.PebInOrderBusiService;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdConfirmItemMapper;
import com.tydic.uoc.dao.UocOrdConfirmMapper;
import com.tydic.uoc.dao.UocOrdRhInfoMapper;
import com.tydic.uoc.dao.UocOrdRhItemMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdConfirmItemPO;
import com.tydic.uoc.po.UocOrdConfirmPO;
import com.tydic.uoc.po.UocOrdRhInfoPO;
import com.tydic.uoc.po.UocOrdRhItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebInOrderBusiServiceImpl
implements PebInOrderBusiService {
    @Autowired
    private UocOrdRhInfoMapper uocOrdRhInfoMapper;
    @Autowired
    private UocOrdRhItemMapper uocOrdRhItemMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Value(value="${SUPPLIER_JD_ID:100055}")
    private Long supplierIdJD;
    @Value(value="${uoc.erp.tk:false}")
    private Boolean isTk;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocProShouldPayOrDeductDealAtomService uocProShouldPayOrDeductDealAtomService;
    @Autowired
    private UocOrdConfirmMapper uocOrdConfirmMapper;
    @Autowired
    private UocOrdConfirmItemMapper uocOrdConfirmItemMapper;

    @Override
    public PebInOrderRspBO dealInOrder(PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocOrdRhItemBO line = reqBO.getLine();
        if (!"DELIVER".equals(line.getTransactionType()) && !"RETURN TO RECEIVING".equals(line.getTransactionType()) && this.isTk.booleanValue()) {
            throw new UocProBusinessException("8888", "\u4e0d\u662f\u5165\u5e93\uff0c\u4e5f\u4e0d\u662f\u9000\u5e93");
        }
        UocOrdRhItemPO itemPO = new UocOrdRhItemPO();
        itemPO.setTransactionId(line.getTransactionId());
        itemPO = this.uocOrdRhItemMapper.selectOne(itemPO);
        if (itemPO != null) {
            rspBO.setRespDesc("\u5165\u5e93\u5355\u4ee5\u5165\u5e93");
            return rspBO;
        }
        UocOrdRhInfoPO po = new UocOrdRhInfoPO();
        po.setExt1(line.getTransactionType());
        po.setReceiptNum(line.getReceiptNum());
        po.setExt2(line.getPoNum());
        po = this.uocOrdRhInfoMapper.selectOne(po);
        Long zId = null;
        if (po != null) {
            UocOrdRhInfoPO update = new UocOrdRhInfoPO();
            update.setId(po.getId());
            update.setAccStatus(Integer.valueOf(2));
            update.setLastUpdateDate(new Date());
            this.uocOrdRhInfoMapper.update(update);
            zId = update.getId();
        } else {
            UocOrdRhInfoPO insert = new UocOrdRhInfoPO();
            insert.setExt1(line.getTransactionType());
            insert.setReceiptNum(line.getReceiptNum());
            insert.setExt2(line.getPoNum());
            insert.setId(Long.valueOf(this.idUtil.nextId()));
            insert.setLastUpdateDate(new Date());
            insert.setAccStatus(Integer.valueOf(2));
            insert.setCreatedBy(line.getCreatedBy());
            insert.setCreationDate(line.getCreationDate());
            insert.setFullName(line.getFullName());
            insert.setOrderId(reqBO.getOrderId());
            insert.setUserName(line.getUserName());
            insert.setExt3(reqBO.getSource());
            this.uocOrdRhInfoMapper.insert(insert);
            zId = insert.getId();
        }
        itemPO = new UocOrdRhItemPO();
        BeanUtils.copyProperties((Object)line, (Object)itemPO);
        itemPO.setExt2(String.valueOf(zId));
        itemPO.setId(Long.valueOf(this.idUtil.nextId()));
        itemPO.setInTime(new Date());
        itemPO.setAccStatus(Integer.valueOf(0));
        this.uocOrdRhItemMapper.insert(itemPO);
        ArrayList<UocOrdSaleRspBO> saleRspBOS = new ArrayList<UocOrdSaleRspBO>();
        if (!UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER.equals(reqBO.getStatus())) {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrdItemId(itemPO.getOrdItemId());
            ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
            this.update(ordItemPO, line.getTransactionType(), line.getQuantity());
            UocOrdSaleRspBO saleRspBO = new UocOrdSaleRspBO();
            saleRspBO.setOrderId(ordItemPO.getOrderId());
            saleRspBO.setSaleVoucherId(ordItemPO.getSaleVoucherId());
            saleRspBOS.add(saleRspBO);
        } else {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setLmOrderId(itemPO.getOrdItemId().toString());
            List list = this.ordItemMapper.getList(ordItemPO);
            if ("DELIVER".equals(line.getTransactionType())) {
                BigDecimal quantity = line.getQuantity();
                for (OrdItemPO get : list) {
                    if (quantity.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal count = null;
                        BigDecimal last = get.getPurchaseCount().subtract(get.getRefuseCount()).subtract(get.getReturnCount());
                        BigDecimal wrh = last.subtract(count = StringUtils.isBlank((CharSequence)get.getExtField5()) ? BigDecimal.ZERO : new BigDecimal(get.getExtField5()));
                        if (wrh.compareTo(BigDecimal.ZERO) <= 0) continue;
                        if (quantity.compareTo(wrh) > 0) {
                            count = count.add(wrh);
                            quantity = quantity.subtract(wrh);
                        } else {
                            count = count.add(quantity);
                            quantity = BigDecimal.ZERO;
                        }
                        this.saveItem(get, count, last);
                        UocOrdSaleRspBO saleRspBO = new UocOrdSaleRspBO();
                        saleRspBO.setOrderId(get.getOrderId());
                        saleRspBO.setSaleVoucherId(get.getSaleVoucherId());
                        saleRspBOS.add(saleRspBO);
                        continue;
                    }
                    break;
                }
            } else {
                BigDecimal quantity = line.getQuantity();
                for (OrdItemPO get : list) {
                    if (quantity.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal count = null;
                        count = StringUtils.isBlank((CharSequence)get.getExtField5()) ? BigDecimal.ZERO : new BigDecimal(get.getExtField5());
                        if (count.compareTo(BigDecimal.ZERO) <= 0) continue;
                        BigDecimal last = get.getPurchaseCount().subtract(get.getRefuseCount()).subtract(get.getReturnCount());
                        if (count.compareTo(quantity) >= 0) {
                            count = count.subtract(quantity);
                            quantity = BigDecimal.ZERO;
                        } else {
                            count = BigDecimal.ZERO;
                            quantity = quantity.subtract(count);
                        }
                        this.saveItem(get, count, last);
                        UocOrdSaleRspBO saleRspBO = new UocOrdSaleRspBO();
                        saleRspBO.setOrderId(get.getOrderId());
                        saleRspBO.setSaleVoucherId(get.getSaleVoucherId());
                        saleRspBOS.add(saleRspBO);
                        continue;
                    }
                    break;
                }
            }
        }
        rspBO.setSaleRspBOS(saleRspBOS);
        return rspBO;
    }

    private void saveItem(OrdItemPO ordItemPO, BigDecimal count, BigDecimal last) {
        OrdItemPO update = new OrdItemPO();
        if (last.compareTo(count) > 0) {
            update.setExtField4("2");
        } else {
            update.setExtField4("1");
        }
        if (count.compareTo(BigDecimal.ZERO) == 0) {
            update.setExtField4("0");
        }
        update.setOrdItemId(ordItemPO.getOrdItemId());
        update.setExtField5(count.toString());
        update.setOrderId(ordItemPO.getOrderId());
        this.ordItemMapper.updateById(update);
    }

    private void update(OrdItemPO ordItemPO, String type, BigDecimal quantity) {
        BigDecimal count = null;
        BigDecimal last = ordItemPO.getPurchaseCount().subtract(ordItemPO.getRefuseCount()).subtract(ordItemPO.getReturnCount());
        count = StringUtils.isBlank((CharSequence)ordItemPO.getExtField5()) ? BigDecimal.ZERO : new BigDecimal(ordItemPO.getExtField5());
        count = "DELIVER".equals(type) ? count.add(quantity) : count.subtract(quantity);
        this.saveItem(ordItemPO, count, last);
    }

    @Override
    public PebInOrderRspBO dealInOrderShip(PebInOrderReqBO reqBO) {
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSaleId(rspBO.getSaleId());
        if (UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString().equals(salePO.getOrderSource())) {
            return rspBO;
        }
        if (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(salePO.getSaleState())) {
            return rspBO;
        }
        OrdShipPO uocCoreOrderShipReqBO = new OrdShipPO();
        uocCoreOrderShipReqBO.setSaleVoucherId(((OrdItemPO)list.get(0)).getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setShipStatus("2202");
        uocCoreOrderShipReqBO.setShipTime(new Date());
        uocCoreOrderShipReqBO.setShipVoucherCode(this.buildNo("ORDER_SHIP_NO", salePO.getOrderSource()));
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setSaleVoucherId(salePO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setShipTime(new Date());
        uocCoreOrderShipReqBO.setSupAccount("\u7cfb\u7edf");
        uocCoreOrderShipReqBO.setArriveTime(new Date());
        uocCoreOrderShipReqBO.setShipVoucherId(Long.valueOf(this.idUtil.nextId()));
        uocCoreOrderShipReqBO.setReceiverContact(null);
        uocCoreOrderShipReqBO.setReceiverRemark(null);
        uocCoreOrderShipReqBO.setReceiverTime(new Date());
        uocCoreOrderShipReqBO.setReceiverUser("\u7cfb\u7edf");
        uocCoreOrderShipReqBO.setReceiverNo(null);
        uocCoreOrderShipReqBO.setArriveTime(new Date());
        uocCoreOrderShipReqBO.setExt2("\u7cfb\u7edf\u751f\u6210");
        this.startProcess(uocCoreOrderShipReqBO.getShipVoucherId(), uocCoreOrderShipReqBO.getOrderId(), "peb_el_ship_order_order_status", null);
        ArrayList<OrdShipItemPO> insert = new ArrayList<OrdShipItemPO>();
        for (OrdItemPO ordItemPO : list) {
            BigDecimal rhCount = BigDecimal.ZERO;
            if (StringUtils.isNotBlank((CharSequence)ordItemPO.getExtField5())) {
                rhCount = new BigDecimal(ordItemPO.getExtField5());
            }
            if (ordItemPO.getSendCount() == null) {
                ordItemPO.setSendCount(BigDecimal.ZERO);
            }
            if (ordItemPO.getSendCount().compareTo(ordItemPO.getPurchaseCount()) >= 0 || ordItemPO.getSendCount().compareTo(rhCount) >= 0) continue;
            BigDecimal notShip = rhCount.subtract(ordItemPO.getSendCount());
            OrdShipItemPO shipItemPO = new OrdShipItemPO();
            shipItemPO.setShipVoucherId(uocCoreOrderShipReqBO.getShipVoucherId());
            shipItemPO.setOrdItemId(ordItemPO.getOrdItemId());
            shipItemPO.setSendCount(notShip);
            shipItemPO.setArriveCount(BigDecimal.ZERO);
            shipItemPO.setOrderId(reqBO.getOrderId());
            shipItemPO.setUnitName(ordItemPO.getUnitName());
            shipItemPO.setShipItemId(Long.valueOf(this.idUtil.nextId()));
            shipItemPO.setReturnCount(BigDecimal.ZERO);
            shipItemPO.setRefuseCount(BigDecimal.ZERO);
            shipItemPO.setAcceptanceCount(BigDecimal.ZERO);
            shipItemPO.setRhCount(BigDecimal.ZERO);
            insert.add(shipItemPO);
            OrdItemPO update = new OrdItemPO();
            update.setOrderId(reqBO.getOrderId());
            update.setOrdItemId(ordItemPO.getOrdItemId());
            update.setSendCount(notShip);
            this.ordItemMapper.updateCounts(update);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(insert)) {
            this.ordShipMapper.insert(uocCoreOrderShipReqBO);
            this.ordShipItemMapper.insertBatch(insert);
        }
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(reqBO.getOrderId());
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setOrderId(reqBO.getOrderId());
        List spList = this.ordShipMapper.getList(shipPO);
        Map<Long, OrdShipPO> spMap = spList.stream().collect(Collectors.toMap(OrdShipPO::getShipVoucherId, i -> i));
        List imList = this.ordShipItemMapper.getList(ordShipItemPO);
        Map<Long, List<OrdShipItemPO>> shipMap = imList.stream().collect(Collectors.groupingBy(OrdShipItemPO::getOrdItemId));
        list = this.ordItemMapper.getList(itemPO);
        HashSet<Long> notArrIds = new HashSet<Long>();
        HashSet<Long> arrIds = new HashSet<Long>();
        HashMap<Long, BigDecimal> count = new HashMap<Long, BigDecimal>();
        ArrayList<UocOrdConfirmPO> confirmPOS = new ArrayList<UocOrdConfirmPO>();
        ArrayList<UocOrdConfirmItemPO> confirmItemPOS = new ArrayList<UocOrdConfirmItemPO>();
        String confirmNo = null;
        Long confirmId = this.idUtil.nextId();
        UocOrdConfirmPO uocOrdConfirmPO = new UocOrdConfirmPO();
        uocOrdConfirmPO.setConfirmCode(this.buildNo("ORDER_SHIP_NO", salePO.getOrderSource()));
        uocOrdConfirmPO.setCreateOperId(String.valueOf("0"));
        uocOrdConfirmPO.setCreateOperName("\u7cfb\u7edf");
        uocOrdConfirmPO.setCreateTime(new Date());
        uocOrdConfirmPO.setId(confirmId);
        uocOrdConfirmPO.setModifyOperId("0");
        uocOrdConfirmPO.setModifyTime(new Date());
        uocOrdConfirmPO.setOrderId(reqBO.getOrderId());
        uocOrdConfirmPO.setReceiverContact("\u7cfb\u7edf");
        uocOrdConfirmPO.setReceiverTime(new Date());
        uocOrdConfirmPO.setReceiverUser("\u7cfb\u7edf");
        confirmPOS.add(uocOrdConfirmPO);
        confirmNo = uocOrdConfirmPO.getConfirmCode();
        for (OrdItemPO po : list) {
            UocOrdConfirmItemPO uocOrdConfirmItemPO;
            OrdShipItemPO update;
            BigDecimal last;
            OrdShipPO sp;
            if (po.getArriveCount() == null) {
                po.setArriveCount(BigDecimal.ZERO);
            }
            if (po.getExtField5() == null) {
                po.setExtField5("0");
            }
            if (po.getArriveCount().compareTo(po.getPurchaseCount().subtract(po.getRefuseCount())) >= 0 || new BigDecimal(po.getExtField5()).compareTo(po.getArriveCount()) <= 0) continue;
            List<OrdShipItemPO> imPos = shipMap.get(po.getOrdItemId());
            BigDecimal isUpdate = new BigDecimal(po.getExtField5()).subtract(po.getArriveCount());
            for (OrdShipItemPO shipItemPO : imPos) {
                sp = spMap.get(shipItemPO.getShipVoucherId());
                if ("2207".equals(sp.getShipStatus()) || "2205".equals(sp.getShipStatus()) || "2202".equals(sp.getShipStatus()) || "2203".equals(sp.getShipStatus()) || "2206".equals(sp.getShipStatus()) || "2210".equals(sp.getShipStatus()) || (last = shipItemPO.getSendCount().subtract(shipItemPO.getArriveCount()).subtract(shipItemPO.getRefuseCount())).compareTo(BigDecimal.ZERO) <= 0 || isUpdate.compareTo(BigDecimal.ZERO) == 0) continue;
                update = new OrdShipItemPO();
                update.setShipItemId(shipItemPO.getShipItemId());
                update.setOrderId(shipItemPO.getOrderId());
                if (isUpdate.compareTo(last) > 0) {
                    update.setArriveCount(last);
                    isUpdate = isUpdate.subtract(last);
                } else {
                    update.setArriveCount(isUpdate);
                    isUpdate = BigDecimal.ZERO;
                }
                if (count.get(shipItemPO.getOrdItemId()) == null) {
                    count.put(shipItemPO.getOrdItemId(), update.getArriveCount());
                } else {
                    count.put(shipItemPO.getOrdItemId(), ((BigDecimal)count.get(shipItemPO.getOrdItemId())).add(update.getArriveCount()));
                }
                this.ordShipItemMapper.updateCounts(update);
                arrIds.add(shipItemPO.getShipVoucherId());
                uocOrdConfirmItemPO = new UocOrdConfirmItemPO();
                uocOrdConfirmItemPO.setShipItemId(shipItemPO.getShipItemId());
                uocOrdConfirmItemPO.setShipVoucherId(shipItemPO.getShipVoucherId());
                uocOrdConfirmItemPO.setShipVoucherNo(uocCoreOrderShipReqBO.getShipVoucherCode());
                uocOrdConfirmItemPO.setConfirmCount(shipItemPO.getArriveCount());
                uocOrdConfirmItemPO.setId(Long.valueOf(this.idUtil.nextId()));
                uocOrdConfirmItemPO.setOrderId(po.getOrderId());
                uocOrdConfirmItemPO.setOrdItemId(po.getOrdItemId());
                uocOrdConfirmItemPO.setConfirmId(confirmId);
                confirmItemPOS.add(uocOrdConfirmItemPO);
            }
            if (isUpdate.compareTo(BigDecimal.ZERO) <= 0) continue;
            for (OrdShipItemPO shipItemPO : imPos) {
                sp = spMap.get(shipItemPO.getShipVoucherId());
                if (!"2202".equals(sp.getShipStatus()) && !"2207".equals(sp.getShipStatus())) continue;
                last = shipItemPO.getSendCount().subtract(shipItemPO.getArriveCount()).subtract(shipItemPO.getRefuseCount());
                update = new OrdShipItemPO();
                update.setShipItemId(shipItemPO.getShipItemId());
                update.setOrderId(shipItemPO.getOrderId());
                if (isUpdate.compareTo(last) > 0) {
                    update.setArriveCount(last);
                    isUpdate = isUpdate.subtract(last);
                } else {
                    update.setArriveCount(isUpdate);
                    isUpdate = BigDecimal.ZERO;
                }
                if (count.get(shipItemPO.getOrdItemId()) == null) {
                    count.put(shipItemPO.getOrdItemId(), update.getArriveCount());
                } else {
                    count.put(shipItemPO.getOrdItemId(), ((BigDecimal)count.get(shipItemPO.getOrdItemId())).add(update.getArriveCount()));
                }
                this.ordShipItemMapper.updateCounts(update);
                notArrIds.add(shipItemPO.getShipVoucherId());
                arrIds.add(shipItemPO.getShipVoucherId());
                uocOrdConfirmItemPO = new UocOrdConfirmItemPO();
                uocOrdConfirmItemPO.setShipItemId(shipItemPO.getShipItemId());
                uocOrdConfirmItemPO.setShipVoucherId(shipItemPO.getShipVoucherId());
                uocOrdConfirmItemPO.setShipVoucherNo(uocCoreOrderShipReqBO.getShipVoucherCode());
                uocOrdConfirmItemPO.setId(Long.valueOf(this.idUtil.nextId()));
                uocOrdConfirmItemPO.setConfirmCount(shipItemPO.getArriveCount());
                uocOrdConfirmItemPO.setOrderId(po.getOrderId());
                uocOrdConfirmItemPO.setOrdItemId(po.getOrdItemId());
                uocOrdConfirmItemPO.setConfirmId(confirmId);
                confirmItemPOS.add(uocOrdConfirmItemPO);
            }
        }
        if (!CollectionUtils.isEmpty(confirmItemPOS)) {
            this.uocOrdConfirmItemMapper.insertBatch(confirmItemPOS);
            this.uocOrdConfirmMapper.insertBatch(confirmPOS);
        }
        this.updateStatus(reqBO, notArrIds, arrIds, count, salePO);
        UocProShouldPayOrDeductDealAtomReqBo uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
        uocProShouldPayOrDeductDealAtomReqBo.setOrderId(reqBO.getOrderId());
        uocProShouldPayOrDeductDealAtomReqBo.setObjId(confirmId);
        uocProShouldPayOrDeductDealAtomReqBo.setConfirmNo(confirmNo);
        uocProShouldPayOrDeductDealAtomReqBo.setObjNo(confirmNo);
        uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        uocProShouldPayOrDeductDealAtomReqBo.setObjDate(new Date());
        uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.THE_ARRIVAL);
        UocProShouldPayOrDeductDealAtomRspBo shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
        if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
            throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
        }
        rspBO.setShipId(arrIds);
        return rspBO;
    }

    private void updateStatus(PebInOrderReqBO reqBO, Set<Long> notArrIds, Set<Long> arrIds, Map<Long, BigDecimal> count, OrdSalePO salePO) {
        if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(salePO.getSaleState())) {
            HashMap map = new HashMap();
            map.put("cancelFlag", "0");
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, salePO.getSaleVoucherId(), map);
        }
        for (Long key : count.keySet()) {
            OrdItemPO update = new OrdItemPO();
            update.setArriveCount(count.get(key));
            update.setOrdItemId(key);
            update.setOrderId(reqBO.getOrderId());
            this.ordItemMapper.updateCounts(update);
        }
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(reqBO.getOrderId());
        List imList = this.ordShipItemMapper.getList(ordShipItemPO);
        Map<Long, List<OrdShipItemPO>> shipMap = imList.stream().collect(Collectors.groupingBy(OrdShipItemPO::getShipVoucherId));
        for (Long id : arrIds) {
            List<OrdShipItemPO> list = shipMap.get(id);
            String shipStatus = null;
            OrdShipPO shipPO = new OrdShipPO();
            BigDecimal sendCount = BigDecimal.ZERO;
            BigDecimal arriveCount = BigDecimal.ZERO;
            BigDecimal refuseCount = BigDecimal.ZERO;
            for (OrdShipItemPO itemPO : list) {
                sendCount = itemPO.getSendCount().add(sendCount);
                arriveCount = itemPO.getArriveCount().add(arriveCount);
                refuseCount = itemPO.getRefuseCount().add(refuseCount);
            }
            shipStatus = sendCount.compareTo(arriveCount.add(refuseCount)) > 0 ? (refuseCount.compareTo(BigDecimal.ZERO) > 0 ? "2208" : "2208") : (refuseCount.compareTo(BigDecimal.ZERO) == 0 ? "2203" : "2210");
            shipPO.setShipStatus(shipStatus);
            shipPO.setShipVoucherId(id);
            shipPO.setOrderId(reqBO.getOrderId());
            if (notArrIds.contains(id)) {
                shipPO.setSupAccount("\u7cfb\u7edf");
            }
            shipPO.setShipTime(new Date());
            shipPO.setArriveTime(new Date());
            shipPO.setReceiverTime(new Date());
            shipPO.setReceiverUser("\u7cfb\u7edf");
            shipPO.setArriveTime(new Date());
            this.ordShipMapper.updateById(shipPO);
        }
        if (!UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(salePO.getOrderSource())) {
            if (this.judgeIsAllReceive(reqBO.getOrderId())) {
                this.executeUpdateSaleOrdState(salePO.getOrderId(), salePO.getSaleVoucherId(), true);
            }
        } else {
            this.dealOrderState(reqBO, salePO, salePO.getSaleVoucherId());
        }
    }

    private void executeUpdateSaleOrdState(Long orderId, Long saleVoucherId, boolean confirm) {
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setOrderId(orderId);
        List ordShipPoList = this.ordShipMapper.getList(ordShipModel);
        for (OrdShipPO ordShipPo : ordShipPoList) {
            if (!"2204".equals(ordShipPo.getShipStatus()) && !"2208".equals(ordShipPo.getShipStatus()) && !"2209".equals(ordShipPo.getShipStatus())) continue;
            return;
        }
        int isAllReceived = 0;
        boolean isPart = false;
        for (OrdShipPO ordShipPo : ordShipPoList) {
            if ("2210".equals(ordShipPo.getShipStatus())) {
                isPart = true;
            }
            if (!"2206".equals(ordShipPo.getShipStatus())) continue;
            ++isAllReceived;
        }
        Integer rejectFlag = null;
        rejectFlag = isAllReceived == 0 ? PecConstant.SHIP_RECEIVED_STATE.ALL_RECEIVED : (isAllReceived == ordShipPoList.size() ? PecConstant.SHIP_RECEIVED_STATE.ALL_REFUSEDR : PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED);
        if (isPart) {
            rejectFlag = PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED;
        }
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(saleVoucherId);
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(orderId);
        processRunReqBO.setOperId("0");
        processRunReqBO.setPreState(UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        processRunReqBO.setVariables(map);
        map.put("rejectFlag", rejectFlag);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102098", "\u901a\u8fc7\u5165\u53c2\uff1a" + processRunReqBO.toString() + "\u72b6\u6001\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private boolean judgeIsAllReceive(Long orderId) {
        OrdItemPO ordItemModel = new OrdItemPO();
        ordItemModel.setOrderId(orderId);
        List ordItemPoList = this.ordItemMapper.getList(ordItemModel);
        BigDecimal totalPurchaseCount = new BigDecimal(0);
        BigDecimal totalArriveCount = new BigDecimal(0);
        for (OrdItemPO ordItemPo : ordItemPoList) {
            totalPurchaseCount = totalPurchaseCount.add(ordItemPo.getPurchaseCount());
            BigDecimal arriveCount = ordItemPo.getArriveCount().add(ordItemPo.getRefuseCount());
            totalArriveCount = totalArriveCount.add(arriveCount);
        }
        return totalArriveCount.equals(totalPurchaseCount);
    }

    private void dealOrderState(PebInOrderReqBO reqBO, OrdSalePO salePO, Long shipId) {
        if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(salePO.getSaleState())) {
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(reqBO.getOrderId());
            List list = this.ordItemMapper.getList(itemPO);
            boolean notAllShip = false;
            for (OrdItemPO ordItemPO : list) {
                if (ordItemPO.getPurchaseCount().compareTo(ordItemPO.getSendCount()) <= 0) continue;
                notAllShip = true;
                break;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (notAllShip) {
                map.put("arrive", "1");
            } else {
                map.put("arrive", "2");
            }
            reqBO.setPreStatus(UocConstant.SALE_ORDER_STATUS.DJ);
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, salePO.getSaleVoucherId(), map);
            return;
        }
        if (!(UocConstant.SALE_ORDER_STATUS.DJ.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PART_DJ.equals(salePO.getSaleState()))) {
            return;
        }
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        boolean allShip = true;
        for (OrdItemPO ordItemPO : list) {
            if (ordItemPO.getPurchaseCount().compareTo(ordItemPO.getSendCount()) <= 0) continue;
            allShip = false;
            break;
        }
        boolean allArrive = true;
        boolean allConfirm = true;
        boolean allRefuse = true;
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setOrderId(reqBO.getOrderId());
        List ordShipPoList = this.ordShipMapper.getList(ordShipModel);
        for (OrdShipPO ordShipPo : ordShipPoList) {
            if ("2209".equals(ordShipPo.getShipStatus()) || "2204".equals(ordShipPo.getShipStatus()) || "2207".equals(ordShipPo.getShipStatus()) || "2208".equals(ordShipPo.getShipStatus())) {
                allArrive = false;
                continue;
            }
            if ("2210".equals(ordShipPo.getShipStatus()) || "2206".equals(ordShipPo.getShipStatus())) {
                allConfirm = false;
                continue;
            }
            allRefuse = false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!allShip || !allArrive) {
            if (allConfirm) {
                map.put("arrive", 1);
                if (UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(salePO.getSaleState())) {
                    return;
                }
                this.run(reqBO, UocConstant.OBJ_TYPE.SALE, shipId, map);
                return;
            }
            return;
        }
        if (allConfirm) {
            map.put("arrive", 2);
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, shipId, map);
        } else {
            if (!allRefuse) {
                map.put("rejectFlag", 2);
            } else {
                map.put("rejectFlag", 1);
            }
            this.run(reqBO, UocConstant.OBJ_TYPE.SALE, shipId, map);
        }
    }

    private void run(PebInOrderReqBO reqBO, Integer objType, Long objId, Map<String, Object> map) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setObjType(objType);
        processRunReqBO.setObjId(objId);
        processRunReqBO.setOperId(String.valueOf("00"));
        processRunReqBO.setVariables(map);
        processRunReqBO.setPreState(reqBO.getPreStatus());
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        reqBO.setPreStatus(null);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102098", "\u72b6\u6001\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private String buildNo(String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102033", voucherNoRsp.getRespDesc());
        }
        return voucherNoRsp.getVoucherNo();
    }

    private void startProcess(Long objId, Long orderId, String procKey, String submit) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setProcDefKey(procKey);
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
        processStartReqBO.setOrderId(orderId);
        HashMap map = new HashMap(1);
        UocProcessStartRspBO processStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(processStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101059", "\u901a\u8fc7\u5165\u53c2\uff1a" + processStartReqBO.toString() + "\u542f\u52a8\u72b6\u6001\u673a\u5931\u8d25\u539f\u56e0\uff1a" + processStartRspBO.getRespDesc());
        }
    }
}

