/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.contract.ability.ContractOrderedAmountSynAbilityService;
import com.tydic.contract.ability.ContractPlanOrderAbilityService;
import com.tydic.contract.ability.bo.ContractOrderedAmountSynAbilityReqBO;
import com.tydic.contract.ability.bo.ContractOrderedAmountSynAbilityRspBO;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityReqBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityRspBo;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdItemUpdateBO;
import com.tydic.uoc.common.atom.api.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.plan.InterFaceContractUpdateOrderItemAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemAtomReqBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemAtomRspBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemBO;
import com.tydic.uoc.common.busi.api.PebUpdateOrderBusiService;
import com.tydic.uoc.common.busi.api.UocGeneralCirculationBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempxMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrdZmItemMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdPurchaseItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrdZmItemPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebUpdateOrderBusiServiceImpl
implements PebUpdateOrderBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private UocOrdGoodsTempMapper uocOrdGoodsTempMapper;
    @Autowired
    private UocOrdGoodsTempxMapper uocOrdGoodsTempxMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private UocOrdZmItemMapper uocOrdZmItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private InterFaceContractUpdateOrderItemAtomService interFaceContractUpdateOrderItemAtomService;
    @Autowired
    private ContractPlanOrderAbilityService contractPlanOrderAbilityService;
    @Autowired
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Value(value="${zone.ship.maxTime:15}")
    private String maxShipTime;
    @Autowired
    private ContractOrderedAmountSynAbilityService contractOrderedAmountSynAbilityService;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaTionAtomService;
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private UocGeneralCirculationBusiService uocGeneralCirculationBusiService;

    @Override
    public PebUpdateOrderRspBO updateOrder(PebUpdateOrderReqBO reqBO) {
        if (reqBO.getZmInfoBO() != null) {
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            BeanUtils.copyProperties((Object)reqBO.getZmInfoBO(), (Object)zmInfoPO);
            zmInfoPO.setOrderId(reqBO.getOrderId());
            this.uocOrdZmInfoMapper.update(zmInfoPO);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdSalePO update = new OrdSalePO();
        update.setSaleVoucherId(salePO.getSaleVoucherId());
        update.setOrderId(reqBO.getOrderId());
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setUpdateOperId(reqBO.getUserId().toString());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExt4())) {
            orderPO.setExt4(reqBO.getExt4());
        }
        orderPO.setOrderName(reqBO.getOrderName());
        if (reqBO.getAddressInfo() != null) {
            this.updateAddr(reqBO.getAddressInfo(), salePO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getGiveTime())) {
            update.setGiveTime(reqBO.getGiveTime());
        }
        Long orderId = reqBO.getOrderId();
        this.updateExt("purUserNo", "\u91c7\u8d2d\u5458\u7f16\u7801", reqBO.getPurUserNo(), orderId);
        this.updateExt("purUserName", "\u91c7\u8d2d\u5458\u540d\u79f0", reqBO.getPurUserName(), orderId);
        this.updateExt("erpAgrNo", "\u91c7\u8d2d\u534f\u8bae\u7f16\u7801", reqBO.getErpAgrNo(), orderId);
        this.updateExt("erpAgrName", "\u91c7\u8d2d\u534f\u8bae\u540d\u79f0", reqBO.getErpAgrName(), orderId);
        this.updateExt("erpAgrId", "\u91c7\u8d2d\u534f\u8baeid", reqBO.getErpAgrId(), orderId);
        this.updateExt("adjustType", "\u8c03\u4ef7\u65b9\u5f0f", reqBO.getAdjustType(), orderId);
        this.saveAccessory(reqBO, orderId);
        if (PebExtConstant.YES.toString().equals(reqBO.getSubmit())) {
            List<Integer> saleStateList = Arrays.asList(1107, 8888);
            if (salePO.getSaleState() == 1107) {
                this.orderMapper.updateProStateNull(salePO.getOrderId());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("submit", "1");
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(salePO.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(salePO.getOrderId());
            processRunReqBO.setOperId("1");
            processRunReqBO.setVariables(map);
            processRunReqBO.setPreState(UocConstant.SALE_ORDER_STATUS.TOBO_SUBMIT);
            UocProcessRunRspBO rspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new UocProBusinessException("8888", rspBO.getRespDesc());
            }
            this.audit(salePO);
        }
        this.saveItem(update, orderPO, reqBO, salePO);
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebUpdateOrderRspBO updateOrderByRecover(PebUpdateOrderReqBO reqBO) {
        if (reqBO.getZmInfoBO() != null) {
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            BeanUtils.copyProperties((Object)reqBO.getZmInfoBO(), (Object)zmInfoPO);
            zmInfoPO.setOrderId(reqBO.getOrderId());
            this.uocOrdZmInfoMapper.update(zmInfoPO);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (!UocConstant.SALE_ORDER_STATUS.REJECT_PENDING.equals(salePO.getSaleState())) {
            PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        OrdSalePO update = new OrdSalePO();
        update.setSaleVoucherId(salePO.getSaleVoucherId());
        update.setOrderId(reqBO.getOrderId());
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExt4())) {
            orderPO.setExt4(reqBO.getExt4());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getGiveTime())) {
            update.setGiveTime(reqBO.getGiveTime());
        }
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        ordLogisticsRelaPO.setOrderId(reqBO.getOrderId());
        this.ordLogisticsRelaMapper.deleteBy(ordLogisticsRelaPO);
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(reqBO.getOrderId(), reqBO.getAddressInfo());
        UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
        if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
        }
        Long contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
        update.setContactId(contactId);
        this.ordInvoiceMapper.deleteByOrderId(reqBO.getOrderId());
        this.saveInvoice(reqBO, reqBO.getOrderId(), reqBO.getSaleVoucherId());
        this.saveAccessory(reqBO, reqBO.getOrderId());
        this.dealItem(update, orderPO, reqBO);
        UocGeneralCirculationReqBO uocGeneralCirculationReqBO = new UocGeneralCirculationReqBO();
        uocGeneralCirculationReqBO = (UocGeneralCirculationReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)uocGeneralCirculationReqBO)), UocGeneralCirculationReqBO.class));
        uocGeneralCirculationReqBO.setActionCode("ACTPEB003");
        uocGeneralCirculationReqBO.setObjType(2);
        uocGeneralCirculationReqBO.setOrderId(reqBO.getOrderId());
        uocGeneralCirculationReqBO.setObjId(reqBO.getSaleVoucherId());
        UocGeneralCirculationRspBO uocGeneralCirculationRspBO = this.uocGeneralCirculationBusiService.dealGeneralCirculation(uocGeneralCirculationReqBO);
        if (!"0000".equals(uocGeneralCirculationRspBO.getRespCode())) {
            throw new UocProBusinessException(uocGeneralCirculationRspBO.getRespCode(), "\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5931\u8d25:" + uocGeneralCirculationRspBO.getRespDesc());
        }
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebUpdateOrderRspBO updateOrderArrivalTime(PebUpdateOrderReqBO reqBO) {
        UocOrdGoodsTempPO record;
        if (reqBO.getTempOrderId() != null) {
            record = new UocOrdGoodsTempPO();
            record.setOrderId(reqBO.getTempOrderId());
            record.setArrivalTime(reqBO.getOrderItemArrivalTime());
            if (reqBO.getIsUpdateAllArrivalTime() == 1) {
                this.uocOrdGoodsTempxMapper.updateArrivalTimeAll(record);
            } else {
                this.uocOrdGoodsTempxMapper.updateArrivalTime(record);
            }
        } else {
            record = new UocOrdGoodsTempPO();
            record.setOrderId(reqBO.getOrderId());
            record.setArrivalTime(reqBO.getOrderItemArrivalTime());
            if (reqBO.getIsUpdateAllArrivalTime() == 1) {
                this.uocOrdGoodsTempMapper.updateArrivalTimeAll(record);
            } else {
                this.uocOrdGoodsTempMapper.updateArrivalTime(record);
            }
        }
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveInvoice(PebUpdateOrderReqBO reqBO, Long orderId, Long saleId) {
        if (reqBO.getInvoiceBO() != null) {
            Long contactId;
            if (reqBO.getInvoiceAddressInfo() != null) {
                UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getInvoiceAddressInfo());
                UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
                if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
                    throw new UocProBusinessException("102107", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
                }
                contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
            } else {
                contactId = saleId;
            }
            Long id = this.idUtil.nextId();
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setInvoiceUrl(reqBO.getInvoiceBO().getInvoiceUrl());
            ordInvoicePO.setBankAccount(reqBO.getInvoiceBO().getBankAccount());
            ordInvoicePO.setBuyerName(reqBO.getInvoiceBO().getBuyerName());
            ordInvoicePO.setCompanyAddress(reqBO.getInvoiceBO().getCompanyAddress());
            ordInvoicePO.setDepositBank(reqBO.getInvoiceBO().getDepositBank());
            ordInvoicePO.setFixPhone(reqBO.getInvoiceBO().getFixPhone());
            ordInvoicePO.setInvoiceNo(reqBO.getInvoiceBO().getInvoiceNo());
            ordInvoicePO.setInvoiceSn(reqBO.getInvoiceBO().getInvoiceSn());
            ordInvoicePO.setInvoiceType(reqBO.getInvoiceBO().getInvoiceType());
            ordInvoicePO.setRelaEmail(reqBO.getInvoiceBO().getRelaEmail());
            ordInvoicePO.setRelaPhone(reqBO.getInvoiceBO().getRelaPhone());
            ordInvoicePO.setOrderId(orderId);
            ordInvoicePO.setId(id);
            ordInvoicePO.setSaleVoucherId(contactId);
            ordInvoicePO.setOutInvoiceId(reqBO.getInvoiceBO().getUmcInvoiceId());
            ordInvoicePO.setInvoceCategory(reqBO.getInvoiceBO().getInvoceCategory());
            this.ordInvoiceMapper.insert(ordInvoicePO);
        }
    }

    private UocCoreCreateLogisticsRelaReqBO buildLogisticsRelaTionParam(Long orderId, PebExtAddressInfoIntfceReqBO addressInfoIntfceBO) {
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = new UocCoreCreateLogisticsRelaReqBO();
        uocCoreCreateLogisticsRelaReqBO.setOrderId(orderId);
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        uocCoreCreateLogisticsRelaReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        uocCoreCreateLogisticsRelaReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        uocCoreCreateLogisticsRelaReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        uocCoreCreateLogisticsRelaReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        uocCoreCreateLogisticsRelaReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        uocCoreCreateLogisticsRelaReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        uocCoreCreateLogisticsRelaReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        uocCoreCreateLogisticsRelaReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        uocCoreCreateLogisticsRelaReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        uocCoreCreateLogisticsRelaReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        return uocCoreCreateLogisticsRelaReqBO;
    }

    private void audit(OrdSalePO saleRspBO) {
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO;
        Long orderId = saleRspBO.getOrderId();
        OrdStakeholderPO stakeholderPo = this.ordStakeholderMapper.getModelById(orderId.longValue());
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(stakeholderPo.getPurPlaceOrderId());
        noTaskAuditCreateReqBO.setCreateOperName(stakeholderPo.getPurPlaceOrderName());
        noTaskAuditCreateReqBO.setCreateOperDept(stakeholderPo.getPurName());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setCreateOperId(stakeholderPo.getPurPlaceOrderId());
        infoReqBO.setUsername(stakeholderPo.getPurPlaceOrderName());
        infoReqBO.setRemark("\u521b\u5efa\u4f9b\u5e94\u5546\u63a5\u5355\u5ba1\u6279");
        infoReqBO.setOrderId(orderId);
        infoReqBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
        Long saleId = saleRspBO.getSaleVoucherId();
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
        approvalObjBO.setObjId(String.valueOf(saleId));
        ArrayList<ApprovalObjBO> objBoS = new ArrayList<ApprovalObjBO>(1);
        objBoS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBoS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBoS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBoS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBoS);
        noTaskAuditCreateReqBO.setOrgId(stakeholderPo.getPurOrgId());
        noTaskAuditCreateReqBO.setOrgTreeId(stakeholderPo.getPurOrgPath());
        noTaskAuditCreateReqBO.setMenuId("M001103");
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(saleRspBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(saleRspBO.getOrderId());
        salePO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(salePO);
        if (zmInfoPO != null) {
            if (StringUtils.isNotBlank((CharSequence)zmInfoPO.getExt1())) {
                noTaskAuditCreateReqBO.setProcDefKey(zmInfoPO.getExt1());
            }
            HashMap<String, Object> ows = new HashMap<String, Object>();
            ows.put("jhwzlb", ElUtils.getMaterialCategory(zmInfoPO.getMaterialCategory()));
            try {
                ows.put("ysje", MoneyUtils.Long2BigDecimal((Long)ordSalePO.getSaleFee()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            noTaskAuditCreateReqBO.setVariables(ows);
        }
        if (!"0000".equals((uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO)).getRespCode())) {
            throw new UocProBusinessException("8888", "\u521b\u5efa\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new UocProBusinessException("8888", "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ba1\u6279\u6d41\u7a0b");
        }
        OrdSalePO ordSalePo = new OrdSalePO();
        ordSalePo.setOrderId(orderId);
        ordSalePo.setSaleVoucherId(saleId);
        ordSalePo.setTbOrderId(uacNoTaskAuditCreateRspBO.getStepId());
        ordSalePo.setExt3("\u5ba1\u6279\u4e2d");
        this.ordSaleMapper.updateById(ordSalePo);
    }

    private void saveItem(OrdSalePO salePO, OrderPO orderPO, PebUpdateOrderReqBO reqBO, OrdSalePO last) {
        Long saleFee = 0L;
        OrdExtMapPO createType = new OrdExtMapPO();
        createType.setOrderId(salePO.getOrderId());
        createType.setFieldCode("createType");
        createType = this.ordExtMapMapper.getModelBy(createType);
        boolean pushFz = false;
        boolean pushHt = true;
        if (createType != null) {
            if ("4".equals(createType.getFieldValue()) || "3".equals(createType.getFieldValue())) {
                pushFz = true;
                pushHt = false;
            }
            if ("2".equals(createType.getFieldValue())) {
                pushHt = false;
            }
        }
        ArrayList<Integer> saleStateList = new ArrayList<Integer>();
        saleStateList.add(1107);
        ArrayList<InterFaceContractUpdateOrderItemBO> operOrderItem = new ArrayList<InterFaceContractUpdateOrderItemBO>();
        ArrayList<ContractPlanOrderAbilityBo> planOrderReqBo = new ArrayList<ContractPlanOrderAbilityBo>();
        UocOrdGoodsTempPO tempPO = new UocOrdGoodsTempPO();
        tempPO.setOrderId(salePO.getOrderId());
        List list = this.uocOrdGoodsTempMapper.selectByCondition(tempPO);
        List xlist = new ArrayList();
        if (reqBO.getTempOrderId() != null) {
            tempPO.setOrderId(reqBO.getTempOrderId());
            xlist = this.uocOrdGoodsTempxMapper.selectByCondition(tempPO);
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(salePO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        Map<Long, OrdItemPO> map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getTempId, i -> i));
        Map<Long, UocOrdGoodsTempPO> oldM = list.stream().collect(Collectors.toMap(UocOrdGoodsTempPO::getTempId, i -> i));
        if (CollectionUtils.isNotEmpty(xlist)) {
            ArrayList<Long> uIds = new ArrayList<Long>();
            for (UocOrdGoodsTempPO po : xlist) {
                UocOrdGoodsTempPO update = oldM.get(po.getTempId());
                po.setOrderId(reqBO.getOrderId());
                if (update != null) {
                    BeanUtils.copyProperties((Object)po, (Object)update);
                    this.uocOrdGoodsTempMapper.update(update);
                } else {
                    this.uocOrdGoodsTempMapper.insert(po);
                }
                uIds.add(po.getTempId());
            }
            ArrayList<Long> itemIds = new ArrayList<Long>();
            ArrayList<Long> delTemp = new ArrayList<Long>();
            for (UocOrdGoodsTempPO old : list) {
                if (uIds.contains(old.getTempId())) continue;
                itemIds.add(map.get(old.getTempId()).getOrdItemId());
                delTemp.add(old.getTempId());
                if (saleStateList.contains(last.getSaleState())) continue;
                if (pushFz) {
                    InterFaceContractUpdateOrderItemBO updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                    updateOrderItemBO.setGoodTypeId(old.getOutObjItemId());
                    updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                    updateOrderItemBO.setOperateType(0);
                    updateOrderItemBO.setOrderNum(old.getPurchaseCount());
                    operOrderItem.add(updateOrderItemBO);
                }
                if (!pushHt) continue;
                ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                abilityBo.setItemId(old.getHtItemId());
                abilityBo.setNum(old.getPurchaseCount().negate());
                planOrderReqBo.add(abilityBo);
            }
            if (CollectionUtils.isNotEmpty(itemIds)) {
                OrdItemPO del = new OrdItemPO();
                del.setItemIds(itemIds);
                this.ordItemMapper.deleteByIds(del);
                UocOrdGoodsTempPO goodsTempPO = new UocOrdGoodsTempPO();
                goodsTempPO.setTempIds(delTemp);
                this.uocOrdGoodsTempMapper.deleteByIds(goodsTempPO);
                this.ordItemMapper.deletePurItemByIds(del);
                this.ordItemMapper.deletePayItemByIds(del);
                this.ordItemMapper.deleteZmItemByIds(del);
                ordItemPO = new OrdItemPO();
                ordItemPO.setOrderId(salePO.getOrderId());
                itemPOS = this.ordItemMapper.getList(ordItemPO);
                map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getTempId, i -> i));
            }
            tempPO = new UocOrdGoodsTempPO();
            tempPO.setOrderId(salePO.getOrderId());
            list = this.uocOrdGoodsTempMapper.selectByCondition(tempPO);
        }
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(reqBO.getOrderId());
        purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
        OrdPayPO payPO = new OrdPayPO();
        payPO.setOrderId(reqBO.getOrderId());
        payPO = this.ordPayMapper.getModelBy(payPO);
        ArrayList<UocOrdZmItemPO> zmItemInsert = new ArrayList<UocOrdZmItemPO>();
        ArrayList<OrdPayItemPO> payItemPOS = new ArrayList<OrdPayItemPO>();
        for (UocOrdGoodsTempPO goodsTempPO : list) {
            InterFaceContractUpdateOrderItemBO updateOrderItemBO;
            BigDecimal purChaseCountAll = goodsTempPO.getPurchaseCount();
            OrdPayItemPO payItemPO = new OrdPayItemPO();
            OrdItemPO itemPO = new OrdItemPO();
            OrdItemPO qry = map.get(goodsTempPO.getTempId());
            if (qry == null) {
                Long id = this.insertItem(goodsTempPO, payItemPOS, salePO.getSaleVoucherId(), purchasePO, payPO.getPayVoucherId());
                UocOrdZmItemPO zmItemPO = new UocOrdZmItemPO();
                BeanUtils.copyProperties((Object)goodsTempPO, (Object)zmItemPO);
                zmItemPO.setOrdItemId(id);
                zmItemInsert.add(zmItemPO);
                try {
                    saleFee = saleFee + MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!saleStateList.contains(last.getSaleState())) {
                    if (pushFz) {
                        InterFaceContractUpdateOrderItemBO updateOrderItemBO2 = new InterFaceContractUpdateOrderItemBO();
                        updateOrderItemBO2.setGoodTypeId(goodsTempPO.getOutObjItemId());
                        updateOrderItemBO2.setType(Integer.valueOf(createType.getFieldValue()));
                        updateOrderItemBO2.setOperateType(1);
                        updateOrderItemBO2.setOrderNum(goodsTempPO.getPurchaseCount());
                        operOrderItem.add(updateOrderItemBO2);
                    }
                    if (pushHt) {
                        ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                        abilityBo.setItemId(goodsTempPO.getHtItemId());
                        abilityBo.setNum(goodsTempPO.getPurchaseCount());
                        planOrderReqBo.add(abilityBo);
                    }
                }
            } else {
                if (!saleStateList.contains(last.getSaleState())) {
                    if (pushFz) {
                        updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                        updateOrderItemBO.setGoodTypeId(goodsTempPO.getOutObjItemId());
                        updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                        BigDecimal count = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                        if (count.compareTo(BigDecimal.ZERO) > 0) {
                            updateOrderItemBO.setOperateType(0);
                            updateOrderItemBO.setOrderNum(count);
                            operOrderItem.add(updateOrderItemBO);
                        } else if (count.compareTo(BigDecimal.ZERO) < 0) {
                            updateOrderItemBO.setOperateType(1);
                            updateOrderItemBO.setOrderNum(count.negate());
                            operOrderItem.add(updateOrderItemBO);
                        }
                    }
                    if (pushHt) {
                        BigDecimal count = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                        ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                        abilityBo.setItemId(goodsTempPO.getHtItemId());
                        abilityBo.setNum(count.negate());
                        if (count.compareTo(BigDecimal.ZERO) > 0) {
                            planOrderReqBo.add(abilityBo);
                        } else if (count.compareTo(BigDecimal.ZERO) < 0) {
                            planOrderReqBo.add(abilityBo);
                        }
                    }
                }
                itemPO.setOrdItemId(qry.getOrdItemId());
                itemPO.setOrderId(salePO.getOrderId());
                itemPO.setTempId(goodsTempPO.getTempId());
                itemPO.setTempId(goodsTempPO.getTempId());
                itemPO.setPurchaseCount(goodsTempPO.getPurchaseCount());
                try {
                    itemPO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getSalePrice()));
                    itemPO.setPurchaseDecimalPrice(goodsTempPO.getSalePrice());
                    itemPO.setSaleDecimalPrice(goodsTempPO.getSalePrice());
                    itemPO.setTotalSaleDecimalPrice(goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                    itemPO.setTotalPurchaseDecimalPrice(goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                    saleFee = saleFee + MoneyUtils.BigDecimal2Long((BigDecimal)itemPO.getTotalSaleDecimalPrice());
                    itemPO.setPurchasePrice(itemPO.getSalePrice());
                    itemPO.setTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getTotalSalePrice()));
                    itemPO.setTotalPurchaseFee(itemPO.getTotalSaleFee());
                    itemPO.setNakedPrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getTotalNakePrice()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                itemPO.setOrganizationId(goodsTempPO.getOrganizationId());
                itemPO.setOrganizationName(goodsTempPO.getOrganizationName());
                itemPO.setArrivalTime(goodsTempPO.getArrivalTime());
                this.ordItemMapper.updateById(itemPO);
                payItemPO.setPayCount(itemPO.getPurchaseCount());
                payItemPO.setPayFee(itemPO.getSalePrice());
                payItemPO.setTotalFee(itemPO.getTotalSaleFee());
                payItemPO.setOrderId(itemPO.getOrderId());
                payItemPO.setOrdItemId(itemPO.getOrdItemId());
                this.ordPayItemMapper.updateById(payItemPO);
                UocOrdZmItemPO zmItemPO = new UocOrdZmItemPO();
                BeanUtils.copyProperties((Object)goodsTempPO, (Object)zmItemPO);
                zmItemPO.setOrdItemId(itemPO.getOrdItemId());
                this.uocOrdZmItemMapper.update(zmItemPO);
                OrdGoodsPO goodsPO = new OrdGoodsPO();
                goodsPO.setSkuMaterialRemark(goodsTempPO.getSkuMaterialRemark());
                goodsPO.setOrdItemId(itemPO.getOrdItemId());
                this.ordGoodsMapper.updateByItem(goodsPO);
                goodsTempPO.setPurchaseCount(itemPO.getPurchaseCount().subtract(qry.getPurchaseCount()));
            }
            if (!saleStateList.contains(last.getSaleState()) || !"1".equals(reqBO.getSubmit())) continue;
            if (pushFz) {
                updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                updateOrderItemBO.setGoodTypeId(goodsTempPO.getOutObjItemId());
                updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                updateOrderItemBO.setOperateType(1);
                updateOrderItemBO.setOrderNum(purChaseCountAll);
                operOrderItem.add(updateOrderItemBO);
            }
            if (!pushHt) continue;
            ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
            abilityBo.setItemId(goodsTempPO.getHtItemId());
            abilityBo.setNum(purChaseCountAll);
            planOrderReqBo.add(abilityBo);
        }
        salePO.setSaleFee(saleFee);
        salePO.setPurchaseFee(saleFee);
        this.ordSaleMapper.updateById(salePO);
        orderPO.setTotalSaleFee(saleFee);
        orderPO.setTotalPurchaseFee(saleFee);
        this.orderMapper.updateById(orderPO);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(salePO.getOrderId());
        ordPayPO.setPayFee(saleFee);
        this.ordPayMapper.updateById(ordPayPO);
        if (CollectionUtils.isNotEmpty(zmItemInsert)) {
            this.uocOrdZmItemMapper.insertBatch(zmItemInsert);
            this.ordPayItemMapper.insertBatch(payItemPOS);
        }
        BigDecimal fee = MoneyUtil.l4B((Long)(saleFee - last.getSaleFee()));
        if (pushHt && PebExtConstant.YES.toString().equals(reqBO.getSubmit())) {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setOrderId(reqBO.getOrderId());
            extMapPO.setObjId(reqBO.getOrderId());
            extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            extMapPO.setFieldCode("contractFee");
            OrdExtMapPO qry = this.ordExtMapMapper.getModelBy(extMapPO);
            OrdAgreementPO agreementPO = new OrdAgreementPO();
            agreementPO.setOrderId(reqBO.getOrderId());
            agreementPO = (OrdAgreementPO)this.ordAgreementMapper.selectByCondition(agreementPO).get(0);
            ContractOrderedAmountSynAbilityReqBO abilityReqBO = new ContractOrderedAmountSynAbilityReqBO();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.valueOf(agreementPO.getAgreementId()));
            abilityReqBO.setContractIds(ids);
            boolean flag = true;
            if (qry != null && PebExtConstant.YES.toString().equals(qry.getFieldValue())) {
                abilityReqBO.setOrderAmount(fee);
                if (fee.compareTo(BigDecimal.ZERO) > 0) {
                    abilityReqBO.setOperType("0");
                } else {
                    abilityReqBO.setOperType("1");
                }
                if (fee.compareTo(BigDecimal.ZERO) == 0) {
                    flag = false;
                }
            } else {
                BigDecimal pushFee = BigDecimal.ZERO;
                if (PebExtConstant.YES.equals(agreementPO.getAssignStatus())) {
                    pushFee = MoneyUtil.l4B((Long)saleFee);
                } else {
                    OrdItemPO ordItemPo = new OrdItemPO();
                    ordItemPo.setOrderId(reqBO.getOrderId());
                    List ordItemList = this.ordItemMapper.getList(ordItemPo);
                    for (OrdItemPO itemPO : ordItemList) {
                        try {
                            BigDecimal price = itemPO.getTax() == null ? new BigDecimal(0) : new BigDecimal((float)itemPO.getTax().longValue() / 100.0f);
                            BigDecimal djs = MoneyUtil.l4B((Long)itemPO.getTotalSaleFee());
                            BigDecimal taxA = price.add(BigDecimal.ONE);
                            pushFee = pushFee.add(djs.subtract(djs.multiply(price).divide(taxA, 6, RoundingMode.HALF_UP)));
                        }
                        catch (Exception exception) {}
                    }
                }
                abilityReqBO.setOrderAmount(pushFee);
                abilityReqBO.setOperType("0");
            }
            if (flag) {
                ContractOrderedAmountSynAbilityRspBO rspBO = this.contractOrderedAmountSynAbilityService.orderedAmountSyn(abilityReqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
                }
                extMapPO.setFieldName("\u4fee\u6539\u5408\u540c\u9650\u989d");
                if (qry != null) {
                    extMapPO.setId(qry.getId());
                    extMapPO.setFieldValue(PebExtConstant.YES.toString());
                    this.ordExtMapMapper.updateById(extMapPO);
                } else {
                    extMapPO.setFieldValue(PebExtConstant.YES.toString());
                    extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                    this.ordExtMapMapper.insert(extMapPO);
                }
            }
        }
        if (operOrderItem.size() > 0) {
            InterFaceContractUpdateOrderItemAtomReqBO interFaceContractUpdateOrderItemAtomReqBO = new InterFaceContractUpdateOrderItemAtomReqBO();
            interFaceContractUpdateOrderItemAtomReqBO.setToken(reqBO.getToken());
            interFaceContractUpdateOrderItemAtomReqBO.setOrderItem(operOrderItem);
            InterFaceContractUpdateOrderItemAtomRspBO interFaceContractUpdateOrderItemAtomRspBO = this.interFaceContractUpdateOrderItemAtomService.updateSchemeOrderItemStatus(interFaceContractUpdateOrderItemAtomReqBO);
            if (!"0000".equals(interFaceContractUpdateOrderItemAtomRspBO.getRespCode())) {
                throw new UocProBusinessException(interFaceContractUpdateOrderItemAtomRspBO.getRespCode(), "\u4fee\u6539\u65b9\u6848\u660e\u7ec6\u62a5\u9519\uff1a" + interFaceContractUpdateOrderItemAtomRspBO.getRespDesc());
            }
        }
        if (planOrderReqBo.size() > 0) {
            ContractPlanOrderAbilityReqBo reqBo = new ContractPlanOrderAbilityReqBo();
            reqBo.setPlanOrderReqBo(planOrderReqBo);
            ContractPlanOrderAbilityRspBo abilityRspBo = this.contractPlanOrderAbilityService.dealContractOrder(reqBo);
            if (!"0000".equals(abilityRspBo.getRespCode())) {
                throw new UocProBusinessException(abilityRspBo.getRespCode(), "\u5408\u540c\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a" + abilityRspBo.getRespDesc());
            }
        }
    }

    private void dealItem(OrdSalePO salePO, OrderPO orderPO, PebUpdateOrderReqBO reqBO) {
        HashSet<Long> ordItemIds = new HashSet<Long>();
        for (UocOrdItemUpdateBO pebExtOrdItemRspBO : reqBO.getOrdItemUpdateList()) {
            if (pebExtOrdItemRspBO.getOrdItemId() == null) continue;
            ordItemIds.add(pebExtOrdItemRspBO.getOrdItemId());
        }
        if (CollectionUtils.isEmpty(ordItemIds)) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a\u4f20\u5165\u7684ordItemId\u6709\u8bef");
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrdItemIdList(new ArrayList(ordItemIds));
        List ordItemPOS = this.ordItemMapper.getList(ordItemPO);
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrdItemIdList(new ArrayList(ordItemIds));
        List ordGoodsPOS = this.ordGoodsMapper.getList(ordGoodsPO);
        if (CollectionUtils.isEmpty((Collection)ordItemPOS) || ordItemPOS.size() != ordItemIds.size()) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a\u4f20\u5165\u7684ordItemId\u6709\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)ordGoodsPOS) || ordGoodsPOS.size() != ordItemIds.size()) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a\u4f20\u5165\u7684ordItemId\u6709\u8bef");
        }
        Map<Long, OrdItemPO> itemPOMap = ordItemPOS.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, e -> e, (k, v) -> k));
        Map<Long, OrdGoodsPO> goodsPOMap = ordGoodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, e -> e, (k, v) -> k));
        Long totalSaleFee = 0L;
        Long totalPurchaseFee = 0L;
        for (UocOrdItemUpdateBO pebExtOrdItemRspBO : reqBO.getOrdItemUpdateList()) {
            if (itemPOMap.get(pebExtOrdItemRspBO.getOrdItemId()) == null) {
                throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a:\u660e\u7ec6id\u67e5\u8be2\u660e\u7ec6\u5931\u8d25");
            }
            OrdItemPO ordItemPO1 = itemPOMap.get(pebExtOrdItemRspBO.getOrdItemId());
            Long sumSaleFee = new BigDecimal(ordItemPO1.getSalePrice()).multiply(pebExtOrdItemRspBO.getPurchaseCount()).longValue();
            Long sumPurchaseFee = new BigDecimal(ordItemPO1.getPurchasePrice()).multiply(pebExtOrdItemRspBO.getPurchaseCount()).longValue();
            this.updatePrice(itemPOMap, goodsPOMap, pebExtOrdItemRspBO, sumSaleFee, sumPurchaseFee, pebExtOrdItemRspBO.getPurchaseCount());
            try {
                totalSaleFee = totalSaleFee + MoneyUtils.BigDecimal2Long((BigDecimal)ordItemPO.getSaleDecimalPrice().multiply(pebExtOrdItemRspBO.getPurchaseCount()).setScale(2, 4));
                totalPurchaseFee = totalPurchaseFee + MoneyUtils.BigDecimal2Long((BigDecimal)ordItemPO.getPurchaseDecimalPrice().multiply(pebExtOrdItemRspBO.getPurchaseCount()).setScale(2, 4));
            }
            catch (Exception exception) {}
        }
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(reqBO.getOrderId());
        purchasePO.setPurchaseFee(totalPurchaseFee);
        purchasePO.setSaleFee(totalSaleFee);
        purchasePO.setOrderId(reqBO.getOrderId());
        this.ordPurchaseMapper.updateById(purchasePO);
        salePO.setSaleFee(totalSaleFee);
        salePO.setPurchaseFee(totalPurchaseFee);
        this.ordSaleMapper.updateById(salePO);
        orderPO.setTotalSaleFee(totalSaleFee);
        orderPO.setTotalPurchaseFee(totalPurchaseFee);
        this.orderMapper.updateById(orderPO);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(salePO.getOrderId());
        ordPayPO.setPayFee(totalSaleFee);
        this.ordPayMapper.updateById(ordPayPO);
    }

    private void updatePrice(Map<Long, OrdItemPO> itemPOMap, Map<Long, OrdGoodsPO> goodsPOMap, UocOrdItemUpdateBO pebExtOrdItemRspBO, Long sumSaleFee, Long sumPurchaseFee, BigDecimal purchaseCount) {
        Long ordItemId = pebExtOrdItemRspBO.getOrdItemId();
        if (itemPOMap.get(ordItemId) == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a:\u660e\u7ec6id\u67e5\u8be2\u660e\u7ec6\u5931\u8d25");
        }
        OrdItemPO ordItemPO = itemPOMap.get(ordItemId);
        OrdPurchaseItemPO ordPurchaseItemPO = new OrdPurchaseItemPO();
        ordPurchaseItemPO.setOrderItemId(ordItemId);
        ordPurchaseItemPO.setPurchaseCount(purchaseCount);
        ordPurchaseItemPO.setTotalPurchaseFee(sumPurchaseFee);
        ordPurchaseItemPO.setTotalSaleFee(sumSaleFee);
        ordPurchaseItemPO.setOrderId(ordItemPO.getOrderId());
        ordPurchaseItemPO.setTotalPurchaseDecimalPrice(ordItemPO.getPurchaseDecimalPrice().multiply(purchaseCount).setScale(2, 4));
        ordPurchaseItemPO.setTotalSaleDecimalPrice(ordItemPO.getSaleDecimalPrice().multiply(purchaseCount).setScale(2, 4));
        this.ordPurchaseItemMapper.updateById(ordPurchaseItemPO);
        OrdPayItemPO ordPayItemPO = new OrdPayItemPO();
        ordPayItemPO.setOrdItemId(ordItemId);
        ordPayItemPO.setPayFee(sumSaleFee);
        ordPayItemPO.setTotalPurchaseDecimalPrice(ordPurchaseItemPO.getTotalPurchaseDecimalPrice());
        ordPayItemPO.setTotalSaleDecimalPrice(ordPurchaseItemPO.getTotalSaleDecimalPrice());
        ordPayItemPO.setOrderId(ordItemPO.getOrderId());
        ordPayItemPO.setPurchaseCount(purchaseCount);
        this.ordPayItemMapper.updateById(ordPayItemPO);
        ordItemPO.setPurchaseCount(pebExtOrdItemRspBO.getPurchaseCount());
        ordItemPO.setTotalPurchaseFee(sumPurchaseFee);
        ordItemPO.setTotalSaleFee(sumSaleFee);
        if (StringUtils.isNotBlank((CharSequence)pebExtOrdItemRspBO.getOrganizationId())) {
            ordItemPO.setOrganizationId(pebExtOrdItemRspBO.getOrganizationId());
        }
        if (StringUtils.isNotBlank((CharSequence)pebExtOrdItemRspBO.getOrganizationName())) {
            ordItemPO.setOrganizationName(pebExtOrdItemRspBO.getOrganizationName());
        }
        ordItemPO.setTotalPurchaseDecimalPrice(ordPurchaseItemPO.getTotalPurchaseDecimalPrice());
        ordItemPO.setTotalSaleDecimalPrice(ordPurchaseItemPO.getTotalSaleDecimalPrice());
        this.ordItemMapper.updateById(ordItemPO);
        OrdGoodsPO OrdGoodsPO2 = goodsPOMap.get(ordItemId);
        if (OrdGoodsPO2 == null) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a:\u660e\u7ec6id\u67e5\u8be2\u5546\u54c1\u8868\u5931\u8d25");
        }
        boolean updateGoods = false;
        if (StringUtils.isNotBlank((CharSequence)pebExtOrdItemRspBO.getMaterialRemark())) {
            OrdGoodsPO2.setSkuMaterialRemark(pebExtOrdItemRspBO.getMaterialRemark());
            updateGoods = true;
        }
        if (StringUtils.isNotBlank((CharSequence)pebExtOrdItemRspBO.getTechnicalParameters())) {
            OrdGoodsPO2.setExt1(pebExtOrdItemRspBO.getTechnicalParameters());
            updateGoods = true;
        }
        if (updateGoods) {
            this.ordGoodsMapper.updateById(OrdGoodsPO2);
        }
    }

    private Long insertItem(UocOrdGoodsTempPO tempPO, List<OrdPayItemPO> list, Long saleId, OrdPurchasePO purchaseP, Long payId) {
        OrdItemPO itemPO = new OrdItemPO();
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        itemPO.setOrdItemId(Long.valueOf(this.idUtil.nextId()));
        goodsPO.setOrdItemId(itemPO.getOrdItemId());
        goodsPO.setGoodsItemId(Long.valueOf(this.idUtil.nextId()));
        itemPO.setTempId(tempPO.getTempId());
        itemPO.setPurchaseVoucherId(purchaseP.getPurchaseVoucherId());
        goodsPO.setSkuCode(tempPO.getSkuCode());
        goodsPO.setSkuMaterialId(tempPO.getSkuMaterialId());
        goodsPO.setCreateTime(new Date());
        itemPO.setItemType(Integer.valueOf(2));
        if (StringUtils.isBlank((CharSequence)tempPO.getSkuId())) {
            itemPO.setSkuId(tempPO.getSkuMaterialId().trim());
            itemPO.setSkuName(tempPO.getSkuMaterialName());
            goodsPO.setSkuName(tempPO.getSkuMaterialName());
            goodsPO.setSkuId(tempPO.getSkuMaterialId().trim());
            goodsPO.setSpuId(tempPO.getSkuMaterialId());
        } else {
            itemPO.setSkuId(tempPO.getSkuId());
            itemPO.setSkuName(tempPO.getSkuName());
            goodsPO.setSkuId(tempPO.getSkuId());
            goodsPO.setSkuName(tempPO.getSkuName());
            goodsPO.setSpuId(tempPO.getExt5());
        }
        itemPO.setOrderId(purchaseP.getOrderId());
        goodsPO.setOrderId(purchaseP.getOrderId());
        itemPO.setSaleVoucherId(saleId);
        goodsPO.setSkuMaterialName(tempPO.getExt8());
        itemPO.setExtField2(tempPO.getSkuMaterialName());
        goodsPO.setSkuMaterialTypeId(tempPO.getExt1());
        goodsPO.setSkuMaterialTypeName(tempPO.getExt2());
        itemPO.setPurchaseCount(tempPO.getPurchaseCount());
        goodsPO.setExt4(tempPO.getExt6());
        goodsPO.setExt6(tempPO.getExt7());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getHtId())) {
            itemPO.setExtField1(tempPO.getHtId());
        }
        try {
            itemPO.setTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice().multiply(tempPO.getPurchaseCount())));
            itemPO.setTotalPurchaseFee(itemPO.getTotalSaleFee());
            itemPO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            itemPO.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            itemPO.setArriveCount(BigDecimal.ZERO);
            itemPO.setSendCount(BigDecimal.ZERO);
            itemPO.setRefuseCount(BigDecimal.ZERO);
            itemPO.setReturnCount(BigDecimal.ZERO);
            itemPO.setAcceptanceCount(BigDecimal.ZERO);
            itemPO.setInspChangeCount(BigDecimal.ZERO);
            itemPO.setAfterServingCount(BigDecimal.ZERO);
            itemPO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
            itemPO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
            itemPO.setTotalSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            itemPO.setTotalPurchaseDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            goodsPO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setTotalSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            goodsPO.setTotalPurchaseDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((CharSequence)tempPO.getPlanId())) {
            itemPO.setPlanId(Long.valueOf(tempPO.getPlanId()));
        }
        goodsPO.setSkuMaterialRemark(tempPO.getSkuMaterialRemark());
        itemPO.setOrganizationId(tempPO.getOrganizationId());
        itemPO.setOrganizationName(tempPO.getOrganizationName());
        itemPO.setExtField3(tempPO.getMaterialUnitName());
        itemPO.setTaxId(tempPO.getTaxCode());
        itemPO.setTax(tempPO.getTax());
        itemPO.setUnitName(tempPO.getUnitName());
        goodsPO.setModel(tempPO.getModel());
        goodsPO.setSpec(tempPO.getSpec());
        if (tempPO.getArrivalTime() != null) {
            itemPO.setArrivalTime(String.valueOf(tempPO.getArrivalTime()));
        } else {
            itemPO.setArrivalTime(this.maxShipTime);
        }
        itemPO.setSettleUnit(tempPO.getExt1());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getExt2())) {
            itemPO.setSalesUnitRate(new BigDecimal(tempPO.getExt2()));
        }
        itemPO.setSupNo(String.valueOf(tempPO.getSupplierShopId()));
        itemPO.setSupplierShopId(tempPO.getSupplierShopId());
        goodsPO.setSupplierShopId(tempPO.getSupplierShopId());
        goodsPO.setSupplierShopName(tempPO.getSkuSupplierName());
        goodsPO.setSkuCurrencyType("CNY");
        goodsPO.setSkuBrandName(tempPO.getPpcd());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getExt3())) {
            goodsPO.setSkuCommodityTypeId(Long.valueOf(tempPO.getExt3()));
        }
        goodsPO.setSkuMaterialTypeId(tempPO.getCateCode());
        goodsPO.setSkuMaterialTypeName(tempPO.getCateName());
        goodsPO.setMaterialBj(tempPO.getMaterialBj());
        goodsPO.setExt1(tempPO.getZljsyq());
        itemPO.setInspectionExcessPercent(Integer.valueOf(0));
        OrdPurchaseItemPO purchaseItemPO = new OrdPurchaseItemPO();
        BeanUtils.copyProperties((Object)itemPO, (Object)purchaseItemPO);
        purchaseItemPO.setPurchaseItemId(Long.valueOf(this.idUtil.nextId()));
        purchaseItemPO.setOrderItemId(itemPO.getOrdItemId());
        this.ordItemMapper.insert(itemPO);
        this.ordGoodsMapper.insert(goodsPO);
        this.ordPurchaseItemMapper.insert(purchaseItemPO);
        OrdPayItemPO uocOrderPayItemBO = new OrdPayItemPO();
        uocOrderPayItemBO.setOrdItemId(itemPO.getOrdItemId());
        uocOrderPayItemBO.setPayObjId(itemPO.getOrdItemId());
        uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
        uocOrderPayItemBO.setPurchaseCount(itemPO.getPurchaseCount());
        uocOrderPayItemBO.setUnitName(itemPO.getUnitName());
        uocOrderPayItemBO.setSalePrice(itemPO.getSalePrice());
        uocOrderPayItemBO.setPurchasePrice(itemPO.getPurchasePrice());
        uocOrderPayItemBO.setCurrencyType(itemPO.getCurrencyType());
        uocOrderPayItemBO.setPayCount(itemPO.getPurchaseCount());
        uocOrderPayItemBO.setTotalFee(itemPO.getTotalSaleFee());
        uocOrderPayItemBO.setPayFee(itemPO.getTotalSaleFee());
        uocOrderPayItemBO.setOrderId(purchaseP.getOrderId());
        uocOrderPayItemBO.setPayItemId(Long.valueOf(this.idUtil.nextId()));
        uocOrderPayItemBO.setReduceFee(Long.valueOf(0L));
        uocOrderPayItemBO.setPayVoucherId(payId);
        uocOrderPayItemBO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
        uocOrderPayItemBO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
        uocOrderPayItemBO.setTotalSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
        uocOrderPayItemBO.setTotalPurchaseDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
        list.add(uocOrderPayItemBO);
        return itemPO.getOrdItemId();
    }

    private void saveAccessory(PebUpdateOrderReqBO reqBO, Long orderId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("CREATE_ORDER");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void updateExt(String key, String name, String val, Long orderId) {
        if (val.equals("")) {
            val = " ";
        }
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setFieldValue(val);
        extMapPO.setFieldCode(key);
        extMapPO.setFieldName(name);
        extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        extMapPO.setObjId(orderId);
        extMapPO.setOrderId(orderId);
        this.ordExtMapMapper.updateById(extMapPO);
    }

    private void updateAddr(PebExtAddressInfoIntfceReqBO addressInfoIntfceBO, OrdSalePO salePO) {
        OrdLogisticsRelaPO relaPO = new OrdLogisticsRelaPO();
        relaPO.setOrderId(salePO.getOrderId());
        relaPO.setContactId(salePO.getContactId());
        relaPO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        relaPO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        relaPO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        relaPO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        relaPO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        relaPO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        relaPO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        relaPO.setContactName(addressInfoIntfceBO.getReceiverName());
        relaPO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        relaPO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        relaPO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        relaPO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        relaPO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        relaPO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        relaPO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        relaPO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        this.ordLogisticsRelaMapper.updateById(relaPO);
    }

    @Override
    public PebUpdateOrderRspBO updateHt(PebUpdateOrderReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO.setExt1(reqBO.getType());
        this.ordSaleMapper.updateById(salePO);
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public PebUpdateOrderRspBO updateFscStatus(PebUpdateOrderReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        reqBO.setSaleVoucherId(salePO.getSaleVoucherId());
        OrderPO orderPO = new OrderPO();
        orderPO.setExt9(reqBO.getFscStatus());
        orderPO.setExt10(reqBO.getFscStatus());
        orderPO.setOrderId(reqBO.getOrderId());
        this.orderMapper.updateById(orderPO);
        PebUpdateOrderRspBO rspBO = new PebUpdateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

