/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.common.ability.api.FscAccountDealWelfareDeductAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDealWelfareDeductAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfCancelPurchaseOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderAbilityReqBo;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderAbilityRspBo;
import com.tydic.uoc.busibase.busi.bo.PebIntfCancelPurchaseOrderData;
import com.tydic.uoc.common.ability.bo.OrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancelRspBO;
import com.tydic.uoc.common.atom.api.UocCoreChgVoucherStateAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryTacheIntfAtomService;
import com.tydic.uoc.common.atom.api.UocPebRefundAtomService;
import com.tydic.uoc.common.atom.api.UocPebUniCallIntfAtomService;
import com.tydic.uoc.common.atom.api.UocQrySaleOrderAtomService;
import com.tydic.uoc.common.atom.api.UocReturnFeeAtomService;
import com.tydic.uoc.common.atom.bo.InterfaceDefBO;
import com.tydic.uoc.common.atom.bo.QrySaleReqBO;
import com.tydic.uoc.common.atom.bo.UnicallInterfaceDefBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryTacheIntfReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryTacheIntfRspBO;
import com.tydic.uoc.common.atom.bo.UocPebUniCallIntfReqBO;
import com.tydic.uoc.common.atom.bo.UocPebUniCallIntfRspBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeAtomRspBO;
import com.tydic.uoc.common.atom.bo.VoucherStateBO;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.common.busi.bo.UocReverseReqBO;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdItemFlMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrderRelMapper;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdItemFlPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrderRelPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uocPebOrderCancelBusiService")
public class UocPebOrderCancelBusiServiceImpl
implements UocPebOrderCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderCancelBusiServiceImpl.class);
    @Autowired
    private UocPebRefundAtomService uocPebRefundAtomService;
    @Autowired
    private UocQrySaleOrderAtomService saleOrderAtomService;
    @Autowired
    private UocPebUniCallIntfAtomService uocPebUniCallIntfAtomService;
    @Autowired
    private UocCoreQryTacheIntfAtomService uocCoreQryTacheIntfAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocCoreChgVoucherStateAtomService uocCoreChgVoucherStateAtomService;
    @Value(value="${UOC_ORDER_CANCEL_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CANCEL_TAG}")
    private String tag;
    @Resource(name="uocPebOrderCancelMsgProvider")
    private ProxyMessageProducer uocPebOrderCancelMsgProvider;
    @Value(value="${uoc.reverse:false}")
    private Boolean reverse;
    @Autowired
    private FscAccountDealWelfareDeductAbilityService fscAccountDealWelfareDeductAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private PebIntfCancelPurchaseOrderAbilityService pebIntfCancelPurchaseOrderAbilityService;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Autowired
    private UocReturnFeeAtomService uocReturnFeeAtomService;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;
    @Autowired
    private UocOrdItemFlMapper uocOrdItemFlMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;

    @Override
    public UocPebOrderCancelRspBO dealOrderCancel(UocPebOrderCancelReqBO reqBO) {
        UocPebOrderCancelRspBO rspBO = new UocPebOrderCancelRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.validateArg(reqBO);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO = this.orderMapper.getModelBy(orderPO);
        QrySaleReqBO qrySaleReqBO = new QrySaleReqBO();
        qrySaleReqBO.setOrderId(reqBO.getOrderId());
        qrySaleReqBO.setSaleId(reqBO.getSaleVoucherId());
        OrdSaleRspBO saleRspBO = this.saleOrderAtomService.qry(qrySaleReqBO);
        if (!PebExtConstant.OrderType.FL.equals(orderPO.getOrderType()) && !PebExtConstant.OrderType.GC.equals(orderPO.getOrderType()) && (UocConstant.SALE_ORDER_STATUS.ZONE_RECEIVED.equals(saleRspBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_ACCEPT_PART.equals(saleRspBO.getSaleState()))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9a8c\u6536\u4e86\u7684\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u53d6\u6d88");
            return rspBO;
        }
        rspBO.setSaleId(saleRspBO.getSaleVoucherId());
        OrdQueryIndexPO ordQueryIndexModel = new OrdQueryIndexPO();
        ordQueryIndexModel.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        ordQueryIndexModel.setOrderId(reqBO.getOrderId());
        OrdQueryIndexPO result = this.ordQueryIndexMapper.getModelBy(ordQueryIndexModel);
        UocOrderRelPO relPO = new UocOrderRelPO();
        relPO.setOrderId(reqBO.getOrderId());
        int count = this.uocOrderRelMapper.getCheckByOrderId(reqBO.getOrderId().longValue());
        if (count > 0) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u6709\u7ed3\u7b97\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        if (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(saleRspBO.getSaleState())) {
            OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
            ordInspectionPO.setOrderId(reqBO.getOrderId());
            ordInspectionPO.setInspTotalSaleFee(Long.valueOf(0L));
            ordInspectionPO.setInspTotalPurchaseFee(Long.valueOf(0L));
            this.ordInspectionMapper.updateById(ordInspectionPO);
            OrdInspectionItemPO inspectionItemPO = new OrdInspectionItemPO();
            inspectionItemPO.setOrderId(reqBO.getOrderId());
            inspectionItemPO.setInspectionCount(BigDecimal.ZERO);
            inspectionItemPO.setInspPurchaseFee(Long.valueOf(0L));
            inspectionItemPO.setInspPurchaseFee(Long.valueOf(0L));
            this.ordInspectionItemMapper.updateByOrderId(inspectionItemPO);
        }
        if (!(result == null || reqBO.getNotInterface() != null && reqBO.getNotInterface().booleanValue())) {
            UocCoreQryTacheIntfReqBO uocCoreQryTacheIntfReqBO = new UocCoreQryTacheIntfReqBO();
            uocCoreQryTacheIntfReqBO.setFlowFlag(UocConstant.FLOW_FLAG.NEGATIVE);
            uocCoreQryTacheIntfReqBO.setTacheCode(String.valueOf(UocConstant.SALE_ORDER_STATUS.CANCEL));
            UocCoreQryTacheIntfRspBO intfRspBO = this.uocCoreQryTacheIntfAtomService.qryTacheIntf(uocCoreQryTacheIntfReqBO);
            if (!"0000".equals(intfRspBO.getRespCode())) {
                rspBO.setRespCode("102078");
                rspBO.setRespDesc(intfRspBO.getRespDesc());
                return rspBO;
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(intfRspBO.getInterfaceList())) {
                for (InterfaceDefBO defBO : intfRspBO.getInterfaceList()) {
                    try {
                        UocPebUniCallIntfReqBO callIntfReqBO = new UocPebUniCallIntfReqBO();
                        UnicallInterfaceDefBO interfaceDefBO = new UnicallInterfaceDefBO();
                        BeanUtils.copyProperties((Object)defBO, (Object)interfaceDefBO);
                        callIntfReqBO.setInterfaceDef(interfaceDefBO);
                        callIntfReqBO.setOrderId(reqBO.getOrderId());
                        callIntfReqBO.setObjId(reqBO.getSaleVoucherId());
                        callIntfReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                        UocPebUniCallIntfRspBO uocPebUniCallIntfRspBO = this.uocPebUniCallIntfAtomService.dealUniCallIntf(callIntfReqBO);
                        if ("0000".equals(uocPebUniCallIntfRspBO.getRespCode()) || reqBO.getThrowEx() == null || !reqBO.getThrowEx().booleanValue()) continue;
                        throw new UocProBusinessException("\u53d6\u6d88\u7535\u5546\u5931\u8d25\uff1a", uocPebUniCallIntfRspBO.getRespDesc());
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        this.updateOrder(reqBO, orderPO);
        this.updateStatus(reqBO, saleRspBO, orderPO);
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(reqBO.getOrderId());
        stakeholderPO.setExtField3("1");
        this.ordStakeholderMapper.updateById(stakeholderPO);
        this.pusherp(saleRspBO, reqBO.getCancelDesc() == null ? "\u8ba2\u5355\u53d6\u6d88" : reqBO.getCancelDesc());
        if (!"0000".equals(reqBO.getFailCode())) {
            UocReturnFeeAtomReqBO atomReqBO = new UocReturnFeeAtomReqBO();
            try {
                atomReqBO.setFee(MoneyUtils.Long2BigDecimal((Long)saleRspBO.getSaleFee()));
                atomReqBO.setProFee(MoneyUtils.Long2BigDecimal((Long)saleRspBO.getPurchaseFee()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            atomReqBO.setOrderId(saleRspBO.getOrderId());
            atomReqBO.setObjId(saleRspBO.getSaleVoucherId());
            atomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            atomReqBO.setSaleState(saleRspBO.getSaleState());
            UocReturnFeeAtomRspBO atomRspBO = this.uocReturnFeeAtomService.returnFee(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new UocProBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
            atomReqBO.setOrderId(saleRspBO.getOrderId());
            if (atomRspBO.getIsFl().booleanValue()) {
                rspBO.setReqJsonStr(JSON.toJSONString((Object)atomReqBO));
            }
        }
        if (this.reverse != null && this.reverse.booleanValue()) {
            UocReverseReqBO reverseReqBO = new UocReverseReqBO();
            reverseReqBO.setOrderId(saleRspBO.getOrderId());
            reverseReqBO.setObjId(saleRspBO.getSaleVoucherId());
            reverseReqBO.setObjType(UocConstant.ORDER_TYPE.SALE_ORDER);
            reverseReqBO.setPrice(saleRspBO.getSaleFee());
            this.uocPebOrderCancelMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)reverseReqBO)));
        }
        this.pushFsc(saleRspBO, reqBO.getName());
        return rspBO;
    }

    private void pushFsc(OrdSaleRspBO ordSalePo, String name) {
        UocOrdItemFlPO itemFlPO = new UocOrdItemFlPO();
        itemFlPO.setOrderId(ordSalePo.getOrderId());
        List bos = this.uocOrdItemFlMapper.selectByCondition(itemFlPO);
        if (CollectionUtils.isEmpty((Collection)bos)) {
            return;
        }
        OrdCruxMapPO cruxMapPO = new OrdCruxMapPO();
        cruxMapPO.setOrderId(ordSalePo.getOrderId());
        cruxMapPO.setFieldName1("\u798f\u70b9\u63a8\u9001\u7ed3\u7b97");
        cruxMapPO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
        cruxMapPO = this.ordCruxMapMapper.getModelBy(cruxMapPO);
        if (cruxMapPO == null) {
            return;
        }
        if (!PebExtConstant.YES.toString().equals(cruxMapPO.getFieldValue1())) {
            return;
        }
        BigDecimal fee = BigDecimal.ZERO;
        for (UocOrdItemFlPO flBO : bos) {
            fee = fee.add(flBO.getFee().subtract(flBO.getRetrunFee())).negate();
        }
        if (fee.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        FscAccountDealWelfareDeductAbilityReqBO deductAbilityReqBO = new FscAccountDealWelfareDeductAbilityReqBO();
        deductAbilityReqBO.setOperationType(Integer.valueOf(3));
        OrdStakeholderPO stakeholderPo = this.ordStakeholderMapper.getModelById(ordSalePo.getOrderId().longValue());
        if ("2".equals(((UocOrdItemFlPO)bos.get(0)).getExt6())) {
            deductAbilityReqBO.setPayType(Integer.valueOf(Integer.parseInt("2")));
        } else {
            deductAbilityReqBO.setPayType(Integer.valueOf(Integer.parseInt("3")));
        }
        deductAbilityReqBO.setSupId(Long.valueOf(stakeholderPo.getProNo()));
        deductAbilityReqBO.setCreditOrgId(Long.valueOf(((UocOrdItemFlPO)bos.get(0)).getExt5()));
        deductAbilityReqBO.setOrderNo(ordSalePo.getSaleVoucherNo());
        deductAbilityReqBO.setOrderId(ordSalePo.getOrderId());
        deductAbilityReqBO.setTotalAmount(fee);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name)) {
            name = stakeholderPo.getPurPlaceOrderName();
        }
        deductAbilityReqBO.setName(name);
        deductAbilityReqBO.setBusiOrderType(Integer.valueOf(3));
        deductAbilityReqBO.setObjId(ordSalePo.getSaleVoucherId());
        if (!StringUtils.isEmpty((Object)((UocOrdItemFlPO)bos.get(0)).getExt4())) {
            deductAbilityReqBO.setWelfareType(Integer.valueOf(((UocOrdItemFlPO)bos.get(0)).getExt4()));
        }
        deductAbilityReqBO.setWelfareChargeCode(((UocOrdItemFlPO)bos.get(0)).getExt3());
        deductAbilityReqBO.setWelfarePointCode(((UocOrdItemFlPO)bos.get(0)).getExt1());
        deductAbilityReqBO.setWelfarePointName(((UocOrdItemFlPO)bos.get(0)).getExt2());
        FscAccountDealWelfareDeductAbilityRspBO abilityRspBO = this.fscAccountDealWelfareDeductAbilityService.dealWelfareDeduct(deductAbilityReqBO);
        if ("0000".equals(abilityRspBO.getRespCode())) {
            cruxMapPO.setFieldValue1(PebExtConstant.YES.toString());
        } else {
            cruxMapPO.setFieldValue1(PebExtConstant.NO.toString());
        }
        this.ordCruxMapMapper.updateById(cruxMapPO);
    }

    private void pusherp(OrdSaleRspBO salePO, String desc) {
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(salePO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (!PebExtConstant.YES.equals(zmInfoPO.getErpStatus())) {
            return;
        }
        PebIntfCancelPurchaseOrderAbilityReqBo reqBo = new PebIntfCancelPurchaseOrderAbilityReqBo();
        PebIntfCancelPurchaseOrderData orderData = new PebIntfCancelPurchaseOrderData();
        ArrayList<PebIntfCancelPurchaseOrderData> data = new ArrayList<PebIntfCancelPurchaseOrderData>();
        orderData.setCANCEL_REASON(desc);
        orderData.setUSER_NAME(zmInfoPO.getErpUserName());
        orderData.setORG_ID(Long.valueOf(zmInfoPO.getBuynerErpNo()));
        orderData.setPO_NUM(salePO.getSaleVoucherNo());
        data.add(orderData);
        reqBo.setPBATCH_ID(String.valueOf(System.currentTimeMillis()));
        reqBo.setHEADER_DATA(data);
        PebIntfCancelPurchaseOrderAbilityRspBo rspBo = this.pebIntfCancelPurchaseOrderAbilityService.cancelPurchaseOrder(reqBo);
        if (!("0000".equals(rspBo.getRespCode()) || rspBo.getRespDesc().contains("\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c") || rspBo.getRespDesc().contains("\u5df2\u53d6\u6d88"))) {
            throw new UocProBusinessException(rspBo.getRespCode(), "\u53d6\u6d88erp\u5931\u8d25:" + rspBo.getRespDesc());
        }
        this.saveLog(salePO.getOrderId(), rspBo, reqBo);
    }

    private void saveLog(Long orderId, PebIntfCancelPurchaseOrderAbilityRspBo purchaseOrderRspBO, PebIntfCancelPurchaseOrderAbilityReqBo purchaseOrderReqBO) {
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(purchaseOrderRspBO.getRespCode());
        logBO.setOutContent(purchaseOrderRspBO.getReturnString());
        logBO.setRetTime(new Date());
        logBO.setOrderId(orderId);
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setObjId(orderId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        logBO.setFlowFlag(1);
        logBO.setErrDetail("1");
        logBO.setInContent(JSON.toJSONString((Object)purchaseOrderReqBO));
        logBO.setInterCode("pushErp");
        logBO.setInterSn("1");
        logBO.setCallCount(1);
        logBO.setCallState("1");
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateOrder(UocPebOrderCancelReqBO reqBO, OrderPO orderPO) {
        orderPO.setCancelDesc(reqBO.getCancelDesc() == null ? "\u8ba2\u5355\u53d6\u6d88" : reqBO.getCancelDesc());
        orderPO.setCancelReason(reqBO.getCancelReason());
        orderPO.setCancelTime(new Date());
        if (reqBO.getCancelOperId() != null) {
            orderPO.setCancelOperId(reqBO.getCancelOperId());
        } else {
            orderPO.setCancelOperId(reqBO.getUserId() == null ? orderPO.getCreateOperId() : String.valueOf(reqBO.getUserId()));
        }
        orderPO.setProcState(reqBO.getFailCode());
        orderPO.setOrderState(UocConstant.CORE_ORDER_STATUS.CANCEL);
        try {
            this.orderMapper.updateById(orderPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102078", "\u8ba2\u5355\u53d6\u6d88\u66f4\u6539\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
    }

    private void updateStatus(UocPebOrderCancelReqBO reqBO, OrdSaleRspBO saleRspBO, OrderPO orderPO) {
        UocCoreChgVoucherStateReqBO voucherStateReqBO = new UocCoreChgVoucherStateReqBO();
        voucherStateReqBO.setDealDesc("\u8ba2\u5355\u53d6\u6d88");
        if (reqBO.getCancelOperId() != null) {
            voucherStateReqBO.setOperId(reqBO.getCancelOperId());
        } else {
            voucherStateReqBO.setOperId(orderPO.getCreateOperId());
        }
        voucherStateReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<VoucherStateBO> voucherStateBOS = new ArrayList<VoucherStateBO>();
        VoucherStateBO voucherStateBO = new VoucherStateBO();
        voucherStateBO.setAfterState(UocConstant.SALE_ORDER_STATUS.CANCEL);
        voucherStateBO.setObjId(saleRspBO.getSaleVoucherId());
        voucherStateBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        voucherStateBOS.add(voucherStateBO);
        voucherStateReqBO.setVoucherStateList(voucherStateBOS);
        UocCoreChgVoucherStateRspBO rspBO = this.uocCoreChgVoucherStateAtomService.dealCoreChgVoucherState(voucherStateReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("102078", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u66f4\u65b0\u72b6\u6001\u5931\u8d25," + rspBO.getRespDesc());
        }
    }

    private void validateArg(UocPebOrderCancelReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getCancelOperId()) && reqBO.getUserId() != null) {
            reqBO.setCancelOperId(reqBO.getUserId().toString());
        }
    }
}

