/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.UocPebOrderDelieveredRejectReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderDelieveredRejectRspBO;
import com.tydic.uoc.common.atom.api.UocCoreArriveRegistAtomService;
import com.tydic.uoc.common.atom.api.UocCoreExtFieldInAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderIdByOutOrderNoAtomService;
import com.tydic.uoc.common.atom.api.UocPebRefundAtomService;
import com.tydic.uoc.common.atom.api.UocReturnFeeAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.ArriveInfoBO;
import com.tydic.uoc.common.atom.bo.CommonCenterFieldValueBO;
import com.tydic.uoc.common.atom.bo.UocCoreArriveRegistReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreArriveRegistRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreExtFieldInReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreExtFieldInRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderIdByOutOrderNoReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderIdByOutOrderNoRspBO;
import com.tydic.uoc.common.atom.bo.UocPebRefundReqBO;
import com.tydic.uoc.common.atom.bo.UocPebRefundRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocReturnFeeAtomRspBO;
import com.tydic.uoc.common.busi.api.UocPayOrderReFundBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderDelieveredRejectBusiService;
import com.tydic.uoc.config.aop.DuplicateCommitLimit;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.ConfSupplierPO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebOrderDelieveredRejectBusiService")
public class UocPebOrderDelieveredRejectBusiServiceImpl
implements UocPebOrderDelieveredRejectBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderDelieveredRejectBusiServiceImpl.class);
    private ConfSupplierMapper confSupplierMapper;
    private OrdShipMapper shipMapper;
    private OrdShipItemMapper shipItemMapper;
    private UocCoreQryOrderIdByOutOrderNoAtomService uocCoreQryOrderIdByOutOrderNoAtomService;
    private UocPebRefundAtomService uocPebRefundAtomService;
    private UocCoreArriveRegistAtomService uocCoreArriveRegistAtomService;
    private OrdSaleMapper ordSaleMapper;
    private OrderMapper orderMapper;
    private OrdItemMapper ordItemMapper;
    private UocRunProcessAtomService uocRunProcessAtomService;
    private UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService;
    @Value(value="${ship.item.ext:false}")
    private Boolean itemExt;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocPayOrderReFundBusiService uocPayOrderReFundBusiService;
    @Autowired
    private UocReturnFeeAtomService uocReturnFeeAtomService;

    @Autowired
    public UocPebOrderDelieveredRejectBusiServiceImpl(ConfSupplierMapper confSupplierMapper, OrdShipMapper shipMapper, OrdShipItemMapper shipItemMapper, UocCoreQryOrderIdByOutOrderNoAtomService uocCoreQryOrderIdByOutOrderNoAtomService, UocPebRefundAtomService uocPebRefundAtomService, UocCoreArriveRegistAtomService uocCoreArriveRegistAtomService, OrdSaleMapper ordSaleMapper, OrderMapper orderMapper, UocRunProcessAtomService uocRunProcessAtomService, OrdItemMapper ordItemMapper, UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService) {
        this.confSupplierMapper = confSupplierMapper;
        this.shipMapper = shipMapper;
        this.shipItemMapper = shipItemMapper;
        this.uocCoreQryOrderIdByOutOrderNoAtomService = uocCoreQryOrderIdByOutOrderNoAtomService;
        this.uocPebRefundAtomService = uocPebRefundAtomService;
        this.uocCoreArriveRegistAtomService = uocCoreArriveRegistAtomService;
        this.ordSaleMapper = ordSaleMapper;
        this.orderMapper = orderMapper;
        this.uocRunProcessAtomService = uocRunProcessAtomService;
        this.ordItemMapper = ordItemMapper;
        this.uocCoreExtFieldInAtomService = uocCoreExtFieldInAtomService;
    }

    @Override
    @DuplicateCommitLimit
    public UocPebOrderDelieveredRejectRspBO executePebOrderDelieveredReject(UocPebOrderDelieveredRejectReqBO reqBO) {
        this.validateArg(reqBO);
        UocPebOrderDelieveredRejectRspBO rspBO = new UocPebOrderDelieveredRejectRspBO();
        UocCoreQryOrderIdByOutOrderNoRspBO inOrderIdAndOutOrderIdRspBO = this.qryOrderIdByOutOrder(reqBO);
        OrdSalePO ordSalePO = this.qryOrdSaleAndValidateState(inOrderIdAndOutOrderIdRspBO);
        Long saleVoucherId = ordSalePO.getSaleVoucherId();
        Long orderId = ordSalePO.getOrderId();
        rspBO.setOrderNo(ordSalePO.getSaleVoucherNo());
        Long shipVoucherId = inOrderIdAndOutOrderIdRspBO.getObjId();
        OrdShipPO ordShipPO = this.qryOrdShip(orderId, shipVoucherId);
        if (ordShipPO.getShipStatus().equals("1203") || ordShipPO.getShipStatus().equals("1205")) {
            rspBO.setRespCode("102072");
            rspBO.setRespDesc("\u8be5\u53d1\u8d27\u5355\u5df2\u7ecf\u5904\u7406\u6210\u529f");
            return rspBO;
        }
        List<OrdShipItemPO> ordShipItemPOList = this.qryOrdShipItemList(ordShipPO.getOrderId(), ordShipPO.getShipVoucherId());
        this.executeArriveRegist(reqBO, inOrderIdAndOutOrderIdRspBO, ordShipPO, ordShipItemPOList);
        if (PecConstant.EXT_ORDER_STATE.RECEIVED.equals(reqBO.getStatus())) {
            this.executeArriveStateProcess(shipVoucherId, orderId);
        }
        if (PecConstant.EXT_ORDER_STATE.REFUSED.equals(reqBO.getStatus())) {
            this.executeRejectStateProcess(shipVoucherId, orderId);
        }
        OrdItemPO ordItemModel = new OrdItemPO();
        ordItemModel.setOrderId(orderId);
        List ordItemPOList = this.ordItemMapper.getList(ordItemModel);
        boolean isAllReceive = this.judgeIsAllReceive(orderId, ordItemPOList);
        if (isAllReceive) {
            this.executeUpdateSaleOrdState(orderId, saleVoucherId, ordItemPOList, rspBO);
            this.addOrderDelieveredTime(ordSalePO);
            rspBO.setEntireFlag(Integer.valueOf(1));
        }
        this.judgeIsExecuteRefund(ordSalePO, reqBO, inOrderIdAndOutOrderIdRspBO);
        if (PecConstant.EXT_ORDER_STATE.REFUSED.equals(reqBO.getStatus())) {
            long fee = 0L;
            long profee = 0L;
            for (OrdItemPO itemPO : ordItemPOList) {
                for (OrdShipItemPO shipItemPO : ordShipItemPOList) {
                    if (!itemPO.getOrdItemId().equals(shipItemPO.getOrdItemId())) continue;
                    fee += new BigDecimal(itemPO.getSalePrice()).multiply(shipItemPO.getSendCount()).longValue();
                    profee += new BigDecimal(itemPO.getPurchasePrice()).multiply(shipItemPO.getSendCount()).longValue();
                }
            }
            UocReturnFeeAtomReqBO atomReqBO = new UocReturnFeeAtomReqBO();
            try {
                atomReqBO.setFee(MoneyUtils.Long2BigDecimal((Long)fee));
                atomReqBO.setProFee(MoneyUtils.Long2BigDecimal((Long)profee));
            }
            catch (Exception itemPO) {
                // empty catch block
            }
            atomReqBO.setOrderId(reqBO.getOrderId());
            atomReqBO.setObjId(shipVoucherId);
            atomReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
            UocReturnFeeAtomRspBO atomRspBO = this.uocReturnFeeAtomService.returnFee(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new UocProBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
            if (atomRspBO.getIsFl().booleanValue()) {
                atomReqBO.setOrderId(reqBO.getOrderId());
                rspBO.setReqJsonStr(JSON.toJSONString((Object)atomReqBO));
            }
        }
        rspBO.setOrderId(orderId);
        rspBO.setSaleVoucherId(saleVoucherId);
        rspBO.setShipVoucherId(shipVoucherId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private ConfSupplierPO qryConfSupplier(UocPebOrderDelieveredRejectReqBO reqBO) {
        try {
            return this.confSupplierMapper.getModelById(reqBO.getSupplierId().longValue());
        }
        catch (Exception e) {
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u662f\u5426\u4e00\u6b21\u6027\u53d1\u8d27");
        }
    }

    private UocCoreQryOrderIdByOutOrderNoRspBO qryOrderIdByOutOrder(UocPebOrderDelieveredRejectReqBO reqBO) {
        UocCoreQryOrderIdByOutOrderNoReqBO qryOrderIdByOutOrderNoReqBO = new UocCoreQryOrderIdByOutOrderNoReqBO();
        qryOrderIdByOutOrderNoReqBO.setOutOrderNo(reqBO.getExtOrderId());
        qryOrderIdByOutOrderNoReqBO.setOrderSystem(String.valueOf(PecConstant.OBJECT_TYPE_ORDER_SHIP));
        UocCoreQryOrderIdByOutOrderNoRspBO qryOrderIdByOutOrderNoRspBO = this.uocCoreQryOrderIdByOutOrderNoAtomService.qryOrderIdByOutOrderNo(qryOrderIdByOutOrderNoReqBO);
        if (!"0000".equals(qryOrderIdByOutOrderNoRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u6839\u636e\u5916\u90e8\u8ba2\u5355\u53f7\u67e5\u8be2\u53d1\u8d27\u5355\u5931\u8d25");
            }
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u6839\u636e\u5916\u90e8\u8ba2\u5355\u53f7\u67e5\u8be2\u53d1\u8d27\u5355\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a" + qryOrderIdByOutOrderNoRspBO.getRespDesc());
        }
        return qryOrderIdByOutOrderNoRspBO;
    }

    private OrdSalePO qryOrdSaleAndValidateState(UocCoreQryOrderIdByOutOrderNoRspBO qryOrderIdByOutOrderNoRspBO) {
        OrdSalePO ordSaleModel = new OrdSalePO();
        ordSaleModel.setOrderId(qryOrderIdByOutOrderNoRspBO.getOrderId());
        try {
            OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(ordSaleModel);
            if (ordSalePO == null) {
                throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f!");
            }
            if (!UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED.equals(ordSalePO.getSaleState())) {
                throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5f53\u524d\u72b6\u6001\u4e0d\u4e3a\u53d1\u8d27\u4e2d,\u4e0d\u5141\u8bb8\u8fdb\u884c\u59a5\u6295-\u62d2\u6536\u64cd\u4f5c!");
            }
            return ordSalePO;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38!");
        }
    }

    private void judgeIsExecuteRefund(OrdSalePO ordSalePO, UocPebOrderDelieveredRejectReqBO reqBO, UocCoreQryOrderIdByOutOrderNoRspBO qryOrderIdByOutOrderNoRspBO) {
        OrderPO orderPO = this.qryOrder(ordSalePO);
        if (PecConstant.EXT_ORDER_STATE.REFUSED.equals(reqBO.getStatus()) && PecConstant.ENTERPRISE_ORDER_TYPE.equals(ordSalePO.getOrderLevel())) {
            UocPebRefundReqBO refundReqBO = new UocPebRefundReqBO();
            refundReqBO.setIsNeedOutBackPay(PecConstant.IS_NEED_OUT_BACKPAY_YES);
            refundReqBO.setSource(PecConstant.ORDER_SOURCE.ELEC_SUPERMARKET);
            refundReqBO.setOrderId(qryOrderIdByOutOrderNoRspBO.getOrderId());
            refundReqBO.setObjType(qryOrderIdByOutOrderNoRspBO.getObjType());
            refundReqBO.setObjId(qryOrderIdByOutOrderNoRspBO.getObjId());
            refundReqBO.setUserId(Long.valueOf(orderPO.getCreateOperId()));
            UocPebRefundRspBO refundRspBO = this.uocPebRefundAtomService.dealUocPebRefund(refundReqBO);
            if (!"0000".equals(refundRspBO.getRespCode())) {
                if (log.isDebugEnabled()) {
                    log.debug("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u7801\uff1a" + refundRspBO.getFailCode() + "\u5931\u8d25\u539f\u56e0\u63cf\u8ff0\uff1a" + refundRspBO.getFailDesc() + "\u5f02\u5e38\u63cf\u8ff0\uff1a" + refundRspBO.getRespDesc());
                }
                throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a" + refundRspBO.getRespDesc());
            }
        }
    }

    private OrderPO qryOrder(OrdSalePO ordSalePO) {
        OrderPO orderModel = new OrderPO();
        orderModel.setOrderId(ordSalePO.getOrderId());
        OrderPO orderPO = this.orderMapper.getModelBy(orderModel);
        if (orderPO == null) {
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f!");
        }
        return orderPO;
    }

    private void executeArriveRegist(UocPebOrderDelieveredRejectReqBO reqBO, UocCoreQryOrderIdByOutOrderNoRspBO qryOrderIdByOutOrderNoRspBO, OrdShipPO ordShipPO, List<OrdShipItemPO> ordShipItemPOList) {
        ArrayList<ArriveInfoBO> arriveInfoBOList = new ArrayList<ArriveInfoBO>();
        boolean notArrive = false;
        for (OrdShipItemPO shipItemPO : ordShipItemPOList) {
            ArriveInfoBO arriveInfoBO = new ArriveInfoBO();
            arriveInfoBO.setShipItemId(shipItemPO.getShipItemId());
            if (PecConstant.EXT_ORDER_STATE.REFUSED.equals(reqBO.getStatus())) {
                arriveInfoBO.setRejectCount(shipItemPO.getSendCount());
            } else if (PecConstant.EXT_ORDER_STATE.RECEIVED.equals(reqBO.getStatus())) {
                arriveInfoBO.setArriveCount(shipItemPO.getSendCount());
                if (shipItemPO.getArriveCount() != null && shipItemPO.getSendCount().compareTo(shipItemPO.getArriveCount()) <= 0) {
                    notArrive = true;
                }
                this.saveExt(shipItemPO);
            }
            arriveInfoBOList.add(arriveInfoBO);
        }
        if (notArrive) {
            return;
        }
        UocCoreArriveRegistReqBO arriveRegistReqBO = new UocCoreArriveRegistReqBO();
        arriveRegistReqBO.setShipVoucherId(ordShipPO.getShipVoucherId());
        arriveRegistReqBO.setOrderId(ordShipPO.getOrderId());
        arriveRegistReqBO.setCreateOperId(ordShipPO.getCreateOperId());
        arriveRegistReqBO.setArriveInfoList(arriveInfoBOList);
        UocCoreArriveRegistRspBO arriveRegistRspBO = this.uocCoreArriveRegistAtomService.dealCoreArriveRegist(arriveRegistReqBO);
        if (!"0000".equals(arriveRegistRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
            }
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
        }
        this.updateShipArriveTime(ordShipPO.getOrderId(), ordShipPO.getShipVoucherId());
    }

    private void saveExt(OrdShipItemPO shipItemPO) {
        if (this.itemExt == null || !this.itemExt.booleanValue()) {
            return;
        }
        OrdItemMapPO qryMapPO = new OrdItemMapPO();
        qryMapPO.setOrderItemId(shipItemPO.getOrdItemId());
        qryMapPO.setOrderId(shipItemPO.getOrderId());
        qryMapPO.setFieldCode("planWarehouseStatus");
        qryMapPO = this.ordItemMapMapper.getModelBy(qryMapPO);
        OrdItemMapPO mapPO = new OrdItemMapPO();
        mapPO.setId(Long.valueOf(this.idUtil.nextId()));
        mapPO.setOrderItemId(shipItemPO.getOrdItemId());
        mapPO.setOrderId(shipItemPO.getOrderId());
        mapPO.setFieldCode("planWarehouseStatus");
        mapPO.setFieldName("\u5165\u5e93\u72b6\u6001");
        mapPO.setFieldValue("4");
        if (qryMapPO == null) {
            this.ordItemMapMapper.insert(mapPO);
        } else {
            qryMapPO.setFieldValue(mapPO.getFieldValue());
            this.ordItemMapMapper.updateById(qryMapPO);
        }
    }

    private OrdShipPO qryOrdShip(Long orderId, Long shipVoucherId) {
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setOrderId(orderId);
        ordShipModel.setShipVoucherId(shipVoucherId);
        try {
            OrdShipPO ordShipPO = this.shipMapper.getModelBy(ordShipModel);
            if (ordShipPO == null) {
                throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u4fe1\u606f!");
            }
            return ordShipPO;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u5f02\u5e38!");
        }
    }

    private List<OrdShipItemPO> qryOrdShipItemList(Long orderId, Long shipVoucherId) {
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(orderId);
        ordShipItemPO.setShipVoucherId(shipVoucherId);
        try {
            List ordShipItemPOList = this.shipItemMapper.getList(ordShipItemPO);
            if (ordShipItemPOList == null || ordShipItemPOList.isEmpty()) {
                throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u4fe1\u606f!");
            }
            return ordShipItemPOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
        }
    }

    private void updateShipArriveTime(Long orderId, Long shipVoucherId) {
        OrdShipPO ordShipModel = new OrdShipPO();
        ordShipModel.setArriveTime(new Date());
        ordShipModel.setShipVoucherId(shipVoucherId);
        ordShipModel.setOrderId(orderId);
        try {
            int updateArriveTimeResult = this.shipMapper.updateById(ordShipModel);
            if (updateArriveTimeResult < 1) {
                if (log.isDebugEnabled()) {
                    log.debug("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5931\u8d25!");
                }
                throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5f02\u5e38!");
        }
    }

    private void executeArriveStateProcess(Long shipVoucherId, Long orderId) {
        try {
            Integer extOrderStatus = PecConstant.SHIP_RECEIVED_STATE.ALL_RECEIVED;
            this.runProcess(shipVoucherId, orderId, UocConstant.OBJ_TYPE.SHIP, extOrderStatus, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u6267\u884c\u59a5\u6295\u64cd\u4f5c\u52a8\u4f5c\u662f\u53d1\u8d27\u5355\u72b6\u6001\u5f02\u5e38!");
        }
    }

    private void executeRejectStateProcess(Long shipVoucherId, Long orderId) {
        try {
            Integer extOrderStatus = PecConstant.SHIP_RECEIVED_STATE.ALL_REFUSEDR;
            this.runProcess(shipVoucherId, orderId, UocConstant.OBJ_TYPE.SHIP, extOrderStatus, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u6267\u884c\u62d2\u6536\u64cd\u4f5c\u52a8\u4f5c\u662f\u53d1\u8d27\u5355\u72b6\u6001\u5f02\u5e38!");
        }
    }

    private boolean judgeIsAllReceive(Long orderId, List<OrdItemPO> ordItemPOList) {
        boolean isAllReceive = true;
        try {
            if (ordItemPOList == null || ordItemPOList.isEmpty()) {
                throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u4e3a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!");
            }
            BigDecimal totalPurchaseCount = new BigDecimal(0);
            BigDecimal totalArriveCount = new BigDecimal(0);
            for (OrdItemPO ordItemPO : ordItemPOList) {
                totalPurchaseCount = totalPurchaseCount.add(ordItemPO.getPurchaseCount());
                BigDecimal arriveCount = ordItemPO.getArriveCount().add(ordItemPO.getRefuseCount());
                totalArriveCount = totalArriveCount.add(arriveCount);
            }
            if (!totalArriveCount.equals(totalPurchaseCount)) {
                isAllReceive = false;
            }
            log.info("------------------------\u662f\u5426\u662f\u5168\u90e8\u5230\u8d27\u72b6\u6001\u503c\uff1a" + isAllReceive);
            return isAllReceive;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38!");
        }
    }

    private void executeUpdateSaleOrdState(Long orderId, Long saleVoucherId, List<OrdItemPO> ordItemPOList, UocPebOrderDelieveredRejectRspBO rspBO) {
        try {
            HashMap<String, Object> map;
            OrderPO orderPO;
            OrderPO qry;
            OrdShipPO ordShipModel = new OrdShipPO();
            ordShipModel.setOrderId(orderId);
            List ordShipPOList = this.shipMapper.getList(ordShipModel);
            if (ordShipPOList == null || ordShipPOList.isEmpty()) {
                throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!");
            }
            Integer isAllReceived = 0;
            for (Object ordShipPO : ordShipPOList) {
                if (!"1205".equals(ordShipPO.getShipStatus())) continue;
                isAllReceived = isAllReceived + 1;
            }
            boolean flag = true;
            for (OrdItemPO ordItemPO : ordItemPOList) {
                BigDecimal last = ordItemPO.getPurchaseCount().subtract(ordItemPO.getRefuseCount()).subtract(ordItemPO.getReturnCount());
                BigDecimal rh = BigDecimal.ZERO;
                if (StringUtils.isNotBlank((CharSequence)ordItemPO.getExtField5())) {
                    rh = new BigDecimal(ordItemPO.getExtField5());
                }
                if (last.compareTo(rh) <= 0) continue;
                flag = false;
                break;
            }
            if (isAllReceived == 0) {
                qry = this.orderMapper.getModelById(orderId.longValue());
                if (PebExtConstant.OrderType.GC.equals(qry.getOrderType()) || PebExtConstant.OrderType.FL.equals(qry.getOrderType())) {
                    this.runProcess(saleVoucherId, orderId, UocConstant.OBJ_TYPE.SALE, PecConstant.SHIP_RECEIVED_STATE.ALL_RECEIVED, null);
                } else if (flag) {
                    this.runProcess(saleVoucherId, orderId, UocConstant.OBJ_TYPE.SALE, PecConstant.SHIP_RECEIVED_STATE.ALL_RECEIVED, null);
                } else {
                    orderPO = new OrderPO();
                    orderPO.setOrderId(orderId);
                    orderPO.setOrderSystem(UocConstant.SALE_ORDER_STATUS.ARRIVED.toString());
                    this.orderMapper.updateById(orderPO);
                    map = new HashMap<String, Object>();
                    map.put("rejectFlag", "4");
                    this.runProcess(saleVoucherId, orderId, UocConstant.OBJ_TYPE.SALE, PecConstant.SHIP_RECEIVED_STATE.ALL_RECEIVED, map);
                    rspBO.setIsSendMsg(PebExtConstant.YES);
                }
            } else if (isAllReceived.intValue() == ordShipPOList.size()) {
                this.runProcess(saleVoucherId, orderId, UocConstant.OBJ_TYPE.SALE, PecConstant.SHIP_RECEIVED_STATE.ALL_REFUSEDR, null);
                OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
                stakeholderPO.setOrderId(orderId);
                stakeholderPO.setExtField3("1");
                this.ordStakeholderMapper.updateById(stakeholderPO);
            } else {
                qry = this.orderMapper.getModelById(orderId.longValue());
                if (PebExtConstant.OrderType.GC.equals(qry.getOrderType()) || PebExtConstant.OrderType.FL.equals(qry.getOrderType())) {
                    this.runProcess(saleVoucherId, orderId, UocConstant.OBJ_TYPE.SALE, PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED, null);
                } else if (flag) {
                    this.runProcess(saleVoucherId, orderId, UocConstant.OBJ_TYPE.SALE, PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED, null);
                } else {
                    orderPO = new OrderPO();
                    orderPO.setOrderId(orderId);
                    orderPO.setOrderSystem(UocConstant.SALE_ORDER_STATUS.ARRIVED.toString());
                    this.orderMapper.updateById(orderPO);
                    map = new HashMap();
                    map.put("rejectFlag", "4");
                    this.runProcess(saleVoucherId, orderId, UocConstant.OBJ_TYPE.SALE, PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED, map);
                    rspBO.setIsSendMsg(PebExtConstant.YES);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            throw new UocProBusinessException("102072", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38!");
        }
    }

    private void runProcess(Long objId, Long orderId, Integer objType, Integer extOrderStatus, Map<String, Object> variables) {
        UocProcessRunRspBO uocProcessRunRspBO;
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(orderId);
        processRunReqBO.setOperId("0");
        processRunReqBO.setVariables(null);
        if (null != extOrderStatus) {
            HashMap<String, Object> map;
            if (PecConstant.SHIP_RECEIVED_STATE.ALL_REFUSEDR.equals(extOrderStatus)) {
                map = new HashMap<String, Object>(1);
                map.put("rejectFlag", PecConstant.SHIP_RECEIVED_STATE.ALL_REFUSEDR);
                processRunReqBO.setVariables(map);
            } else if (PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED.equals(extOrderStatus)) {
                map = new HashMap(1);
                map.put("rejectFlag", PecConstant.SHIP_RECEIVED_STATE.PART_RECEIVED);
                processRunReqBO.setVariables(map);
            } else {
                map = new HashMap(1);
                map.put("rejectFlag", PecConstant.SHIP_RECEIVED_STATE.ALL_RECEIVED);
                processRunReqBO.setVariables(map);
            }
        }
        if (variables != null) {
            processRunReqBO.setVariables(null);
            processRunReqBO.setVariables(variables);
        }
        if (!"0000".equals((uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO)).getRespCode())) {
            throw new UocProBusinessException("102072", "\u901a\u8fc7\u5165\u53c2\uff1a" + processRunReqBO.toString() + "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void addOrderDelieveredTime(OrdSalePO ordSalePO) {
        ArrayList<CommonCenterFieldValueBO> extFieldList = new ArrayList<CommonCenterFieldValueBO>();
        CommonCenterFieldValueBO fieldValueBO = new CommonCenterFieldValueBO();
        fieldValueBO.setFieldCode("delieveredTime");
        fieldValueBO.setFieldName("\u8ba2\u5355\u59a5\u6295\u65f6\u95f4");
        fieldValueBO.setFieldValue(DateUtils.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        extFieldList.add(fieldValueBO);
        UocCoreExtFieldInReqBO uocCoreExtFieldInReqBO = new UocCoreExtFieldInReqBO();
        uocCoreExtFieldInReqBO.setOrderId(ordSalePO.getOrderId());
        uocCoreExtFieldInReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        uocCoreExtFieldInReqBO.setObjId(ordSalePO.getSaleVoucherId());
        uocCoreExtFieldInReqBO.setExtFieldList(extFieldList);
        UocCoreExtFieldInRspBO uocCoreExtFieldInRspBO = this.uocCoreExtFieldInAtomService.dealCoreExtFieldIn(uocCoreExtFieldInReqBO);
        if (!"0000".equals(uocCoreExtFieldInRspBO.getRespCode())) {
            throw new UocProBusinessException("102072", "\u8ba2\u5355\u59a5\u6295\u65f6\u95f4\u6269\u5c55\u5c5e\u6027\u5165\u5e93\u5931\u8d25!" + uocCoreExtFieldInRspBO.getRespDesc());
        }
    }

    private void validateArg(UocPebOrderDelieveredRejectReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getExtOrderId())) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010extOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010supplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getStatus() == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010status\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

