/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.common.busi.api.UocGeneralCirculationBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import com.tydic.uoc.common.comb.api.UocGeneralCirculationCombService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocGeneralCirculationCombServiceImpl
implements UocGeneralCirculationCombService {
    @Autowired
    private UocGeneralCirculationBusiService uocGeneralCirculationBusiService;
    @Resource(name="dealZoneDealAutomaticTaskMsgProvider")
    private ProxyMessageProducer dealZoneDealAutomaticTaskMsgProvider;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TOPIC}")
    private String taskTopic;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TAG}")
    private String taskTag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;

    @Override
    public UocGeneralCirculationRspBO dealGeneralCirculation(UocGeneralCirculationReqBO reqBO) {
        UocGeneralCirculationRspBO rspBO = this.uocGeneralCirculationBusiService.dealGeneralCirculation(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        if (!StringUtils.isEmpty((CharSequence)rspBO.getReqJsonStr())) {
            this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, rspBO.getReqJsonStr()));
        }
        if (rspBO.getAuto().booleanValue() && reqBO.getActionCode().equals("ACTPEB019")) {
            UocGeneralCirculationReqBO circulationReqBO = new UocGeneralCirculationReqBO();
            circulationReqBO.setActionCode("ACTPEB020");
            circulationReqBO.setObjId(reqBO.getObjId());
            circulationReqBO.setOrderId(reqBO.getOrderId());
            circulationReqBO.setObjType(reqBO.getObjType());
            this.dealZoneDealAutomaticTaskMsgProvider.send(new ProxyMessage(this.taskTopic, this.taskTag, JSONObject.toJSONString((Object)((Object)circulationReqBO))));
        }
        return rspBO;
    }
}

