/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.common.ability.bo.PebExtAgreementCancelAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtApprovalOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtDealOrderBO;
import com.tydic.uoc.common.ability.bo.UocSendMessageReqBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.enums.UocSaleStateEnum;
import com.tydic.uoc.common.utils.UocNotificationUtil;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderNotifyComponent {
    private static final Logger log = LoggerFactory.getLogger(OrderNotifyComponent.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private UocNotificationUtil uocNotificationUtil;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    public void syncNotApprovedNoticeMessage(PebExtApprovalOrderReqBO reqBO) {
        CompletableFuture.supplyAsync(() -> {
            for (PebExtDealOrderBO pebExtDealOrderBO : reqBO.getOrderInfo()) {
                OrdSalePO salePO = new OrdSalePO();
                salePO.setSaleVoucherId(pebExtDealOrderBO.getSaleVoucherId());
                salePO = this.ordSaleMapper.getModelBy(salePO);
                OrderPO orderPO = new OrderPO();
                orderPO.setOrderId(salePO.getOrderId());
                OrderPO orderModel = this.orderMapper.getModelBy(orderPO);
                OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
                ordStakeholderPO.setOrderId(salePO.getOrderId());
                OrdStakeholderPO ordStakeholderModel = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
                List<Long> messageUserList = UocSaleStateEnum.getMessageUserList(salePO, orderModel, ordStakeholderModel);
                UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
                uocSendMessageReqBO.setUserId(Long.valueOf(1L));
                uocSendMessageReqBO.setReceiveIds(messageUserList);
                uocSendMessageReqBO.setTitel(MessageFormat.format("\u8ba2\u5355\u5ba1\u6279\u9a73\u56de - \u3010{0}\u3011", salePO.getSaleVoucherNo()));
                uocSendMessageReqBO.setText(MessageFormat.format("\u8ba2\u5355\u7f16\u53f7\uff1a\u3010{0}\u3011\u7531\u3010{1}({2})\u3011\u5728 \uff08{3}\uff09\u5ba1\u6279\u9a73\u56de\uff0c\u8bf7\u77e5\u6089\u3002", salePO.getSaleVoucherNo(), reqBO.getName(), reqBO.getUserCode(), DateUtil.dateToStrLong((Date)new Date())));
                log.info("order not approved syncNoticeMessage param:{}", (Object)JSON.toJSONString((Object)uocSendMessageReqBO));
                this.uocNotificationUtil.sendNotification(uocSendMessageReqBO);
            }
            return null;
        });
    }

    public void syncCancelNoticeMessage(OrdSalePO salePO, PebExtAgreementCancelAbilityReqBO reqBO) {
        CompletableFuture.supplyAsync(() -> {
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(salePO.getOrderId());
            OrderPO orderModel = this.orderMapper.getModelBy(orderPO);
            OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
            ordStakeholderPO.setOrderId(salePO.getOrderId());
            OrdStakeholderPO ordStakeholderModel = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
            List<Long> messageUserList = UocSaleStateEnum.getMessageUserList(salePO, orderModel, ordStakeholderModel);
            SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
            SelectSingleDictRspBO dictRspBO = new SelectSingleDictRspBO();
            String orderStatusDesc = null;
            dictReqBO.setCode(salePO.getSaleState() + "");
            dictReqBO.setPcode("SALE_ORDER_STATUS");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                orderStatusDesc = dictRspBO.getDicDictionarys().getDescrip();
            }
            UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
            uocSendMessageReqBO.setUserId(Long.valueOf(1L));
            uocSendMessageReqBO.setReceiveIds(messageUserList);
            uocSendMessageReqBO.setTitel(MessageFormat.format("\u8ba2\u5355\u53d6\u6d88 - \u3010{0}\u3011", salePO.getSaleVoucherNo()));
            uocSendMessageReqBO.setText(MessageFormat.format("\u8ba2\u5355\u7f16\u53f7\uff1a\u3010{0}\u3011- \u3010{1}\u3011\u7531{2}\uff08{3}\uff09\u5728 \uff08{4}\uff09\u7533\u8bf7\u8ba2\u5355\u53d6\u6d88\uff0c\u8bf7\u77e5\u6089\u3002", salePO.getSaleVoucherNo(), orderStatusDesc, reqBO.getName(), reqBO.getUserCode(), DateUtil.dateToStrLong((Date)new Date())));
            log.info("order cancel syncNoticeMessage param:{}", (Object)JSON.toJSONString((Object)uocSendMessageReqBO));
            this.uocNotificationUtil.sendNotification(uocSendMessageReqBO);
            return null;
        });
    }
}

