/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebComfirmByUserAbilityService;
import com.tydic.uoc.common.ability.bo.PebPushErpReqBO;
import com.tydic.uoc.common.ability.bo.PebPushErpRspBO;
import com.tydic.uoc.common.busi.api.PebComfirmByUserBusiService;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebComfirmByUserAbilityService"})
public class PebComfirmByUserAbilityServiceImpl
implements PebComfirmByUserAbilityService {
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebComfirmByUserBusiService pebComfirmByUserBusiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @PostMapping(value={"dealPushErp"})
    public PebPushErpRspBO dealPushErp(@RequestBody PebPushErpReqBO reqBO) {
        if (!StringUtils.isEmpty((Object)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (!UocConstant.SALE_ORDER_STATUS.USER_COMFRIM.equals(salePO.getSaleState())) {
            this.syncIndex(reqBO);
            throw new UocProBusinessException("102080", "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c");
        }
        PebPushErpRspBO rspBO = this.pebComfirmByUserBusiService.dealPushErp(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.syncIndex(reqBO);
        }
        return rspBO;
    }

    private void syncIndex(PebPushErpReqBO reqBO) {
        PebExtOrdIdxSyncReqBO syncReqBO = new PebExtOrdIdxSyncReqBO();
        syncReqBO.setOrderId(reqBO.getOrderId());
        syncReqBO.setObjId(reqBO.getSaleVoucherId());
        syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)syncReqBO))));
    }
}

