/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.common.OrderNotifyComponent;
import com.tydic.uoc.common.ability.api.PebExtAgreementCancelAbilityService;
import com.tydic.uoc.common.ability.api.PebExtSyncUnifyChangeAbilityService;
import com.tydic.uoc.common.ability.api.UocPebOrderCancellationAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtAgreementCancelAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementCancelAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtCancelRspBO;
import com.tydic.uoc.common.ability.bo.PebExtSyncUnifyChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancellationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderCancellationAbilityRspBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.ability.enums.TodoWaitTypeEnum;
import com.tydic.uoc.common.atom.bo.SendNotificationExtAtomReqBO;
import com.tydic.uoc.common.busi.api.PebExtCancelBusiService;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.common.enums.UocSaleStateEnum;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.dao.UocPlanBargainOrderMapper;
import com.tydic.uoc.po.BusinessDiversionInfo;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocPlanBargainOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtAgreementCancelAbilityService"})
public class PebExtAgreementCancelAbilityServiceImpl
implements PebExtAgreementCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtAgreementCancelAbilityServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocPebOrderCancellationAbilityService uocPebOrderCancellationAbilityService;
    @Autowired
    private PebExtSyncUnifyChangeAbilityService pebExtSyncUnifyChangeAbilityService;
    @Autowired
    private PebExtCancelBusiService pebExtCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Resource(name="uocFlMsgProvider")
    private ProxyMessageProducer uocFlMsgProvider;
    @Value(value="${UOC_FL_TOPIC:UOC_FL_TOPIC}")
    private String orderFlTopic;
    @Value(value="${UOC_Fl_TAG:*}")
    private String orderFlTag;
    @Autowired
    private OrderNotifyComponent orderNotifyComponent;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Resource
    private UocPlanBargainOrderMapper uocPlanBargainOrderMapper;
    @Resource(name="sendNotificationOrderOrderProvider")
    private ProxyMessageProducer sendNotificationOrderOrderProvider;
    @Value(value="${SEND_NOTIFICATION_TOPIC:SEND_NOTIFICATION_TOPIC}")
    private String sendNotificationTopic;
    @Value(value="${SEND_NOTIFICATION_TAG:SEND_NOTIFICATION_TAG}")
    private String sendNotificationTag;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;

    @PostMapping(value={"agreementCancel"})
    public PebExtAgreementCancelAbilityRspBO agreementCancel(@RequestBody PebExtAgreementCancelAbilityReqBO reqBO) {
        log.info("agreementCancel reqBO:{}", (Object)JSON.toJSONString((Object)reqBO));
        reqBO.setUserCode(reqBO.getUsername());
        if (!StringUtils.isEmpty((Object)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        PebExtAgreementCancelAbilityRspBO rspBO = new PebExtAgreementCancelAbilityRspBO();
        this.validateParam(reqBO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null == ordSalePO) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u9500\u552e\u5355\u4fe1\u606f");
        }
        if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(ordSalePO.getSaleState()) && !PebExtConstant.YES.equals(reqBO.getIsSupAudit())) {
            PebExtCancelReqBO pebExtCancelReqBO = (PebExtCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebExtCancelReqBO.class);
            pebExtCancelReqBO.setCancelReason(reqBO.getCancelReson());
            PebExtCancelRspBO pebExtCancelRspBO = this.pebExtCancelBusiService.dealOrderCancelled(pebExtCancelReqBO);
            if (!"0000".equals(pebExtCancelRspBO.getRespCode())) {
                throw new UocProBusinessException(pebExtCancelRspBO.getRespCode(), pebExtCancelRspBO.getRespDesc());
            }
            UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
            uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
            uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
            uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
            if (!StringUtils.isEmpty((Object)pebExtCancelRspBO.getReqJsonStr())) {
                this.uocFlMsgProvider.send(new ProxyMessage(this.orderFlTopic, this.orderFlTag, pebExtCancelRspBO.getReqJsonStr()));
            }
        } else {
            UocPebOrderCancellationAbilityRspBO cancellationAbilityRspBO = this.uocPebOrderCancellationAbilityService.dealPebOrderCancellation((UocPebOrderCancellationAbilityReqBO)reqBO);
            if (!"0000".equals(cancellationAbilityRspBO.getRespCode())) {
                throw new UocProBusinessException(cancellationAbilityRspBO.getRespCode(), cancellationAbilityRspBO.getRespDesc());
            }
            PebExtSyncUnifyChangeAbilityReqBO changeReqBO = new PebExtSyncUnifyChangeAbilityReqBO();
            changeReqBO.setOrderId(reqBO.getOrderId());
            changeReqBO.setPushType(UocCoreConstant.PUSH_TYPE.CONTRACT_ORDER_CHANGE);
            this.pebExtSyncUnifyChangeAbilityService.syncPushUnifyOrderChange(changeReqBO);
            SendNotificationExtAtomReqBO sendNotificationExtAtomReqBO = new SendNotificationExtAtomReqBO();
            sendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            sendNotificationExtAtomReqBO.setOrderId(reqBO.getOrderId());
            sendNotificationExtAtomReqBO.setNotificationType(UocConstant.NotificationType.ORDER_CANCEL);
            this.sendNotificationOrderOrderProvider.send(new ProxyMessage(this.sendNotificationTopic, this.sendNotificationTag, JSONObject.toJSONString((Object)((Object)sendNotificationExtAtomReqBO))));
            rspBO.setRespCode(cancellationAbilityRspBO.getRespCode());
            rspBO.setRespDesc(cancellationAbilityRspBO.getRespDesc());
            this.pushTodoWait(reqBO, ordSalePO);
        }
        this.dealYijiNum(reqBO);
        try {
            this.orderNotifyComponent.syncCancelNoticeMessage(ordSalePO, reqBO);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u53d6\u6d88\u7ad9\u5185\u4fe1\u901a\u77e5error:{}", (Throwable)e);
        }
        return rspBO;
    }

    @PostMapping(value={"invalidOrder"})
    public PebExtAgreementCancelAbilityRspBO invalidOrder(@RequestBody PebExtAgreementCancelAbilityReqBO reqBO) {
        PebExtCancelReqBO pebExtCancelReqBO = (PebExtCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebExtCancelReqBO.class);
        pebExtCancelReqBO.setCancelReason(reqBO.getCancelReson());
        PebExtCancelRspBO pebExtCancelRspBO = this.pebExtCancelBusiService.dealInvalidOrder(pebExtCancelReqBO);
        if ("0000".equals(pebExtCancelRspBO.getRespCode())) {
            throw new UocProBusinessException(pebExtCancelRspBO.getRespCode(), pebExtCancelRspBO.getRespDesc());
        }
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(pebExtCancelRspBO.getSaleId());
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
        PebExtAgreementCancelAbilityRspBO rspBO = new PebExtAgreementCancelAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealYijiNum(PebExtAgreementCancelAbilityReqBO reqBO) {
        log.info("--------------\u8fdb\u5165\u8bae\u4ef7\u4e0b\u5355\u53d6\u6d88-----------");
        OrdItemMapPO itemMapPO = new OrdItemMapPO();
        itemMapPO.setOrderId(reqBO.getOrderId());
        itemMapPO.setFieldCode("awardNumId");
        List awardNumList = this.ordItemMapMapper.getList(itemMapPO);
        if (!CollectionUtils.isEmpty((Collection)awardNumList)) {
            ArrayList bargainOrderPOList = new ArrayList();
            OrdItemPO itemPO = new OrdItemPO();
            itemPO.setOrderId(reqBO.getOrderId());
            itemPO.setSaleVoucherId(reqBO.getSaleVoucherId());
            List itemPOList = this.ordItemMapper.getList(itemPO);
            Map<Long, BigDecimal> ordItemMap = itemPOList.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, OrdItemPO::getPurchaseCount, (k1, k2) -> k1));
            List diversionInfos = awardNumList.stream().map(x -> {
                BusinessDiversionInfo info = new BusinessDiversionInfo();
                info.setBargainStatus("2");
                info.setAwardNumId(x.getFieldValue());
                info.setItemHasNum(((BigDecimal)ordItemMap.get(x.getOrderItemId())).negate());
                UocPlanBargainOrderPO planBargainOrderPO = new UocPlanBargainOrderPO();
                planBargainOrderPO.setOrderId(reqBO.getOrderId());
                planBargainOrderPO.setAwardNumId(x.getFieldValue());
                planBargainOrderPO.setOrderState(Integer.valueOf(2));
                planBargainOrderPO.setUpdateId(String.valueOf(reqBO.getUserId()));
                planBargainOrderPO.setUpdateTime(new Date());
                bargainOrderPOList.add(planBargainOrderPO);
                return info;
            }).collect(Collectors.toList());
            this.planDiversionMapper.updateAwardNumId(diversionInfos);
            if (!CollectionUtils.isEmpty(bargainOrderPOList)) {
                log.info("\u8bae\u4ef7\u4e0b\u5355\u53d6\u6d88\u660e\u7ec6\u96c6\u5408\uff1a" + JSON.toJSONString(bargainOrderPOList));
                bargainOrderPOList.forEach(e -> this.uocPlanBargainOrderMapper.updateOrderStatus(e));
            }
        }
    }

    private void validateParam(PebExtAgreementCancelAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null || 0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u8ba2\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSaleVoucherId() == null || 0L == reqBO.getSaleVoucherId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u3010\u9500\u552e\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCancelReson())) {
            throw new UocProBusinessException("100001", "\u3010\u53d6\u6d88\u539f\u56e0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void pushTodoWait(PebExtAgreementCancelAbilityReqBO reqBO, OrdSalePO saleRspBO) {
        try {
            PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
            uocTodoBO.setOrderId(saleRspBO.getOrderId());
            uocTodoBO.setSaleVoucherId(saleRspBO.getSaleVoucherId());
            uocTodoBO.setApproveType(ApproveTypeEnum.CANCLE.getCode());
            uocTodoBO.setOperatorId(reqBO.getUserId() + "");
            uocTodoBO.setOperatorNo(reqBO.getUsername());
            uocTodoBO.setOperatorName(reqBO.getName());
            uocTodoBO.setOrgId((long)reqBO.getOrgId());
            if (UocSaleStateEnum.order_under_review.getStatusCode().equals(saleRspBO.getSaleState())) {
                uocTodoBO.setBusiCode(TodoWaitTypeEnum.ADJUST_TYPE.getCode());
            }
            log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
            this.uocPushTodoProvider.send(new ProxyMessage(this.todoTopic, this.todoTag, JSON.toJSONString((Object)uocTodoBO)));
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
        }
    }
}

